/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.contentengine;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.FieldEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.acl.GWTJahiaNodeACL;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.workflow.GWTJahiaWorkflowDefinition;
import org.jahia.ajax.gwt.client.data.workflow.GWTJahiaWorkflowType;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.AsyncTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.EditEngineTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.NodeHolder;
import org.jahia.ajax.gwt.client.widget.contentengine.WorkflowHistoryPanel;

public class WorkflowTabItem
extends EditEngineTabItem {
    private transient LayoutContainer container;
    private transient WorkflowHistoryPanel activePanel;
    private transient Map<String, WorkflowHistoryPanel> panelsByLanguage = new HashMap<String, WorkflowHistoryPanel>(1);
    private transient GWTJahiaWorkflowDefinition previousSelection = null;
    private transient Map<GWTJahiaWorkflowType, List<GWTJahiaWorkflowDefinition>> workflowRules;

    public WorkflowTabItem() {
        this.setHandleCreate(false);
    }

    @Override
    public void init(final NodeHolder engine, final AsyncTabItem tab, String locale) {
        if (engine.getNode() == null) {
            return;
        }
        if (this.container != null) {
            this.container.removeFromParent();
            this.container.removeAll();
        }
        if (this.container == null) {
            this.container = new LayoutContainer((Layout)new BorderLayout());
        }
        tab.add((Widget)this.container);
        tab.setProcessed(true);
        final LayoutContainer layoutContainer = new LayoutContainer((Layout)new BorderLayout());
        this.container.add((Widget)layoutContainer, (LayoutData)new BorderLayoutData(Style.LayoutRegion.NORTH, 150.0f));
        WorkflowHistoryPanel next = this.getPanel(locale, engine);
        if (this.activePanel != null && this.activePanel != next) {
            this.activePanel.removeFromParent();
        }
        this.container.add((Widget)next, (LayoutData)new BorderLayoutData(Style.LayoutRegion.CENTER));
        this.activePanel = next;
        JahiaContentManagementService.App.getInstance().getWorkflowRules(engine.getNode().getPath(), (AsyncCallback<Map<GWTJahiaWorkflowType, List<GWTJahiaWorkflowDefinition>>>)new BaseAsyncCallback<Map<GWTJahiaWorkflowType, List<GWTJahiaWorkflowDefinition>>>(){

            public void onSuccess(Map<GWTJahiaWorkflowType, List<GWTJahiaWorkflowDefinition>> result) {
                WorkflowTabItem.this.workflowRules = result;
                for (List list : WorkflowTabItem.this.workflowRules.values()) {
                    for (GWTJahiaWorkflowDefinition definition : list) {
                        if (!Boolean.TRUE.equals(definition.get("active")) || !engine.getNode().getPath().equals(definition.get("workflowRootPath"))) continue;
                        definition.set("set", Boolean.TRUE);
                    }
                }
                ListStore types = new ListStore();
                types.add(new ArrayList(WorkflowTabItem.this.workflowRules.keySet()));
                types.sort("displayName", Style.SortDir.ASC);
                ColumnModel header = new ColumnModel(Arrays.asList(new ColumnConfig("displayName", "displayName", 300)));
                Grid grid = new Grid(types, header);
                grid.setWidth(250);
                grid.setHideHeaders(true);
                grid.setHeight(150);
                grid.setAutoExpandColumn("displayName");
                grid.setAutoExpandMax(1200);
                BorderLayoutData data = new BorderLayoutData(Style.LayoutRegion.WEST, 250.0f);
                layoutContainer.add((Widget)grid, (LayoutData)data);
                FormPanel form = new FormPanel();
                form.setHeaderVisible(false);
                form.setLabelWidth(200);
                form.setFieldWidth(300);
                final CheckBox box = new CheckBox();
                box.setFieldLabel(Messages.get("label.workflow.inherited", "Same workflow as parent"));
                form.add((Widget)box);
                final ListStore states = new ListStore();
                final ComboBox combo = new ComboBox();
                combo.setFieldLabel(Messages.get("label.workflow", "Workflow"));
                combo.setForceSelection(true);
                combo.setDisplayField("displayName");
                combo.setWidth(400);
                combo.setStore(states);
                combo.setTypeAhead(true);
                combo.setTriggerAction(ComboBox.TriggerAction.ALL);
                form.add((Widget)combo);
                data = new BorderLayoutData(Style.LayoutRegion.CENTER);
                layoutContainer.add((Widget)form, (LayoutData)data);
                grid.getSelectionModel().addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaWorkflowType>(){

                    public void selectionChanged(SelectionChangedEvent<GWTJahiaWorkflowType> se) {
                        WorkflowTabItem.this.previousSelection = null;
                        combo.setValue(null);
                        combo.clearSelections();
                        states.removeAll();
                        List list = (List)WorkflowTabItem.this.workflowRules.get(se.getSelectedItem());
                        states.add(list);
                        states.sort("displayName", Style.SortDir.ASC);
                        for (GWTJahiaWorkflowDefinition definition : list) {
                            if (!Boolean.TRUE.equals(definition.get("active"))) continue;
                            box.setValue(Boolean.valueOf(!Boolean.TRUE.equals(definition.get("set"))));
                            combo.setValue((ModelData)definition);
                            return;
                        }
                        box.setValue(Boolean.valueOf(true));
                    }
                });
                box.addListener(Events.Change, (Listener)new Listener<FieldEvent>(){

                    public void handleEvent(FieldEvent be) {
                        combo.setEnabled(box.getValue() == false);
                        if (combo.getSelection().size() == 1) {
                            ((GWTJahiaWorkflowDefinition)combo.getSelection().get(0)).set("set", box.getValue() == false);
                            if (!box.getValue().booleanValue()) {
                                ((GWTJahiaWorkflowDefinition)combo.getSelection().get(0)).set("active", Boolean.TRUE);
                            }
                        }
                    }
                });
                combo.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaWorkflowDefinition>(){

                    public void selectionChanged(SelectionChangedEvent<GWTJahiaWorkflowDefinition> event) {
                        if (WorkflowTabItem.this.previousSelection != null) {
                            WorkflowTabItem.this.previousSelection.set("set", Boolean.FALSE);
                            WorkflowTabItem.this.previousSelection.set("active", Boolean.FALSE);
                        }
                        if (event.getSelectedItem() != null) {
                            ((GWTJahiaWorkflowDefinition)event.getSelectedItem()).set("set", box.getValue() == false);
                            if (!box.getValue().booleanValue()) {
                                ((GWTJahiaWorkflowDefinition)event.getSelectedItem()).set("active", Boolean.TRUE);
                            }
                        }
                        WorkflowTabItem.this.previousSelection = (GWTJahiaWorkflowDefinition)event.getSelectedItem();
                        tab.layout();
                    }
                });
                if (!PermissionsUtils.isPermitted("jcr:write", engine.getNode()) || engine.getNode().isLocked().booleanValue()) {
                    box.setReadOnly(true);
                    combo.setReadOnly(true);
                }
                grid.getSelectionModel().select(0, false);
                tab.layout();
            }
        });
    }

    private WorkflowHistoryPanel getPanel(String locale, NodeHolder engine) {
        WorkflowHistoryPanel panel = this.panelsByLanguage.get(locale);
        if (panel == null) {
            panel = new WorkflowHistoryPanel(engine.getNode().getUUID(), locale);
            panel.setVisible(true);
            this.panelsByLanguage.put(locale, panel);
        }
        return panel;
    }

    @Override
    public void doSave(GWTJahiaNode node, List<GWTJahiaNodeProperty> changedProperties, Map<String, List<GWTJahiaNodeProperty>> changedI18NProperties, Set<String> addedTypes, Set<String> removedTypes, List<GWTJahiaNode> chidren, GWTJahiaNodeACL acl) {
        HashSet<GWTJahiaWorkflowDefinition> activeWorkflows = new HashSet<GWTJahiaWorkflowDefinition>();
        if (this.workflowRules == null) {
            return;
        }
        for (List<GWTJahiaWorkflowDefinition> list : this.workflowRules.values()) {
            for (GWTJahiaWorkflowDefinition definition : list) {
                if (!Boolean.TRUE.equals(definition.get("set"))) continue;
                activeWorkflows.add(definition);
            }
        }
        node.set("activeWorkflows", activeWorkflows);
    }

    @Override
    public void setProcessed(boolean processed) {
        if (!processed) {
            this.container = null;
            this.panelsByLanguage = new HashMap<String, WorkflowHistoryPanel>(1);
            this.previousSelection = null;
            this.workflowRules = null;
        }
        super.setProcessed(processed);
    }
}

