/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.definition;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.MessageBoxEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.FlowData;
import com.extjs.gxt.ui.client.widget.layout.FlowLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTChoiceListInitializer;
import org.jahia.ajax.gwt.client.data.GWTJahiaEditEngineInitBean;
import org.jahia.ajax.gwt.client.data.GWTJahiaLanguage;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaItemDefinition;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeType;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaPropertyDefinition;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaGetPropertiesResult;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementServiceAsync;
import org.jahia.ajax.gwt.client.util.definition.FormFieldCreator;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.definition.PropertiesEditor;
import org.jahia.ajax.gwt.client.widget.toolbar.action.LanguageSwitcherActionItem;

public class LangPropertiesEditor
extends LayoutContainer {
    private static JahiaContentManagementServiceAsync contentService = JahiaContentManagementService.App.getInstance();
    private PropertiesEditor displayedPropertiesEditor;
    private Map<String, PropertiesEditor> langPropertiesEditorMap;
    private List<String> excludedTypes;
    private List<String> dataType;
    private List<GWTJahiaNodeType> nodeTypes;
    private List<GWTJahiaNodeType> mixin;
    private Map<String, GWTChoiceListInitializer> initializersValues;
    private Map<String, GWTJahiaNodeProperty> properties;
    private GWTJahiaNode node;
    private ComboBox<GWTJahiaLanguage> languageSwitcher;
    private LayoutContainer mainPanel;
    private boolean editable = true;
    private GWTJahiaLanguage displayedLocale = null;
    private LayoutContainer topBar;
    private boolean translationEnabled;
    private LangPropertiesEditor translationSource;
    private CallBack callback;
    private boolean needRefresh = false;

    public LangPropertiesEditor(GWTJahiaNode node, List<String> dataType, boolean editable, GWTJahiaLanguage displayedLanguage, CallBack callback) {
        this(node, dataType, editable, displayedLanguage, null, callback);
    }

    public LangPropertiesEditor(GWTJahiaNode node, List<String> dataType, boolean editable, GWTJahiaLanguage displayedLanguage, LangPropertiesEditor translationSource, CallBack callBack) {
        this.node = node;
        this.dataType = dataType;
        this.langPropertiesEditorMap = new HashMap<String, PropertiesEditor>();
        this.editable = editable;
        this.translationSource = translationSource;
        this.callback = callBack;
        this.setScrollMode(Style.Scroll.NONE);
        this.setBorders(false);
        this.setLayout((Layout)new BorderLayout());
        LayoutContainer top = new LayoutContainer((Layout)new FlowLayout());
        this.topBar = new HorizontalPanel();
        this.languageSwitcher = this.createLanguageSwitcher();
        this.topBar.add(this.languageSwitcher);
        top.add((Widget)this.topBar, (LayoutData)new FlowData(5));
        this.add((Widget)top, (LayoutData)new BorderLayoutData(Style.LayoutRegion.NORTH, 25.0f));
        this.loadEngine(displayedLanguage);
    }

    public LayoutContainer getTopBar() {
        return this.topBar;
    }

    public GWTJahiaLanguage getDisplayedLocale() {
        return this.displayedLocale;
    }

    public PropertiesEditor getPropertiesEditorByLang(String locale) {
        if (locale == null) {
            return null;
        }
        return this.langPropertiesEditorMap.get(locale);
    }

    private void setPropertiesEditorByLang(PropertiesEditor displayedPropertiesEditor, String locale) {
        if (this.langPropertiesEditorMap == null || locale == null) {
            return;
        }
        this.langPropertiesEditorMap.put(locale, displayedPropertiesEditor);
    }

    public void updatePropertiesComponent(String locale) {
        if (this.mixin != null) {
            PropertiesEditor langPropertiesEditor;
            List<GWTJahiaNodeProperty> previousNon18nProperties = null;
            boolean addSharedLangLabel = true;
            if (this.displayedPropertiesEditor != null) {
                this.displayedPropertiesEditor.setVisible(false);
                previousNon18nProperties = this.displayedPropertiesEditor.getProperties(false, true, false);
            }
            if (locale == null) {
                locale = this.displayedLocale.getLanguage();
            }
            if ((langPropertiesEditor = this.getPropertiesEditorByLang(locale)) == null) {
                if (addSharedLangLabel && this.node.isShared()) {
                    Label label = new Label("Important : This is a shared node, editing it will modify its value for all its usages");
                    label.setStyleAttribute("color", "rgb(200,80,80)");
                    label.setStyleAttribute("font-size", "14px");
                    this.add((Component)label);
                }
                addSharedLangLabel = false;
                langPropertiesEditor = new PropertiesEditor(this.nodeTypes, this.properties, this.dataType);
                langPropertiesEditor.setLocale(locale);
                langPropertiesEditor.setMixin(this.mixin);
                langPropertiesEditor.setChoiceListInitializersValues(this.initializersValues);
                langPropertiesEditor.setNonI18NWriteable(false);
                langPropertiesEditor.setWriteable(this.editable);
                langPropertiesEditor.setFieldSetGrouping(true);
                langPropertiesEditor.setExcludedTypes(this.excludedTypes);
                if (this.node != null) {
                    langPropertiesEditor.setPermissions(this.node.getPermissions());
                }
                if (this.translationEnabled && this.translationSource != null) {
                    langPropertiesEditor.setTranslationSource(this.translationSource);
                    langPropertiesEditor.setTranslationTarget(this);
                }
                langPropertiesEditor.renderNewFormPanel();
                this.setPropertiesEditorByLang(langPropertiesEditor, locale);
                this.mainPanel.add((Widget)langPropertiesEditor);
            } else {
                langPropertiesEditor.setVisible(true);
            }
            if (previousNon18nProperties != null && !previousNon18nProperties.isEmpty()) {
                Map<String, PropertiesEditor.PropertyAdapterField> fieldsMap = langPropertiesEditor.getFieldsMap();
                for (GWTJahiaNodeProperty property : previousNon18nProperties) {
                    FormFieldCreator.fillValue(fieldsMap.get(property.getName()).getField(), langPropertiesEditor.getGWTJahiaItemDefinition(property), property, null, null);
                }
            }
            this.displayedPropertiesEditor = langPropertiesEditor;
            this.layout();
        } else {
            Log.debug((String)"mixin is not set");
        }
    }

    private ComboBox<GWTJahiaLanguage> createLanguageSwitcher() {
        ComboBox languageSwitcher = new ComboBox();
        languageSwitcher.setStore(new ListStore());
        languageSwitcher.setDisplayField("displayName");
        languageSwitcher.setVisible(false);
        languageSwitcher.setTemplate(LanguageSwitcherActionItem.getLangSwitchingTemplate());
        languageSwitcher.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaLanguage>(){

            public void selectionChanged(SelectionChangedEvent<GWTJahiaLanguage> event) {
                if (!((GWTJahiaLanguage)event.getSelectedItem()).getLanguage().equalsIgnoreCase(LangPropertiesEditor.this.displayedLocale.getLanguage())) {
                    LangPropertiesEditor.this.onLanguageSelectionChanged(((GWTJahiaLanguage)event.getSelectedItem()).getLanguage());
                }
                LangPropertiesEditor.this.displayedLocale = (GWTJahiaLanguage)event.getSelectedItem();
            }
        });
        languageSwitcher.setTypeAhead(true);
        languageSwitcher.setTriggerAction(ComboBox.TriggerAction.ALL);
        languageSwitcher.setForceSelection(true);
        return languageSwitcher;
    }

    private Button createSuggestTranslationButton() {
        Button button = new Button(Messages.get("label.translate.suggest", "Suggest translation"));
        button.addStyleName("button-suggest");
        button.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                MessageBox.confirm((String)Messages.get("label.translate.suggest", "Suggest translation"), (String)Messages.get("label.translate.suggest.confirm", "Do you want to replace the content by an automatic translation of it?"), (Listener)new Listener<MessageBoxEvent>(){

                    public void handleEvent(MessageBoxEvent be) {
                        if ("yes".equalsIgnoreCase(be.getButtonClicked().getItemId())) {
                            String destLanguage;
                            PropertiesEditor sourcePropertiesEditor = LangPropertiesEditor.this.translationSource.getPropertiesEditorByLang(LangPropertiesEditor.this.translationSource.getDisplayedLocale().getLanguage());
                            ArrayList<GWTJahiaNodeProperty> props = new ArrayList<GWTJahiaNodeProperty>();
                            ArrayList<GWTJahiaItemDefinition> defs = new ArrayList<GWTJahiaItemDefinition>();
                            for (GWTJahiaNodeProperty prop : sourcePropertiesEditor.getProperties()) {
                                GWTJahiaItemDefinition def = sourcePropertiesEditor.getGWTJahiaItemDefinition(prop);
                                if (((GWTJahiaPropertyDefinition)def).getRequiredType() != 1 || !def.isInternationalized() || def.isHidden() || def.isProtected() || ((GWTJahiaPropertyDefinition)def).isConstrained()) continue;
                                props.add(prop);
                                defs.add(def);
                            }
                            String srcLanguage = LangPropertiesEditor.this.translationSource.getDisplayedLocale().getLanguage();
                            int i = srcLanguage.indexOf("_");
                            if (i > -1) {
                                srcLanguage = srcLanguage.substring(0, i);
                            }
                            if ((i = (destLanguage = LangPropertiesEditor.this.displayedLocale.getLanguage()).indexOf("_")) > -1) {
                                destLanguage = destLanguage.substring(0, i);
                            }
                            JahiaContentManagementService.App.getInstance().translate(props, defs, srcLanguage, destLanguage, JahiaGWTParameters.getSiteUUID(), (AsyncCallback<List<GWTJahiaNodeProperty>>)new BaseAsyncCallback<List<GWTJahiaNodeProperty>>(){

                                @Override
                                public void onApplicationFailure(Throwable throwable) {
                                    Window.alert((String)(Messages.get("failure.properties.translation", "Properties translation failed") + "\n\n" + throwable.getMessage()));
                                    Log.error((String)"Failed to translate properties", (Throwable)throwable);
                                }

                                public void onSuccess(List<GWTJahiaNodeProperty> newProps) {
                                    Map<String, PropertiesEditor.PropertyAdapterField> fieldsMap = LangPropertiesEditor.this.getPropertiesEditorByLang(LangPropertiesEditor.this.displayedLocale.getLanguage()).getFieldsMap();
                                    for (GWTJahiaNodeProperty prop : newProps) {
                                        Field<?> f = fieldsMap.get(prop.getName()).getField();
                                        FormFieldCreator.copyValue(prop, f);
                                    }
                                }
                            });
                        }
                    }
                });
            }
        });
        return button;
    }

    private void onLanguageSelectionChanged(String locale) {
        this.updateNodeInfo(locale);
    }

    public void refresh() {
        this.setNeedRefresh(false);
        this.setPropertiesEditorByLang(null, this.getDisplayedLocale().getLanguage());
        this.updateNodeInfo(this.getDisplayedLocale().getLanguage());
    }

    private void updateNodeInfo(final String locale) {
        Log.debug((String)("update node info ,locale code = " + locale));
        contentService.getProperties(this.node.getPath(), locale, (AsyncCallback<GWTJahiaGetPropertiesResult>)new BaseAsyncCallback<GWTJahiaGetPropertiesResult>(){

            public void onSuccess(GWTJahiaGetPropertiesResult result) {
                LangPropertiesEditor.this.node = result.getNode();
                LangPropertiesEditor.this.nodeTypes = result.getNodeTypes();
                LangPropertiesEditor.this.properties = result.getProperties();
                if (LangPropertiesEditor.this.displayedLocale == null) {
                    LangPropertiesEditor.this.displayedLocale = result.getCurrentLocale();
                    LangPropertiesEditor.this.languageSwitcher.setVisible(true);
                    ArrayList<GWTJahiaLanguage> selected = new ArrayList<GWTJahiaLanguage>();
                    selected.add(result.getCurrentLocale());
                    LangPropertiesEditor.this.languageSwitcher.getStore().add(result.getAvailabledLanguages());
                    LangPropertiesEditor.this.languageSwitcher.setSelection(selected);
                }
                LangPropertiesEditor.this.updatePropertiesComponent(locale);
                if (LangPropertiesEditor.this.callback != null) {
                    LangPropertiesEditor.this.callback.execute();
                }
            }

            @Override
            public void onApplicationFailure(Throwable throwable) {
                Log.error((String)"Cannot get properties", (Throwable)throwable);
            }
        });
    }

    private void loadEngine(final GWTJahiaLanguage displayedLanguage) {
        contentService.initializeEditEngine(this.node.getPath(), false, (AsyncCallback<GWTJahiaEditEngineInitBean>)new BaseAsyncCallback<GWTJahiaEditEngineInitBean>(){

            public void onSuccess(GWTJahiaEditEngineInitBean result) {
                ArrayList<GWTJahiaLanguage> selected;
                if (result == null) {
                    return;
                }
                LangPropertiesEditor.this.node = result.getNode();
                LangPropertiesEditor.this.nodeTypes = result.getNodeTypes();
                LangPropertiesEditor.this.properties = result.getProperties();
                LangPropertiesEditor.this.mainPanel = new LayoutContainer();
                LangPropertiesEditor.this.mainPanel.setScrollMode(Style.Scroll.AUTOY);
                LangPropertiesEditor.this.add((Widget)LangPropertiesEditor.this.mainPanel, (LayoutData)new BorderLayoutData(Style.LayoutRegion.CENTER));
                if (LangPropertiesEditor.this.displayedLocale == null) {
                    LangPropertiesEditor.this.displayedLocale = result.getCurrentLocale();
                    LangPropertiesEditor.this.languageSwitcher.setVisible(true);
                    selected = new ArrayList<GWTJahiaLanguage>();
                    selected.add(result.getCurrentLocale());
                    if (LangPropertiesEditor.this.editable) {
                        for (GWTJahiaLanguage language : result.getAvailabledLanguages()) {
                            if (!PermissionsUtils.isPermitted("jcr:modifyProperties_" + JahiaGWTParameters.getWorkspace() + "_" + language.getLanguage(), LangPropertiesEditor.this.node.getPermissions())) continue;
                            LangPropertiesEditor.this.languageSwitcher.getStore().add((ModelData)language);
                        }
                    } else {
                        LangPropertiesEditor.this.languageSwitcher.getStore().add(result.getAvailabledLanguages());
                    }
                    LangPropertiesEditor.this.languageSwitcher.setSelection(selected);
                }
                LangPropertiesEditor.this.translationEnabled = result.isTranslationEnabled();
                if (LangPropertiesEditor.this.translationEnabled && LangPropertiesEditor.this.translationSource != null) {
                    LangPropertiesEditor.this.topBar.add((Widget)LangPropertiesEditor.this.createSuggestTranslationButton());
                    LangPropertiesEditor.this.topBar.layout();
                }
                LangPropertiesEditor.this.mixin = result.getMixin();
                LangPropertiesEditor.this.initializersValues = result.getInitializersValues();
                if (displayedLanguage != null) {
                    selected = new ArrayList();
                    selected.add(displayedLanguage);
                    LangPropertiesEditor.this.languageSwitcher.setSelection(selected);
                    LangPropertiesEditor.this.updateNodeInfo(displayedLanguage.getLanguage());
                } else {
                    LangPropertiesEditor.this.updatePropertiesComponent(null);
                }
            }

            @Override
            public void onApplicationFailure(Throwable throwable) {
                Log.error((String)"Cannot get properties", (Throwable)throwable);
            }
        });
    }

    public Map<String, List<GWTJahiaNodeProperty>> getLangPropertiesMap() {
        HashMap<String, List<GWTJahiaNodeProperty>> mapProperties = new HashMap<String, List<GWTJahiaNodeProperty>>();
        for (String langCode : this.langPropertiesEditorMap.keySet()) {
            mapProperties.put(langCode, this.langPropertiesEditorMap.get(langCode).getProperties(true, false, true));
        }
        return mapProperties;
    }

    public boolean isNeedRefresh() {
        return this.needRefresh;
    }

    public void setNeedRefresh(boolean needRefresh) {
        this.needRefresh = needRefresh;
    }

    public static interface CallBack {
        public void execute();
    }
}

