/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.definitionsmodeler;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.data.PagingLoadResult;
import com.extjs.gxt.ui.client.dnd.DND;
import com.extjs.gxt.ui.client.dnd.GridDropTarget;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.store.StoreEvent;
import com.extjs.gxt.ui.client.store.StoreListener;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.DualListField;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FieldSet;
import com.extjs.gxt.ui.client.widget.form.Validator;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.RowData;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.GWTChoiceListInitializer;
import org.jahia.ajax.gwt.client.data.GWTJahiaValueDisplayBean;
import org.jahia.ajax.gwt.client.data.acl.GWTJahiaNodeACL;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaItemDefinition;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodePropertyValue;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeType;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaPropertyDefinition;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaGetPropertiesResult;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.definition.FormFieldCreator;
import org.jahia.ajax.gwt.client.util.icons.StandardIconsProvider;
import org.jahia.ajax.gwt.client.util.icons.ToolbarIconProvider;
import org.jahia.ajax.gwt.client.widget.AsyncTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.EditEngineTabItem;
import org.jahia.ajax.gwt.client.widget.contentengine.NodeHolder;
import org.jahia.ajax.gwt.client.widget.definition.PropertiesEditor;

public class ChildItemsTabItem
extends EditEngineTabItem {
    private static final long serialVersionUID = 1L;
    private List<String> columnsConfig;
    protected transient ListStore<GWTJahiaNode> store;
    protected transient PropertiesEditor propertiesEditor;
    protected transient Map<GWTJahiaNode, PropertiesEditor> propertiesEditors;
    protected transient Map<GWTJahiaNode, Map<String, PropertiesEditor>> propertiesEditorsByLang;
    private String type;
    private transient Grid<GWTJahiaNode> grid;
    private transient List<String> columnsKeys;
    private transient GWTJahiaNodeType nodeType;
    private transient Map<String, GWTChoiceListInitializer> initializerMap = new HashMap<String, GWTChoiceListInitializer>();
    private transient String currentLanguage;
    private transient GWTJahiaNode engineNode;
    private transient List<GWTJahiaNode> children;
    private transient List<GWTJahiaNode> removedChildren;
    private static final String[] STRING = new String[]{"1", "string", "String", "STRING"};
    private static final String[] BINARY = new String[]{"2", "binary", "Binary", "BINARY"};
    private static final String[] LONG = new String[]{"3", "long", "Long", "LONG"};
    private static final String[] DOUBLE = new String[]{"4", "double", "Double", "DOUBLE"};
    private static final String[] BOOLEAN = new String[]{"5", "boolean", "Boolean", "BOOLEAN"};
    private static final String[] DATE = new String[]{"6", "date", "Date", "DATE"};
    private static final String[] NAME = new String[]{"7", "name", "Name", "NAME"};
    private static final String[] PATH = new String[]{"8", "path", "Path", "PATH"};
    private static final String[] REFERENCE = new String[]{"9", "reference", "Reference", "REFERENCE"};
    private static final String[] WEAKREFERENCE = new String[]{"10", "WEAKREFERENCE", "WeakReference", "weakreference"};
    private static final String[] URI = new String[]{"11", "URI", "Uri", "uri"};
    private static final String[] DECIMAL = new String[]{"12", "DECIMAL", "Decimal", "decimal"};
    private static final String[] UNDEFINED = new String[]{"0", "undefined", "Undefined", "UNDEFINED", "*"};

    @Override
    public void init(final NodeHolder engine, final AsyncTabItem tab, String language) {
        if (tab.isProcessed()) {
            return;
        }
        this.engineNode = engine.getNode();
        if (this.engineNode == null) {
            this.engineNode = new GWTJahiaNode();
            this.engineNode.setPath("newNode");
        }
        this.currentLanguage = language;
        this.children = new ArrayList<GWTJahiaNode>();
        this.removedChildren = new ArrayList<GWTJahiaNode>();
        JahiaContentManagementService.App.getInstance().getFieldInitializerValues("jnt:childNodeDefinition", "j:defaultPrimaryType", engine.getNode() != null ? engine.getNode().getPath() : engine.getTargetNode().getPath(), new HashMap<String, List<GWTJahiaNodePropertyValue>>(), (AsyncCallback<GWTChoiceListInitializer>)new BaseAsyncCallback<GWTChoiceListInitializer>(){

            public void onSuccess(GWTChoiceListInitializer result) {
                ChildItemsTabItem.this.initializerMap.put("jnt:childNodeDefinition.j:defaultPrimaryType", result);
                ChildItemsTabItem.this.initializerMap.put("jnt:childNodeDefinition.j:requiredPrimaryTypes", result);
                ChildItemsTabItem.this.initializerMap.put("jnt:unstructuredChildNodeDefinition.j:requiredPrimaryTypes", result);
                ChildItemsTabItem.this.initializerMap.put("jnt:childNodeDefinition.j:requiredPrimaryTypes", result);
                ChildItemsTabItem.this.initializerMap.put("jnt:unstructuredChildNodeDefinition.j:requiredPrimaryTypes", result);
            }
        });
        tab.setLayout((Layout)new RowLayout(Style.Orientation.VERTICAL));
        this.store = new ListStore();
        this.propertiesEditor = null;
        this.propertiesEditors = new HashMap<GWTJahiaNode, PropertiesEditor>();
        this.propertiesEditorsByLang = new HashMap<GWTJahiaNode, Map<String, PropertiesEditor>>();
        this.columnsKeys = new ArrayList<String>();
        for (String columnConfig : this.columnsConfig) {
            String[] config = columnConfig.split(",");
            this.columnsKeys.add(config[0]);
        }
        if (engine.getNode() != null) {
            JahiaContentManagementService.App.getInstance().lsLoad(engine.getNode().getPath(), Arrays.asList(this.type), null, null, this.columnsKeys, false, -1, 0, false, null, null, false, false, (AsyncCallback<PagingLoadResult<GWTJahiaNode>>)new BaseAsyncCallback<PagingLoadResult<GWTJahiaNode>>(){

                public void onSuccess(PagingLoadResult<GWTJahiaNode> result) {
                    for (GWTJahiaNode itemDefinition : result.getData()) {
                        if (!engine.getNode().getChildren().contains(itemDefinition)) {
                            engine.getNode().getChildren().add(itemDefinition);
                        }
                        ChildItemsTabItem.this.children.add(itemDefinition);
                        ChildItemsTabItem.this.store.add((ModelData)itemDefinition);
                    }
                }
            });
        }
        this.grid = new Grid(this.store, new ColumnModel(new ArrayList()));
        GridDropTarget target = new GridDropTarget(this.grid);
        target.setAllowSelfAsSource(true);
        target.setFeedback(DND.Feedback.INSERT);
        this.grid.setHeight(200);
        ToolBar toolBar = new ToolBar();
        Button add = new Button(Messages.get("label.add", "Add"));
        add.addStyleName("button-add");
        add.setIcon(StandardIconsProvider.STANDARD_ICONS.plusRound());
        add.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                final MessageBox box = ChildItemsTabItem.this.getNamePrompt();
                box.getDialog().getButtonById("ok").removeAllListeners();
                box.getDialog().getButtonById("ok").addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                    public void componentSelected(ButtonEvent ce) {
                        if (box.getTextBox().isValid()) {
                            GWTJahiaNode itemDefinition = new GWTJahiaNode();
                            String name = "*".equals(box.getTextBox().getValue()) ? this.findAvailableName(new StringBuilder("__undef")).toString() : (String)box.getTextBox().getValue();
                            itemDefinition.setName(name);
                            String t = ChildItemsTabItem.this.type;
                            if ("*".equals(box.getTextBox().getValue())) {
                                t = ChildItemsTabItem.this.type.equals("jnt:propertyDefinition") ? "jnt:unstructuredPropertyDefinition" : "jnt:unstructuredChildNodeDefinition";
                            }
                            itemDefinition.setNodeTypes(Arrays.asList(t));
                            ChildItemsTabItem.this.initValues(itemDefinition);
                            ChildItemsTabItem.this.removedChildren.remove(itemDefinition);
                            ChildItemsTabItem.this.children.add(itemDefinition);
                            ChildItemsTabItem.this.store.add((ModelData)itemDefinition);
                            ChildItemsTabItem.this.grid.getSelectionModel().select((ModelData)itemDefinition, false);
                            box.getDialog().hide();
                        }
                    }

                    private StringBuilder findAvailableName(StringBuilder name) {
                        for (GWTJahiaNode n : ChildItemsTabItem.this.store.getModels()) {
                            if (!n.getName().equals(name.toString())) continue;
                            name.append("_");
                            return this.findAvailableName(name);
                        }
                        return name;
                    }
                });
            }
        });
        toolBar.add((Component)add);
        final Button remove = new Button(Messages.get("label.remove", "Remove"));
        remove.addStyleName("button-remove");
        remove.disable();
        remove.setIcon(StandardIconsProvider.STANDARD_ICONS.minusRound());
        remove.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                if (ChildItemsTabItem.this.propertiesEditor != null) {
                    tab.remove((Widget)ChildItemsTabItem.this.propertiesEditor);
                    ChildItemsTabItem.this.propertiesEditor = null;
                    tab.layout();
                }
                ChildItemsTabItem.this.grid.getSelectionModel().setFiresEvents(false);
                List selection = ChildItemsTabItem.this.grid.getSelectionModel().getSelection();
                for (GWTJahiaNode node : selection) {
                    ChildItemsTabItem.this.removedChildren.add(node);
                    if (engine.getNode() != null) {
                        engine.getNode().remove((ModelData)node);
                    }
                    ChildItemsTabItem.this.propertiesEditors.remove(node);
                    ChildItemsTabItem.this.children.remove(node);
                    ChildItemsTabItem.this.store.remove((ModelData)node);
                }
                ChildItemsTabItem.this.grid.getSelectionModel().setFiresEvents(true);
            }
        });
        toolBar.add((Component)remove);
        final Button rename = new Button(Messages.get("label.rename", "Rename"));
        rename.addStyleName("button-rename");
        rename.setIcon(StandardIconsProvider.STANDARD_ICONS.minusRound());
        rename.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                final GWTJahiaNode selection = (GWTJahiaNode)ChildItemsTabItem.this.grid.getSelectionModel().getSelectedItem();
                final MessageBox box = ChildItemsTabItem.this.getNamePrompt();
                box.getTextBox().setValue((Object)selection.getName());
                box.getDialog().getButtonById("ok").removeAllListeners();
                box.getDialog().getButtonById("ok").addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                    public void componentSelected(ButtonEvent ce) {
                        if (box.getTextBox().isValid()) {
                            for (GWTJahiaNode prop : ChildItemsTabItem.this.children) {
                                if (!prop.getName().equals(selection.getName())) continue;
                                prop.set("renamedFrom", prop.getName());
                                PropertiesEditor pe = ChildItemsTabItem.this.propertiesEditors.remove(prop);
                                Map<String, PropertiesEditor> pesByLang = ChildItemsTabItem.this.propertiesEditorsByLang.remove(prop);
                                prop.setName((String)box.getTextBox().getValue());
                                prop.setPath(engine.getNode().getPath() + "/" + prop.getName());
                                ChildItemsTabItem.this.propertiesEditors.put(prop, pe);
                                if (pesByLang == null) break;
                                ChildItemsTabItem.this.propertiesEditorsByLang.put(prop, pesByLang);
                                break;
                            }
                            selection.setName((String)box.getTextBox().getValue());
                            ChildItemsTabItem.this.grid.getView().refresh(false);
                            box.close();
                        }
                    }
                });
            }
        });
        rename.setIcon(ToolbarIconProvider.getInstance().getIcon("rename"));
        rename.disable();
        toolBar.add((Component)rename);
        final Button moveUp = new Button(Messages.get("label.move.up", "move up"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                for (GWTJahiaNode node : ChildItemsTabItem.this.getOrderedSelectedList()) {
                    this.execute(node);
                }
                ChildItemsTabItem.this.grid.getView().refresh(false);
            }

            public void execute(GWTJahiaNode selectedNode) {
                ChildItemsTabItem.this.removeSorter();
                int index = ChildItemsTabItem.this.grid.getStore().indexOf((ModelData)selectedNode);
                if (index > 0) {
                    ChildItemsTabItem.this.grid.getStore().remove((ModelData)selectedNode);
                    ChildItemsTabItem.this.grid.getStore().insert((ModelData)selectedNode, index - 1);
                    ChildItemsTabItem.this.grid.getSelectionModel().select(index - 1, true);
                }
            }
        });
        moveUp.addStyleName("move-up");
        moveUp.setIcon(StandardIconsProvider.STANDARD_ICONS.moveUp());
        moveUp.disable();
        toolBar.add((Component)moveUp);
        final Button moveFirst = new Button(Messages.get("label.move.first", "move first"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                int iteration = 0;
                for (GWTJahiaNode node : ChildItemsTabItem.this.getOrderedSelectedList()) {
                    this.execute(node, iteration);
                    ++iteration;
                }
            }

            public void execute(GWTJahiaNode node, int index) {
                ChildItemsTabItem.this.removeSorter();
                ChildItemsTabItem.this.grid.getStore().remove((ModelData)node);
                ChildItemsTabItem.this.grid.getStore().insert((ModelData)node, index);
                ChildItemsTabItem.this.grid.getSelectionModel().select(index, true);
                ChildItemsTabItem.this.grid.getView().refresh(false);
            }
        });
        moveFirst.addStyleName("move-first");
        moveFirst.setIcon(StandardIconsProvider.STANDARD_ICONS.moveFirst());
        moveFirst.disable();
        toolBar.add((Component)moveFirst);
        final Button moveDown = new Button(Messages.get("label.move.down", "move down"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                List ordered = ChildItemsTabItem.this.getOrderedSelectedList();
                Collections.reverse(ordered);
                for (GWTJahiaNode node : ordered) {
                    this.execute(node);
                }
            }

            public void execute(GWTJahiaNode selectedNode) {
                int index = ChildItemsTabItem.this.grid.getStore().indexOf((ModelData)selectedNode);
                if (index < ChildItemsTabItem.this.grid.getStore().getCount() - 1) {
                    ChildItemsTabItem.this.removeSorter();
                    ChildItemsTabItem.this.grid.getStore().remove((ModelData)selectedNode);
                    ChildItemsTabItem.this.grid.getStore().insert((ModelData)selectedNode, index + 1);
                    ChildItemsTabItem.this.grid.getSelectionModel().select(index + 1, true);
                    ChildItemsTabItem.this.grid.getView().refresh(false);
                }
            }
        });
        moveDown.addStyleName("move-down");
        moveDown.setIcon(StandardIconsProvider.STANDARD_ICONS.moveDown());
        moveDown.disable();
        toolBar.add((Component)moveDown);
        final Button moveLast = new Button(Messages.get("label.move.last", "move last"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent ce) {
                List ordered = ChildItemsTabItem.this.getOrderedSelectedList();
                Collections.reverse(ordered);
                int index = ChildItemsTabItem.this.grid.getStore().getCount() - 1;
                for (GWTJahiaNode node : ordered) {
                    this.execute(node, index);
                    --index;
                }
                ChildItemsTabItem.this.grid.getSelectionModel().setSelection(ChildItemsTabItem.this.grid.getSelectionModel().getSelection());
                ChildItemsTabItem.this.grid.getView().refresh(false);
            }

            public void execute(GWTJahiaNode node, int index) {
                ChildItemsTabItem.this.removeSorter();
                ChildItemsTabItem.this.grid.getStore().remove((ModelData)node);
                ChildItemsTabItem.this.grid.getStore().insert((ModelData)node, index);
                ChildItemsTabItem.this.grid.getSelectionModel().select(index, true);
            }
        });
        moveLast.addStyleName("move-last");
        moveLast.setIcon(StandardIconsProvider.STANDARD_ICONS.moveLast());
        moveLast.disable();
        toolBar.add((Component)moveLast);
        tab.add((Widget)toolBar, (LayoutData)new RowData(1.0, -1.0, new Margins(2)));
        tab.add((Widget)this.grid, (LayoutData)new RowData(1.0, 200.0, new Margins(2)));
        this.grid.getSelectionModel().addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaNode>(){

            public void selectionChanged(SelectionChangedEvent<GWTJahiaNode> se) {
                boolean any = se.getSelectedItem() != null;
                boolean single = se.getSelection().size() == 1;
                remove.setEnabled(any);
                rename.setEnabled(single);
                moveDown.setEnabled(any);
                moveFirst.setEnabled(any);
                moveLast.setEnabled(any);
                moveUp.setEnabled(any);
                ChildItemsTabItem.this.switchPropertiesEditor(tab);
            }
        });
        JahiaContentManagementService.App.getInstance().getNodeType(this.type, (AsyncCallback<GWTJahiaNodeType>)new BaseAsyncCallback<GWTJahiaNodeType>(){

            public void onSuccess(GWTJahiaNodeType result) {
                ChildItemsTabItem.this.nodeType = result;
                ArrayList<ColumnConfig> columns = new ArrayList<ColumnConfig>();
                HashMap<String, String> labels = new HashMap<String, String>();
                for (GWTJahiaItemDefinition gwtJahiaItemDefinition : ChildItemsTabItem.this.nodeType.getItems()) {
                    labels.put(gwtJahiaItemDefinition.getName(), gwtJahiaItemDefinition.getLabel());
                }
                ChildItemsTabItem.this.columnsKeys = new ArrayList();
                String autoExpandColumn = null;
                for (String columnConfig : ChildItemsTabItem.this.columnsConfig) {
                    String[] config = columnConfig.split(",");
                    ChildItemsTabItem.this.columnsKeys.add(config[0]);
                    ColumnConfig colConfig = new ColumnConfig();
                    colConfig.setId(config[0]);
                    if (!"*".equals(config[1])) {
                        colConfig.setWidth(Integer.valueOf(config[1]).intValue());
                    } else {
                        autoExpandColumn = config[0];
                    }
                    if (config.length > 2) {
                        colConfig.setHeaderHtml(Messages.get(config[2], config[2]));
                    } else {
                        colConfig.setHeaderHtml((String)labels.get(config[0]));
                    }
                    columns.add(colConfig);
                    colConfig.setRenderer((GridCellRenderer)new GridCellRenderer<GWTJahiaNode>(){

                        public Object render(GWTJahiaNode node, String property, ColumnData config, int rowIndex, int colIndex, ListStore store, Grid grid) {
                            StringBuilder cellValue = new StringBuilder();
                            if (node.get(property) != null) {
                                if (node.get(property) instanceof ArrayList) {
                                    for (Object s : (ArrayList)node.get(property)) {
                                        if (cellValue.length() != 0) {
                                            cellValue.append(",");
                                        }
                                        if (s instanceof GWTJahiaNodePropertyValue) {
                                            cellValue.append(((GWTJahiaNodePropertyValue)s).getString());
                                            continue;
                                        }
                                        if (!(s instanceof String)) continue;
                                        cellValue.append(s);
                                    }
                                } else {
                                    Object p = node.get(property);
                                    if (p instanceof GWTJahiaNodePropertyValue) {
                                        cellValue.append(((GWTJahiaNodePropertyValue)p).getString());
                                    } else {
                                        cellValue.append(p);
                                    }
                                }
                                if (cellValue.toString().startsWith("__")) {
                                    return "*";
                                }
                            }
                            return cellValue.toString();
                        }
                    });
                }
                ChildItemsTabItem.this.grid.setAutoExpandMax(2000);
                ChildItemsTabItem.this.grid.setAutoExpandColumn(autoExpandColumn);
                ChildItemsTabItem.this.grid.reconfigure(ChildItemsTabItem.this.store, new ColumnModel(columns));
            }
        });
        tab.layout();
        tab.setProcessed(true);
    }

    private MessageBox getNamePrompt() {
        MessageBox box = MessageBox.prompt((String)Messages.get("label.name"), (String)(Messages.get("label.enterItemName") + ":"));
        box.getTextBox().setValidator(new Validator(){

            public String validate(Field<?> field, String value) {
                if (!value.equals("*") && !value.matches("[A-Za-z]+[A-Za-z0-9:_]*")) {
                    return Messages.get("label.childName.error", "the name can contain only letters or numbers (: and _ are also allowed) and must start by a letter");
                }
                for (GWTJahiaNode n : ChildItemsTabItem.this.store.getModels()) {
                    if (!n.getName().equals(value)) continue;
                    return Messages.get("label.duplicate.name", "this name already used, please select a new one");
                }
                return null;
            }
        });
        return box;
    }

    @Override
    public void onLanguageChange(String language, TabItem tabItem) {
        this.currentLanguage = language;
        this.switchPropertiesEditor(tabItem);
        super.onLanguageChange(language, tabItem);
    }

    private void switchPropertiesEditor(final TabItem tab) {
        if (this.grid == null || this.grid.getSelectionModel() == null) {
            return;
        }
        final GWTJahiaNode item = (GWTJahiaNode)this.grid.getSelectionModel().getSelectedItem();
        if (this.propertiesEditor != null) {
            tab.remove((Widget)this.propertiesEditor);
        }
        if (item == null) {
            this.propertiesEditor = null;
            tab.layout();
        } else if (this.propertiesEditorsByLang.containsKey(item) && this.propertiesEditorsByLang.get(item).containsKey(this.currentLanguage)) {
            this.propertiesEditor = this.propertiesEditorsByLang.get(item).get(this.currentLanguage);
            PropertiesEditor previous = this.propertiesEditors.get(item);
            this.propertiesEditors.put(item, this.propertiesEditor);
            this.syncWithPrevious(previous, this.propertiesEditor);
            tab.add((Widget)this.propertiesEditor, (LayoutData)new RowData(1.0, 1.0, new Margins(2)));
            tab.layout();
        } else if (item.getPath() != null) {
            JahiaContentManagementService.App.getInstance().getProperties(item.getPath(), this.currentLanguage, (AsyncCallback<GWTJahiaGetPropertiesResult>)new BaseAsyncCallback<GWTJahiaGetPropertiesResult>(){

                public void onSuccess(GWTJahiaGetPropertiesResult result) {
                    ChildItemsTabItem.this.displayProperties(item, result.getNodeTypes(), result.getProperties());
                    tab.add((Widget)ChildItemsTabItem.this.propertiesEditor, (LayoutData)new RowData(1.0, 1.0, new Margins(2)));
                    tab.layout();
                }
            });
        } else {
            item.set("newItem", "true");
            item.setPath(this.engineNode.getPath() + "/" + item.getName());
            this.displayProperties(item, Arrays.asList(this.nodeType), (Map)item.get("default-properties"));
            item.remove("default-properties");
            tab.add((Widget)this.propertiesEditor, (LayoutData)new RowData(1.0, 1.0, new Margins(2)));
            tab.layout();
        }
    }

    private void initValues(GWTJahiaNode item) {
        HashMap<String, GWTJahiaNodeProperty> properties = new HashMap<String, GWTJahiaNodeProperty>();
        for (GWTJahiaItemDefinition definition : this.nodeType.getItems()) {
            GWTJahiaPropertyDefinition propertyDefinition;
            List<GWTJahiaNodePropertyValue> defaultValues;
            if (!(definition instanceof GWTJahiaPropertyDefinition) || (defaultValues = (propertyDefinition = (GWTJahiaPropertyDefinition)definition).getDefaultValues()) == null) continue;
            GWTJahiaNodeProperty value = new GWTJahiaNodeProperty(definition.getName(), (GWTJahiaNodePropertyValue)null);
            value.setMultiple(propertyDefinition.isMultiple());
            value.setValues(defaultValues);
            properties.put(definition.getName(), value);
            if (propertyDefinition.isMultiple()) {
                item.set(definition.getName(), value.getValues());
                continue;
            }
            if (value.getValues().isEmpty()) continue;
            item.set(definition.getName(), value.getValues().get(0));
        }
        item.set("default-properties", properties);
    }

    private void displayProperties(final GWTJahiaNode item, List<GWTJahiaNodeType> nodeTypes, Map<String, GWTJahiaNodeProperty> properties) {
        for (GWTJahiaNodeType nt : nodeTypes) {
            if (!nt.getName().equals("jnt:unstructuredChildNodeDefinition") && !nt.getSuperTypes().contains("jnt:unstructuredChildNodeDefinition") && !nt.getName().equals("jnt:unstructuredPropertyDefinition") && !nt.getSuperTypes().contains("jnt:unstructuredPropertyDefinition")) continue;
            for (GWTJahiaItemDefinition def : nt.getInheritedItems()) {
                if (!def.isHidden()) continue;
                def.setHidden(false);
                def.setProtected(true);
            }
        }
        this.propertiesEditor = new PropertiesEditor(nodeTypes, properties, null);
        this.propertiesEditor.setChoiceListInitializersValues(this.initializerMap);
        if (!this.propertiesEditorsByLang.containsKey(item)) {
            this.propertiesEditorsByLang.put(item, new HashMap());
        }
        this.propertiesEditorsByLang.get(item).put(this.currentLanguage, this.propertiesEditor);
        PropertiesEditor previous = this.propertiesEditors.get(item);
        this.propertiesEditors.put(item, this.propertiesEditor);
        this.propertiesEditor.renderNewFormPanel();
        this.syncWithPrevious(previous, this.propertiesEditor);
        for (final String key : this.columnsKeys) {
            if (!this.propertiesEditor.getFieldsMap().containsKey(key)) continue;
            final PropertiesEditor.PropertyAdapterField field = this.propertiesEditor.getFieldsMap().get(key);
            if (field.getField() instanceof DualListField) {
                ((DualListField)field.getField()).getToList().getStore().addStoreListener((StoreListener)new StoreListener<GWTJahiaValueDisplayBean>(){

                    public void handleEvent(StoreEvent<GWTJahiaValueDisplayBean> e) {
                        ArrayList<String> strings = new ArrayList<String>();
                        List beans = ((ListStore)e.getSource()).getModels();
                        for (GWTJahiaValueDisplayBean bean : beans) {
                            strings.add(bean.getValue());
                        }
                        item.set(key, strings);
                        ChildItemsTabItem.this.store.update((ModelData)item);
                        super.handleEvent(e);
                    }
                });
                continue;
            }
            field.addListener(Events.Change, (Listener<? extends BaseEvent>)new Listener<BaseEvent>(){

                public void handleEvent(BaseEvent be) {
                    Object value = field.getValue();
                    if (value instanceof GWTJahiaValueDisplayBean) {
                        value = ((GWTJahiaValueDisplayBean)value).getValue();
                    }
                    item.set(key, value);
                    ChildItemsTabItem.this.store.update((ModelData)item);
                }
            });
        }
    }

    private List<GWTJahiaNode> getOrderedSelectedList() {
        List selectedNodes = this.grid.getSelectionModel().getSelection();
        Comparator<GWTJahiaNode> c = new Comparator<GWTJahiaNode>(){

            @Override
            public int compare(GWTJahiaNode gwtJahiaNode, GWTJahiaNode gwtJahiaNode1) {
                int index2;
                int index = ChildItemsTabItem.this.grid.getStore().indexOf((ModelData)gwtJahiaNode);
                if (index == (index2 = ChildItemsTabItem.this.grid.getStore().indexOf((ModelData)gwtJahiaNode1))) {
                    return 0;
                }
                if (index > index2) {
                    return 1;
                }
                return -1;
            }
        };
        Collections.sort(selectedNodes, c);
        return selectedNodes;
    }

    public List<GWTJahiaNode> getOrderedNodes() {
        return this.grid.getStore().getModels();
    }

    @Override
    public void setProcessed(boolean processed) {
        if (!processed) {
            this.store = null;
            this.engineNode = null;
        }
        super.setProcessed(processed);
    }

    @Override
    public void doSave(GWTJahiaNode node, List<GWTJahiaNodeProperty> changedProperties, Map<String, List<GWTJahiaNodeProperty>> changedI18NProperties, Set<String> addedTypes, Set<String> removedTypes, List<GWTJahiaNode> children, GWTJahiaNodeACL acl) {
        if (this.store != null) {
            ArrayList definitions = new ArrayList(this.store.getModels());
            for (GWTJahiaNode itemDefinition : definitions) {
                boolean duplicate = false;
                if (this.propertiesEditorsByLang.containsKey(itemDefinition)) {
                    boolean isNew;
                    PropertiesEditor pe = this.propertiesEditors.get(itemDefinition);
                    Map<String, PropertiesEditor> peByLang = this.propertiesEditorsByLang.get(itemDefinition);
                    boolean bl = isNew = itemDefinition.get("uuid") == null;
                    if (itemDefinition.getName().startsWith("__undef")) {
                        itemDefinition.setName(this.computeUnstructuredItemName(itemDefinition));
                        String path = itemDefinition.getPath().substring(0, itemDefinition.getPath().indexOf("__undef")) + itemDefinition.getName();
                        for (GWTJahiaNode n : this.store.getModels()) {
                            if (!n.getPath().equals(path)) continue;
                            duplicate = true;
                            break;
                        }
                        if (!duplicate) {
                            itemDefinition.setPath(itemDefinition.getPath().substring(0, itemDefinition.getPath().indexOf("__undef")) + itemDefinition.getName());
                        } else {
                            this.children.remove(itemDefinition);
                        }
                    }
                    itemDefinition.set("nodeProperties", pe.getProperties(false, true, !isNew));
                    HashMap<String, List<GWTJahiaNodeProperty>> langCodeProperties = new HashMap<String, List<GWTJahiaNodeProperty>>();
                    for (Map.Entry<String, PropertiesEditor> entry : peByLang.entrySet()) {
                        langCodeProperties.put(entry.getKey(), entry.getValue().getProperties(true, false, !isNew));
                    }
                    itemDefinition.set("nodeLangCodeProperties", langCodeProperties);
                    continue;
                }
                itemDefinition.set("nodeProperties", new ArrayList());
                itemDefinition.set("nodeLangCodeProperties", new HashMap());
            }
            Comparator<ModelData> nodeComparator = new Comparator<ModelData>(){

                @Override
                public int compare(ModelData o1, ModelData o2) {
                    int index2;
                    int index = o1 != null && o1 instanceof GWTJahiaNode ? ChildItemsTabItem.this.grid.getStore().indexOf((ModelData)((GWTJahiaNode)o1)) : -1;
                    int n = index2 = o2 != null && o2 instanceof GWTJahiaNode ? ChildItemsTabItem.this.grid.getStore().indexOf((ModelData)((GWTJahiaNode)o2)) : -1;
                    return index < index2 ? -1 : (index == index2 ? 0 : 1);
                }
            };
            if (node != null) {
                Collections.sort(node.getChildren(), nodeComparator);
            }
            Collections.sort(this.children, nodeComparator);
            if (node != null) {
                for (GWTJahiaNode child : this.removedChildren) {
                    node.remove((ModelData)child);
                }
                for (GWTJahiaNode child : this.children) {
                    if (node.getChildren().contains(child)) continue;
                    node.add((ModelData)child);
                }
                this.children.clear();
                node.set("includeChildren", Boolean.TRUE);
            } else {
                children.addAll(this.children);
            }
        }
    }

    private void removeSorter() {
        if (this.grid.getStore().getStoreSorter() != null) {
            this.grid.getStore().setSortField(null);
            this.grid.getStore().setStoreSorter(null);
            this.grid.getView().refresh(true);
        } else {
            this.grid.getView().refresh(false);
        }
    }

    private String computeUnstructuredItemName(GWTJahiaNode node) {
        String s1 = "";
        if (node.getNodeTypes().contains("jnt:unstructuredPropertyDefinition")) {
            boolean isMultiple = false;
            List<GWTJahiaNodeProperty> properties = this.propertiesEditors.get(node).getProperties();
            for (GWTJahiaNodeProperty property : properties) {
                if (!property.getName().equals("j:multiple")) continue;
                isMultiple = property.getValues().get(0).getBoolean();
            }
            if (isMultiple) {
                if (node.get("j:requiredType") instanceof String) {
                    int i = 256 + this.getPropertyType((String)node.get("j:requiredType"));
                    s1 = "__prop__" + i;
                } else if (node.get("j:requiredType") instanceof GWTJahiaNodePropertyValue) {
                    int i = 256 + this.getPropertyType(((GWTJahiaNodePropertyValue)node.get("j:requiredType")).getString());
                    s1 = "__prop__" + i;
                }
            } else if (node.get("j:requiredType") instanceof String) {
                s1 = "__prop__" + this.getPropertyType((String)node.get("j:requiredType"));
            } else if (node.get("j:requiredType") instanceof GWTJahiaNodePropertyValue) {
                s1 = "__prop__" + this.getPropertyType(((GWTJahiaNodePropertyValue)node.get("j:requiredType")).getString());
            }
        } else {
            StringBuilder s = new StringBuilder("__node__");
            for (Object e : (List)node.get("j:requiredPrimaryTypes")) {
                if (e instanceof String) {
                    s.append(((String)e).replace(":", "@@")).append(" ");
                    continue;
                }
                if (!(e instanceof GWTJahiaNodePropertyValue)) continue;
                s.append(((GWTJahiaNodePropertyValue)e).getString().replace(":", "@@")).append(" ");
            }
            s1 = s.toString().trim();
        }
        return s1;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setColumnsConfig(List<String> columnsConfig) {
        this.columnsConfig = columnsConfig;
    }

    public void syncWithPrevious(PropertiesEditor previous, PropertiesEditor propertiesEditor) {
        if (previous != null && !((Object)((Object)previous)).equals((Object)propertiesEditor)) {
            List<GWTJahiaNodeProperty> previousNon18nProperties = previous.getProperties(false, true, true);
            if (previousNon18nProperties != null && !previousNon18nProperties.isEmpty()) {
                Map<String, PropertiesEditor.PropertyAdapterField> fieldsMap = propertiesEditor.getFieldsMap();
                for (GWTJahiaNodeProperty property : previousNon18nProperties) {
                    if (!fieldsMap.containsKey(property.getName())) continue;
                    FormFieldCreator.fillValue(fieldsMap.get(property.getName()).getField(), propertiesEditor.getGWTJahiaItemDefinition(property), property, null, null);
                }
            }
            Set<String> previousAddedTypes = previous.getAddedTypes();
            Set<String> previousRemovedTypes = previous.getRemovedTypes();
            if (previousAddedTypes != null) {
                Map<String, FieldSet> f = propertiesEditor.getFieldSetsMap();
                propertiesEditor.getAddedTypes().addAll(previousAddedTypes);
                propertiesEditor.getRemovedTypes().addAll(previousRemovedTypes);
                for (String addedType : previousAddedTypes) {
                    f.get(addedType).expand();
                }
                for (String addedType : previousRemovedTypes) {
                    f.get(addedType).collapse();
                }
            }
        }
    }

    private int getPropertyType(String token) {
        if (this.tokenEquals(token, STRING)) {
            return Integer.parseInt(STRING[0]);
        }
        if (this.tokenEquals(token, BINARY)) {
            return Integer.parseInt(BINARY[0]);
        }
        if (this.tokenEquals(token, LONG)) {
            return Integer.parseInt(LONG[0]);
        }
        if (this.tokenEquals(token, DOUBLE)) {
            return Integer.parseInt(DOUBLE[0]);
        }
        if (this.tokenEquals(token, BOOLEAN)) {
            return Integer.parseInt(BOOLEAN[0]);
        }
        if (this.tokenEquals(token, DATE)) {
            return Integer.parseInt(DATE[0]);
        }
        if (this.tokenEquals(token, NAME)) {
            return Integer.parseInt(NAME[0]);
        }
        if (this.tokenEquals(token, PATH)) {
            return Integer.parseInt(PATH[0]);
        }
        if (this.tokenEquals(token, REFERENCE)) {
            return Integer.parseInt(REFERENCE[0]);
        }
        if (this.tokenEquals(token, WEAKREFERENCE)) {
            return Integer.parseInt(WEAKREFERENCE[0]);
        }
        if (this.tokenEquals(token, URI)) {
            return Integer.parseInt(URI[0]);
        }
        if (this.tokenEquals(token, DECIMAL)) {
            return Integer.parseInt(DECIMAL[0]);
        }
        if (this.tokenEquals(token, UNDEFINED)) {
            return Integer.parseInt(UNDEFINED[0]);
        }
        return -1;
    }

    private boolean tokenEquals(String token, String[] s) {
        for (String e : s) {
            if (!token.equals(e)) continue;
            return true;
        }
        return false;
    }
}

