/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.edit.mainarea;

import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Header;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.Text;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.icons.ToolbarIconProvider;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.MainModule;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.SimpleModule;

public class AreaModule
extends SimpleModule {
    private String mockupStyle;
    private String areaType = "jnt:contentList";
    private String areaHolder;
    private boolean showAreaButton;
    private boolean missingList;
    private final LayoutContainer content;
    private String conflictsWith = null;
    private static int MIN_WIDTH = 100;

    public AreaModule(String id, String path, com.google.gwt.user.client.Element divElement, String moduleType, MainModule mainModule) {
        super(id, path, divElement, mainModule);
        this.hasDragDrop = false;
        this.addIconInHeader = false;
        this.head = new Header();
        if (this.editable) {
            this.add((Component)this.head);
        }
        this.mockupStyle = DOM.getElementAttribute((Element)divElement, (String)"mockupStyle");
        this.missingList = "true".equals(DOM.getElementAttribute((Element)divElement, (String)"missingList"));
        this.showAreaButton = "true".equals(DOM.getElementAttribute((Element)divElement, (String)"showAreaButton"));
        this.areaHolder = DOM.getElementAttribute((Element)divElement, (String)"areaHolder");
        this.conflictsWith = DOM.getElementAttribute((Element)divElement, (String)"conflictsWith");
        String areaType = DOM.getElementAttribute((Element)divElement, (String)"areaType");
        if (areaType != null && areaType.length() > 0) {
            this.areaType = areaType;
        }
        if (this.conflictsWith.length() == 0) {
            this.conflictsWith = null;
        }
        String areaTitle = path.contains("/") ? path.substring(path.lastIndexOf(47) + 1) : path;
        this.setHeaderText(areaTitle);
        this.head.setId("JahiaGxtArea__" + areaTitle);
        this.head.setTextStyle("x-panel-header-text-" + moduleType + "module");
        this.head.addStyleName("x-panel-header");
        this.head.addStyleName("x-panel-header-" + moduleType + "module");
        this.html = new HTML(divElement.getInnerHTML());
        this.content = new LayoutContainer();
        this.content.add((Widget)this.html);
        this.add((Component)this.content);
    }

    @Override
    public void onParsed() {
        super.onParsed();
        this.addStyleName(this.mainModule.getConfig().getName() + "Area");
        this.setBorders(true);
        if (this.missingList && this.editable) {
            if (this.mockupStyle != null) {
                this.addStyleName(this.mockupStyle);
            }
            this.canHover = false;
        }
    }

    @Override
    public void onNodeTypesLoaded() {
        if (this.conflictsWith != null) {
            HorizontalPanel p = new HorizontalPanel();
            Text label = new Text(Messages.getWithArgs("label.areaConflicts", "Area conflicts with same name node {0}. Rename the area or the node", new String[]{this.conflictsWith}));
            if (this.getWidth() >= MIN_WIDTH) {
                p.add((Widget)label);
            } else {
                p.setTitle(label.getText());
            }
            this.head.addTool((Component)p);
            this.layout();
        } else if (this.missingList && this.editable && this.showAreaButton) {
            HorizontalPanel p = new HorizontalPanel();
            Image icon = ToolbarIconProvider.getInstance().getIcon("enableArea").createImage();
            icon.setTitle(Messages.get("label.areaEnable", "Enable area"));
            p.add((Widget)icon);
            p.sinkEvents(1);
            p.addStyleName("button-enable");
            p.addListener(Events.OnClick, (Listener)new Listener<ComponentEvent>(){

                public void handleEvent(ComponentEvent be) {
                    AreaModule.this.createNode((AsyncCallback<GWTJahiaNode>)new BaseAsyncCallback<GWTJahiaNode>(){

                        public void onSuccess(GWTJahiaNode result) {
                            HashMap<String, Object> data = new HashMap<String, Object>();
                            data.put("refreshMain", true);
                            AreaModule.this.mainModule.getEditLinker().refresh(data);
                        }
                    });
                }
            });
            this.head.addTool((Component)p);
            this.addStyleName(this.mainModule.getConfig().getName() + "DisableArea");
            this.content.addStyleName(this.mainModule.getConfig().getName() + "DisableAreaContent");
            this.layout();
        }
    }

    public void setEnabledEmptyArea() {
        if (this.showAreaButton) {
            HorizontalPanel p = new HorizontalPanel();
            Image icon = ToolbarIconProvider.getInstance().getIcon("disableArea").createImage();
            icon.setTitle(Messages.get("label.areaDisable", "Disable area"));
            p.add((Widget)icon);
            p.sinkEvents(1);
            p.addStyleName("button-disable");
            p.addListener(Events.OnClick, (Listener)new Listener<ComponentEvent>(){

                public void handleEvent(ComponentEvent be) {
                    JahiaContentManagementService.App.getInstance().deletePaths(Arrays.asList(AreaModule.this.path), (AsyncCallback<GWTJahiaNode>)new BaseAsyncCallback<GWTJahiaNode>(){

                        public void onSuccess(GWTJahiaNode result) {
                            HashMap<String, Object> data = new HashMap<String, Object>();
                            data.put("refreshMain", true);
                            AreaModule.this.mainModule.getEditLinker().refresh(data);
                        }
                    });
                }
            });
            this.head.addTool((Component)p);
            this.addStyleName(this.mainModule.getConfig().getName() + "EnabledEmptyArea");
            this.content.addStyleName(this.mainModule.getConfig().getName() + "EnabledEmptyAreaContent");
            this.layout();
        }
    }

    public String getAreaHolder() {
        return this.areaHolder;
    }

    @Override
    public String getPath() {
        return "*";
    }

    public void createNode(final AsyncCallback<GWTJahiaNode> callback) {
        if (this.node == null) {
            JahiaContentManagementService.App.getInstance().createNode(this.path.substring(0, this.path.lastIndexOf(47)), this.path.substring(this.path.lastIndexOf(47) + 1), this.areaType, Collections.singletonList("jmix:isAreaList"), null, null, null, null, null, true, new AsyncCallback<GWTJahiaNode>(){

                public void onSuccess(GWTJahiaNode result) {
                    AreaModule.this.node = result;
                    callback.onSuccess((Object)result);
                }

                public void onFailure(Throwable caught) {
                    callback.onFailure(caught);
                }
            });
        } else {
            callback.onSuccess((Object)this.node);
        }
    }
}

