/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.edit.mainarea;

import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.widget.BoxComponent;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.google.gwt.dom.client.Node;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.jahia.ajax.gwt.client.data.toolbar.GWTConfiguration;
import org.jahia.ajax.gwt.client.util.WindowUtil;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.AreaModule;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.ListModule;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.MainModule;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.Module;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.SimpleModule;

public class Hover {
    private static Hover instance;
    private MainModule mainModule;
    private Map<Module, Box> boxes = new HashMap<Module, Box>();

    public static Hover getInstance() {
        if (instance == null) {
            instance = new Hover();
        }
        return instance;
    }

    private Hover() {
    }

    public void setLightStyle(LayoutContainer l) {
    }

    public void setBoldStyle(LayoutContainer l) {
        l.setBorders(true);
        l.setStyleAttribute("border", "2px dashed");
    }

    public void setMainModule(MainModule m) {
        this.mainModule = m;
    }

    public void addHover(Module module, ComponentEvent ce) {
        if (this.boxes.containsKey((Object)module)) {
            return;
        }
        LayoutContainer c = module.getContainer();
        Box b = new Box(c);
        int max = module.getDepth();
        for (Map.Entry<Module, Box> moduleBoxEntry : this.boxes.entrySet()) {
            if (moduleBoxEntry.getKey().getDepth() <= max) continue;
            max = moduleBoxEntry.getKey().getDepth();
        }
        if (max == module.getDepth()) {
            this.setStyle(module, b);
            module.setSelectable(true);
            module.setDraggable(true);
        } else {
            this.setSecondaryStyle(module, b);
            module.setSelectable(false);
            module.setDraggable(false);
        }
        for (Map.Entry<Module, Box> moduleBoxEntry : this.boxes.entrySet()) {
            Box value = moduleBoxEntry.getValue();
            Module key = moduleBoxEntry.getKey();
            if (key.getDepth() == max) {
                this.setStyle(key, value);
                key.setSelectable(true);
                key.setDraggable(true);
                continue;
            }
            this.setSecondaryStyle(key, value);
            key.setSelectable(false);
            key.setDraggable(false);
        }
        this.mainModule.setSelectable(false);
        if (this.boxes.containsKey((Object)module)) {
            return;
        }
        b.show();
        module.addStyleName("hover-module");
        if (this.mainModule.getDragAndDropBehavior() == GWTConfiguration.DragAndDropBehavior.DRAG_ZONE_IN_EDIT_AREA && module.isSelectable() && module instanceof SimpleModule && ((SimpleModule)module).hasDragDrop()) {
            module.addStyleName("hover-draggable ");
            int x = ce.getClientX() - module.getAbsoluteLeft();
            int y = ce.getClientY() - module.getAbsoluteTop();
            boolean inDragZone = x < 20 && y < 20;
            ((SimpleModule)module).setDragEnabled(inDragZone);
        }
        this.boxes.put(module, b);
    }

    public void removeHover(Module module) {
        Box b = this.boxes.get((Object)module);
        if (b != null) {
            b.hide();
            this.boxes.remove((Object)module);
            module.removeStyleName("hover-module");
            module.removeStyleName("hover-draggable");
        }
        if (this.boxes.isEmpty()) {
            this.mainModule.setSelectable(true);
        }
    }

    public void removeAll() {
        for (Map.Entry<Module, Box> entry : this.boxes.entrySet()) {
            entry.getKey().removeStyleName("hover-module");
            entry.getKey().removeStyleName("hover-draggable");
            entry.getValue().hide();
        }
        this.boxes.clear();
    }

    private void setStyle(Module module, Box value) {
        if (module instanceof ListModule) {
            value.setStyle("list");
        } else if (module instanceof AreaModule) {
            value.setStyle("area");
        } else {
            value.setStyle("simple");
        }
    }

    private void setSecondaryStyle(Module module, Box value) {
        if (module instanceof ListModule) {
            value.setStyle("list-secondary");
        } else if (module instanceof AreaModule) {
            value.setStyle("area-secondary");
        } else {
            value.setStyle("simple-secondary");
        }
    }

    class Box
    extends LayoutContainer {
        LayoutContainer ctn;
        private BoxComponent top;
        private BoxComponent bottom;
        private BoxComponent left;
        private BoxComponent right;

        Box(LayoutContainer ctn) {
            this.ctn = ctn;
            this.top = new LayoutContainer();
            this.bottom = new LayoutContainer();
            this.left = new LayoutContainer();
            this.right = new LayoutContainer();
            this.top.setStyleAttribute("z-index", "990");
            this.bottom.setStyleAttribute("z-index", "990");
            this.left.setStyleAttribute("z-index", "990");
            this.right.setStyleAttribute("z-index", "990");
            this.hide();
        }

        private void setStyle(String key) {
            this.top.setStyleName("hover-top-" + key);
            this.bottom.setStyleName("hover-bottom-" + key);
            this.left.setStyleName("hover-left-" + key);
            this.right.setStyleName("hover-right-" + key);
        }

        public void setPosition(int x, int y, int w, int h) {
            this.top.setPosition(x, y);
            this.top.setSize(w, 0);
            this.bottom.setPosition(x, y + h);
            this.bottom.setSize(w, 0);
            this.left.setPosition(x, y);
            this.left.setSize(0, h);
            this.right.setPosition(x + w, y);
            this.right.setSize(0, h);
        }

        public void show() {
            if (!this.hidden) {
                return;
            }
            this.hidden = false;
            RootPanel.get().add((Widget)this.top);
            Hover.this.mainModule.getInnerElement().appendChild((Node)this.top.getElement());
            this.top.el().makePositionable(true);
            RootPanel.get().add((Widget)this.left);
            Hover.this.mainModule.getInnerElement().appendChild((Node)this.left.getElement());
            this.left.el().makePositionable(true);
            RootPanel.get().add((Widget)this.right);
            Hover.this.mainModule.getInnerElement().appendChild((Node)this.right.getElement());
            this.right.el().makePositionable(true);
            RootPanel.get().add((Widget)this.bottom);
            Hover.this.mainModule.getInnerElement().appendChild((Node)this.bottom.getElement());
            this.bottom.el().makePositionable(true);
            this.onShow();
            Element element = this.ctn.getElement();
            this.setPosition(WindowUtil.getAbsoluteLeft(element), WindowUtil.getAbsoluteTop(element), this.ctn.getWidth(), this.ctn.getHeight());
        }

        public void hide() {
            if (this.hidden) {
                return;
            }
            this.hidden = true;
            this.onHide();
            RootPanel.get().remove((Widget)this.top);
            RootPanel.get().remove((Widget)this.bottom);
            RootPanel.get().remove((Widget)this.left);
            RootPanel.get().remove((Widget)this.right);
        }
    }
}

