/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.edit.sidepanel;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.FormData;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.TableData;
import com.extjs.gxt.ui.client.widget.layout.VBoxLayout;
import com.extjs.gxt.ui.client.widget.layout.VBoxLayoutData;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Map;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTJahiaBasicDataBean;
import org.jahia.ajax.gwt.client.data.GWTJahiaChannel;
import org.jahia.ajax.gwt.client.data.toolbar.GWTSidePanelTab;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.widget.edit.sidepanel.SidePanelTabItem;

public class ChannelsTabItem
extends SidePanelTabItem {
    protected transient Grid<GWTJahiaBasicDataBean> grid;
    protected transient ComboBox<GWTJahiaChannel> deviceCombo;
    protected transient ComboBox<GWTJahiaBasicDataBean> orientationComponent;
    protected transient Image deviceImage;
    protected transient Label deviceNameLabel;

    @Override
    public TabItem create(GWTSidePanelTab sidePanelTab) {
        super.create(sidePanelTab);
        this.tab.setScrollMode(Style.Scroll.AUTO);
        this.tab.setId("JahiaGxtChannelsTab");
        VBoxLayout verticalEastLayout = new VBoxLayout();
        verticalEastLayout.setVBoxLayoutAlign(VBoxLayout.VBoxLayoutAlign.STRETCH);
        this.tab.setLayout((Layout)verticalEastLayout);
        VerticalPanel deviceDetailsPanel = new VerticalPanel();
        deviceDetailsPanel.setTableWidth("100%");
        deviceDetailsPanel.setHorizontalAlign(Style.HorizontalAlignment.CENTER);
        this.deviceImage = new Image();
        deviceDetailsPanel.add((Widget)this.deviceImage, (LayoutData)new TableData("64px", "64px"));
        this.deviceNameLabel = new Label(Messages.get("label.deviceName", "Device name"));
        deviceDetailsPanel.add((Widget)this.deviceNameLabel);
        FormPanel formPanel = new FormPanel();
        formPanel.setPadding(2);
        formPanel.setBorders(false);
        formPanel.setBodyBorder(false);
        formPanel.setHeaderVisible(false);
        ListStore channelListStore = new ListStore();
        channelListStore.add(JahiaGWTParameters.getChannels());
        this.deviceCombo = new ComboBox();
        this.deviceCombo.setEmptyText(Messages.get("label.selectDevice", "Select device..."));
        this.deviceCombo.setDisplayField("display");
        this.deviceCombo.setStore(channelListStore);
        if (channelListStore.getCount() > 0) {
            GWTJahiaChannel channel = (GWTJahiaChannel)channelListStore.getAt(0);
            this.deviceCombo.setValue((ModelData)channel);
            this.deviceImage.setUrl(JahiaGWTParameters.getContextPath() + channel.getCapability("device-image"));
        } else {
            this.deviceCombo.setValue(null);
            this.deviceCombo.disable();
        }
        this.deviceCombo.setTypeAhead(true);
        this.deviceCombo.setWidth(100);
        this.deviceCombo.setFieldLabel(Messages.get("label.device", "Device"));
        this.deviceCombo.setTriggerAction(ComboBox.TriggerAction.ALL);
        this.deviceCombo.setTemplate(this.getChannelTemplate());
        this.deviceCombo.setItemSelector("div.thumb-wrap");
        this.deviceCombo.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaChannel>(){

            public void selectionChanged(SelectionChangedEvent<GWTJahiaChannel> event) {
                GWTJahiaChannel selectedChannel = (GWTJahiaChannel)event.getSelectedItem();
                ChannelsTabItem.this.editLinker.getMainModule().switchChannel(selectedChannel, null);
                ChannelsTabItem.this.doRefresh();
            }
        });
        formPanel.add(this.deviceCombo);
        ListStore orientations = new ListStore();
        this.orientationComponent = new ComboBox();
        this.orientationComponent.setEmptyText(Messages.get("label.selectVariant", "Select variant..."));
        this.orientationComponent.setDisplayField("displayName");
        this.orientationComponent.setName("previewChannelOrientation");
        this.orientationComponent.setStore(orientations);
        if (orientations.getCount() > 0) {
            this.orientationComponent.setValue((ModelData)((GWTJahiaBasicDataBean)orientations.getAt(0)));
        } else {
            this.orientationComponent.disable();
        }
        this.orientationComponent.setTypeAhead(true);
        this.orientationComponent.setWidth(100);
        this.orientationComponent.setFieldLabel(Messages.get("label.variant", "Variant"));
        this.orientationComponent.setTriggerAction(ComboBox.TriggerAction.ALL);
        this.orientationComponent.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaBasicDataBean>(){

            public void selectionChanged(SelectionChangedEvent<GWTJahiaBasicDataBean> se) {
                ChannelsTabItem.this.editLinker.getMainModule().switchChannel(ChannelsTabItem.this.editLinker.getActiveChannel(), ((GWTJahiaBasicDataBean)se.getSelectedItem()).getValue());
            }
        });
        formPanel.add(this.orientationComponent, (LayoutData)new FormData("100%"));
        deviceDetailsPanel.add((Widget)formPanel);
        VBoxLayoutData firstBoxLayoutData = new VBoxLayoutData();
        firstBoxLayoutData.setFlex(1.0);
        this.tab.add((Widget)deviceDetailsPanel, (LayoutData)firstBoxLayoutData);
        ContentPanel gridContentPanel = new ContentPanel((Layout)new FitLayout());
        gridContentPanel.setHeadingHtml(Messages.get("label.capabilities", "Capabilities"));
        ListStore capabilitiesStore = new ListStore();
        ArrayList<ColumnConfig> configs = new ArrayList<ColumnConfig>();
        ColumnConfig column = new ColumnConfig();
        column.setId("displayName");
        column.setHeaderHtml(Messages.get("label.name", "Name"));
        column.setRowHeader(true);
        column.setWidth(100);
        configs.add(column);
        column = new ColumnConfig();
        column.setId("value");
        column.setHeaderHtml(Messages.get("label.value", "Value"));
        column.setWidth(100);
        configs.add(column);
        ColumnModel cm = new ColumnModel(configs);
        this.grid = new Grid(capabilitiesStore, cm);
        this.grid.setAutoExpandColumn("value");
        gridContentPanel.add(this.grid);
        VBoxLayoutData contentVBoxData = new VBoxLayoutData();
        contentVBoxData.setFlex(3.0);
        this.tab.add((Widget)gridContentPanel, (LayoutData)contentVBoxData);
        BorderLayoutData eastData = new BorderLayoutData(Style.LayoutRegion.EAST);
        eastData.setSplit(true);
        eastData.setCollapsible(true);
        eastData.setSize(200.0f);
        eastData.setHidden(true);
        return this.tab;
    }

    @Override
    public boolean needRefresh(Map<String, Object> data) {
        return data.containsKey("event") && "channelChanged".equals(data.get("event"));
    }

    @Override
    public void doRefresh() {
        GWTJahiaChannel activeChannel = this.editLinker.getActiveChannel();
        int activeChannelIndex = 0;
        this.deviceImage.setUrl("");
        this.deviceNameLabel.setHtml(Messages.get("label.default", "Default"));
        if (activeChannel != null) {
            if (activeChannel.getCapability("device-image") != null) {
                this.deviceImage.setUrl(JahiaGWTParameters.getContextPath() + activeChannel.getCapability("device-image"));
            }
            this.deviceNameLabel.setHtml(activeChannel.getDisplay());
        }
        this.orientationComponent.getStore().removeAll();
        if (activeChannel != null && activeChannel.getCapability("variants") != null) {
            String[] variantValueArray;
            String[] variantDisplayNameArray = variantValueArray = activeChannel.getCapability("variants").split(",");
            if (activeChannel.getCapability("variants-displayNames") != null) {
                variantDisplayNameArray = activeChannel.getCapability("variants-displayNames").split(",");
            }
            activeChannelIndex = this.editLinker.getActiveChannelVariantIndex();
            ArrayList<GWTJahiaBasicDataBean> selectedItems = new ArrayList<GWTJahiaBasicDataBean>();
            int i = 0;
            String[] stringArray = variantValueArray;
            int n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                String variantValue;
                String displayName = variantValue = stringArray[j];
                if (i < variantDisplayNameArray.length) {
                    displayName = variantDisplayNameArray[i];
                }
                GWTJahiaBasicDataBean currentVariant = new GWTJahiaBasicDataBean(variantValue, displayName);
                if (activeChannelIndex == i) {
                    selectedItems.add(currentVariant);
                }
                this.orientationComponent.getStore().add((ModelData)currentVariant);
                ++i;
            }
            this.orientationComponent.disableEvents(true);
            this.orientationComponent.setSelection(selectedItems);
            this.orientationComponent.disableEvents(false);
            this.orientationComponent.enable();
        } else {
            this.orientationComponent.disableEvents(true);
            this.orientationComponent.setValue(null);
            this.orientationComponent.disableEvents(false);
            this.orientationComponent.disable();
        }
        this.grid.getStore().removeAll();
        if (activeChannel != null && activeChannel.getCapabilities() != null) {
            for (Map.Entry<String, String> capabilityEntry : activeChannel.getCapabilities().entrySet()) {
                this.grid.getStore().add((ModelData)new GWTJahiaBasicDataBean(capabilityEntry.getValue(), capabilityEntry.getKey()));
            }
        }
        this.tab.layout();
    }

    private native String getChannelTemplate();
}

