/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.edit.sidepanel;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.BaseListLoader;
import com.extjs.gxt.ui.client.data.DataProxy;
import com.extjs.gxt.ui.client.data.ListLoadResult;
import com.extjs.gxt.ui.client.data.ListLoader;
import com.extjs.gxt.ui.client.data.LoadEvent;
import com.extjs.gxt.ui.client.data.PagingLoadResult;
import com.extjs.gxt.ui.client.data.RpcProxy;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.ListViewEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.LoadListener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.store.StoreSorter;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.layout.CenterLayout;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.VBoxLayoutData;
import com.extjs.gxt.ui.client.widget.selection.AbstractStoreSelectionModel;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTSidePanelTab;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.Collator;
import org.jahia.ajax.gwt.client.util.content.JCRClientUtils;
import org.jahia.ajax.gwt.client.widget.content.ThumbsListView;
import org.jahia.ajax.gwt.client.widget.edit.EditLinker;
import org.jahia.ajax.gwt.client.widget.edit.sidepanel.BrowseTabItem;
import org.jahia.ajax.gwt.client.widget.edit.sidepanel.ImageDragSource;

class FileImagesBrowseTabItem
extends BrowseTabItem {
    protected transient LayoutContainer contentContainer;
    protected transient ListLoader<ListLoadResult<GWTJahiaNode>> listLoader;
    protected transient ListStore<GWTJahiaNode> contentStore;
    protected transient ImageDragSource dragSource;
    protected transient ThumbsListView listView;

    FileImagesBrowseTabItem() {
    }

    @Override
    public TabItem create(GWTSidePanelTab config) {
        super.create(config);
        this.contentContainer = new LayoutContainer();
        this.contentContainer.setId("images-view");
        this.contentContainer.setBorders(true);
        this.contentContainer.setScrollMode(Style.Scroll.AUTOY);
        this.contentContainer.setLayout((Layout)new FitLayout());
        RpcProxy<PagingLoadResult<GWTJahiaNode>> listProxy = new RpcProxy<PagingLoadResult<GWTJahiaNode>>(){

            protected void load(Object gwtJahiaFolder, AsyncCallback<PagingLoadResult<GWTJahiaNode>> listAsyncCallback) {
                if (gwtJahiaFolder != null) {
                    String path = ((GWTJahiaNode)gwtJahiaFolder).getPath();
                    Log.debug((String)("retrieving children of " + path));
                    JahiaContentManagementService.App.getInstance().lsLoad(path, JCRClientUtils.FILE_NODETYPES, null, null, Arrays.asList("permissions", "icon", "publicationInfo", "thumbnails", "tags", "j:width", "j:height"), false, -1, -1, false, null, null, false, false, listAsyncCallback);
                } else {
                    FileImagesBrowseTabItem.this.contentContainer.unmask();
                }
            }
        };
        this.listLoader = new BaseListLoader((DataProxy)listProxy);
        this.listLoader.addLoadListener(new LoadListener(){

            public void loaderLoad(LoadEvent le) {
                if (!le.isCancelled()) {
                    FileImagesBrowseTabItem.this.contentContainer.unmask();
                }
            }
        });
        this.contentStore = new ListStore(this.listLoader);
        this.contentStore.setStoreSorter(new StoreSorter((Comparator)new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof String && o2 instanceof String) {
                    String s1 = (String)o1;
                    String s2 = (String)o2;
                    return Collator.getInstance().localeCompare(s1, s2);
                }
                if (o1 instanceof Comparable && o2 instanceof Comparable) {
                    return ((Comparable)o1).compareTo(o2);
                }
                return 0;
            }
        }));
        this.tree.getSelectionModel().addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaNode>(){

            public void selectionChanged(SelectionChangedEvent<GWTJahiaNode> event) {
                FileImagesBrowseTabItem.this.contentContainer.mask(Messages.get("label.loading", "Loading..."), "x-mask-loading");
                FileImagesBrowseTabItem.this.listLoader.load((Object)event.getSelectedItem());
            }
        });
        this.tree.setContextMenu(this.createContextMenu(config.getTreeContextMenu(), (AbstractStoreSelectionModel<GWTJahiaNode>)this.tree.getSelectionModel()));
        this.listView = new ThumbsListView(true);
        this.listView.setStyleAttribute("overflow-x", "hidden");
        this.listView.setStore(this.contentStore);
        this.contentStore.setSortField("display");
        this.contentContainer.add((Widget)this.listView);
        VBoxLayoutData contentVBoxData = new VBoxLayoutData();
        contentVBoxData.setFlex(2.0);
        this.tab.add((Widget)this.contentContainer, (LayoutData)contentVBoxData);
        this.listView.addListener(Events.DoubleClick, (Listener)new Listener<ListViewEvent<GWTJahiaNode>>(){

            public void handleEvent(ListViewEvent<GWTJahiaNode> be) {
                Window w = new Window();
                w.addStyleName("fileimage-browse-preview");
                GWTJahiaNode node = (GWTJahiaNode)FileImagesBrowseTabItem.this.listView.getSelectionModel().getSelectedItem();
                String text = "Preview of " + node.getDisplayName();
                w.setHeadingHtml(text);
                w.setScrollMode(Style.Scroll.AUTO);
                w.setModal(true);
                w.setClosable(true);
                w.setMaximizable(true);
                w.setSize(Math.max(Integer.parseInt((String)node.get("j:width")) + 60, 400), Math.max(Integer.parseInt((String)node.get("j:height")) + 80, 50));
                w.setBlinkModal(true);
                w.setPlain(true);
                w.setToolTip(text);
                w.setLayout((Layout)new CenterLayout());
                w.add((Widget)new Image(((GWTJahiaNode)FileImagesBrowseTabItem.this.listView.getSelectionModel().getSelectedItem()).getUrl()));
                w.show();
            }
        });
        this.listView.setContextMenu(this.createContextMenu(config.getTableContextMenu(), (AbstractStoreSelectionModel<GWTJahiaNode>)this.listView.getSelectionModel()));
        this.tab.setId("JahiaGxtFileImagesBrowseTab");
        return this.tab;
    }

    @Override
    public void initWithLinker(EditLinker linker) {
        super.initWithLinker(linker);
        if (linker.getConfig().isDragAndDropEnabled()) {
            this.dragSource = new ImageDragSource(this.listView);
            this.dragSource.addDNDListener(linker.getDndListener());
        }
    }

    @Override
    protected boolean acceptNode(GWTJahiaNode node) {
        return node.getInheritedNodeTypes().contains("nt:file");
    }

    @Override
    public boolean needRefresh(Map<String, Object> data) {
        GWTJahiaNode node;
        data.put("refreshMain", false);
        if (data.containsKey("node") && ((node = (GWTJahiaNode)data.get("node")).getNodeTypes().contains("jnt:folder") || node.getNodeTypes().contains("jnt:file"))) {
            return true;
        }
        return super.needRefresh(data);
    }
}

