/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.edit.sidepanel;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.PagingLoadResult;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.GridEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.store.StoreSorter;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.VBoxLayout;
import com.extjs.gxt.ui.client.widget.layout.VBoxLayoutData;
import com.extjs.gxt.ui.client.widget.selection.AbstractStoreSelectionModel;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTRenderResult;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTSidePanelTab;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementServiceAsync;
import org.jahia.ajax.gwt.client.util.Collator;
import org.jahia.ajax.gwt.client.util.content.JCRClientUtils;
import org.jahia.ajax.gwt.client.util.icons.ContentModelIconProvider;
import org.jahia.ajax.gwt.client.widget.NodeColumnConfigList;
import org.jahia.ajax.gwt.client.widget.contentengine.EngineLoader;
import org.jahia.ajax.gwt.client.widget.edit.EditLinker;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.ModuleHelper;
import org.jahia.ajax.gwt.client.widget.edit.sidepanel.DisplayGridDragSource;
import org.jahia.ajax.gwt.client.widget.edit.sidepanel.SidePanelTabItem;

class LastContentBrowseTabItem
extends SidePanelTabItem {
    protected String search;
    protected int limit = -1;
    private String cssWrapper;
    protected transient LayoutContainer contentContainer;
    protected transient ListStore<GWTJahiaNode> contentStore;
    protected transient DisplayGridDragSource displayGridSource;
    private transient LayoutContainer previewLayoutContainer;
    protected transient Grid<GWTJahiaNode> grid;

    LastContentBrowseTabItem() {
    }

    @Override
    public TabItem create(GWTSidePanelTab config) {
        super.create(config);
        this.tab.addListener(Events.Select, (Listener)new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                LastContentBrowseTabItem.this.fillStore();
                LastContentBrowseTabItem.this.tab.removeListener(Events.Select, (Listener)this);
            }
        });
        VBoxLayout l = new VBoxLayout();
        l.setVBoxLayoutAlign(VBoxLayout.VBoxLayoutAlign.STRETCH);
        this.tab.setLayout((Layout)l);
        this.contentContainer = new LayoutContainer();
        this.contentContainer.setBorders(true);
        this.contentContainer.setScrollMode(Style.Scroll.AUTO);
        this.contentContainer.setLayout((Layout)new FitLayout());
        this.contentStore = new ListStore();
        this.contentStore.setStoreSorter(new StoreSorter((Comparator)new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof String && o2 instanceof String) {
                    String s1 = (String)o1;
                    String s2 = (String)o2;
                    return Collator.getInstance().localeCompare(s1, s2);
                }
                if (o1 instanceof Comparable && o2 instanceof Comparable) {
                    return ((Comparable)o1).compareTo(o2);
                }
                return 0;
            }
        }));
        ArrayList<ColumnConfig> displayColumns = new ArrayList<ColumnConfig>();
        ColumnConfig col = new ColumnConfig("icon", "", 40);
        col.setAlignment(Style.HorizontalAlignment.CENTER);
        col.setRenderer((GridCellRenderer)new GridCellRenderer<GWTJahiaNode>(){

            public String render(GWTJahiaNode modelData, String s, ColumnData columnData, int i, int i1, ListStore<GWTJahiaNode> listStore, Grid<GWTJahiaNode> g) {
                return ContentModelIconProvider.getInstance().getIcon(modelData).getHTML();
            }
        });
        displayColumns.add(col);
        col = new ColumnConfig("displayName", Messages.get("label.name"), 170);
        col.setRenderer(NodeColumnConfigList.NAME_RENDERER);
        displayColumns.add(col);
        col = new ColumnConfig("jcr:lastModified", Messages.get("label.lastModif"), 100);
        col.setDateTimeFormat(DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_SHORT));
        displayColumns.add(col);
        this.grid = new Grid(this.contentStore, new ColumnModel(displayColumns));
        this.contentContainer.add(this.grid);
        this.grid.setContextMenu(this.createContextMenu(config.getTableContextMenu(), (AbstractStoreSelectionModel<GWTJahiaNode>)this.grid.getSelectionModel()));
        this.grid.getStore().setMonitorChanges(true);
        this.grid.setAutoExpandColumn("displayName");
        this.previewLayoutContainer = new LayoutContainer();
        this.previewLayoutContainer.setLayout((Layout)new FitLayout());
        this.previewLayoutContainer.addStyleName(this.cssWrapper);
        this.grid.getSelectionModel().addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaNode>(){

            public void selectionChanged(SelectionChangedEvent<GWTJahiaNode> evt) {
                if (evt.getSelectedItem() != null) {
                    JahiaContentManagementService.App.getInstance().getRenderedContent(((GWTJahiaNode)evt.getSelectedItem()).getPath(), null, LastContentBrowseTabItem.this.editLinker.getLocale(), "default", "preview", null, true, "editmode", LastContentBrowseTabItem.this.editLinker.getActiveChannelIdentifier(), null, (AsyncCallback<GWTRenderResult>)new BaseAsyncCallback<GWTRenderResult>(){

                        public void onSuccess(GWTRenderResult gwtRenderResult) {
                            LastContentBrowseTabItem.this.previewLayoutContainer.removeAll();
                            LastContentBrowseTabItem.this.previewLayoutContainer.add((Widget)new HTML(gwtRenderResult.getResult()));
                            LastContentBrowseTabItem.this.previewLayoutContainer.layout(true);
                        }
                    });
                } else {
                    LastContentBrowseTabItem.this.previewLayoutContainer.removeAll();
                    LastContentBrowseTabItem.this.previewLayoutContainer.layout(true);
                }
            }
        });
        this.grid.addListener(Events.OnDoubleClick, (Listener)new Listener<GridEvent<GWTJahiaNode>>(){

            public void handleEvent(GridEvent<GWTJahiaNode> baseEvent) {
                final GWTJahiaNode gwtJahiaNode = (GWTJahiaNode)baseEvent.getModel();
                if (gwtJahiaNode != null && LastContentBrowseTabItem.this.editLinker != null) {
                    ModuleHelper.checkCanUseComponentForEdit(gwtJahiaNode.getNodeTypes().get(0), new ModuleHelper.CanUseComponentForEditCallback(){

                        @Override
                        public void handle(boolean canUseComponentForEdit) {
                            if (canUseComponentForEdit) {
                                EngineLoader.showEditEngine(LastContentBrowseTabItem.this.editLinker, gwtJahiaNode, null);
                            }
                        }
                    });
                }
            }
        });
        VBoxLayoutData contentVBoxData = new VBoxLayoutData();
        contentVBoxData.setFlex(2.0);
        this.tab.add((Widget)this.contentContainer, (LayoutData)contentVBoxData);
        contentVBoxData.setFlex(1.0);
        this.tab.add((Widget)this.previewLayoutContainer, (LayoutData)contentVBoxData);
        this.tab.setId("JahiaGxtLastContentBrowseTab");
        return this.tab;
    }

    @Override
    public void initWithLinker(EditLinker linker) {
        super.initWithLinker(linker);
        if (linker.getConfig().isDragAndDropEnabled()) {
            this.displayGridSource = new DisplayGridDragSource(this.grid);
            this.displayGridSource.addDNDListener(this.editLinker.getDndListener());
        }
    }

    private void fillStore() {
        this.contentContainer.mask(Messages.get("label.loading", "Loading..."), "x-mask-loading");
        this.contentStore.setFiresEvents(false);
        if (this.previewLayoutContainer != null) {
            this.previewLayoutContainer.removeAll();
            this.previewLayoutContainer.layout(true);
        }
        this.contentStore.removeAll();
        this.contentStore.setFiresEvents(true);
        JahiaContentManagementServiceAsync async = JahiaContentManagementService.App.getInstance();
        String searchString = this.search;
        if (searchString.contains("$site") && JahiaGWTParameters.getSiteNode() != null) {
            searchString = searchString.replace("$site", JahiaGWTParameters.getSiteNode().getPath());
        }
        if (searchString.contains("$systemsite")) {
            searchString = searchString.replace("$systemsite", "/sites/systemsite");
        }
        async.searchSQL(searchString, this.limit, 0, JCRClientUtils.CONTENT_NODETYPES, Arrays.asList("icon", "jcr:lastModified", "permissions"), false, (AsyncCallback<PagingLoadResult<GWTJahiaNode>>)new BaseAsyncCallback<PagingLoadResult<GWTJahiaNode>>(){

            public void onSuccess(PagingLoadResult<GWTJahiaNode> gwtJahiaNodes) {
                LastContentBrowseTabItem.this.contentStore.add(gwtJahiaNodes.getData());
                LastContentBrowseTabItem.this.contentContainer.layout(true);
                LastContentBrowseTabItem.this.contentContainer.unmask();
            }
        });
    }

    @Override
    public void doRefresh() {
        this.fillStore();
    }

    public String getSearch() {
        return this.search;
    }

    public void setSearch(String search) {
        this.search = search;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setCssWrapper(String cssWrapper) {
        this.cssWrapper = cssWrapper;
    }
}

