/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.edit.sidepanel;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.BaseModelData;
import com.extjs.gxt.ui.client.data.BasePagingLoader;
import com.extjs.gxt.ui.client.data.DataProxy;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.data.PagingLoadConfig;
import com.extjs.gxt.ui.client.data.PagingLoadResult;
import com.extjs.gxt.ui.client.data.PagingLoader;
import com.extjs.gxt.ui.client.data.RpcProxy;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.GridEvent;
import com.extjs.gxt.ui.client.event.KeyListener;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.store.StoreSorter;
import com.extjs.gxt.ui.client.util.Margins;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.Radio;
import com.extjs.gxt.ui.client.widget.form.RadioGroup;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.RowData;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.extjs.gxt.ui.client.widget.selection.AbstractStoreSelectionModel;
import com.extjs.gxt.ui.client.widget.toolbar.PagingToolBar;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTJahiaLanguage;
import org.jahia.ajax.gwt.client.data.GWTJahiaSearchQuery;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeType;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTColumn;
import org.jahia.ajax.gwt.client.data.toolbar.GWTSidePanelTab;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.Collator;
import org.jahia.ajax.gwt.client.util.icons.StandardIconsProvider;
import org.jahia.ajax.gwt.client.widget.NodeColumnConfigList;
import org.jahia.ajax.gwt.client.widget.content.ContentPickerField;
import org.jahia.ajax.gwt.client.widget.contentengine.EngineLoader;
import org.jahia.ajax.gwt.client.widget.edit.EditLinker;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.ModuleHelper;
import org.jahia.ajax.gwt.client.widget.edit.sidepanel.DisplayGridDragSource;
import org.jahia.ajax.gwt.client.widget.edit.sidepanel.SidePanelTabItem;
import org.jahia.ajax.gwt.client.widget.form.CalendarField;

class SearchTabItem
extends SidePanelTabItem {
    protected int numberResults = 15;
    protected transient ListStore<GWTJahiaNode> contentStore;
    protected transient DisplayGridDragSource displayGridSource;
    private transient TextField<String> searchField;
    private transient ContentPickerField pagePickerField;
    private transient ComboBox<GWTJahiaLanguage> langPickerField;
    private transient ComboBox<GWTJahiaNodeType> defPicker;
    protected transient PagingLoader<PagingLoadResult<GWTJahiaNode>> loader;
    protected transient Grid<GWTJahiaNode> grid;
    private transient CalendarField startDateField;
    private transient CalendarField endDateField;
    private transient ComboBox<ModelData> timesField;
    private transient RadioGroup dateTypeField;
    private List<String> defaultSearchedTypes;
    private String gxtTabId = "JahiaGxtSearchTab";

    SearchTabItem() {
    }

    @Override
    public TabItem create(GWTSidePanelTab config) {
        super.create(config);
        this.tab.setLayout((Layout)new FitLayout());
        FormPanel searchForm = new FormPanel();
        searchForm.addStyleName(this.gxtTabId + "-form");
        searchForm.setHeaderVisible(false);
        searchForm.setBorders(false);
        searchForm.setBodyBorder(false);
        searchForm.setPadding(4);
        this.searchField = new TextField();
        this.searchField.setFieldLabel(Messages.get("label.search"));
        this.searchField.setId(this.gxtTabId + "__searchField");
        this.searchField.addKeyListener(new KeyListener(){

            public void handleEvent(ComponentEvent keyEvent) {
                if (keyEvent.getKeyCode() == 13) {
                    SearchTabItem.this.contentStore.removeAll();
                    SearchTabItem.this.loader.load(0, SearchTabItem.this.numberResults);
                }
            }
        });
        Button ok = new Button(Messages.get("label.search"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent e) {
                SearchTabItem.this.contentStore.removeAll();
                SearchTabItem.this.loader.load(0, SearchTabItem.this.numberResults);
            }
        });
        ok.addStyleName("button-search");
        ok.setIcon(StandardIconsProvider.STANDARD_ICONS.search());
        searchForm.add(this.searchField);
        this.pagePickerField = this.createPageSelectorField();
        searchForm.add((Widget)this.pagePickerField);
        this.langPickerField = this.createLanguageSelectorField();
        searchForm.add(this.langPickerField);
        this.defPicker = this.createNodeSelector();
        searchForm.add(this.defPicker);
        Radio radio = new Radio();
        radio.setBoxLabel(Messages.get("label.modification", "modification"));
        radio.setValueAttribute("1");
        radio.setValue(Boolean.valueOf(true));
        Radio radio2 = new Radio();
        radio2.setBoxLabel(Messages.get("label.creation", "creation"));
        radio2.setValueAttribute("2");
        Radio radio3 = new Radio();
        radio3.setBoxLabel(Messages.get("label.publication", "publication"));
        radio3.setValueAttribute("3");
        this.dateTypeField = new RadioGroup();
        this.dateTypeField.setOrientation(Style.Orientation.VERTICAL);
        this.dateTypeField.setFieldLabel(Messages.get("label.dateType", "According date of"));
        this.dateTypeField.add(radio);
        this.dateTypeField.add(radio2);
        this.dateTypeField.add(radio3);
        searchForm.add((Widget)this.dateTypeField);
        this.startDateField = new CalendarField("dd.MM.yyyy", false, false, null, false, null){

            protected void onClick(ComponentEvent ce) {
                SearchTabItem.this.timesField.clearSelections();
                super.onClick(ce);
            }
        };
        this.startDateField.setFieldLabel(Messages.get("label.startDate", "Start Date"));
        this.endDateField = new CalendarField("dd.MM.yyyy", false, false, null, false, null){

            protected void onClick(ComponentEvent ce) {
                SearchTabItem.this.timesField.clearSelections();
                super.onClick(ce);
            }
        };
        this.endDateField.setFieldLabel(Messages.get("label.endDate", "End Date"));
        searchForm.add((Widget)this.startDateField);
        searchForm.add((Widget)this.endDateField);
        String[] timesValues = new String[]{"1day,1", "1week,7", "2weeks,14", "1month,30", "3months,90", "6months,180", "1year,365"};
        ListStore times = new ListStore();
        for (String timesValue : timesValues) {
            String[] value = timesValue.split(",");
            BaseModelData d = new BaseModelData();
            d.set("key", (Object)value[1]);
            d.set("title", (Object)Messages.get("label." + value[0], value[0]));
            times.add((ModelData)d);
        }
        this.timesField = new ComboBox<ModelData>(){

            protected void onClick(ComponentEvent ce) {
                SearchTabItem.this.startDateField.clear();
                SearchTabItem.this.endDateField.clear();
                this.clear();
                super.onClick(ce);
            }
        };
        this.timesField.setDisplayField("title");
        this.timesField.setValueField("key");
        this.timesField.setStore(times);
        this.timesField.setFieldLabel(Messages.get("label.timeRange", "Time range"));
        searchForm.add(this.timesField);
        searchForm.addButton(ok);
        LayoutContainer panel = new LayoutContainer();
        panel.setLayout((Layout)new RowLayout(Style.Orientation.VERTICAL));
        panel.setWidth("100%");
        panel.setHeight("100%");
        panel.addStyleName("x-panel-mc");
        panel.add((Widget)searchForm, (LayoutData)new RowData(1.0, -1.0, new Margins(0)));
        RpcProxy<PagingLoadResult<GWTJahiaNode>> proxy = new RpcProxy<PagingLoadResult<GWTJahiaNode>>(){

            public void load(Object loadConfig, AsyncCallback<PagingLoadResult<GWTJahiaNode>> callback) {
                SearchTabItem.this.doSearch((PagingLoadConfig)loadConfig, (AsyncCallback<PagingLoadResult<GWTJahiaNode>>)callback);
            }
        };
        this.loader = new BasePagingLoader((DataProxy)proxy);
        this.loader.setRemoteSort(true);
        PagingToolBar toolBar = new PagingToolBar(this.numberResults);
        toolBar.bind(this.loader);
        this.contentStore = new ListStore(this.loader);
        ArrayList<GWTColumn> columnNames = new ArrayList<GWTColumn>();
        columnNames.add(new GWTColumn("icon", Messages.get("label.icon", ""), 40));
        columnNames.add(new GWTColumn("displayName", Messages.get("label.name", "Name"), 240));
        NodeColumnConfigList columnConfigList = new NodeColumnConfigList((List<GWTColumn>)columnNames);
        columnConfigList.init();
        this.grid = new Grid(this.contentStore, new ColumnModel((List)columnConfigList));
        ContentPanel gridPanel = new ContentPanel();
        gridPanel.addStyleName(this.gxtTabId + "-results");
        gridPanel.setLayout((Layout)new FitLayout());
        gridPanel.setBottomComponent((Component)toolBar);
        gridPanel.setHeaderVisible(false);
        gridPanel.setFrame(false);
        gridPanel.setBodyBorder(false);
        gridPanel.setBorders(false);
        gridPanel.add(this.grid);
        panel.add((Widget)gridPanel, (LayoutData)new RowData(1.0, 1.0, new Margins(0, 0, 0, 0)));
        this.tab.add((Widget)panel);
        this.grid.addListener(Events.OnDoubleClick, (Listener)new Listener<GridEvent<GWTJahiaNode>>(){

            public void handleEvent(GridEvent<GWTJahiaNode> be) {
                final GWTJahiaNode node = (GWTJahiaNode)be.getModel();
                ModuleHelper.checkCanUseComponentForEdit(node.getNodeTypes().get(0), new ModuleHelper.CanUseComponentForEditCallback(){

                    @Override
                    public void handle(boolean canUseComponentForEdit) {
                        if (canUseComponentForEdit) {
                            EngineLoader.showEditEngine(SearchTabItem.this.editLinker, node, null);
                        }
                    }
                });
            }
        });
        this.grid.setContextMenu(this.createContextMenu(config.getTableContextMenu(), (AbstractStoreSelectionModel<GWTJahiaNode>)this.grid.getSelectionModel()));
        this.tab.setId(this.gxtTabId);
        return this.tab;
    }

    @Override
    public void initWithLinker(EditLinker linker) {
        super.initWithLinker(linker);
        if (linker.getConfig().isDragAndDropEnabled()) {
            this.displayGridSource = new DisplayGridDragSource(this.grid);
            this.displayGridSource.addDNDListener(this.editLinker.getDndListener());
        }
    }

    @Override
    public void refresh(Map<String, Object> data) {
        if (JahiaGWTParameters.getSiteLanguages().size() > 1) {
            this.langPickerField.show();
        } else {
            this.langPickerField.hide();
        }
    }

    private ContentPickerField createPageSelectorField() {
        ContentPickerField field = new ContentPickerField(null, null, null, null, "pagepicker", false);
        field.setFieldLabel(Messages.get("label.pagePicker", "Pages"));
        field.setId(this.gxtTabId + "__pageSelector");
        return field;
    }

    private ComboBox<GWTJahiaLanguage> createLanguageSelectorField() {
        ComboBox combo = new ComboBox();
        combo.setFieldLabel(Messages.get("label.language", "Language"));
        combo.setStore(new ListStore());
        combo.setDisplayField("displayName");
        combo.setTemplate(SearchTabItem.getLangSwitchingTemplate());
        combo.setTypeAhead(true);
        combo.setTriggerAction(ComboBox.TriggerAction.ALL);
        combo.setForceSelection(true);
        combo.getStore().removeAll();
        combo.getStore().add(JahiaGWTParameters.getSiteLanguages());
        combo.setId(this.gxtTabId + "__languageSelector");
        return combo;
    }

    private ComboBox<GWTJahiaNodeType> createNodeSelector() {
        final ComboBox combo = new ComboBox();
        combo.setFieldLabel(Messages.get("nodes.label", "Node type"));
        combo.setStore(new ListStore());
        combo.setDisplayField("label");
        combo.setValueField("name");
        combo.setTypeAhead(true);
        combo.setTriggerAction(ComboBox.TriggerAction.ALL);
        combo.setForceSelection(true);
        combo.getStore().setStoreSorter(new StoreSorter((Comparator)new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof String && o2 instanceof String) {
                    String s1 = (String)o1;
                    String s2 = (String)o2;
                    return Collator.getInstance().localeCompare(s1, s2);
                }
                if (o1 instanceof Comparable && o2 instanceof Comparable) {
                    return ((Comparable)o1).compareTo(o2);
                }
                return 0;
            }
        }));
        ArrayList<String> searchableTypes = new ArrayList<String>(this.defaultSearchedTypes);
        searchableTypes.add("jnt:portlet");
        JahiaContentManagementService.App.getInstance().getContentTypes(searchableTypes, true, false, (AsyncCallback<List<GWTJahiaNodeType>>)new BaseAsyncCallback<List<GWTJahiaNodeType>>(){

            public void onSuccess(List<GWTJahiaNodeType> result) {
                combo.getStore().add(result);
                combo.getStore().sort("label", Style.SortDir.ASC);
            }

            @Override
            public void onApplicationFailure(Throwable caught) {
                Log.error((String)"Unable to get nodetypes :", (Throwable)caught);
            }
        });
        combo.setId(this.gxtTabId + "__nodeSelector");
        return combo;
    }

    private void doSearch(PagingLoadConfig loadConfig, AsyncCallback<PagingLoadResult<GWTJahiaNode>> callback) {
        GWTJahiaSearchQuery gwtJahiaSearchQuery = this.getGWTJahiaSearchQuery();
        int limit = 500;
        int offset = 0;
        if (loadConfig != null) {
            limit = loadConfig.getLimit();
            offset = loadConfig.getOffset();
        }
        Log.debug((String)((String)this.searchField.getValue() + "," + this.pagePickerField.getValue() + "," + this.langPickerField.getValue()));
        JahiaContentManagementService.App.getInstance().search(gwtJahiaSearchQuery, limit, offset, false, callback);
    }

    private GWTJahiaSearchQuery getGWTJahiaSearchQuery() {
        GWTJahiaSearchQuery gwtJahiaSearchQuery = new GWTJahiaSearchQuery();
        gwtJahiaSearchQuery.setQuery((String)this.searchField.getValue());
        gwtJahiaSearchQuery.setInContents(true);
        gwtJahiaSearchQuery.setInTags(true);
        gwtJahiaSearchQuery.setOriginSiteUuid(JahiaGWTParameters.getSiteUUID());
        gwtJahiaSearchQuery.setPages(this.pagePickerField.getValue().size() > 0 ? this.pagePickerField.getValue() : Arrays.asList(JahiaGWTParameters.getSiteNode()));
        gwtJahiaSearchQuery.setLanguage((GWTJahiaLanguage)this.langPickerField.getValue());
        if (this.endDateField != null && this.endDateField.getValue() != null || this.startDateField != null && this.startDateField.getValue() != null || this.timesField != null && this.timesField.getValue() != null) {
            Date startDate = (Date)this.startDateField.getValue();
            Date endDate = null;
            if (this.timesField.getValue() != null) {
                gwtJahiaSearchQuery.setTimeInDays((String)this.timesField.getValue().get("key"));
                endDate = new Date();
            }
            if (endDate == null) {
                endDate = (Date)this.endDateField.getValue();
            }
            switch (Integer.parseInt(this.dateTypeField.getValue().getValueAttribute())) {
                case 1: {
                    gwtJahiaSearchQuery.setStartEditionDate(startDate);
                    gwtJahiaSearchQuery.setEndEditionDate(endDate);
                    break;
                }
                case 2: {
                    gwtJahiaSearchQuery.setStartCreationDate(startDate);
                    gwtJahiaSearchQuery.setEndCreationDate(endDate);
                    break;
                }
                case 3: {
                    gwtJahiaSearchQuery.setStartPublicationDate(startDate);
                    gwtJahiaSearchQuery.setEndPublicationDate(endDate);
                }
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        if (this.defPicker.getValue() != null) {
            list.add(((GWTJahiaNodeType)this.defPicker.getValue()).getName());
        } else {
            list.addAll(this.defaultSearchedTypes);
        }
        gwtJahiaSearchQuery.setNodeTypes(list);
        return gwtJahiaSearchQuery;
    }

    public int getNumberResults() {
        return this.numberResults;
    }

    public void setNumberResults(int numberResults) {
        this.numberResults = numberResults;
    }

    public List<String> getDefaultSearchedTypes() {
        return this.defaultSearchedTypes;
    }

    public void setDefaultSearchedTypes(List<String> defaultSearchedTypes) {
        this.defaultSearchedTypes = defaultSearchedTypes;
    }

    private static native String getLangSwitchingTemplate();
}

