/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.form.tag;

import com.extjs.gxt.ui.client.GXT;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ComponentHelper;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.extjs.gxt.ui.client.widget.form.MultiField;
import com.extjs.gxt.ui.client.widget.layout.ColumnLayout;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.widget.form.tag.AddTagContainer;
import org.jahia.ajax.gwt.client.widget.form.tag.TagButton;

public class TagField
extends MultiField<List<String>> {
    protected LayoutContainer displayTagContainer;
    protected AddTagContainer addTagContainer;
    private String separator;

    public TagField(String separator, String autocomplete) {
        this.separator = separator;
        this.displayTagContainer = new LayoutContainer((Layout)new ColumnLayout());
        this.displayTagContainer.setScrollMode(Style.Scroll.AUTOY);
        this.displayTagContainer.setWidth("100%");
        this.addTagContainer = new AddTagContainer(this, autocomplete);
        this.addTagContainer.setSpacing(5);
    }

    public List<String> getValue() {
        return this.getTags();
    }

    public void setValue(List<String> value) {
        for (String tag : value) {
            this.addSplitedTag(tag);
        }
    }

    public void setRawValue(String value) {
    }

    protected void onRender(Element target, int index) {
        this.lc = new VerticalPanel();
        if (GXT.isIE) {
            this.lc.setStyleAttribute("position", "relative");
        }
        this.lc.add((Widget)this.displayTagContainer);
        this.lc.add((Widget)this.addTagContainer);
        this.lc.render(target, index);
        ComponentHelper.setParent((Widget)this, (Widget)this.lc);
        this.setElement(this.lc.getElement());
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                TagField.this.lc.setWidth(TagField.this.getWidth());
                TagField.this.displayTagContainer.setWidth(TagField.this.getWidth());
                TagField.this.addTagContainer.setWidth(TagField.this.getWidth());
                TagField.this.lc.layout();
            }
        });
    }

    protected void addTag(String tag) {
        if (tag != null && tag.length() > 0) {
            if (this.separator != null && this.separator.length() > 0) {
                for (String subTag : tag.split(this.separator)) {
                    this.addSplitedTag(subTag);
                }
            } else {
                this.addSplitedTag(tag);
            }
        }
    }

    private void addSplitedTag(String tag) {
        if (tag != null && tag.trim().length() > 0) {
            JahiaContentManagementService.App.getInstance().convertTag(tag, (AsyncCallback<String>)new BaseAsyncCallback<String>(){

                public void onSuccess(String tag) {
                    boolean exist = false;
                    for (Component tagComponent : TagField.this.displayTagContainer.getItems()) {
                        if (!(tagComponent instanceof TagButton) || !tag.equals(((TagButton)tagComponent).getTagField().getValue())) continue;
                        exist = true;
                        break;
                    }
                    if (!exist) {
                        TagButton tagButton = new TagButton(tag);
                        tagButton.getTagButton().addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                            public void componentSelected(ButtonEvent ce) {
                                TagField.this.displayTagContainer.remove(ce.getButton().getParent());
                                TagField.this.displayTagContainer.layout(true);
                            }
                        });
                        if (TagField.this.afterRender) {
                            TagField.this.displayTagContainer.insert((Widget)tagButton, TagField.this.displayTagContainer.getItems().size());
                            TagField.this.displayTagContainer.layout(true);
                        } else {
                            TagField.this.displayTagContainer.add((Widget)tagButton);
                        }
                    }
                }
            });
        }
    }

    protected List<String> getTags() {
        ArrayList<String> tags = new ArrayList<String>();
        for (Component tagComponent : this.displayTagContainer.getItems()) {
            if (!(tagComponent instanceof TagButton)) continue;
            tags.add(String.valueOf(((TagButton)tagComponent).getTagField().getValue()));
        }
        return tags;
    }
}

