/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.poller;

import com.extjs.gxt.ui.client.GXT;
import com.extjs.gxt.ui.client.widget.Info;
import com.extjs.gxt.ui.client.widget.InfoConfig;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.atmosphere.gwt20.client.Atmosphere;
import org.atmosphere.gwt20.client.AtmosphereRequestConfig;
import org.atmosphere.gwt20.client.ClientSerializer;
import org.atmosphere.gwt20.client.RequestConfig;
import org.atmosphere.gwt20.client.managed.RPCEvent;
import org.atmosphere.gwt20.client.managed.RPCSerializer;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;

public class Poller {
    private static final boolean SSE_SUPPORT;
    private static final int RECONNECT_INTERVAL_MS = 2000;
    private static final int CONNECTION_RESTORED_NOTIFICATION_DELAY_MS = 15000;
    private static Poller instance;
    private Map<Class, ArrayList<PollListener>> listeners = new HashMap<Class, ArrayList<PollListener>>();
    private boolean reconnectingAfterError;

    public Poller(boolean useWebsockets) {
        RPCSerializer serializer = (RPCSerializer)GWT.create(RPCSerializer.class);
        if (this.initGWTMessageHandler(this, serializer)) {
            Scheduler.get().scheduleDeferred(() -> {
                AtmosphereRequestConfig requestConfig = AtmosphereRequestConfig.create((ClientSerializer)serializer);
                requestConfig.setUrl(GWT.getModuleBaseURL().substring(0, GWT.getModuleBaseURL().indexOf("/gwt/")) + "/atmosphere/rpc?windowId=" + JahiaContentManagementService.App.getWindowId());
                AtmosphereRequestConfig.Transport transport = useWebsockets ? AtmosphereRequestConfig.Transport.WEBSOCKET : (SSE_SUPPORT ? AtmosphereRequestConfig.Transport.SSE : AtmosphereRequestConfig.Transport.STREAMING);
                requestConfig.setTransport(transport);
                requestConfig.setFallbackTransport(AtmosphereRequestConfig.Transport.LONG_POLLING);
                requestConfig.setMaxReconnectOnClose(Integer.MAX_VALUE);
                requestConfig.setReconnectInterval(2000);
                requestConfig.setErrorHandler(response -> {
                    GWT.log((String)"RPC error");
                    this.reconnectingAfterError = true;
                });
                requestConfig.setReconnectHandler((request, response) -> GWT.log((String)"RPC reconnection"));
                requestConfig.setOpenHandler(response -> {
                    GWT.log((String)"RPC Connection opened");
                    this.onConnectionOpen();
                });
                requestConfig.setReopenHandler(response -> {
                    GWT.log((String)"RPC Connection reopened");
                    PermissionsUtils.triggerPermissionsReload();
                    this.onConnectionOpen();
                });
                requestConfig.setCloseHandler(response -> GWT.log((String)"RPC Connection closed"));
                requestConfig.setMessageHandler(response -> {
                    List messages = response.getMessages();
                    this.handleMessages(messages);
                    this.dispatchToGWTConsumers(response.getResponseBody());
                });
                requestConfig.setFlags(new AtmosphereRequestConfig.Flags[]{AtmosphereRequestConfig.Flags.enableProtocol});
                requestConfig.setFlags(new AtmosphereRequestConfig.Flags[]{AtmosphereRequestConfig.Flags.trackMessageLength});
                Atmosphere atmosphere = Atmosphere.create();
                atmosphere.subscribe((RequestConfig)requestConfig);
            });
        }
    }

    public static Poller getInstance() {
        if (instance == null) {
            instance = new Poller(JahiaGWTParameters.isWebSockets());
        }
        return instance;
    }

    private void handleMessages(List<RPCEvent> messages) {
        for (RPCEvent event : messages) {
            for (Map.Entry<Class, ArrayList<PollListener>> entry : this.listeners.entrySet()) {
                if (entry.getKey() != event.getClass()) continue;
                for (PollListener pollListener : entry.getValue()) {
                    pollListener.handlePollingResult(event);
                }
            }
        }
    }

    private native boolean initGWTMessageHandler(Poller var1, RPCSerializer var2);

    private native void dispatchToGWTConsumers(String var1);

    private void onConnectionOpen() {
        if (!this.reconnectingAfterError) {
            return;
        }
        this.reconnectingAfterError = false;
        InfoConfig infoConfig = new InfoConfig(Messages.get("label.information"), Messages.get("instantMessaging.connectionRecovered.notification"));
        infoConfig.display = 15000;
        Info.display((InfoConfig)infoConfig);
    }

    public void registerListener(PollListener listener, Class eventType) {
        if (!this.listeners.containsKey(eventType)) {
            this.listeners.put(eventType, new ArrayList());
        }
        this.listeners.get(eventType).add(listener);
    }

    public void unregisterListener(PollListener listener, Class eventType) {
        if (this.listeners.containsKey(eventType)) {
            this.listeners.get(eventType).remove(listener);
        }
    }

    static {
        String userAgent = GXT.getUserAgent();
        SSE_SUPPORT = !GXT.isIE && (userAgent == null || userAgent.indexOf("trident/7") == -1);
    }

    public static interface PollListener<T> {
        public void handlePollingResult(T var1);
    }
}

