/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.publication;

import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.store.GroupingStore;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.store.Store;
import com.extjs.gxt.ui.client.store.StoreSorter;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ButtonBar;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnData;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridCellRenderer;
import com.extjs.gxt.ui.client.widget.grid.GridGroupRenderer;
import com.extjs.gxt.ui.client.widget.grid.GridSelectionModel;
import com.extjs.gxt.ui.client.widget.grid.GridView;
import com.extjs.gxt.ui.client.widget.grid.GroupColumnData;
import com.extjs.gxt.ui.client.widget.grid.GroupingView;
import com.extjs.gxt.ui.client.widget.treegrid.TreeGridCellRenderer;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.publication.GWTJahiaPublicationInfo;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.content.compare.CompareEngine;
import org.jahia.ajax.gwt.client.widget.contentengine.EngineContainer;
import org.jahia.ajax.gwt.client.widget.contentengine.EngineLoader;
import org.jahia.ajax.gwt.client.widget.grid.JahiaGroupingView;

public class PublicationStatusGrid
extends Grid<GWTJahiaPublicationInfo> {
    public PublicationStatusGrid(List<GWTJahiaPublicationInfo> infos, boolean checkbox, final Linker linker, EngineContainer container) {
        GroupingStore store = new GroupingStore();
        store.add(infos);
        store.setStoreSorter((StoreSorter)new StoreSorter<GWTJahiaPublicationInfo>(){

            public int compare(Store<GWTJahiaPublicationInfo> store, GWTJahiaPublicationInfo m1, GWTJahiaPublicationInfo m2, String property) {
                if (property.equals("mainPath")) {
                    return super.compare(store, (ModelData)m1, (ModelData)m2, "mainPathIndex");
                }
                return super.compare(store, (ModelData)m1, (ModelData)m2, property);
            }
        });
        ArrayList<ColumnConfig> configs = new ArrayList<ColumnConfig>();
        ColumnConfig column = new ColumnConfig("title", Messages.get("label.path"), 450);
        column.setRenderer((GridCellRenderer)new TreeGridCellRenderer<GWTJahiaPublicationInfo>(){

            @Override
            public Object render(GWTJahiaPublicationInfo model, String property, ColumnData config, int rowIndex, int colIndex, ListStore listStore, Grid grid) {
                return SafeHtmlUtils.htmlEscape((String)((String)model.get("title")));
            }
        });
        configs.add(column);
        column = new ColumnConfig("nodetype", Messages.get("label.nodetype"), 150);
        configs.add(column);
        column = new ColumnConfig("status", Messages.get("org.jahia.jcr.publication.currentStatus"), 150);
        column.setRenderer((GridCellRenderer)new TreeGridCellRenderer<GWTJahiaPublicationInfo>(){

            @Override
            public Object render(GWTJahiaPublicationInfo model, String property, ColumnData config, int rowIndex, int colIndex, ListStore listStore, Grid grid) {
                String label = GWTJahiaPublicationInfo.statusToLabel.get(model.getStatus());
                String status = Messages.get("label.publication." + label, label);
                if (model.getStatus() == 6) {
                    return "<span style='color:red'>" + status + "</span>";
                }
                return status;
            }
        });
        configs.add(column);
        column = new ColumnConfig("action", "", 150);
        final LinkedList paths = new LinkedList();
        column.setRenderer((GridCellRenderer)new TreeGridCellRenderer<GWTJahiaPublicationInfo>(){

            @Override
            public Object render(final GWTJahiaPublicationInfo model, String property, ColumnData config, int rowIndex, int colIndex, ListStore listStore, Grid grid) {
                final String uuid = model.getMainUUID();
                final String language = model.getLanguage();
                final String path = model.getMainPath();
                ButtonBar buttonBar = new ButtonBar();
                if (!paths.contains(path)) {
                    paths.add(path);
                    Button compare = new Button(Messages.get("label.compare", "Compare"));
                    compare.addStyleName("button-compare");
                    compare.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                        public void componentSelected(ButtonEvent ce) {
                            new CompareEngine(uuid, language, false, path).show();
                        }
                    });
                    buttonBar.add((Component)compare);
                }
                Button review = new Button(Messages.get("label.review.content", "Review Content"));
                review.addStyleName("button-review");
                review.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

                    public void componentSelected(ButtonEvent ce) {
                        JahiaContentManagementService.App.getInstance().getNodes(Arrays.asList(model.getPath()), null, (AsyncCallback<List<GWTJahiaNode>>)new BaseAsyncCallback<List<GWTJahiaNode>>(){

                            public void onSuccess(List<GWTJahiaNode> result) {
                                EngineLoader.showEditEngine(linker, result.get(0), true, null);
                            }
                        });
                    }
                });
                buttonBar.add((Component)review);
                return buttonBar;
            }
        });
        configs.add(column);
        column = new ColumnConfig("mainPath", Messages.get("label.parentObject", "Parent object"), 150);
        column.setHidden(true);
        column.setRenderer((GridCellRenderer)new TreeGridCellRenderer<GWTJahiaPublicationInfo>(){

            @Override
            public Object render(GWTJahiaPublicationInfo model, String property, ColumnData config, int rowIndex, int colIndex, ListStore listStore, Grid grid) {
                return SafeHtmlUtils.htmlEscape((String)((String)model.get("mainPath")));
            }
        });
        configs.add(column);
        store.groupBy("mainPath");
        final ColumnModel cm = new ColumnModel(configs);
        this.setStripeRows(true);
        this.setBorders(true);
        JahiaGroupingView view = new JahiaGroupingView();
        view.setShowGroupedColumn(false);
        view.setForceFit(true);
        view.setGroupRenderer(new GridGroupRenderer(){

            public String render(GroupColumnData data) {
                ColumnConfig config = cm.getColumnById(data.field);
                String l = data.models.size() == 1 ? Messages.get("label.item", "Item") : Messages.get("label.items", "Items");
                String v = config.getRenderer() != null ? config.getRenderer().render((ModelData)data.models.get(0), null, null, 0, 0, null, null).toString() : data.group.substring(1);
                return SafeHtmlUtils.htmlEscape((String)v) + " (" + data.models.size() + " " + l + ")";
            }
        });
        this.setView((GridView)view);
        this.reconfigure((ListStore)store, cm);
        this.setSelectionModel(new GridSelectionModel());
    }

    protected void onAfterRenderView() {
        super.onAfterRenderView();
        ((GroupingView)this.getView()).collapseAllGroups();
    }
}

