/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.publication;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.Info;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FieldSet;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jahia.ajax.gwt.client.EmptyLinker;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTHooks;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTJahiaLanguage;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.publication.GWTJahiaPublicationInfo;
import org.jahia.ajax.gwt.client.data.workflow.GWTJahiaWorkflow;
import org.jahia.ajax.gwt.client.data.workflow.GWTJahiaWorkflowDefinition;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.content.ManagerLinker;
import org.jahia.ajax.gwt.client.widget.contentengine.EngineCards;
import org.jahia.ajax.gwt.client.widget.contentengine.EngineContainer;
import org.jahia.ajax.gwt.client.widget.contentengine.EnginePanel;
import org.jahia.ajax.gwt.client.widget.contentengine.EngineWindow;
import org.jahia.ajax.gwt.client.widget.definition.PropertiesEditor;
import org.jahia.ajax.gwt.client.widget.publication.PublicationStatusGrid;
import org.jahia.ajax.gwt.client.widget.publication.PublicationStatusWindow;
import org.jahia.ajax.gwt.client.widget.publication.UnpublicationWorkflow;
import org.jahia.ajax.gwt.client.widget.toolbar.action.WorkInProgressActionItem;
import org.jahia.ajax.gwt.client.widget.workflow.CustomWorkflow;
import org.jahia.ajax.gwt.client.widget.workflow.WorkflowActionDialog;

public class PublicationWorkflow
implements CustomWorkflow {
    public static final List<Integer> STATUS = Arrays.asList(12, 3, 4, 5, 6, 10);
    private static final long serialVersionUID = -4916142720074054130L;
    private static transient boolean doRefresh;
    protected List<GWTJahiaPublicationInfo> publicationInfos;

    public PublicationWorkflow() {
    }

    public PublicationWorkflow(List<GWTJahiaPublicationInfo> publicationInfos) {
        this.publicationInfos = publicationInfos;
    }

    private static void closeDialog(WorkflowActionDialog dialog) {
        ((EngineCards)dialog.getContainer()).closeEngine((Component)dialog);
    }

    public static List<String> getAllUuids(List<GWTJahiaPublicationInfo> publicationInfos) {
        return PublicationWorkflow.getAllUuids(publicationInfos, false, false);
    }

    public static List<String> getAllUuids(List<GWTJahiaPublicationInfo> publicationInfos, boolean onlyAllowedToPublishWithoutWorkflow, boolean unpublish) {
        ArrayList<String> l = new ArrayList<String>();
        for (GWTJahiaPublicationInfo info : publicationInfos) {
            if (info.getStatus() == 11 || !unpublish && !info.isPublishable() || onlyAllowedToPublishWithoutWorkflow && !info.isAllowedToPublishWithoutWorkflow().booleanValue()) continue;
            if (info.getUuid() != null) {
                l.add(info.getUuid());
            }
            if (info.getI18nUuid() != null) {
                l.add(info.getI18nUuid());
            }
            if (info.getDeletedI18nUuid() == null) continue;
            l.addAll(Arrays.asList(info.getDeletedI18nUuid().split(" ")));
        }
        return l;
    }

    public static void create(List<GWTJahiaPublicationInfo> all, final Linker linker, final boolean unpublish) {
        final TreeMap<String, List<GWTJahiaPublicationInfo>> infosListByWorflowGroup = new TreeMap<String, List<GWTJahiaPublicationInfo>>();
        ArrayList<String> keys = new ArrayList<String>();
        for (GWTJahiaPublicationInfo info : all) {
            String workflowGroupKey = info.getWorkflowGroup();
            infosListByWorflowGroup.computeIfAbsent(workflowGroupKey, k -> new ArrayList()).add(info);
            if (info.getWorkflowDefinition() == null || keys.contains(info.getWorkflowDefinition())) continue;
            keys.add(info.getWorkflowDefinition());
        }
        if (!keys.isEmpty()) {
            JahiaContentManagementService.App.getInstance().getWorkflowDefinitions(keys, (AsyncCallback<Map<String, GWTJahiaWorkflowDefinition>>)new BaseAsyncCallback<Map<String, GWTJahiaWorkflowDefinition>>(){

                public void onSuccess(Map<String, GWTJahiaWorkflowDefinition> definitions) {
                    PublicationWorkflow.create(infosListByWorflowGroup, definitions, linker, unpublish);
                }
            });
        } else {
            PublicationWorkflow.create(infosListByWorflowGroup, new HashMap<String, GWTJahiaWorkflowDefinition>(), linker, unpublish);
        }
    }

    private static void create(SortedMap<String, List<GWTJahiaPublicationInfo>> infosListByWorflowGroup, Map<String, GWTJahiaWorkflowDefinition> definitions, final Linker linker, boolean unpublish) {
        EngineContainer container = linker instanceof ManagerLinker || linker instanceof EmptyLinker ? new EngineWindow() : new EnginePanel();
        final EngineCards cards = new EngineCards(container, linker);
        if (infosListByWorflowGroup.entrySet().isEmpty()) {
            new PublicationStatusWindow(linker, null, null, cards, unpublish);
        }
        boolean showStartWfButton = false;
        int numberOfWorkflows = infosListByWorflowGroup.size();
        for (Map.Entry<String, List<GWTJahiaPublicationInfo>> entry : infosListByWorflowGroup.entrySet()) {
            List<GWTJahiaPublicationInfo> infoList = entry.getValue();
            boolean entries = PublicationWorkflow.parseEntries(definitions, linker, unpublish, cards, infoList, numberOfWorkflows);
            showStartWfButton = showStartWfButton || entries;
        }
        if (showStartWfButton) {
            cards.addGlobalButton(PublicationWorkflow.getStartAllWorkflows(cards, linker, unpublish));
        }
        cards.addGlobalButton(PublicationWorkflow.getBypassAllWorkflowsButton(cards, linker, unpublish));
        Button button = new Button(Messages.get("label.cancel"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                cards.closeAllEngines();
                if (doRefresh) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("refreshMain", true);
                    data.put("event", "workflowStarted");
                    linker.refresh(data);
                }
            }
        });
        button.addStyleName("button-cancel");
        cards.addGlobalButton(button);
        cards.showEngine();
    }

    private static boolean parseEntries(Map<String, GWTJahiaWorkflowDefinition> definitions, Linker linker, boolean unpublish, EngineCards cards, List<GWTJahiaPublicationInfo> infoList, int numberOfWorkflows) {
        String workflowDefinition = infoList.get(0).getWorkflowDefinition();
        if (workflowDefinition != null) {
            PublicationWorkflow custom = unpublish ? new UnpublicationWorkflow(infoList) : new PublicationWorkflow(infoList);
            new WorkflowActionDialog(infoList.get(0).getMainPath(), Messages.getWithArgs("label.workflow.start.message", "{0} started by {1} on {2} - {3} content items involved", new Object[]{definitions.get(workflowDefinition).getDisplayName(), JahiaGWTParameters.getCurrentUser(), DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_SHORT).format(new Date()), infoList.size()}), definitions.get(workflowDefinition), linker, custom, cards, infoList.get(0).getLanguage(), numberOfWorkflows);
            return true;
        }
        PublicationWorkflow custom = unpublish ? new UnpublicationWorkflow(infoList) : new PublicationWorkflow(infoList);
        new WorkflowActionDialog(infoList.get(0).getMainPath(), Messages.get("label.engineTab.publication", "Publication"), null, linker, custom, cards, infoList.get(0).getLanguage(), numberOfWorkflows);
        return false;
    }

    private static Button getBypassAllWorkflowsButton(EngineCards cards, Linker linker, boolean unpublish) {
        Button button;
        if (!PublicationWorkflow.isHasBypassAll(cards)) {
            return null;
        }
        if (unpublish) {
            button = new Button(Messages.get(cards.getComponents().size() == 1 ? "label.bypassUnpublishWorkflow" : "label.bypassUnpublishWorkflow.all", cards.getComponents().size() == 1 ? "Unpublish" : "Unpublish all"));
        } else {
            button = new Button(Messages.get(cards.getComponents().size() == 1 ? "label.bypassWorkflow" : "label.bypassWorkflow.all", cards.getComponents().size() == 1 ? "Publish" : "Publish all"));
            button.setId("publishNowButton");
        }
        button.addStyleName("button-bypassworkflow");
        button.addSelectionListener((SelectionListener)new BypassAllWorkflowListener(cards, linker));
        return button;
    }

    private static boolean isHasBypassAll(EngineCards cards) {
        for (Component component : cards.getComponents()) {
            List<GWTJahiaPublicationInfo> thisWFInfo;
            if (!(component instanceof WorkflowActionDialog ? (thisWFInfo = ((PublicationWorkflow)((WorkflowActionDialog)component).getCustomWorkflow()).getPublicationInfos()).get(0).isAllowedToPublishWithoutWorkflow() != false : component instanceof PublicationStatusWindow)) continue;
            return true;
        }
        return false;
    }

    private static Button getStartAllWorkflows(EngineCards cards, Linker linker, boolean unpublish) {
        boolean hasWorkflow = false;
        for (Component component : cards.getComponents()) {
            if (!(component instanceof WorkflowActionDialog)) continue;
            hasWorkflow = true;
            break;
        }
        if (!hasWorkflow) {
            return null;
        }
        Button button = unpublish ? new Button(Messages.get(cards.getComponents().size() == 1 ? "label.workflow.unpublish.start" : "label.workflow.unpublish.start.all", cards.getComponents().size() == 1 ? "Request unpublication" : "Request unpublication for all")) : new Button(Messages.get(cards.getComponents().size() == 1 ? "label.workflow.start" : "label.workflow.start.all", cards.getComponents().size() == 1 ? "Request publication" : "Request publication for all"));
        button.addStyleName("button-start");
        button.addSelectionListener((SelectionListener)new StartAllWorkflowsListener(cards, linker));
        return button;
    }

    private static BaseAsyncCallback<Object> getCallback(final EngineCards cards, final int[] nbWF, final String successMessage, final String errorMessage, final String statusMessage, final Linker linker, final Map<String, Object> refreshData) {
        return new BaseAsyncCallback<Object>(){

            @Override
            public void onApplicationFailure(Throwable caught) {
                PublicationWorkflow.close(cards, nbWF, errorMessage, statusMessage, linker, refreshData);
                Log.error((String)errorMessage, (Throwable)caught);
                Window.alert((String)(errorMessage + caught.getMessage()));
            }

            public void onSuccess(Object result) {
                if (successMessage != null) {
                    PublicationWorkflow.close(cards, nbWF, successMessage, statusMessage, linker, refreshData);
                }
            }
        };
    }

    private static void close(EngineCards cards, int[] nbWF, String message, String statusMessage, Linker linker, Map<String, Object> refreshData) {
        nbWF[0] = nbWF[0] - 1;
        if (nbWF[0] == 0) {
            Info.display((String)message, (String)message);
            WorkInProgressActionItem.removeStatus(statusMessage);
            if (refreshData != null) {
                linker.refresh(refreshData);
            }
            cards.closeAllEngines();
        }
    }

    private static boolean fillDialogProperties(WorkflowActionDialog dialog, List<GWTJahiaNodeProperty> nodeProperties) {
        PropertiesEditor propertiesEditor = dialog.getPropertiesEditor();
        if (propertiesEditor != null) {
            for (PropertiesEditor.PropertyAdapterField adapterField : propertiesEditor.getFieldsMap().values()) {
                Field<?> field = adapterField.getField();
                if (!field.isEnabled() || field.isReadOnly() || field.validate() || !((FieldSet)adapterField.getParent()).isExpanded()) continue;
                String error = Messages.get("label.workflow.form.error", "Your form is not valid");
                Info.display((String)error, (String)error);
                dialog.enableButtons();
                return false;
            }
            nodeProperties.addAll(propertiesEditor.getProperties());
        }
        return true;
    }

    public static void openPublicationWorkflow(List<String> uuids, Linker linker, boolean allSubTree, boolean allLanguages, boolean checkForUnpublication) {
        OpenPublicationWorkflowCallback asyncCallback = new OpenPublicationWorkflowCallback(linker, checkForUnpublication);
        if (!allLanguages) {
            JahiaContentManagementService.App.getInstance().getPublicationInfo(uuids, allSubTree, checkForUnpublication, asyncCallback);
        } else {
            HashSet<String> languages = new HashSet<String>();
            for (GWTJahiaLanguage gwtJahiaLanguage : JahiaGWTParameters.getSiteLanguages()) {
                if (!Boolean.TRUE.equals(gwtJahiaLanguage.isActive())) continue;
                languages.add(gwtJahiaLanguage.getLanguage());
            }
            JahiaContentManagementService.App.getInstance().getPublicationInfo(uuids, allSubTree, checkForUnpublication, languages, asyncCallback);
        }
    }

    @Override
    public void initStartWorkflowDialog(GWTJahiaWorkflowDefinition workflow, WorkflowActionDialog dialog, int numberOfWorkflows) {
        Button button;
        boolean unpublish = this instanceof UnpublicationWorkflow;
        this.initDialog(dialog);
        if (dialog.getButtonsBar().getItemCount() > 0) {
            dialog.getButtonsBar().remove(dialog.getButtonsBar().getItem(0));
        }
        if ((button = this.getBypassWorkflowButton(dialog)) != null) {
            if (unpublish && numberOfWorkflows > 1) {
                button.setVisible(false);
            }
            dialog.getButtonsBar().insert((Component)button, 0);
        }
        if (workflow != null && (button = this.getStartWorkflowButton(workflow, dialog)) != null) {
            if (unpublish && numberOfWorkflows > 1) {
                button.setVisible(false);
            }
            dialog.getButtonsBar().insert((Component)button, 0);
        }
    }

    @Override
    public void initExecuteActionDialog(GWTJahiaWorkflow workflow, WorkflowActionDialog dialog) {
        this.initDialog(dialog);
    }

    protected void initDialog(WorkflowActionDialog dialog) {
        TabItem tab = new TabItem("Publication infos");
        tab.setLayout((Layout)new FitLayout());
        tab.setStyleName("workflow-dialog-publication-tab");
        doRefresh = false;
        PublicationStatusGrid g = new PublicationStatusGrid(this.publicationInfos, true, dialog.getLinker(), dialog.getContainer());
        tab.add((Widget)g);
        dialog.getTabPanel().add(tab);
        TabItem p = (TabItem)dialog.getTabPanel().getItem(0);
        LayoutContainer layoutContainer = new LayoutContainer((Layout)new RowLayout());
        layoutContainer.setStyleAttribute("margin", "5px");
        HashMap<Integer, Integer> results = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> pageResults = new HashMap<Integer, Integer>();
        for (GWTJahiaPublicationInfo info : this.publicationInfos) {
            Integer status = info.getStatus();
            if (status == 11) {
                status = 12;
            }
            if (Boolean.TRUE.equals(info.get("isPage"))) {
                if (!pageResults.containsKey(status)) {
                    pageResults.put(status, 1);
                } else {
                    pageResults.put(status, (Integer)pageResults.get(status) + 1);
                }
            }
            if (!results.containsKey(status)) {
                results.put(status, 1);
                continue;
            }
            results.put(status, (Integer)results.get(status) + 1);
        }
        int i = 0;
        for (Integer status : STATUS) {
            if (!results.containsKey(status)) continue;
            ++i;
            HorizontalPanel h = new HorizontalPanel();
            h.add((Widget)GWTJahiaPublicationInfo.renderPublicationStatusImage(status));
            String labelKey = GWTJahiaPublicationInfo.statusToLabel.get(status);
            String text = "&nbsp;" + Messages.get("label.publication." + labelKey, labelKey) + " : ";
            text = status == 12 && (Integer)results.get(status) > 10 ? text + "<span style=\"color:red\">" + results.get(status) + " " + ((Integer)results.get(status) > 1 ? Messages.get("label.items", "Items") : Messages.get("label.item", "Item")) + "</span>" : text + results.get(status) + " " + ((Integer)results.get(status) > 1 ? Messages.get("label.items", "Items") : Messages.get("label.item", "Item"));
            if (pageResults.get(status) != null) {
                text = (Integer)pageResults.get(status) > 1 ? text + " " + Messages.get("label.including", "including") + " <span style=\"color:red\">" + pageResults.get(status) + " " + Messages.get("label.pages", "pages") + "</span>" : text + " " + Messages.get("label.including", "including") + " " + pageResults.get(status) + " " + Messages.get("label.page", "page");
            }
            Html w = new Html(text);
            h.add((Widget)w);
            layoutContainer.add((Widget)h);
        }
        if (i > 0) {
            p.add((Widget)layoutContainer, (LayoutData)new BorderLayoutData(Style.LayoutRegion.NORTH, (float)(5 + i * 20)));
        }
    }

    public Button getStartWorkflowButton(GWTJahiaWorkflowDefinition wf, WorkflowActionDialog dialog) {
        boolean unpublish = this instanceof UnpublicationWorkflow;
        Button button = new Button(Messages.get(unpublish ? "label.workflow.unpublish.start" : "label.workflow.start", unpublish ? "Request unpublication" : "Request publication"));
        button.addStyleName("button-start");
        button.addSelectionListener((SelectionListener)new StartWorkflowListener(dialog, unpublish, wf));
        return button;
    }

    public Button getBypassWorkflowButton(WorkflowActionDialog dialog) {
        if (!this.publicationInfos.isEmpty() && Boolean.TRUE.equals(this.publicationInfos.get(0).isAllowedToPublishWithoutWorkflow())) {
            Button button = new Button(Messages.get(this instanceof UnpublicationWorkflow ? "label.bypassUnpublishWorkflow" : "label.bypassWorkflow", this instanceof UnpublicationWorkflow ? "Unpublish" : "Publish"));
            button.addStyleName("button-bypassworkflow");
            button.addSelectionListener((SelectionListener)new BypassWorkflowListener(dialog, this.publicationInfos.get(0).getLanguage()));
            if (!(this instanceof UnpublicationWorkflow)) {
                button.setId("publishNowButton");
            }
            return button;
        }
        return null;
    }

    protected void doPublish(List<GWTJahiaNodeProperty> nodeProperties, WorkflowActionDialog dialog, String language) {
        String status = null;
        if ("publishNowButton".equals(dialog.getButtonsBar().getItem(1).getId())) {
            if (JahiaGWTHooks.hasHook("queuePublication")) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("message", Messages.get("label.queuePublication", "Publication is queued"));
                JahiaGWTHooks.callHook("queuePublication", map);
            }
        } else {
            status = Messages.get("label.publication.task", "Publishing content");
            Info.display((String)status, (String)status);
            WorkInProgressActionItem.setStatus(status);
        }
        List<String> allUuids = this.getAllUuids();
        final String finalStatus = status;
        JahiaContentManagementService.App.getInstance().publish(allUuids, nodeProperties, null, language, new BaseAsyncCallback<Object>(){

            @Override
            public void onApplicationFailure(Throwable caught) {
                WorkInProgressActionItem.removeStatus(finalStatus);
                Info.display((String)"Cannot publish", (String)"Cannot publish");
                Window.alert((String)("Cannot publish " + caught.getMessage()));
            }

            public void onSuccess(Object result) {
                WorkInProgressActionItem.removeStatus(finalStatus);
            }
        });
    }

    public List<String> getAllUuids() {
        return PublicationWorkflow.getAllUuids(this.publicationInfos);
    }

    public List<GWTJahiaPublicationInfo> getPublicationInfos() {
        return this.publicationInfos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicationWorkflow that = (PublicationWorkflow)o;
        return this.publicationInfos != null ? this.publicationInfos.equals(that.publicationInfos) : that.publicationInfos == null;
    }

    public int hashCode() {
        int result = this.publicationInfos != null ? this.publicationInfos.hashCode() : 0;
        return result;
    }

    private class BypassWorkflowListener
    extends SelectionListener<ButtonEvent> {
        private final WorkflowActionDialog dialog;
        private String language;

        public BypassWorkflowListener(WorkflowActionDialog dialog, String language) {
            this.dialog = dialog;
            this.language = language;
        }

        public void componentSelected(ButtonEvent ce) {
            this.dialog.disableButtons();
            ArrayList<GWTJahiaNodeProperty> nodeProperties = new ArrayList();
            if (this.dialog.getPropertiesEditor() != null) {
                nodeProperties = this.dialog.getPropertiesEditor().getProperties();
            }
            PublicationWorkflow.closeDialog(this.dialog);
            PublicationWorkflow.this.doPublish(nodeProperties, this.dialog, this.language);
        }
    }

    private class StartWorkflowListener
    extends SelectionListener<ButtonEvent> {
        private final WorkflowActionDialog dialog;
        private final boolean unpublish;
        private final GWTJahiaWorkflowDefinition wf;

        public StartWorkflowListener(WorkflowActionDialog dialog, boolean unpublish, GWTJahiaWorkflowDefinition wf) {
            this.dialog = dialog;
            this.unpublish = unpublish;
            this.wf = wf;
        }

        public void componentSelected(ButtonEvent buttonEvent) {
            this.dialog.disableButtons();
            ArrayList<GWTJahiaNodeProperty> nodeProperties = new ArrayList();
            PropertiesEditor propertiesEditor = this.dialog.getPropertiesEditor();
            if (propertiesEditor != null) {
                for (PropertiesEditor.PropertyAdapterField adapterField : propertiesEditor.getFieldsMap().values()) {
                    Field<?> field = adapterField.getField();
                    if (!field.isEnabled() || field.isReadOnly() || field.validate() || !((FieldSet)adapterField.getParent()).isExpanded()) continue;
                    String status = Messages.get("label.workflow.form.error", "Your form is not valid");
                    Info.display((String)status, (String)status);
                    this.dialog.enableButtons();
                    return;
                }
                nodeProperties = propertiesEditor.getProperties();
            }
            this.dialog.enableButtons();
            PublicationWorkflow.closeDialog(this.dialog);
            Info.display((String)Messages.get(this.unpublish ? "label.workflow.unpublish.start" : "label.workflow.start", this.unpublish ? "Request unpublication" : "Request publication"), (String)Messages.get("message.workflow.starting", "Starting publication workflow"));
            String status = Messages.get("label.workflow.task", "Executing workflow task");
            WorkInProgressActionItem.setStatus(status);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("customWorkflowInfo", PublicationWorkflow.this);
            String workflowGroup = PublicationWorkflow.this.publicationInfos.get(0).getWorkflowGroup();
            String locale = workflowGroup.substring(0, workflowGroup.indexOf("/"));
            JahiaContentManagementService.App.getInstance().startWorkflow(PublicationWorkflow.getAllUuids(PublicationWorkflow.this.publicationInfos, false, true), this.wf, nodeProperties, this.dialog.getComments(), map, locale, new StartWorkflowCallback(status));
        }

        private class StartWorkflowCallback
        extends BaseAsyncCallback<Object> {
            private final String status;

            public StartWorkflowCallback(String status) {
                this.status = status;
            }

            @Override
            public void onApplicationFailure(Throwable caught) {
                WorkInProgressActionItem.removeStatus(this.status);
                Log.error((String)Messages.get("label.workflow.cannotStart", "Cannot start workflow"), (Throwable)caught);
                Window.alert((String)(Messages.get("label.workflow.cannotStart", "Cannot start workflow") + caught.getMessage()));
            }

            public void onSuccess(Object result) {
                Info.display((String)Messages.get(StartWorkflowListener.this.unpublish ? "label.workflow.unpublish.start" : "label.workflow.start", StartWorkflowListener.this.unpublish ? "Request unpublication" : "Request publication"), (String)Messages.get("message.workflow.started", "Workflow started"));
                WorkInProgressActionItem.removeStatus(this.status);
                doRefresh = true;
                if (StartWorkflowListener.this.dialog.getContainer() instanceof EngineCards && ((EngineCards)StartWorkflowListener.this.dialog.getContainer()).getComponents().isEmpty()) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("refreshMain", true);
                    data.put("event", "workflowStarted");
                    StartWorkflowListener.this.dialog.getLinker().refresh(data);
                }
            }
        }
    }

    private static class OpenPublicationWorkflowCallback
    extends BaseAsyncCallback<List<GWTJahiaPublicationInfo>> {
        private final Linker linker;
        private final boolean checkForUnpublication;

        public OpenPublicationWorkflowCallback(Linker linker, boolean checkForUnpublication) {
            this.linker = linker;
            this.checkForUnpublication = checkForUnpublication;
        }

        @Override
        public void onApplicationFailure(Throwable caught) {
            if (this.linker != null) {
                this.linker.loaded();
            }
            MessageBox.alert((String)Messages.get(this.checkForUnpublication ? "label.unpublish" : "label.publish", this.checkForUnpublication ? "Unpublish" : "Publish"), (String)Messages.get(this.checkForUnpublication ? "message.content.unpublished.error" : "message.content.published.error", this.checkForUnpublication ? "Cannot be unpublished" : "Cannot be published"), null);
        }

        public void onSuccess(List<GWTJahiaPublicationInfo> result) {
            if (this.linker != null) {
                this.linker.loaded();
            }
            if (result.isEmpty()) {
                MessageBox.info((String)Messages.get(this.checkForUnpublication ? "label.unpublish" : "label.publish", this.checkForUnpublication ? "Unpublish" : "Publish"), (String)Messages.get(this.checkForUnpublication ? "label.publication.nothingToUnpublish" : "label.publication.nothingToPublish", this.checkForUnpublication ? "Nothing to unpublish" : "Nothing to publish"), null);
            } else {
                ArrayList<GWTJahiaPublicationInfo> unpublishable = new ArrayList<GWTJahiaPublicationInfo>();
                for (GWTJahiaPublicationInfo info : result) {
                    Integer status = info.getStatus();
                    if (status != 6 && status != 9) continue;
                    unpublishable.add(info);
                }
                result.removeAll(unpublishable);
                if (unpublishable.isEmpty()) {
                    PublicationWorkflow.create(result, this.linker, this.checkForUnpublication);
                } else {
                    Integer status;
                    StringBuilder message = new StringBuilder();
                    HashMap unpublishableMap = new HashMap();
                    for (GWTJahiaPublicationInfo gWTJahiaPublicationInfo : unpublishable) {
                        status = gWTJahiaPublicationInfo.getStatus();
                        if (!unpublishableMap.containsKey(status)) {
                            unpublishableMap.put(status, new ArrayList());
                        }
                        ((List)unpublishableMap.get(status)).add("<span class=\"info-publication-label\"><strong>" + SafeHtmlUtils.htmlEscape((String)gWTJahiaPublicationInfo.getTitle()) + "</strong></span><span class=\"info-publication-path\">(" + SafeHtmlUtils.htmlEscape((String)gWTJahiaPublicationInfo.getPath()) + ")</span>");
                    }
                    for (Map.Entry entry : unpublishableMap.entrySet()) {
                        status = (Integer)entry.getKey();
                        HashSet<String> values = new HashSet<String>((Collection)entry.getValue());
                        if (values.size() >= 10) {
                            values = new LinkedHashSet(new ArrayList(values).subList(0, 10));
                            values.add("<span class=\"info-publication-more\">...</span>");
                        }
                        String labelKey = GWTJahiaPublicationInfo.statusToLabel.get(status);
                        message.append("<div class=\"info-publication-header\">").append(Messages.get("label.publication." + labelKey, labelKey)).append("</div>");
                        message.append("<ul class=\"info-publication-list\">");
                        for (String value : values) {
                            message.append("<li>").append(value).append("</li>");
                        }
                        message.append("</ul>");
                    }
                    if (!result.isEmpty()) {
                        message.append("<div class=\"info-publication-continue\">").append(Messages.get("message.continue")).append("</div>");
                        MessageBox.confirm((String)Messages.get("label.publish", "Publication"), (String)message.toString(), be -> {
                            if (be.getButtonClicked().getItemId().equalsIgnoreCase("yes")) {
                                PublicationWorkflow.create(result, this.linker, this.checkForUnpublication);
                            }
                        });
                    } else {
                        MessageBox.info((String)Messages.get("label.publish", "Publication"), (String)message.toString(), null);
                    }
                }
            }
        }
    }

    private static class StartAllWorkflowsListener
    extends SelectionListener<ButtonEvent> {
        private final EngineCards cards;
        private final Linker linker;

        public StartAllWorkflowsListener(EngineCards cards, Linker linker) {
            this.cards = cards;
            this.linker = linker;
        }

        public void componentSelected(ButtonEvent buttonEvent) {
            Info.display((String)Messages.get("label.workflow.start", "Request publication"), (String)Messages.get("message.workflow.starting", "Starting publication workflow"));
            String status = Messages.get("label.workflow.task", "Executing workflow task");
            WorkInProgressActionItem.setStatus(status);
            ArrayList<Component> components = new ArrayList<Component>(this.cards.getComponents());
            int[] nbWF = new int[]{components.size()};
            HashMap<String, Object> refreshData = new HashMap<String, Object>();
            refreshData.put("refreshMain", true);
            refreshData.put("event", "workflowStarted");
            for (Component component : components) {
                if (component instanceof WorkflowActionDialog) {
                    WorkflowActionDialog dialog = (WorkflowActionDialog)component;
                    dialog.disableButtons();
                    boolean unpublish = dialog.getCustomWorkflow() instanceof UnpublicationWorkflow;
                    ArrayList<GWTJahiaNodeProperty> nodeProperties = new ArrayList<GWTJahiaNodeProperty>();
                    if (!PublicationWorkflow.fillDialogProperties(dialog, nodeProperties)) {
                        return;
                    }
                    PublicationWorkflow customWorkflow = (PublicationWorkflow)dialog.getCustomWorkflow();
                    List<GWTJahiaPublicationInfo> thisWFInfo = customWorkflow.getPublicationInfos();
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("customWorkflowInfo", customWorkflow);
                    String workflowGroup = thisWFInfo.get(0).getWorkflowGroup();
                    String locale = workflowGroup.substring(0, workflowGroup.indexOf("/"));
                    JahiaContentManagementService.App.getInstance().startWorkflow(PublicationWorkflow.getAllUuids(thisWFInfo, false, unpublish), dialog.getWfDefinition(), nodeProperties, dialog.getComments(), map, locale, PublicationWorkflow.getCallback(this.cards, nbWF, Messages.get("label.workflow.start", "Start Workflow"), Messages.get("label.workflow.cannotStart", "Cannot start workflow"), status, this.linker, refreshData));
                    continue;
                }
                PublicationWorkflow.close(this.cards, nbWF, Messages.get("label.workflow.start", "Request publication"), status, this.linker, refreshData);
            }
        }
    }

    private static class BypassAllWorkflowListener
    extends SelectionListener<ButtonEvent> {
        private final EngineCards cards;
        private final Linker linker;

        public BypassAllWorkflowListener(EngineCards cards, Linker linker) {
            this.cards = cards;
            this.linker = linker;
        }

        public void componentSelected(ButtonEvent ce) {
            String status = null;
            if ("publishNowButton".equals(ce.getButton().getId())) {
                if (JahiaGWTHooks.hasHook("queuePublication")) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("message", Messages.get("label.queuePublication", "Publication is queued"));
                    JahiaGWTHooks.callHook("queuePublication", map);
                }
            } else {
                status = Messages.get("label.publication.task", "Publishing content");
                Info.display((String)status, (String)status);
                WorkInProgressActionItem.setStatus(status);
            }
            ArrayList<Component> components = new ArrayList<Component>(this.cards.getComponents());
            int[] nbWF = new int[]{components.size()};
            HashSet<String> unpublishedUUIds = new HashSet<String>();
            for (Component component : components) {
                LayoutContainer dialog;
                if (component instanceof WorkflowActionDialog) {
                    dialog = (WorkflowActionDialog)component;
                    dialog.disableButtons();
                    ArrayList<GWTJahiaNodeProperty> nodeProperties = new ArrayList<GWTJahiaNodeProperty>();
                    if (!PublicationWorkflow.fillDialogProperties((WorkflowActionDialog)dialog, nodeProperties)) {
                        return;
                    }
                    dialog.getContainer().closeEngine();
                    PublicationWorkflow customWorkflow = (PublicationWorkflow)dialog.getCustomWorkflow();
                    List<GWTJahiaPublicationInfo> thisWFInfo = customWorkflow.getPublicationInfos();
                    this.handleWorkflowActionDialog(status, nbWF, (WorkflowActionDialog)dialog, nodeProperties, customWorkflow, thisWFInfo, unpublishedUUIds);
                    continue;
                }
                if (component instanceof PublicationStatusWindow) {
                    dialog = (PublicationStatusWindow)component;
                    List<String> uuids = dialog.getUuids();
                    if (dialog.isUnpublish()) {
                        LinkedList<String> toBeUnpublished = new LinkedList<String>();
                        for (String uuid : uuids) {
                            if (unpublishedUUIds.contains(uuid)) continue;
                            unpublishedUUIds.add(uuid);
                            toBeUnpublished.add(uuid);
                        }
                        JahiaContentManagementService.App.getInstance().unpublish(toBeUnpublished, PublicationWorkflow.getCallback(this.cards, nbWF, Messages.get("message.content.unpublished", "Content unpublished"), Messages.get("message.content.unpublished.error", "Cannot unpublish"), status, this.linker, null));
                        continue;
                    }
                    JahiaContentManagementService.App.getInstance().publish(uuids, null, null, PublicationWorkflow.getCallback(this.cards, nbWF, null, Messages.get("message.content.published.error", "Cannot publish"), status, this.linker, null));
                    continue;
                }
                PublicationWorkflow.close(this.cards, nbWF, Messages.get("label.workflow.start", "Start Workflow"), status, this.linker, null);
            }
        }

        private void handleWorkflowActionDialog(String status, int[] nbWF, WorkflowActionDialog dialog, List<GWTJahiaNodeProperty> nodeProperties, PublicationWorkflow customWorkflow, List<GWTJahiaPublicationInfo> thisWFInfo, Set<String> unpublishedUUIds) {
            if (thisWFInfo.get(0).isAllowedToPublishWithoutWorkflow().booleanValue()) {
                if (customWorkflow instanceof UnpublicationWorkflow) {
                    LinkedList<String> toBeUnpublished = new LinkedList<String>();
                    List<String> uuids = PublicationWorkflow.getAllUuids(thisWFInfo, false, true);
                    for (String uuid : uuids) {
                        if (unpublishedUUIds.contains(uuid)) continue;
                        unpublishedUUIds.add(uuid);
                        toBeUnpublished.add(uuid);
                    }
                    JahiaContentManagementService.App.getInstance().unpublish(toBeUnpublished, PublicationWorkflow.getCallback(this.cards, nbWF, Messages.get("message.content.unpublished", "Content unpublished"), Messages.get("message.content.unpublished.error", "Cannot unpublish"), status, this.linker, null));
                } else {
                    JahiaContentManagementService.App.getInstance().publish(PublicationWorkflow.getAllUuids(thisWFInfo), nodeProperties, null, thisWFInfo.get(0).getLanguage(), PublicationWorkflow.getCallback(this.cards, nbWF, null, Messages.get("message.content.published.error", "Cannot publish"), status, this.linker, null));
                }
            } else {
                PublicationWorkflow.close(this.cards, nbWF, Messages.get("message.content.published", "Content published"), status, dialog.getLinker(), null);
            }
        }
    }
}

