/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.publication;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.Info;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.definition.GWTJahiaNodeProperty;
import org.jahia.ajax.gwt.client.data.publication.GWTJahiaPublicationInfo;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.widget.publication.PublicationStatusGrid;
import org.jahia.ajax.gwt.client.widget.publication.PublicationWorkflow;
import org.jahia.ajax.gwt.client.widget.toolbar.action.WorkInProgressActionItem;
import org.jahia.ajax.gwt.client.widget.workflow.WorkflowActionDialog;

public class UnpublicationWorkflow
extends PublicationWorkflow {
    private static final long serialVersionUID = -4916142720074054130L;

    public UnpublicationWorkflow() {
    }

    public UnpublicationWorkflow(List<GWTJahiaPublicationInfo> publicationInfos) {
        super(publicationInfos);
    }

    @Override
    protected void initDialog(WorkflowActionDialog dialog) {
        TabItem tab = new TabItem("Unpublication infos");
        tab.setLayout((Layout)new FitLayout());
        PublicationStatusGrid g = new PublicationStatusGrid(this.publicationInfos, true, dialog.getLinker(), dialog.getContainer());
        tab.add((Widget)g);
        dialog.getTabPanel().add(tab);
        TabItem p = (TabItem)dialog.getTabPanel().getItem(0);
        LayoutContainer layoutContainer = new LayoutContainer((Layout)new RowLayout());
        layoutContainer.setStyleAttribute("margin", "5px");
        int results = 0;
        int pageResults = 0;
        for (GWTJahiaPublicationInfo info : this.publicationInfos) {
            ++results;
            if (!Boolean.TRUE.equals(info.get("isPage"))) continue;
            ++pageResults;
        }
        HorizontalPanel h = new HorizontalPanel();
        h.add((Widget)GWTJahiaPublicationInfo.renderPublicationStatusImage(5));
        String text = "&nbsp;" + Messages.get("label.publication.unpublished.task", "Unpublishing content") + " : ";
        text = results > 10 ? text + " <span style=\"color:red\">" + results + " " + Messages.get("label.items", "Items") + "</span>" : (results > 1 ? text + results + " " + Messages.get("label.items", "Items") : text + results + " " + Messages.get("label.item", "Item"));
        if (pageResults > 0) {
            text = pageResults > 1 ? text + " " + Messages.get("label.including", "including") + " <span style=\"color:red\">" + pageResults + " " + Messages.get("label.pages", "pages") + "</span>" : text + " " + Messages.get("label.including", "including") + " " + pageResults + " " + Messages.get("label.page", "page");
        }
        Html w = new Html(text);
        h.add((Widget)w);
        layoutContainer.add((Widget)h);
        p.add((Widget)layoutContainer, (LayoutData)new BorderLayoutData(Style.LayoutRegion.NORTH, 25.0f));
    }

    @Override
    protected void doPublish(List<GWTJahiaNodeProperty> nodeProperties, final WorkflowActionDialog dialog, String language) {
        final String status = Messages.get("label.publication.unpublished.task", "Unpublishing content");
        Info.display((String)status, (String)status);
        WorkInProgressActionItem.setStatus(status);
        final List<String> allUuids = this.getAllUuids();
        BaseAsyncCallback callback = new BaseAsyncCallback(){

            @Override
            public void onApplicationFailure(Throwable caught) {
                WorkInProgressActionItem.removeStatus(status);
                Info.display((String)"Cannot unpublish", (String)"Cannot unpublish");
                Window.alert((String)("Cannot unpublish " + caught.getMessage()));
            }

            public void onSuccess(Object result) {
                WorkInProgressActionItem.removeStatus(status);
                if (allUuids.size() < 20) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("refreshMain", true);
                    data.put("event", "unpublicationSuccess");
                    dialog.getLinker().refresh(data);
                }
            }
        };
        JahiaContentManagementService.App.getInstance().unpublish(allUuids, callback);
    }

    @Override
    public List<String> getAllUuids() {
        return UnpublicationWorkflow.getAllUuids(this.publicationInfos, false, true);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnpublicationWorkflow that = (UnpublicationWorkflow)o;
        return !(this.publicationInfos != null ? !this.publicationInfos.equals(that.publicationInfos) : that.publicationInfos != null);
    }

    @Override
    public int hashCode() {
        int result = this.publicationInfos != null ? this.publicationInfos.hashCode() : 0;
        return result;
    }
}

