/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import java.util.ArrayList;
import java.util.List;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTEditConfiguration;
import org.jahia.ajax.gwt.client.data.toolbar.GWTJahiaToolbar;
import org.jahia.ajax.gwt.client.data.toolbar.GWTJahiaToolbarItem;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.toolbar.ActionToolbar;

public class ActionToolbarLayoutContainer
extends LayoutContainer {
    private List<ActionToolbar> actionToolbars = new ArrayList<ActionToolbar>();
    private Linker linker;
    private List<GWTJahiaToolbar> toolbarSet;

    public ActionToolbarLayoutContainer(GWTJahiaToolbar toolbar) {
        this.toolbarSet = new ArrayList<GWTJahiaToolbar>();
        this.toolbarSet.add(toolbar);
        this.setLayout((Layout)new RowLayout());
    }

    public ActionToolbarLayoutContainer(List<GWTJahiaToolbar> toolbarSet) {
        this.setLayout((Layout)new RowLayout());
        this.toolbarSet = toolbarSet;
    }

    public void setToolbarSet(List<GWTJahiaToolbar> toolbarSet) {
        this.removeAll();
        this.toolbarSet = toolbarSet;
        this.actionToolbars = new ArrayList<ActionToolbar>();
    }

    private void createToolbarUI(List<GWTJahiaToolbar> toolbarList) {
        if (toolbarList != null && !toolbarList.isEmpty()) {
            Log.debug((String)(toolbarList.size() + " toolbar(s)."));
            for (int i = 0; i < toolbarList.size(); ++i) {
                List<GWTJahiaToolbarItem> toolbarItemsGroups;
                GWTJahiaToolbar gwtToolbar = toolbarList.get(i);
                if (gwtToolbar == null || (toolbarItemsGroups = gwtToolbar.getGwtToolbarItems()) == null || toolbarItemsGroups.isEmpty()) continue;
                this.addActionToolbar(gwtToolbar, i == 0);
            }
            Log.debug((String)"-- all tool bars added.");
        } else {
            Log.debug((String)"There is no toolbar");
        }
        this.handleNewLinkerSelection();
    }

    public void addActionToolbar(GWTJahiaToolbar gwtToolbar, boolean first) {
        ActionToolbar actionToolbar = new ActionToolbar(gwtToolbar, this.linker);
        actionToolbar.createToolBar();
        actionToolbar.addStyleName("action-toolbar");
        if (first) {
            actionToolbar.addStyleName("x-toolbar-first");
        }
        actionToolbar.addStyleName(gwtToolbar.getClassName());
        this.add((Component)actionToolbar);
        this.layout();
        this.actionToolbars.add(actionToolbar);
    }

    public void handleNewLinkerSelection() {
        for (ActionToolbar actionToolbar : this.actionToolbars) {
            actionToolbar.handleNewLinkerSelection();
        }
    }

    public void handleNewMainNodeLoaded(GWTJahiaNode node) {
        for (ActionToolbar actionToolbar : this.actionToolbars) {
            actionToolbar.handleNewMainNodeLoaded(node);
        }
    }

    public void initWithLinker(Linker linker) {
        this.linker = linker;
        if (this.toolbarSet != null) {
            this.createToolbarUI(this.toolbarSet);
        }
    }

    public void setConfig(GWTEditConfiguration config) {
        this.setToolbarSet(config.getTopToolbars());
    }
}

