/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar;

import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.menu.Item;
import com.extjs.gxt.ui.client.widget.menu.Menu;
import com.extjs.gxt.ui.client.widget.menu.MenuItem;
import com.extjs.gxt.ui.client.widget.menu.SeparatorMenuItem;
import java.util.List;
import org.jahia.ajax.gwt.client.data.toolbar.GWTJahiaToolbarItem;
import org.jahia.ajax.gwt.client.data.toolbar.GWTJahiaToolbarMenu;
import org.jahia.ajax.gwt.client.util.icons.ToolbarIconProvider;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.toolbar.ActionToolbar;
import org.jahia.ajax.gwt.client.widget.toolbar.ToolbarGroup;
import org.jahia.ajax.gwt.client.widget.toolbar.action.ActionItem;
import org.jahia.ajax.gwt.client.widget.toolbar.action.BaseActionItem;

public class ActionToolbarMenu
extends Menu
implements ToolbarGroup {
    protected Linker linker;
    protected List<ActionItem> actionItems;

    public ActionToolbarMenu(Linker linker) {
        this.linker = linker;
    }

    public void setActionItems(List<ActionItem> actionItems) {
        this.actionItems = actionItems;
    }

    @Override
    public void addItem(GWTJahiaToolbarItem gwtToolbarItem) {
        if (gwtToolbarItem instanceof GWTJahiaToolbarMenu) {
            final MenuItem subMenu = new MenuItem();
            subMenu.addStyleName("action-bar-menu-item");
            gwtToolbarItem.addClasses((Component)subMenu);
            if (gwtToolbarItem.getIcon() != null) {
                subMenu.setIcon(ToolbarIconProvider.getInstance().getIcon(gwtToolbarItem.getIcon()));
            }
            GWTJahiaToolbarMenu gwtToolbarMenu = (GWTJahiaToolbarMenu)gwtToolbarItem;
            subMenu.setText(gwtToolbarMenu.getItemsGroupTitle());
            ActionToolbarMenu menu = new ActionToolbarMenu(this.linker);
            menu.addStyleName("menu-" + gwtToolbarMenu.getClassName());
            menu.addStyleName("action-bar-menu");
            menu.setActionItems(this.actionItems);
            for (GWTJahiaToolbarItem subItem : gwtToolbarMenu.getGwtToolbarItems()) {
                menu.addItem(subItem);
            }
            subMenu.setSubMenu((Menu)menu);
            subMenu.addListener(Events.Attach, (Listener)new Listener<BaseEvent>(){

                public void handleEvent(BaseEvent be) {
                    boolean show = false;
                    block0: for (Component item : subMenu.getSubMenu().getItems()) {
                        for (ActionItem baseItem : ActionToolbarMenu.this.actionItems) {
                            if (!baseItem.getMenuItem().equals(item) || !(baseItem instanceof BaseActionItem) || !((BaseActionItem)baseItem).isEnabled()) continue;
                            show = true;
                            continue block0;
                        }
                    }
                    subMenu.setVisible(show);
                }
            });
            subMenu.setHideOnClick(false);
            this.add((Component)subMenu);
        } else {
            ActionItem actionItem = gwtToolbarItem.getActionItem();
            this.actionItems.add(actionItem);
            if (actionItem != null) {
                actionItem.init(gwtToolbarItem, this.linker);
                if (ActionToolbar.isSeparator(gwtToolbarItem)) {
                    this.add((Component)new SeparatorMenuItem());
                } else if (actionItem.getCustomItem() != null) {
                    this.add(actionItem.getCustomItem());
                } else {
                    this.add((Component)this.createActionItem(actionItem));
                }
            }
        }
    }

    protected Item createActionItem(ActionItem actionItem) {
        return actionItem.getMenuItem();
    }
}

