/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.FieldSet;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.FormLayout;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.widget.form.CalendarField;
import org.jahia.ajax.gwt.client.widget.toolbar.action.ExecuteActionItem;

public class ExecuteRemotePublicationActionItem
extends ExecuteActionItem {
    private static final long serialVersionUID = 1008895688179692790L;
    private boolean showOptions = true;
    private String titleKey;
    private transient CalendarField calendarFieldStart;
    private transient CalendarField calendarFieldEnd;
    private transient Window wnd;

    @Override
    public void onComponentSelection() {
        if (this.wnd != null) {
            this.wnd.show();
            return;
        }
        this.wnd = new Window();
        this.wnd.setWidth(550);
        this.wnd.setHeight(this.showOptions ? 220 : 120);
        this.wnd.setModal(true);
        this.wnd.setBlinkModal(true);
        this.wnd.setHeadingHtml(this.titleKey != null ? Messages.get(this.titleKey) : Messages.get("label.information", "Information"));
        this.wnd.setLayout((Layout)new FitLayout());
        FormPanel form = new FormPanel();
        form.setHeight(this.showOptions ? 180 : 80);
        form.setHeaderVisible(false);
        form.setFrame(false);
        form.setLabelWidth(250);
        VerticalPanel vpLabels = new VerticalPanel();
        vpLabels.add((Widget)new Label(this.confirmationMessageKey != null ? Messages.get(this.confirmationMessageKey, "You are about to execute action " + this.action + ". Do you want to continue?") : "You are about to execute action " + this.action + ". Do you want to continue?"));
        form.add((Widget)vpLabels);
        if (this.showOptions) {
            FieldSet fieldSet = new FieldSet();
            fieldSet.setHeadingHtml(Messages.get("label.options", "Options"));
            FormLayout layout = new FormLayout();
            layout.setLabelWidth(250);
            fieldSet.setLayout((Layout)layout);
            fieldSet.setCollapsible(true);
            fieldSet.collapse();
            fieldSet.addListener(Events.Expand, (Listener)new Listener<ComponentEvent>(){

                public void handleEvent(ComponentEvent componentEvent) {
                    ExecuteRemotePublicationActionItem.this.wnd.setHeight(ExecuteRemotePublicationActionItem.this.wnd.getHeight() + 70);
                }
            });
            fieldSet.addListener(Events.Collapse, (Listener)new Listener<ComponentEvent>(){

                public void handleEvent(ComponentEvent componentEvent) {
                    ExecuteRemotePublicationActionItem.this.wnd.setHeight(ExecuteRemotePublicationActionItem.this.wnd.getHeight() - 70);
                }
            });
            this.calendarFieldStart = new CalendarField("yyyy-MM-dd HH:mm", true, false, "startDate", false, null);
            this.calendarFieldStart.setFieldLabel(Messages.get("label.remotePublication.startDate", "Start time of the replication (optional)"));
            this.calendarFieldStart.setAllowBlank(true);
            fieldSet.add((Widget)this.calendarFieldStart);
            this.calendarFieldEnd = new CalendarField("yyyy-MM-dd HH:mm", true, false, "endDate", false, null);
            this.calendarFieldEnd.setFieldLabel(Messages.get("label.remotePublication.endDate", "End time of the replication (optional)"));
            this.calendarFieldEnd.setAllowBlank(true);
            fieldSet.add((Widget)this.calendarFieldEnd);
            form.add((Widget)fieldSet);
        }
        Button btnSubmit = new Button(Messages.get("label.yes", "Yes"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                ExecuteRemotePublicationActionItem.this.wnd.mask(Messages.get("label.executing", "Executing action..."));
                ExecuteRemotePublicationActionItem.this.doAction();
            }
        });
        btnSubmit.addStyleName("button-yes");
        form.addButton(btnSubmit);
        Button btnCancel = new Button(Messages.get("label.no", "No"), (SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                ExecuteRemotePublicationActionItem.this.wnd.hide();
            }
        });
        btnCancel.addStyleName("button-no");
        form.addButton(btnCancel);
        form.setButtonAlign(Style.HorizontalAlignment.CENTER);
        this.wnd.add((Widget)form);
        this.wnd.layout();
        this.wnd.show();
    }

    @Override
    protected String getRequestData() {
        if (!this.showOptions) {
            return null;
        }
        StringBuffer data = new StringBuffer();
        if (this.calendarFieldStart.getValue() != null) {
            data.append("start=").append(((Date)this.calendarFieldStart.getValue()).getTime());
        }
        if (this.calendarFieldEnd.getValue() != null) {
            if (data.length() > 0) {
                data.append("&");
            }
            data.append("end=").append(((Date)this.calendarFieldEnd.getValue()).getTime());
        }
        return data.length() > 0 ? data.toString() : null;
    }

    @Override
    protected void actionExecuted(int statusCode) {
        if (this.wnd != null) {
            this.wnd.unmask();
            this.wnd.hide();
        }
    }

    public void setTitleKey(String titleKey) {
        this.titleKey = titleKey;
    }

    public void setShowOptions(boolean showOptions) {
        this.showOptions = showOptions;
    }
}

