/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.form.ComboBox;
import java.util.Arrays;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTJahiaLanguage;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTJahiaToolbarItem;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.content.ManagerLinker;
import org.jahia.ajax.gwt.client.widget.edit.EditLinker;
import org.jahia.ajax.gwt.client.widget.toolbar.action.BaseLanguageAwareActionItem;

public class LanguageSwitcherActionItem
extends BaseLanguageAwareActionItem {
    private static final long serialVersionUID = 9115660301140902069L;
    private static LanguageSwitcherActionItem instance;
    protected transient ComboBox<GWTJahiaLanguage> mainComponent;
    protected boolean events = true;

    @Override
    public void init(GWTJahiaToolbarItem gwtToolbarItem, Linker linker) {
        super.init(gwtToolbarItem, linker);
        this.initMainComponent();
        instance = this;
    }

    private void initMainComponent() {
        this.mainComponent = new ComboBox();
        this.mainComponent.addStyleName(this.getGwtToolbarItem().getClassName());
        this.mainComponent.addStyleName("action-bar-menu-item");
        this.mainComponent.setStore(new ListStore());
        this.mainComponent.getStore().add(JahiaGWTParameters.getSiteLanguages());
        this.mainComponent.setDisplayField("displayName");
        this.mainComponent.setTemplate(LanguageSwitcherActionItem.getLangSwitchingTemplate());
        this.mainComponent.setTypeAhead(true);
        this.mainComponent.setTriggerAction(ComboBox.TriggerAction.ALL);
        this.mainComponent.setForceSelection(true);
        this.mainComponent.setEditable(false);
        this.mainComponent.setValue((ModelData)this.selectedLang);
        this.mainComponent.getListView().setStyleAttribute("font-size", "11px");
        this.mainComponent.getListView().addStyleName("menu-" + this.getGwtToolbarItem().getClassName());
        this.mainComponent.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<GWTJahiaLanguage>(){

            public void selectionChanged(SelectionChangedEvent<GWTJahiaLanguage> event) {
                if (LanguageSwitcherActionItem.this.events) {
                    if (LanguageSwitcherActionItem.this.linker instanceof EditLinker) {
                        ((EditLinker)LanguageSwitcherActionItem.this.linker).getMainModule().switchLanguage((GWTJahiaLanguage)event.getSelectedItem());
                    } else if (LanguageSwitcherActionItem.this.linker instanceof ManagerLinker) {
                        ((ManagerLinker)LanguageSwitcherActionItem.this.linker).switchLanguage((GWTJahiaLanguage)event.getSelectedItem());
                    }
                }
            }
        });
        this.setEnabled(true);
    }

    @Override
    public void handleNewMainNodeLoaded(GWTJahiaNode node) {
        super.handleNewMainNodeLoaded(node);
        this.updateSite();
    }

    @Override
    public void handleNewLinkerSelection() {
        super.handleNewLinkerSelection();
        this.updateSite();
    }

    private void updateSite() {
        if (!JahiaGWTParameters.getSiteLanguages().equals(this.mainComponent.getStore().getModels())) {
            this.events = false;
            this.mainComponent.getStore().removeAll();
            this.mainComponent.reset();
            this.mainComponent.getStore().add(JahiaGWTParameters.getSiteLanguages());
            this.mainComponent.getListView().getSelectionModel().setSelectionMode(Style.SelectionMode.SINGLE);
            if (this.mainComponent.getSelection().isEmpty() || !JahiaGWTParameters.getLanguage().equals(((GWTJahiaLanguage)((Object)this.mainComponent.getSelection().get(0))).getLanguage())) {
                this.mainComponent.getStore().clearFilters();
                for (GWTJahiaLanguage language : JahiaGWTParameters.getSiteLanguages()) {
                    if (!language.getLanguage().equals(JahiaGWTParameters.getLanguage())) continue;
                    this.mainComponent.setSelection(Arrays.asList(language));
                    break;
                }
            }
            this.events = true;
            if (!JahiaGWTParameters.getSiteLanguages().contains(this.mainComponent.getSelection().get(0))) {
                this.mainComponent.setSelection(Arrays.asList((GWTJahiaLanguage)((Object)JahiaGWTParameters.getSiteNode().get("j:defaultLanguage"))));
            }
        }
        if (!JahiaGWTParameters.getLanguage().equals(((GWTJahiaLanguage)((Object)this.mainComponent.getSelection().get(0))).getLanguage())) {
            this.events = false;
            GWTJahiaLanguage language = JahiaGWTParameters.getLanguage(JahiaGWTParameters.getLanguage());
            if (language != null) {
                this.mainComponent.setSelection(Arrays.asList(language));
            }
            this.events = true;
        }
    }

    public static void setLanguage(GWTJahiaLanguage language) {
        LanguageSwitcherActionItem.instance.mainComponent.setSelection(Arrays.asList(language));
    }

    @Override
    public Component getCustomItem() {
        return this.mainComponent;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.mainComponent.setEnabled(enabled);
    }

    public static native String getLangSwitchingTemplate();
}

