/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.Arrays;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTJahiaToolbarItem;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.LinkerSelectionContext;
import org.jahia.ajax.gwt.client.widget.toolbar.action.PublishActionItem;

public class PublishSiteActionItem
extends PublishActionItem {
    @Override
    public void init(GWTJahiaToolbarItem gwtToolbarItem, Linker linker) {
        this.allSubTree = true;
        this.updateTitle(gwtToolbarItem.getTitle() + " " + JahiaGWTParameters.getSiteKey() + " - " + JahiaGWTParameters.getLanguageDisplayName());
        super.init(gwtToolbarItem, linker);
    }

    @Override
    public void handleNewLinkerSelection() {
        LinkerSelectionContext ctx = this.linker.getSelectionContext();
        if (this.hasPermission(ctx.getSelectionPermissions()) && this.isNodeTypeAllowed(ctx.getMultipleSelection())) {
            boolean hasOnlyOneLanguage = JahiaGWTParameters.getSiteLanguages().size() == 1;
            this.setEnabled(true);
            if (this.allLanguages) {
                if (hasOnlyOneLanguage) {
                    this.setEnabled(false);
                    return;
                }
                this.updateTitle(this.getGwtToolbarItem().getTitle() + " " + JahiaGWTParameters.getSiteKey() + " - " + Messages.get("label.publish.all.languages", "all languages"));
            } else {
                this.updateTitle(this.getGwtToolbarItem().getTitle() + " " + JahiaGWTParameters.getSiteKey() + " - " + JahiaGWTParameters.getLanguageDisplayName());
            }
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public void onComponentSelection() {
        this.linker.loading(Messages.get("label.gettingPublicationInfo", "Getting publication information"));
        JahiaContentManagementService.App.getInstance().getNodes(Arrays.asList("/sites/" + JahiaGWTParameters.getSiteKey()), Arrays.asList("publicationInfo", "workflowInfo"), (AsyncCallback<List<GWTJahiaNode>>)new BaseAsyncCallback<List<GWTJahiaNode>>(){

            public void onSuccess(List<GWTJahiaNode> result) {
                PublishSiteActionItem.this.linker.loaded();
                LinkerSelectionContext selectionContext = PublishSiteActionItem.this.linker.getSelectionContext();
                List<GWTJahiaNode> multipleSelection = selectionContext.getMultipleSelection();
                selectionContext.setSelectedNodes(result);
                selectionContext.refresh(3);
                PublishSiteActionItem.super.onComponentSelection();
                selectionContext.setSelectedNodes(multipleSelection);
                selectionContext.refresh(3);
            }
        });
    }
}

