/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import com.extjs.gxt.ui.client.widget.MessageBox;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.Arrays;
import java.util.HashMap;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.util.security.PermissionsUtils;
import org.jahia.ajax.gwt.client.widget.LinkerSelectionContext;
import org.jahia.ajax.gwt.client.widget.content.FileUploader;
import org.jahia.ajax.gwt.client.widget.content.ManagerLinker;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.MainModule;
import org.jahia.ajax.gwt.client.widget.toolbar.action.NodeTypeAwareBaseActionItem;

public class RenameActionItem
extends NodeTypeAwareBaseActionItem {
    private int maxNameSize = -1;

    @Override
    public void onComponentSelection() {
        GWTJahiaNode selection = this.linker.getSelectionContext().getSingleSelection();
        if (selection != null) {
            if (selection.isLocked().booleanValue()) {
                Window.alert((String)(selection.getName() + " is locked"));
                return;
            }
            MainModule mainModule = MainModule.getInstance();
            final boolean goTo = mainModule != null ? selection.getPath().equals(mainModule.getNode().getPath()) : false;
            this.linker.loading(Messages.get("statusbar.renaming.label"));
            String newName = Window.prompt((String)(Messages.get("confirm.newName.label") + " " + selection.getName()), (String)selection.getName());
            if (selection.isNodeType("nt:hierarchyNode") && newName != null && FileUploader.filenameHasInvalidCharacters(newName)) {
                MessageBox.alert((String)Messages.get("label.error"), (String)Messages.getWithArgs("failure.upload.invalid.filename", "{0} is an invalid name", new String[]{newName}), null);
            } else if (this.maxNameSize > 0 && newName != null && newName.length() > 0 && newName.length() > this.maxNameSize) {
                MessageBox.alert((String)Messages.get("label.error"), (String)Messages.getWithArgs("failure.upload.invalid.filename.toolong", "The name is too long. The maximum length is {0}", new String[]{String.valueOf(this.maxNameSize)}), null);
            } else if (newName != null && newName.length() > 0 && !newName.equals(selection.getName())) {
                JahiaContentManagementService.App.getInstance().rename(selection.getPath(), newName, (AsyncCallback<GWTJahiaNode>)new BaseAsyncCallback<GWTJahiaNode>(){

                    @Override
                    public void onApplicationFailure(Throwable throwable) {
                        MessageBox.alert((String)Messages.get("failure.rename.label"), (String)throwable.getLocalizedMessage(), null);
                        RenameActionItem.this.linker.loaded();
                    }

                    public void onSuccess(GWTJahiaNode node) {
                        if (goTo) {
                            RenameActionItem.this.linker.setSelectPathAfterDataUpdate(Arrays.asList(node.getPath()));
                        }
                        RenameActionItem.this.linker.loaded();
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put("node", node);
                        if (RenameActionItem.this.linker instanceof ManagerLinker) {
                            data.put("refreshAll", true);
                        }
                        RenameActionItem.this.linker.refresh(data);
                    }
                });
            } else {
                this.linker.loaded();
            }
        }
    }

    @Override
    public void handleNewLinkerSelection() {
        LinkerSelectionContext lh = this.linker.getSelectionContext();
        this.setEnabled(lh.getSingleSelection() != null && this.hasPermission(lh.getSelectionPermissions()) && PermissionsUtils.isPermitted("jcr:write", lh.getSelectionPermissions()) && !lh.isLocked() && !lh.isRootNode() && !lh.getSingleSelection().getPath().equals("/sites/" + lh.getSingleSelection().getSiteKey() + "/" + lh.getSingleSelection().getName()) && !lh.getSingleSelection().getPath().equals("/" + lh.getSingleSelection().getName()) && this.isNodeTypeAllowed(lh.getSingleSelection()));
    }

    public void setMaxNameSize(int maxNameSize) {
        this.maxNameSize = maxNameSize;
    }
}

