/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.WindowEvent;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.Radio;
import com.extjs.gxt.ui.client.widget.form.RadioGroup;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import org.jahia.ajax.gwt.client.messages.Messages;

public class SourceControlDialog
extends Dialog {
    private RadioGroup scmType;
    private TextField<String> uri;
    private TextField<String> moduleId;
    private TextField<String> sources;
    private TextField<String> branchOrTag;
    private Map<String, Radio> radios;
    private final FormPanel form;
    private SourceControlDialog sourceControlDialog;

    public SourceControlDialog(String heading, boolean viewModuleName, boolean viewBranchOrTag) {
        this.setHeadingHtml(heading);
        this.setButtons("okcancel");
        this.setModal(true);
        this.setHideOnButtonClick(true);
        this.setWidth(500);
        this.setHeight(300);
        this.setLayout((Layout)new FitLayout());
        this.form = new FormPanel();
        this.form.setHeaderVisible(false);
        this.form.setFrame(false);
        this.form.setLabelWidth(175);
        this.scmType = new RadioGroup("scmType");
        this.scmType.setFieldLabel(Messages.get("label.scmType", "SCM type"));
        this.radios = new HashMap<String, Radio>();
        Radio git = new Radio();
        git.setBoxLabel(Messages.get("label.git", "GIT"));
        git.setValue(Boolean.valueOf(true));
        git.setValueAttribute("git");
        this.scmType.add(git);
        this.radios.put(git.getValueAttribute(), git);
        Radio svn = new Radio();
        svn.setBoxLabel(Messages.get("label.svn", "SVN"));
        svn.setValueAttribute("svn");
        this.scmType.add(svn);
        this.radios.put(svn.getValueAttribute(), svn);
        this.form.add((Widget)this.scmType);
        this.uri = new TextField();
        this.uri.setName("uri");
        this.uri.setFieldLabel(Messages.get("label.uri", "URI"));
        this.uri.setAllowBlank(false);
        this.form.add(this.uri);
        if (viewModuleName) {
            this.moduleId = new TextField();
            this.moduleId.setName("moduleId");
            this.moduleId.setFieldLabel(Messages.get("label.moduleId", "Module ID (artifactId)"));
            this.moduleId.setAllowBlank(true);
            this.form.add(this.moduleId);
            this.sources = new TextField();
            this.sources.setName("sources");
            this.sources.setFieldLabel(Messages.get("label.sources.folder", "Sources folder (optional - will be created with new sources)"));
            this.form.add(this.sources);
        }
        if (viewBranchOrTag) {
            this.branchOrTag = new TextField();
            this.branchOrTag.setName("branchOrTag");
            this.branchOrTag.setFieldLabel(Messages.get("label.branchOrTag", "Branch or tag"));
            this.form.add(this.branchOrTag);
        }
        this.add((Component)this.form);
        this.sourceControlDialog = this;
    }

    public String getScmType() {
        return this.scmType.getValue().getValueAttribute();
    }

    public void setScmType(String value) {
        this.scmType.setValue(this.radios.get(value));
    }

    public String getUri() {
        return (String)this.uri.getValue();
    }

    public void setUri(String value) {
        this.uri.setValue((Object)value);
    }

    public String getModuleId() {
        return (String)this.moduleId.getValue();
    }

    public void setModuleId(String moduleId) {
        this.moduleId.setValue((Object)moduleId);
    }

    public String getSources() {
        return (String)this.sources.getValue();
    }

    public void setSources(String sources) {
        this.sources.setValue((Object)sources);
    }

    public String getBranchOrTag() {
        return (String)this.branchOrTag.getValue();
    }

    public void setBranchOrTag(String value) {
        this.branchOrTag.setValue((Object)value);
    }

    public void addCallback(final Listener<WindowEvent> listener) {
        this.addListener(Events.Hide, (Listener)new Listener<WindowEvent>(){

            public void handleEvent(WindowEvent be) {
                if (be.getButtonClicked().getItemId().equalsIgnoreCase("ok")) {
                    if (SourceControlDialog.this.form.isValid()) {
                        listener.handleEvent((BaseEvent)be);
                    } else {
                        SourceControlDialog.this.sourceControlDialog.show();
                    }
                }
            }
        });
    }
}

