/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.toolbar.action;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.button.ToggleButton;
import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.storage.client.Storage;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.RootPanel;
import java.util.List;
import java.util.Set;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTJahiaLanguage;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.toolbar.GWTEditConfiguration;
import org.jahia.ajax.gwt.client.data.toolbar.GWTJahiaToolbarItem;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.widget.Linker;
import org.jahia.ajax.gwt.client.widget.edit.EditLinker;
import org.jahia.ajax.gwt.client.widget.edit.mainarea.MainModule;
import org.jahia.ajax.gwt.client.widget.toolbar.action.NodeTypeAwareBaseActionItem;

public class SwitchConfigActionItem
extends NodeTypeAwareBaseActionItem {
    private String configurationName;
    private boolean updateSidePanel = true;
    private boolean updateToolbar = true;
    private String enforcedWorkspace = "default";
    private boolean forceRootChange = false;
    private boolean updateOnMainNodeRefresh = false;
    private Set<String> noChecksInMode;

    @Override
    public void init(GWTJahiaToolbarItem gwtToolbarItem, Linker linker) {
        super.init(gwtToolbarItem, linker);
        RootPanel panel = RootPanel.get((String)"editmode");
        if (panel != null) {
            if (!MainModule.getInstance().getConfig().getName().equals(this.configurationName)) {
                this.getTextToolItem().setEnabled(true);
                this.getGwtToolbarItem().setSelected(false);
            } else {
                this.getGwtToolbarItem().setSelected(true);
            }
        }
    }

    public boolean isUpdateSidePanel() {
        return this.updateSidePanel;
    }

    public void setUpdateSidePanel(boolean updateSidePanel) {
        this.updateSidePanel = updateSidePanel;
    }

    public boolean isUpdateToolbar() {
        return this.updateToolbar;
    }

    public void setUpdateToolbar(boolean updateToolbar) {
        this.updateToolbar = updateToolbar;
    }

    public void setNoChecksInMode(Set<String> noChecksInMode) {
        this.noChecksInMode = noChecksInMode;
    }

    @Override
    public void handleNewMainNodeLoaded(GWTJahiaNode node) {
        if (!this.updateOnMainNodeRefresh || this.noChecksInMode != null && this.noChecksInMode.contains(this.linker.getConfig().getName())) {
            this.setEnabled(true);
        } else {
            this.setEnabled(this.isNodeTypeAllowed(node) && !((EditLinker)this.linker).isInSettingsPage() && this.hasPermission(node));
        }
    }

    @Override
    public void onComponentSelection() {
        if (!this.configurationName.equals(MainModule.getInstance().getConfig().getName())) {
            this.linker.loading(Messages.get("label.loading", "Loading..."));
            final Storage storage = Storage.getSessionStorageIfSupported();
            final boolean useSamePath = this.linker.getConfig().getSamePathConfigsList().contains(this.configurationName);
            String path = null;
            if (useSamePath && !this.forceRootChange) {
                String sitePath = JahiaGWTParameters.getSiteNode().getSiteKey().equals("systemsite") ? null : JahiaGWTParameters.getSiteNode().getPath();
                path = this.linker.getSelectionContext().getMainNode() == null ? sitePath : this.linker.getSelectionContext().getMainNode().getPath();
            } else if (storage != null) {
                path = storage.getItem(this.configurationName + "_nodePath");
            }
            JahiaContentManagementService.App.getInstance().getEditConfiguration(path, this.configurationName, this.enforcedWorkspace, (AsyncCallback<GWTEditConfiguration>)new BaseAsyncCallback<GWTEditConfiguration>(){

                public void onSuccess(GWTEditConfiguration gwtEditConfiguration) {
                    if (gwtEditConfiguration.getDefaultLocation() == null) {
                        SwitchConfigActionItem.this.linker.loaded();
                        Window.alert((String)Messages.getWithArgs("label.gwt.error", "Error: {}", new Object[]{Messages.get("label.noAvailableSites")}));
                    } else {
                        String newPath;
                        if (useSamePath) {
                            newPath = null;
                        } else {
                            if (storage != null && storage.getItem(gwtEditConfiguration.getName() + "_path") != null) {
                                newPath = storage.getItem(gwtEditConfiguration.getName() + "_path");
                                GWTJahiaNode siteNode = gwtEditConfiguration.getSiteNode();
                                MatchResult m = RegExp.compile((String)(gwtEditConfiguration.getDefaultUrlMapping() + "frame/default/([a-zA-Z_]+)/.*")).exec(newPath);
                                if (m != null) {
                                    List langs = (List)siteNode.get("siteLanguages");
                                    for (GWTJahiaLanguage lang : langs) {
                                        if (!lang.getLanguage().equals(m.getGroup(1))) continue;
                                        ((EditLinker)SwitchConfigActionItem.this.linker).setLocale(lang);
                                        break;
                                    }
                                }
                            } else {
                                String currentLocale = ((EditLinker)SwitchConfigActionItem.this.linker).getLocale();
                                GWTJahiaNode siteNode = gwtEditConfiguration.getSiteNode();
                                List languages = (List)siteNode.get("j:languages");
                                if (languages == null || !languages.contains(currentLocale)) {
                                    ((EditLinker)SwitchConfigActionItem.this.linker).setLocale((GWTJahiaLanguage)((Object)siteNode.get("j:defaultLanguage")));
                                }
                                newPath = MainModule.getInstance().getBaseUrl() + gwtEditConfiguration.getDefaultLocation();
                            }
                            newPath = SwitchConfigActionItem.this.removeWebflowParameter(newPath);
                        }
                        EditLinker editLinker = (EditLinker)SwitchConfigActionItem.this.linker;
                        if (SwitchConfigActionItem.replaceSwitchByOpen() && newPath != null) {
                            newPath = newPath.replaceFirst(editLinker.getConfig().getDefaultUrlMapping(), gwtEditConfiguration.getDefaultUrlMapping()).replaceFirst("frame/default/", "/default/");
                            Window.Location.assign((String)newPath);
                        } else {
                            editLinker.switchConfig(gwtEditConfiguration, newPath, SwitchConfigActionItem.this.updateSidePanel, SwitchConfigActionItem.this.updateToolbar, SwitchConfigActionItem.this.enforcedWorkspace);
                        }
                    }
                }

                @Override
                public void onApplicationFailure(Throwable throwable) {
                    SwitchConfigActionItem.this.linker.loaded();
                    Window.alert((String)Messages.getWithArgs("label.gwt.error", "Error: {}", new Object[]{throwable.getMessage()}));
                    Log.error((String)"Error when loading EditConfiguration", (Throwable)throwable);
                }
            });
        }
    }

    private String removeWebflowParameter(String path) {
        String[] paramsToremove;
        for (String param : paramsToremove = new String[]{"webflowexecution", "webflowToken", "webflowLocale"}) {
            path = this.removePathParameter(path, param);
        }
        return path;
    }

    private String removePathParameter(String path, String parameter) {
        if (path == null) {
            return null;
        }
        int index = path.indexOf(parameter);
        String newPath = path;
        if (index > -1) {
            newPath = path.substring(0, index);
            if ((index = path.indexOf("&", index)) > -1) {
                newPath = newPath + path.substring(index + 1);
            }
            if (newPath.endsWith("?") || newPath.endsWith("&")) {
                newPath = newPath.substring(0, newPath.length() - 1);
            }
        }
        return newPath;
    }

    public void setConfigurationName(String configurationName) {
        this.configurationName = configurationName;
    }

    @Override
    public Component createNewToolItem() {
        ToggleButton toggleButton = new ToggleButton();
        toggleButton.setToggleGroup("switchConfig");
        if (this.getGwtToolbarItem().isSelected()) {
            toggleButton.setAllowDepress(false);
        }
        return toggleButton;
    }

    public void setEnforcedWorkspace(String enforcedWorkspace) {
        this.enforcedWorkspace = enforcedWorkspace;
    }

    public void setForceRootChange(boolean forceRootChange) {
        this.forceRootChange = forceRootChange;
    }

    public void setUpdateOnMainNodeRefresh(boolean updateOnMainNodeRefresh) {
        this.updateOnMainNodeRefresh = updateOnMainNodeRefresh;
    }

    @Deprecated
    public void setCheckPermissionOnSite(boolean checkPermissionOnSite) {
    }

    private static native boolean replaceSwitchByOpen();
}

