/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.trash;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.layout.BorderLayout;
import com.extjs.gxt.ui.client.widget.layout.BorderLayoutData;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jahia.ajax.gwt.client.core.BaseAsyncCallback;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.GWTRenderResult;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.messages.Messages;
import org.jahia.ajax.gwt.client.service.content.JahiaContentManagementService;
import org.jahia.ajax.gwt.client.widget.Linker;

public class PreviewWindow
extends Window {
    private LayoutContainer htmlPreview;

    public PreviewWindow(Linker linker, GWTJahiaNode jahiaNode) {
        this.addStyleName("preview-window");
        this.setClosable(true);
        this.setModal(true);
        this.setLayout((Layout)new BorderLayout());
        this.setSize(800, 600);
        LayoutContainer container = new LayoutContainer((Layout)new RowLayout());
        HTML label = new HTML("<b>" + Messages.getWithArgs("label.trashedContentPreview", "{0} on {1} said about \"{2}\" : ", new Object[]{jahiaNode.get("j:deletionUser"), jahiaNode.get("j:deletionDate"), jahiaNode.getDisplayName()}) + "</b>");
        container.add((Widget)label);
        TextArea textArea = new TextArea();
        textArea.setReadOnly(true);
        textArea.setEnabled(false);
        textArea.setValue((Object)((String)jahiaNode.get("j:deletionMessage")));
        textArea.setWidth("95%");
        container.add((Widget)textArea);
        container.add((Widget)new Text(Messages.get("label.path", "path") + " : " + jahiaNode.getPath()));
        this.add((Widget)container, (LayoutData)new BorderLayoutData(Style.LayoutRegion.NORTH, 100.0f));
        this.htmlPreview = new LayoutContainer();
        this.htmlPreview.setStyleAttribute("background-color", "white");
        this.htmlPreview.setScrollMode(Style.Scroll.AUTO);
        this.add((Widget)this.htmlPreview, (LayoutData)new BorderLayoutData(Style.LayoutRegion.CENTER));
        Button button = new Button(Messages.get("label.close", "Close"));
        button.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public void componentSelected(ButtonEvent event) {
                PreviewWindow.this.hide();
            }
        });
        this.addButton(button);
        String configuration = jahiaNode.isNodeType("jnt:page") ? "gwt" : "preview";
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        params.put("noDeleteLayer", Arrays.asList("true"));
        JahiaContentManagementService.App.getInstance().getRenderedContent(jahiaNode.getPath(), null, JahiaGWTParameters.getLanguage(), "default", configuration, params, true, linker.getConfig().getName(), null, null, (AsyncCallback<GWTRenderResult>)new BaseAsyncCallback<GWTRenderResult>(){

            public void onSuccess(GWTRenderResult gwtRenderResult) {
                PreviewWindow.this.htmlPreview.removeAll();
                PreviewWindow.this.htmlPreview.add((Widget)new HTML(gwtRenderResult.getResult()));
                PreviewWindow.this.htmlPreview.layout();
            }
        });
    }
}

