/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.client.widget.usergroup;

import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.InlineHTML;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jahia.ajax.gwt.client.core.JahiaGWTParameters;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.widget.usergroup.UserGroupAdder;
import org.jahia.ajax.gwt.client.widget.usergroup.UserGroupSelect;

public class UserGroupSelectButton
extends InlineHTML {
    private static final Set<String> MODES = new HashSet<String>(3);
    private String callback;
    private String fieldId;
    private String mode;
    private boolean showSiteSelector;
    private boolean singleSelectionMode;

    public static native void add(String var0, String var1, String var2, String var3, String var4);

    private static String getAttribute(Element elem, String attributeName, String defaultValue) {
        return elem.getAttribute(attributeName).length() > 0 ? elem.getAttribute(attributeName) : defaultValue;
    }

    public UserGroupSelectButton(Element elem) {
        super(UserGroupSelectButton.getAttribute(elem, "label", ""));
        this.mode = UserGroupSelectButton.getAttribute(elem, "mode", "both");
        this.mode = MODES.contains(this.mode) ? this.mode : "both";
        this.setStyleName(UserGroupSelectButton.getAttribute(elem, "styleName", "usergroup-button usergroup-mode-" + this.mode));
        this.showSiteSelector = Boolean.valueOf(UserGroupSelectButton.getAttribute(elem, "showSiteSelector", "false"));
        this.singleSelectionMode = Boolean.valueOf(UserGroupSelectButton.getAttribute(elem, "singleSelectionMode", "false"));
        this.callback = UserGroupSelectButton.getAttribute(elem, "onSelect", null);
        this.fieldId = UserGroupSelectButton.getAttribute(elem, "fieldId", null);
        this.init();
    }

    private int getViewMode() {
        int viewMode = 3;
        if ("users".equals(this.mode)) {
            viewMode = 1;
        } else if ("groups".equals(this.mode)) {
            viewMode = 2;
        }
        return viewMode;
    }

    private void init() {
        this.addClickListener(new ClickListener(){

            public void onClick(Widget sender) {
                new UserGroupSelect(new UserGroupAdder(){

                    @Override
                    public void addUsersGroups(List<GWTJahiaNode> users) {
                        for (GWTJahiaNode user : users) {
                            UserGroupSelectButton.add(UserGroupSelectButton.this.fieldId, UserGroupSelectButton.this.callback, user.isNodeType("jnt:user") ? "u" : "g", user.getPath(), user.getDisplayName());
                        }
                    }
                }, UserGroupSelectButton.this.getViewMode(), JahiaGWTParameters.getSiteKey(), UserGroupSelectButton.this.singleSelectionMode);
            }
        });
    }

    static {
        MODES.add("both");
        MODES.add("users");
        MODES.add("groups");
    }
}

