/*
 * ==========================================================================================
 * =                   JAHIA'S DUAL LICENSING - IMPORTANT INFORMATION                       =
 * ==========================================================================================
 *
 *                                 http://www.jahia.com
 *
 *     Copyright (C) 2002-2025 Jahia Solutions Group SA. All rights reserved.
 *
 *     THIS FILE IS AVAILABLE UNDER TWO DIFFERENT LICENSES:
 *     1/Apache2 OR 2/JSEL
 *
 *     1/ Apache2
 *     ==================================================================================
 *
 *     Copyright (C) 2002-2025 Jahia Solutions Group SA. All rights reserved.
 *
 *     Licensed under the Apache License, Version 2.0 (the "License");
 *     you may not use this file except in compliance with the License.
 *     You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *     Unless required by applicable law or agreed to in writing, software
 *     distributed under the License is distributed on an "AS IS" BASIS,
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *     See the License for the specific language governing permissions and
 *     limitations under the License.
 *
 *
 *     2/ JSEL - Commercial and Supported Versions of the program
 *     ===================================================================================
 *
 *     IF YOU DECIDE TO CHOOSE THE JSEL LICENSE, YOU MUST COMPLY WITH THE FOLLOWING TERMS:
 *
 *     Alternatively, commercial and supported versions of the program - also known as
 *     Enterprise Distributions - must be used in accordance with the terms and conditions
 *     contained in a separate written agreement between you and Jahia Solutions Group SA.
 *
 *     If you are unsure which license is appropriate for your use,
 *     please contact the sales department at sales@jahia.com.
 */
package org.jahia.services.content.rules;

import org.drools.core.spi.KnowledgeHelper;
import org.jahia.services.content.JCRSessionWrapper;

import javax.jcr.RepositoryException;

/**
 * This class describe a property deletion event for the drools engine.
 * User: toto
 * Date: 17 janv. 2008
 * Time: 15:20:31
 */
public class DeletedPropertyFact implements ModifiedPropertyFact {
    private String nodePath;
    private AddedNodeFact node;
    private String name;

    public DeletedPropertyFact(ChangedPropertyFact property, KnowledgeHelper drools) throws RepositoryException {
        name = property.getName();
        node = property.getNode();
        nodePath = node.getPath();
        property.getProperty().remove();
        drools.retract(property);
    }

    public DeletedPropertyFact(AddedNodeFact node, String property) throws RepositoryException {
        this.node = node;
        nodePath = node.getPath();
        name = property;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public AddedNodeFact getNode() {
        return node;
    }

    @Override
    public String toString() {
        return "deleted " + nodePath + "/" + name;
    }

    /**
     * Returns the current JCR operation type.
     *
     * @return the current JCR operation type
     * @throws javax.jcr.RepositoryException in case of a repository access error
     * @since Jahia 6.6
     */
    public String getOperationType() {
        return node.getOperationType();
    }

    @Override
    public String getWorkspace() throws RepositoryException {
        return getNode().getWorkspace();
    }

    @Override
    public JCRSessionWrapper getSession() throws RepositoryException {
        return getNode().getSession();
    }

    @Override
    public String getNodeIdentifier() throws RepositoryException {
        return getNode().getIdentifier();
    }

    @Override
    public String getNodeType() throws RepositoryException {
        return getNode().getNodeType();
    }
}
