/*
 * ==========================================================================================
 * =                   JAHIA'S DUAL LICENSING - IMPORTANT INFORMATION                       =
 * ==========================================================================================
 *
 *                                 http://www.jahia.com
 *
 *     Copyright (C) 2002-2025 Jahia Solutions Group SA. All rights reserved.
 *
 *     THIS FILE IS AVAILABLE UNDER TWO DIFFERENT LICENSES:
 *     1/Apache2 OR 2/JSEL
 *
 *     1/ Apache2
 *     ==================================================================================
 *
 *     Copyright (C) 2002-2025 Jahia Solutions Group SA. All rights reserved.
 *
 *     Licensed under the Apache License, Version 2.0 (the "License");
 *     you may not use this file except in compliance with the License.
 *     You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *     Unless required by applicable law or agreed to in writing, software
 *     distributed under the License is distributed on an "AS IS" BASIS,
 *     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *     See the License for the specific language governing permissions and
 *     limitations under the License.
 *
 *
 *     2/ JSEL - Commercial and Supported Versions of the program
 *     ===================================================================================
 *
 *     IF YOU DECIDE TO CHOOSE THE JSEL LICENSE, YOU MUST COMPLY WITH THE FOLLOWING TERMS:
 *
 *     Alternatively, commercial and supported versions of the program - also known as
 *     Enterprise Distributions - must be used in accordance with the terms and conditions
 *     contained in a separate written agreement between you and Jahia Solutions Group SA.
 *
 *     If you are unsure which license is appropriate for your use,
 *     please contact the sales department at sales@jahia.com.
 */
package org.jahia.services.importexport;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/**
 *
 * User: toto
 * Date: May 26, 2008
 * Time: 10:59:42 AM
 *
 * @deprecated Legacy import code, seems not used
 */
@Deprecated(since = "8.2.1.0", forRemoval = true)
public class FilesDateImportHandler extends DefaultHandler {

    private static final transient Logger logger = LoggerFactory.getLogger(FilesDateImportHandler.class);

    private Map<String, Date> fileToDate = new HashMap<String, Date>();
    private DateFormat df = new SimpleDateFormat(ImportExportService.DATE_FORMAT);

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String value = attributes.getValue("jahia:lastModification");
        if (value != null) {
            try {
                fileToDate.put(attributes.getValue("jahia:path"), df.parse(value));
            } catch (ParseException e) {
                logger.error(e.getMessage(), e);
            }
        }
    }

    public Map<String, Date> getFileToDate() {
        return fileToDate;
    }
}
