/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.query.Row;
import javax.jcr.query.qom.ChildNode;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DescendantNode;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.FullTextSearch;
import javax.jcr.query.qom.Literal;
import javax.jcr.query.qom.Or;
import javax.jcr.query.qom.PropertyValue;
import javax.jcr.query.qom.SameNode;
import javax.jcr.query.qom.Selector;
import javax.jcr.query.qom.StaticOperand;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.math.util.MathUtils;
import org.apache.jackrabbit.commons.predicate.Predicate;
import org.apache.jackrabbit.commons.query.qom.OperandEvaluator;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.query.lucene.AnalyzerRegistry;
import org.apache.jackrabbit.core.query.lucene.CountHandler;
import org.apache.jackrabbit.core.query.lucene.DescendantSelfAxisQuery;
import org.apache.jackrabbit.core.query.lucene.FacetHandler;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.JackrabbitIndexSearcher;
import org.apache.jackrabbit.core.query.lucene.JackrabbitTermQuery;
import org.apache.jackrabbit.core.query.lucene.JahiaNodeIndexer;
import org.apache.jackrabbit.core.query.lucene.JahiaSearchIndex;
import org.apache.jackrabbit.core.query.lucene.LuceneQueryFactory;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.QueryHits;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.jackrabbit.core.query.lucene.join.SelectorRow;
import org.apache.jackrabbit.core.security.JahiaAccessManager;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.DocIdBitSet;
import org.apache.lucene.util.OpenBitSet;
import org.apache.lucene.util.OpenBitSetDISI;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.search.facets.JahiaQueryParser;
import org.jahia.services.visibility.VisibilityService;
import org.jahia.utils.LanguageCodeConverters;
import org.jahia.utils.Patterns;
import org.jahia.utils.security.AccessManagerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JahiaLuceneQueryFactoryImpl
extends LuceneQueryFactory {
    private static Logger logger = LoggerFactory.getLogger(JahiaLuceneQueryFactoryImpl.class);
    private Locale locale;
    private String queryLanguage;
    public static final FieldSelector ONLY_MAIN_NODE_UUID = (FieldSelector & Serializable)fieldName -> {
        if (JahiaNodeIndexer.TRANSLATED_NODE_PARENT == fieldName) {
            return FieldSelectorResult.LOAD;
        }
        if (FieldNames.PARENT == fieldName) {
            return FieldSelectorResult.LOAD;
        }
        return FieldSelectorResult.NO_LOAD;
    };
    public static final FieldSelector OPTIMIZATION_FIELDS = (FieldSelector & Serializable)fieldName -> {
        if (JahiaNodeIndexer.TRANSLATED_NODE_PARENT == fieldName) {
            return FieldSelectorResult.LOAD;
        }
        if (FieldNames.PARENT == fieldName) {
            return FieldSelectorResult.LOAD;
        }
        if (JahiaNodeIndexer.ACL_UUID == fieldName) {
            return FieldSelectorResult.LOAD;
        }
        if (JahiaNodeIndexer.CHECK_VISIBILITY == fieldName) {
            return FieldSelectorResult.LOAD;
        }
        if (JahiaNodeIndexer.PUBLISHED == fieldName) {
            return FieldSelectorResult.LOAD;
        }
        if (JahiaNodeIndexer.INVALID_LANGUAGES == fieldName) {
            return FieldSelectorResult.LOAD;
        }
        return FieldSelectorResult.NO_LOAD;
    };

    static boolean checkIndexedAcl(Map<String, Boolean> checkedAcls, String aclUuid, SessionImpl session) throws RepositoryException {
        if (aclUuid == null) {
            return true;
        }
        boolean canRead = false;
        Object[] acls = Patterns.SPACE.split(aclUuid);
        ArrayUtils.reverse((Object[])acls);
        HashSet readPermissions = null;
        for (Object acl : acls) {
            Boolean aclChecked;
            if (((String)acl).contains("/")) {
                String singleUser = StringUtils.substringAfter((String)acl, (String)"/");
                acl = StringUtils.substringBefore((String)acl, (String)"/");
                if (singleUser.indexOf(47) != -1) {
                    String roles = StringUtils.substringBeforeLast((String)singleUser, (String)"/");
                    if (!(singleUser = StringUtils.substringAfterLast((String)singleUser, (String)"/")).equals(session.getUserID())) continue;
                    for (String role : StringUtils.split((String)roles, (char)'/')) {
                        if (null == readPermissions) {
                            readPermissions = Sets.newHashSet((Object[])new String[]{AccessManagerUtils.getPrivilegeName("{http://www.jcp.org/jcr/1.0}read", session.getWorkspace().getName())});
                        }
                        if (!((JahiaAccessManager)session.getAccessControlManager()).matchPermission(readPermissions, role)) continue;
                        return true;
                    }
                } else if (!singleUser.equals(session.getUserID())) continue;
            }
            if ((aclChecked = checkedAcls.get(acl)) == null) {
                try {
                    canRead = session.getAccessManager().canRead(null, (ItemId)new NodeId((String)acl));
                    checkedAcls.put((String)acl, canRead);
                }
                catch (RepositoryException repositoryException) {}
                break;
            }
            canRead = aclChecked;
            break;
        }
        return canRead;
    }

    public JahiaLuceneQueryFactoryImpl(SessionImpl session, SearchIndex index, Map<String, Value> bindVariables) throws RepositoryException {
        super(session, index, bindVariables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Row> execute(Map<String, PropertyValue> columns, Selector selector, Constraint constraint, Sort sort, boolean externalSort, long offsetIn, long limitIn) throws RepositoryException, IOException {
        IndexReader reader = this.index.getIndexReader(true);
        int offset = offsetIn < 0L ? 0 : (int)offsetIn;
        int limit = limitIn < 0L ? Integer.MAX_VALUE : (int)limitIn;
        QueryHits hits = null;
        try {
            JackrabbitIndexSearcher searcher = new JackrabbitIndexSearcher(this.session, reader, this.index.getContext().getItemStateManager());
            searcher.setSimilarity(this.index.getSimilarity());
            BooleanQuery query = new BooleanQuery();
            query.add(this.create(selector), BooleanClause.Occur.MUST);
            LuceneQueryFactory.QueryPair qp = new LuceneQueryFactory.QueryPair(query);
            Predicate filter = Predicate.TRUE;
            if (constraint != null) {
                String name = selector.getSelectorName();
                NodeType type = this.ntManager.getNodeType(selector.getNodeTypeName());
                filter = this.mapConstraintToQueryAndFilter(qp, constraint, Collections.singletonMap(name, type), searcher, reader);
            }
            HashSet<String> foundIds = new HashSet<String>();
            int hasFacets = FacetHandler.hasFacetFunctions(columns, this.session);
            CountHandler.CountType countType = CountHandler.hasCountFunction(columns, this.session);
            boolean isCount = countType != null;
            BitSet bitset = (hasFacets & 1) == 0 ? null : new BitSet();
            LinkedList<Row> rowList = externalSort ? new LinkedList<Row>() : null;
            LinkedHashMap<String, Object> rows = externalSort ? null : new LinkedHashMap<String, Object>();
            hits = searcher.evaluate(qp.mainQuery, sort, (long)offset + (long)limit);
            int currentNode = 0;
            int addedNodes = 0;
            int resultCount = 0;
            int hitsSize = 0;
            ScoreNode node = hits.nextScoreNode();
            HashMap<String, Boolean> checkedAcls = new HashMap<String, Boolean>();
            while (node != null) {
                if (isCount && countType.isApproxCount() && ++hitsSize > countType.getApproxCountLimit()) {
                    if (hits.getSize() > 0) {
                        hitsSize = hits.getSize();
                        break;
                    }
                    node = hits.nextScoreNode();
                    continue;
                }
                IndexedNodeInfo infos = this.getIndexedNodeInfo(node, reader, isCount && countType.isSkipChecks());
                if (foundIds.add(infos.getMainNodeUuid())) {
                    if (isCount && countType.isSkipChecks()) {
                        ++resultCount;
                    } else {
                        try {
                            boolean checkVisibility;
                            boolean canRead = true;
                            if (this.isAclUuidInIndex()) {
                                canRead = this.checkIndexedAcl(checkedAcls, infos.getAclUuid());
                            }
                            boolean bl = checkVisibility = "1".equals(infos.getCheckVisibility()) && "live".equals(this.session.getWorkspace().getName());
                            if (!(!canRead || "live".equals(this.session.getWorkspace().getName()) && (infos.getPublished() != null && !"true".equals(infos.getPublished()) || infos.getCheckInvalidLanguages() != null && this.getLocale() != null && infos.getCheckInvalidLanguages().contains(this.getLocale().toString())))) {
                                if (filter == Predicate.TRUE) {
                                    if ((hasFacets & 2) == 0) {
                                        LazySelectorRow row = null;
                                        if (checkVisibility || !this.isAclUuidInIndex()) {
                                            NodeImpl objectNode = this.getNodeWithAclAndVisibilityCheck(node, checkVisibility);
                                            if (isCount) {
                                                ++resultCount;
                                            } else {
                                                row = new LazySelectorRow(columns, this.evaluator, selector.getSelectorName(), (Node)objectNode, (double)node.getScore());
                                            }
                                        } else if (isCount) {
                                            ++resultCount;
                                        } else {
                                            row = new LazySelectorRow(columns, this.evaluator, selector.getSelectorName(), node.getNodeId(), (double)node.getScore());
                                        }
                                        if (row == null) continue;
                                        if (externalSort) {
                                            rowList.add((Row)row);
                                        } else {
                                            if (currentNode >= offset && currentNode - offset < limit) {
                                                rows.put(node.getNodeId().toString(), (Object)row);
                                                ++addedNodes;
                                            }
                                            ++currentNode;
                                            if (addedNodes == limit) break;
                                        }
                                    }
                                    if ((hasFacets & 1) == 1) {
                                        if (this.isAclUuidInIndex() && !checkVisibility) {
                                            bitset.set(infos.getDocNumber());
                                        } else {
                                            this.getNodeWithAclAndVisibilityCheck(node, checkVisibility);
                                            bitset.set(infos.getDocNumber());
                                        }
                                    }
                                } else {
                                    NodeImpl objectNode = this.session.getNodeById(node.getNodeId());
                                    if (objectNode.isNodeType("jnt:translation")) {
                                        objectNode = (NodeImpl)objectNode.getParent();
                                    }
                                    if (isCount) {
                                        ++resultCount;
                                    } else {
                                        SelectorRow row = new SelectorRow(columns, this.evaluator, selector.getSelectorName(), (Node)objectNode, (double)node.getScore());
                                        if (filter.evaluate((Object)row)) {
                                            if ((hasFacets & 2) == 0) {
                                                if (externalSort) {
                                                    rowList.add((Row)row);
                                                } else {
                                                    if (currentNode >= offset && currentNode - offset < limit) {
                                                        rows.put(node.getNodeId().toString(), row);
                                                        ++addedNodes;
                                                    }
                                                    ++currentNode;
                                                    if (addedNodes == limit) break;
                                                }
                                            }
                                            if ((hasFacets & 1) == 1) {
                                                bitset.set(infos.getDocNumber());
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        catch (ItemNotFoundException | PathNotFoundException canRead) {}
                    }
                } else if ((hasFacets & 2) == 0 && !isCount && !externalSort && !infos.getMainNodeUuid().equals(node.getNodeId().toString()) && rows.containsKey(infos.getMainNodeUuid())) {
                    rows.put(infos.getMainNodeUuid(), (Row)rows.remove(infos.getMainNodeUuid()));
                }
                node = hits.nextScoreNode();
            }
            if (rowList == null) {
                LinkedList<Object> linkedList = rowList = rows == null ? new LinkedList() : new LinkedList(rows.values());
            }
            if ((hasFacets & 1) == 1) {
                OpenBitSetDISI docIdSet = new OpenBitSetDISI(new DocIdBitSet(bitset).iterator(), bitset.size());
                FacetHandler h = new FacetHandler(columns, selector, (OpenBitSet)docIdSet, this.index, this.session, this.nsMappings);
                h.handleFacets(reader);
                rowList.add(0, h.getFacetsRow());
            } else if (isCount) {
                boolean wasApproxLimitReached = false;
                if (countType.isApproxCount() && hitsSize > countType.getApproxCountLimit()) {
                    resultCount = hitsSize * resultCount / countType.getApproxCountLimit();
                    resultCount = (int)Math.ceil(MathUtils.round((float)resultCount, (int)(resultCount < 1000 ? -1 : (resultCount < 10000 ? -2 : -3)), (int)0));
                    wasApproxLimitReached = true;
                }
                rowList.add(0, CountHandler.createCountRow(resultCount, wasApproxLimitReached));
            }
            LinkedList<Row> linkedList = rowList;
            return linkedList;
        }
        finally {
            if (hits != null) {
                hits.close();
            }
            Util.closeOrRelease((IndexReader)reader);
        }
    }

    private NodeImpl getNodeWithAclAndVisibilityCheck(ScoreNode node, boolean checkVisibility) throws RepositoryException {
        NodeImpl objectNode = this.session.getNodeById(node.getNodeId());
        if (objectNode.isNodeType("jnt:translation")) {
            objectNode = (NodeImpl)objectNode.getParent();
        }
        if (checkVisibility) {
            String nodePath = objectNode.getPath();
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession("live");
            if (session.itemExists(nodePath) && !VisibilityService.getInstance().matchesConditions(session.getNode(nodePath))) {
                throw new ItemNotFoundException(node.getNodeId().toString());
            }
        }
        return objectNode;
    }

    private boolean checkIndexedAcl(Map<String, Boolean> checkedAcls, String aclUuid) throws RepositoryException {
        return JahiaLuceneQueryFactoryImpl.checkIndexedAcl(checkedAcls, aclUuid, this.session);
    }

    public boolean isAclUuidInIndex() {
        return JahiaSearchIndex.isAclUuidInIndex(this.index);
    }

    private IndexedNodeInfo getIndexedNodeInfo(ScoreNode sn, IndexReader reader, boolean onlyMainNodeUuid) throws IOException {
        IndexedNodeInfo info = new IndexedNodeInfo(sn.getDoc(reader));
        FieldSelector fieldSelector = onlyMainNodeUuid ? ONLY_MAIN_NODE_UUID : OPTIMIZATION_FIELDS;
        Document doc = reader.document(info.getDocNumber(), fieldSelector);
        if (doc.getFieldable(JahiaNodeIndexer.TRANSLATED_NODE_PARENT) != null) {
            info.setMainNodeUuid(doc.getFieldable(FieldNames.PARENT).stringValue());
        } else {
            info.setMainNodeUuid(sn.getNodeId().toString());
        }
        if (!onlyMainNodeUuid) {
            Fieldable[] checkInvalidLanguagesField;
            Fieldable publishedField;
            Fieldable checkVisibilityField;
            Fieldable aclUuidField;
            if (this.isAclUuidInIndex() && (aclUuidField = doc.getFieldable(JahiaNodeIndexer.ACL_UUID)) != null) {
                info.setAclUuid(aclUuidField.stringValue());
            }
            if ((checkVisibilityField = doc.getFieldable(JahiaNodeIndexer.CHECK_VISIBILITY)) != null) {
                info.setCheckVisibility(checkVisibilityField.stringValue());
            }
            if ((publishedField = doc.getFieldable(JahiaNodeIndexer.PUBLISHED)) != null) {
                info.setPublished(publishedField.stringValue());
            }
            for (Fieldable field : checkInvalidLanguagesField = doc.getFieldables(JahiaNodeIndexer.INVALID_LANGUAGES)) {
                info.addInvalidLanguages(field.stringValue());
            }
        }
        return info;
    }

    protected Query getNodeIdQuery(String field, String path) throws RepositoryException {
        try {
            if (field.equals(FieldNames.PARENT)) {
                String identifier = this.session.getNode(path).getIdentifier();
                JackrabbitTermQuery q1 = new JackrabbitTermQuery(new Term(FieldNames.PARENT, identifier));
                JackrabbitTermQuery q2 = new JackrabbitTermQuery(new Term(JahiaNodeIndexer.TRANSLATED_NODE_PARENT, identifier));
                BooleanQuery or = new BooleanQuery();
                or.add((Query)q1, BooleanClause.Occur.SHOULD);
                or.add((Query)q2, BooleanClause.Occur.SHOULD);
                return or;
            }
            return super.getNodeIdQuery(field, path);
        }
        catch (AccessDeniedException | PathNotFoundException e) {
            return new JackrabbitTermQuery(new Term(FieldNames.UUID, "invalid-node-id"));
        }
    }

    protected Query create(Constraint constraint, Map<String, NodeType> selectorMap, JackrabbitIndexSearcher searcher) throws RepositoryException, IOException {
        if (constraint instanceof SameNode) {
            SameNode sn = (SameNode)constraint;
            if (this.locale != null) {
                String identifier = this.session.getNode(sn.getPath()).getIdentifier();
                JackrabbitTermQuery q1 = new JackrabbitTermQuery(new Term(FieldNames.UUID, identifier));
                JackrabbitTermQuery q2 = new JackrabbitTermQuery(new Term(FieldNames.PARENT, identifier));
                JackrabbitTermQuery q3 = new JackrabbitTermQuery(new Term(JahiaNodeIndexer.TRANSLATION_LANGUAGE, this.locale.toString()));
                BooleanQuery and = new BooleanQuery();
                and.add((Query)q2, BooleanClause.Occur.MUST);
                and.add((Query)q3, BooleanClause.Occur.MUST);
                BooleanQuery or = new BooleanQuery();
                or.add((Query)q1, BooleanClause.Occur.SHOULD);
                or.add((Query)and, BooleanClause.Occur.SHOULD);
                return or;
            }
            return this.getNodeIdQuery(FieldNames.UUID, sn.getPath());
        }
        return super.create(constraint, selectorMap, searcher);
    }

    protected Query getFullTextSearchQuery(FullTextSearch fts) throws RepositoryException {
        if (!StringUtils.startsWith((String)fts.getPropertyName(), (String)"rep:filter(")) {
            return super.getFullTextSearchQuery(fts);
        }
        StaticOperand expr = fts.getFullTextSearchExpression();
        if (expr instanceof Literal) {
            String expression = ((Literal)expr).getLiteralValue().getString();
            Query qobj = this.resolveSingleMixedInclusiveExclusiveRangeQuery(expression);
            if (qobj == null) {
                try {
                    JahiaQueryParser qp = new JahiaQueryParser(FieldNames.FULLTEXT, (Analyzer)new KeywordAnalyzer());
                    qp.setLowercaseExpandedTerms(false);
                    qobj = qp.parse(expression);
                }
                catch (ParseException e) {
                    throw new RepositoryException((Throwable)e);
                }
            }
            return qobj;
        }
        throw new RepositoryException("Unknown static operand type: " + expr);
    }

    private Query resolveSingleMixedInclusiveExclusiveRangeQuery(String expression) {
        boolean inclusiveEndRange = expression.endsWith("]");
        boolean exclusiveEndRange = expression.endsWith("}");
        int inclusiveBeginRangeCount = StringUtils.countMatches((String)expression, (String)"[");
        int exclusiveBeginRangeCount = StringUtils.countMatches((String)expression, (String)"{");
        if (inclusiveEndRange && exclusiveBeginRangeCount == 1 && inclusiveBeginRangeCount == 0 || exclusiveEndRange && inclusiveBeginRangeCount == 1 && exclusiveBeginRangeCount == 0) {
            String fieldName;
            String separator = inclusiveEndRange ? ":{" : ":[";
            String string = fieldName = inclusiveEndRange || exclusiveEndRange ? StringUtils.substringBefore((String)expression, (String)separator) : "";
            if (fieldName.indexOf(32) == -1) {
                fieldName = fieldName.replace("\\:", ":");
                String open = inclusiveEndRange ? "{" : "[";
                String close = inclusiveEndRange ? "]" : "}";
                String rangeExpression = StringUtils.substringBetween((String)expression, (String)open, (String)close);
                String part1 = StringUtils.substringBefore((String)rangeExpression, (String)" TO");
                String part2 = StringUtils.substringAfter((String)rangeExpression, (String)"TO ");
                SchemaField sf = new SchemaField(fieldName, (FieldType)JahiaQueryParser.STRING_TYPE);
                return JahiaQueryParser.STRING_TYPE.getRangeQuery(null, sf, part1.equals("*") ? null : part1, part2.equals("*") ? null : part2, !inclusiveEndRange, inclusiveEndRange);
            }
        }
        return null;
    }

    protected Predicate mapConstraintToQueryAndFilter(LuceneQueryFactory.QueryPair query, Constraint constraint, Map<String, NodeType> selectorMap, JackrabbitIndexSearcher searcher, IndexReader reader) throws RepositoryException, IOException {
        try {
            BooleanQuery context;
            if (constraint instanceof DescendantNode && !((DescendantNode)constraint).getAncestorPath().equals("/")) {
                Node parentNode = this.session.getNode(((DescendantNode)constraint).getAncestorPath()).getParent();
                Term term = new Term(JahiaNodeIndexer.TRANSLATED_NODE_PARENT, parentNode.getIdentifier());
                query.subQuery.add((Query)new TermQuery(term), BooleanClause.Occur.MUST_NOT);
            } else if (constraint instanceof ChildNode && !((ChildNode)constraint).getParentPath().equals("/")) {
                Node parentNode = this.session.getNode(((ChildNode)constraint).getParentPath()).getParent();
                Term term = new Term(JahiaNodeIndexer.TRANSLATED_NODE_PARENT, parentNode.getIdentifier());
                query.subQuery.add((Query)new TermQuery(term), BooleanClause.Occur.MUST_NOT);
            } else if (constraint instanceof Or && this.mapOrConstraintWithDescendantNodesOnly(context = new BooleanQuery(), constraint)) {
                query.mainQuery = new DescendantSelfAxisQuery((Query)context, (Query)query.subQuery, false);
                return Predicate.TRUE;
            }
        }
        catch (AccessDeniedException context) {
        }
        catch (PathNotFoundException e) {
            Term term = new Term(FieldNames.UUID, "invalid-node-id");
            query.subQuery.add((Query)new JackrabbitTermQuery(term), BooleanClause.Occur.MUST);
        }
        return super.mapConstraintToQueryAndFilter(query, constraint, selectorMap, searcher, reader);
    }

    public boolean mapOrConstraintWithDescendantNodesOnly(BooleanQuery context, Constraint constraint) throws RepositoryException {
        if (constraint instanceof Or) {
            Or or = (Or)constraint;
            return this.mapOrConstraintWithDescendantNodesOnly(context, or.getConstraint1()) && this.mapOrConstraintWithDescendantNodesOnly(context, or.getConstraint2());
        }
        if (constraint instanceof DescendantNode) {
            DescendantNode descendantNode = (DescendantNode)constraint;
            context.add(this.getNodeIdQuery(FieldNames.UUID, descendantNode.getAncestorPath()), BooleanClause.Occur.SHOULD);
            return true;
        }
        return false;
    }

    public Locale getLocale() {
        if (this.queryLanguage != null) {
            return LanguageCodeConverters.languageCodeToLocale(this.queryLanguage);
        }
        return this.locale;
    }

    public void setQueryLanguageAndLocale(String queryLanguage, Locale locale) {
        this.queryLanguage = queryLanguage;
        this.locale = locale;
    }

    protected Query getComparisonQuery(DynamicOperand left, int transform, String operator, StaticOperand rigth, Map<String, NodeType> selectorMap) throws RepositoryException {
        if (left instanceof PropertyValue) {
            String propertyName = ((PropertyValue)left).getPropertyName();
            if (propertyName.equals("_PARENT")) {
                String valueString = this.getValueString(this.evaluator.getValue(rigth), 9);
                return new JackrabbitTermQuery(new Term(FieldNames.PARENT, valueString));
            }
            if (propertyName.equals("jcr:primaryType") || propertyName.equals("jcr:mixinTypes")) {
                String field = this.npResolver.getJCRName(this.session.getQName(propertyName));
                return this.getPropertyValueQuery(field, operator, this.evaluator.getValue(rigth), 7, transform);
            }
        }
        return super.getComparisonQuery(left, transform, operator, rigth, selectorMap);
    }

    protected Analyzer getTextAnalyzer() {
        Analyzer analyzer;
        String lang;
        AnalyzerRegistry analyzerRegistry;
        if ((this.locale != null || this.queryLanguage != null) && (analyzerRegistry = this.index.getAnalyzerRegistry()).acceptKey((Object)(lang = this.getLocale().toString())) && (analyzer = analyzerRegistry.getAnalyzer((Object)lang)) != null) {
            return analyzer;
        }
        return super.getTextAnalyzer();
    }

    public NamespaceMappings getNamespaceMappings() {
        return this.nsMappings;
    }

    class LazySelectorRow
    extends SelectorRow {
        private Node node;
        private NodeId nodeId;

        LazySelectorRow(Map<String, PropertyValue> columns, OperandEvaluator evaluator, String selector, NodeId nodeId, double score) {
            super(columns, evaluator, selector, null, score);
            this.nodeId = nodeId;
        }

        LazySelectorRow(Map<String, PropertyValue> columns, OperandEvaluator evaluator, String selector, Node node, double score) {
            super(columns, evaluator, selector, node, score);
            this.node = node;
        }

        public Node getNode() {
            if (this.node != null) {
                return this.node;
            }
            try {
                NodeImpl originalNode = JahiaLuceneQueryFactoryImpl.this.session.getNodeById(this.nodeId);
                if (originalNode.isNodeType("jnt:translation")) {
                    originalNode = originalNode.getParent();
                }
                if (originalNode != null) {
                    this.node = originalNode;
                }
            }
            catch (ItemNotFoundException | PathNotFoundException originalNode) {
            }
            catch (RepositoryException e) {
                logger.error("Cannot get node " + this.nodeId, (Throwable)e);
            }
            return this.node;
        }

        public Node getNode(String selectorName) throws RepositoryException {
            super.getNode(selectorName);
            return this.getNode();
        }
    }

    class IndexedNodeInfo {
        private int docNumber;
        private String mainNodeUuid;
        private String aclUuid;
        private String checkVisibility;
        private String published;
        private List<String> checkInvalidLanguages = null;

        public IndexedNodeInfo(int docNumber) {
            this.docNumber = docNumber;
        }

        public String getMainNodeUuid() {
            return this.mainNodeUuid;
        }

        public void setMainNodeUuid(String mainNodeUuid) {
            this.mainNodeUuid = mainNodeUuid;
        }

        public String getAclUuid() {
            return this.aclUuid;
        }

        public void setAclUuid(String aclUuid) {
            this.aclUuid = aclUuid;
        }

        public String getCheckVisibility() {
            return this.checkVisibility;
        }

        public void setCheckVisibility(String checkVisibility) {
            this.checkVisibility = checkVisibility;
        }

        public String getPublished() {
            return this.published;
        }

        public void setPublished(String published) {
            this.published = published;
        }

        public int getDocNumber() {
            return this.docNumber;
        }

        public List<String> getCheckInvalidLanguages() {
            return this.checkInvalidLanguages;
        }

        public void addInvalidLanguages(String invalidLanguage) {
            if (this.checkInvalidLanguages == null) {
                this.checkInvalidLanguages = new ArrayList<String>();
            }
            this.checkInvalidLanguages.add(invalidLanguage);
        }
    }
}

