/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ISMLocking;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.data.core.TransactionContext;

@Deprecated(since="8.0.0.0", forRemoval=true)
public class JahiaFineGrainedISMLocking
implements ISMLocking {
    private static final Integer ONE = new Integer(1);
    private final ISMLocking.ReadLock anonymousReadLock = new ReadLockImpl();
    private WriteLockImpl activeWriter;
    private volatile Object activeWriterId;
    private ReadWriteLock writerStateRWLock = new ReentrantReadWriteLock(true);
    private final LockMap readLockMap = new LockMap();
    private final AtomicInteger readerCount = new AtomicInteger(0);
    private List<CountDownLatch> waitingReaders = Collections.synchronizedList(new LinkedList());
    private List<CountDownLatch> waitingWriters = new LinkedList<CountDownLatch>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISMLocking.ReadLock acquireReadLock(ItemId id) throws InterruptedException {
        if (TransactionContext.isSameThreadId((Object)this.activeWriterId, (Object)TransactionContext.getCurrentThreadId())) {
            this.readerCount.incrementAndGet();
            this.readLockMap.addLock(id);
            return new ReadLockImpl(id);
        }
        while (true) {
            CountDownLatch signal;
            Lock shared = this.writerStateRWLock.readLock();
            shared.lock();
            try {
                if (this.activeWriter == null || !JahiaFineGrainedISMLocking.hasDependency(this.activeWriter.changes, id)) {
                    this.readerCount.incrementAndGet();
                    this.readLockMap.addLock(id);
                    ReadLockImpl readLockImpl = new ReadLockImpl(id);
                    return readLockImpl;
                }
                signal = new CountDownLatch(1);
                this.waitingReaders.add(signal);
            }
            finally {
                shared.unlock();
            }
            signal.await();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISMLocking.WriteLock acquireWriteLock(ChangeLog changeLog) throws InterruptedException {
        while (true) {
            CountDownLatch signal;
            Lock exclusive = this.writerStateRWLock.writeLock();
            exclusive.lock();
            try {
                if (this.activeWriter == null && !this.readLockMap.hasDependency(changeLog)) {
                    this.activeWriter = new WriteLockImpl(changeLog);
                    this.activeWriterId = TransactionContext.getCurrentThreadId();
                    WriteLockImpl writeLockImpl = this.activeWriter;
                    return writeLockImpl;
                }
                signal = new CountDownLatch(1);
                this.waitingWriters.add(signal);
            }
            finally {
                exclusive.unlock();
            }
            signal.await();
        }
    }

    private static boolean hasDependency(ChangeLog changeLog, ItemId id) {
        try {
            if (!(changeLog.get(id) != null || id.denotesNode() && changeLog.getReferencesTo((NodeId)id) != null)) {
                return false;
            }
        }
        catch (NoSuchItemStateException noSuchItemStateException) {
            // empty catch block
        }
        return true;
    }

    private void notifyWaitingReaders() {
        Iterator<CountDownLatch> it = this.waitingReaders.iterator();
        while (it.hasNext()) {
            it.next().countDown();
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWaitingWriters() {
        List<CountDownLatch> list = this.waitingWriters;
        synchronized (list) {
            if (this.waitingWriters.isEmpty()) {
                return;
            }
            Iterator<CountDownLatch> it = this.waitingWriters.iterator();
            while (it.hasNext()) {
                it.next().countDown();
                it.remove();
            }
        }
    }

    private static final class LockMap {
        private final Map<ItemId, Integer>[] slots = new Map[16];
        private volatile boolean global = false;

        public LockMap() {
            for (int i = 0; i < this.slots.length; ++i) {
                this.slots[i] = new HashMap<ItemId, Integer>();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLock(ItemId id) {
            Map<ItemId, Integer> locks;
            if (id == null) {
                if (this.global) {
                    throw new IllegalStateException("Map already globally locked");
                }
                this.global = true;
                return;
            }
            Map<ItemId, Integer> map = locks = this.slots[LockMap.slotIndex(id)];
            synchronized (map) {
                Integer i = locks.get(id);
                i = i == null ? ONE : new Integer(i + 1);
                locks.put(id, i);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeLock(ItemId id) {
            Map<ItemId, Integer> locks;
            if (id == null) {
                if (!this.global) {
                    throw new IllegalStateException("Map not globally locked");
                }
                this.global = false;
                return;
            }
            Map<ItemId, Integer> map = locks = this.slots[LockMap.slotIndex(id)];
            synchronized (map) {
                Integer i = locks.get(id);
                if (i != null) {
                    if (i == 1) {
                        locks.remove(id);
                    } else {
                        locks.put(id, new Integer(i - 1));
                    }
                } else {
                    throw new IllegalStateException("No lock present for id: " + id);
                }
            }
        }

        public boolean hasDependency(ChangeLog changes) {
            if (this.global) {
                return true;
            }
            for (int i = 0; i < this.slots.length; ++i) {
                Map<ItemId, Integer> locks = this.slots[i];
                for (ItemId id : locks.keySet()) {
                    if (!JahiaFineGrainedISMLocking.hasDependency(changes, id)) continue;
                    return true;
                }
            }
            return false;
        }

        private static int slotIndex(ItemId id) {
            NodeId nodeId = id.denotesNode() ? (NodeId)id : ((PropertyId)id).getParentId();
            return (int)nodeId.getLeastSignificantBits() & 0xF;
        }
    }

    private final class ReadLockImpl
    implements ISMLocking.ReadLock {
        private final ItemId id;

        public ReadLockImpl() {
            this(null);
        }

        ReadLockImpl(ItemId id) {
            this.id = id;
        }

        public void release() {
            Lock shared = JahiaFineGrainedISMLocking.this.writerStateRWLock.readLock();
            shared.lock();
            try {
                JahiaFineGrainedISMLocking.this.readLockMap.removeLock(this.id);
                if (JahiaFineGrainedISMLocking.this.readerCount.decrementAndGet() == 0 && JahiaFineGrainedISMLocking.this.activeWriter == null) {
                    JahiaFineGrainedISMLocking.this.activeWriterId = null;
                }
                if (!TransactionContext.isSameThreadId((Object)JahiaFineGrainedISMLocking.this.activeWriterId, (Object)TransactionContext.getCurrentThreadId())) {
                    JahiaFineGrainedISMLocking.this.notifyWaitingWriters();
                }
            }
            finally {
                shared.unlock();
            }
        }
    }

    private final class WriteLockImpl
    implements ISMLocking.WriteLock {
        private final ChangeLog changes;

        WriteLockImpl(ChangeLog changes) {
            this.changes = changes;
        }

        public void release() {
            Lock exclusive = JahiaFineGrainedISMLocking.this.writerStateRWLock.writeLock();
            exclusive.lock();
            try {
                JahiaFineGrainedISMLocking.this.activeWriter = null;
                JahiaFineGrainedISMLocking.this.activeWriterId = null;
                JahiaFineGrainedISMLocking.this.notifyWaitingReaders();
                JahiaFineGrainedISMLocking.this.notifyWaitingWriters();
            }
            finally {
                exclusive.unlock();
            }
        }

        public ISMLocking.ReadLock downgrade() {
            JahiaFineGrainedISMLocking.this.readerCount.incrementAndGet();
            JahiaFineGrainedISMLocking.this.readLockMap.addLock(null);
            Lock exclusive = JahiaFineGrainedISMLocking.this.writerStateRWLock.writeLock();
            exclusive.lock();
            try {
                JahiaFineGrainedISMLocking.this.activeWriter = null;
                JahiaFineGrainedISMLocking.this.notifyWaitingReaders();
            }
            finally {
                exclusive.unlock();
            }
            return JahiaFineGrainedISMLocking.this.anonymousReadLock;
        }
    }
}

