/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.commons.server;

import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RPC;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JahiaRPC {
    private static final Logger logger = LoggerFactory.getLogger(JahiaRPC.class);

    static String invokeAndEncodeResponse(Object target, Method serviceMethod, Object[] args, SerializationPolicy serializationPolicy) throws SerializationException {
        return JahiaRPC.invokeAndEncodeResponse(target, serviceMethod, args, serializationPolicy, 0);
    }

    private static String invokeAndEncodeResponse(Object target, Method serviceMethod, Object[] args, SerializationPolicy serializationPolicy, int flags) throws SerializationException {
        String responsePayload;
        if (serviceMethod == null) {
            throw new NullPointerException("serviceMethod");
        }
        if (serializationPolicy == null) {
            throw new NullPointerException("serializationPolicy");
        }
        try {
            Object result = serviceMethod.invoke(target, args);
            responsePayload = RPC.encodeResponseForSuccess((Method)serviceMethod, (Object)result, (SerializationPolicy)serializationPolicy, (int)flags);
        }
        catch (IllegalAccessException e) {
            SecurityException securityException = new SecurityException(JahiaRPC.formatIllegalAccessErrorMessage(target, serviceMethod));
            securityException.initCause(e);
            throw securityException;
        }
        catch (IllegalArgumentException e) {
            SecurityException securityException = new SecurityException(JahiaRPC.formatIllegalArgumentErrorMessage(target, serviceMethod, args));
            securityException.initCause(e);
            throw securityException;
        }
        catch (InvocationTargetException e) {
            JahiaRPC.onError(serviceMethod, e);
            Throwable cause = e.getCause();
            responsePayload = RPC.encodeResponseForFailure((Method)serviceMethod, (Throwable)cause, (SerializationPolicy)serializationPolicy, (int)flags);
        }
        return responsePayload;
    }

    private static String formatIllegalAccessErrorMessage(Object target, Method serviceMethod) {
        StringBuffer sb = new StringBuffer();
        sb.append("Blocked attempt to access inaccessible method '");
        sb.append(JahiaRPC.getSourceRepresentation(serviceMethod));
        sb.append("'");
        if (target != null) {
            sb.append(" on target '");
            sb.append(JahiaRPC.printTypeName(target.getClass()));
            sb.append("'");
        }
        sb.append("; this is either misconfiguration or a hack attempt");
        return sb.toString();
    }

    private static String formatIllegalArgumentErrorMessage(Object target, Method serviceMethod, Object[] args) {
        StringBuffer sb = new StringBuffer();
        sb.append("Blocked attempt to invoke method '");
        sb.append(JahiaRPC.getSourceRepresentation(serviceMethod));
        sb.append("'");
        if (target != null) {
            sb.append(" on target '");
            sb.append(JahiaRPC.printTypeName(target.getClass()));
            sb.append("'");
        }
        sb.append(" with invalid arguments");
        if (args != null && args.length > 0) {
            sb.append(Arrays.asList(args));
        }
        return sb.toString();
    }

    private static String getSourceRepresentation(Method method) {
        return method.toString().replace('$', '.');
    }

    private static void onError(Method serviceMethod, InvocationTargetException e) {
        Throwable cause = e;
        if (e.getCause() != null) {
            cause = e.getCause();
        }
        logger.error("An error occurred calling the GWT service method " + serviceMethod + ". Cause: " + cause.getMessage(), cause);
    }

    private static String printTypeName(Class<?> type) {
        if (type.equals(Integer.TYPE)) {
            return "int";
        }
        if (type.equals(Long.TYPE)) {
            return "long";
        }
        if (type.equals(Short.TYPE)) {
            return "short";
        }
        if (type.equals(Byte.TYPE)) {
            return "byte";
        }
        if (type.equals(Character.TYPE)) {
            return "char";
        }
        if (type.equals(Boolean.TYPE)) {
            return "boolean";
        }
        if (type.equals(Float.TYPE)) {
            return "float";
        }
        if (type.equals(Double.TYPE)) {
            return "double";
        }
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            return JahiaRPC.printTypeName(componentType) + "[]";
        }
        return type.getName().replace('$', '.');
    }

    private JahiaRPC() {
    }
}

