/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.content.server;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.Binary;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.value.BinaryImpl;
import org.jahia.ajax.gwt.content.server.UploadedPendingFile;
import org.jahia.bin.SessionNamedDataStorageSupport;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.utils.JcrUtils;

public class UploadedPendingFileStorageJcr
extends SessionNamedDataStorageSupport<UploadedPendingFile> {
    private String jcrFolderName;

    public void setJcrFolderName(String jcrFolderName) {
        this.jcrFolderName = jcrFolderName;
    }

    @Override
    public void put(String sessionID, String name, final UploadedPendingFile file) {
        final String finalSessionID = Text.escapeIllegalJcrChars((String)sessionID);
        final String finalName = Text.escapeIllegalJcrChars((String)name);
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void doInJCR(JCRSessionWrapper jcrSession) throws RepositoryException {
                    BinaryImpl contentBinary;
                    JCRNodeWrapper pendingFiles = JcrUtils.getNodeCreateIfNeeded(jcrSession.getRootNode(), UploadedPendingFileStorageJcr.this.jcrFolderName, "jnt:tempFolder");
                    JCRNodeWrapper sessionPendingFiles = JcrUtils.getNodeCreateIfNeeded(pendingFiles, finalSessionID, "jnt:tempFolder");
                    if (sessionPendingFiles.hasNode(finalName)) {
                        sessionPendingFiles.getNode(finalName).remove();
                    }
                    JCRNodeWrapper fileNode = sessionPendingFiles.addNode(finalName, "jnt:tempFile");
                    fileNode.setProperty("jcr:mimeType", file.getContentType());
                    try {
                        contentBinary = new BinaryImpl(file.getContentStream());
                    }
                    catch (IOException e) {
                        throw new JahiaRuntimeException(e);
                    }
                    try {
                        fileNode.setProperty("jcr:data", (Binary)contentBinary);
                    }
                    finally {
                        contentBinary.dispose();
                    }
                    jcrSession.save();
                    return null;
                }
            });
        }
        catch (RepositoryException e) {
            throw new JahiaRuntimeException(e);
        }
    }

    @Override
    public UploadedPendingFile get(String sessionID, String name) {
        try {
            return this.retrieve(sessionID, name);
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (RepositoryException e) {
            throw new JahiaRuntimeException(e);
        }
    }

    @Override
    public UploadedPendingFile getRequired(String sessionID, String name) {
        try {
            return this.retrieve(sessionID, name);
        }
        catch (RepositoryException e) {
            throw new JahiaRuntimeException(e);
        }
    }

    @Override
    public void remove(String sessionID, String name) {
        final String finalSessionID = Text.escapeIllegalJcrChars((String)sessionID);
        final String finalName = Text.escapeIllegalJcrChars((String)name);
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Void>(){

                @Override
                public Void doInJCR(JCRSessionWrapper jcrSession) throws RepositoryException {
                    jcrSession.removeItem(UploadedPendingFileStorageJcr.getPathString(UploadedPendingFileStorageJcr.this.jcrFolderName, finalSessionID, finalName));
                    jcrSession.save();
                    return null;
                }
            });
        }
        catch (RepositoryException e) {
            throw new JahiaRuntimeException(e);
        }
    }

    @Override
    public void removeIfExists(String sessionID) {
        final String finalSessionID = Text.escapeIllegalJcrChars((String)sessionID);
        try {
            JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<Void>(){

                @Override
                public Void doInJCR(JCRSessionWrapper jcrSession) throws RepositoryException {
                    jcrSession.removeItem(UploadedPendingFileStorageJcr.getPathString(UploadedPendingFileStorageJcr.this.jcrFolderName, finalSessionID));
                    jcrSession.save();
                    return null;
                }
            });
        }
        catch (PathNotFoundException pathNotFoundException) {
        }
        catch (RepositoryException e) {
            throw new JahiaRuntimeException(e);
        }
    }

    private static String getPathString(String ... pathElements) {
        return "/" + StringUtils.join((Object[])pathElements, (char)'/');
    }

    private UploadedPendingFile retrieve(String sessionID, String name) throws RepositoryException {
        final String finalSessionID = Text.escapeIllegalJcrChars((String)sessionID);
        final String finalName = Text.escapeIllegalJcrChars((String)name);
        return JCRTemplate.getInstance().doExecuteWithSystemSession(new JCRCallback<UploadedPendingFile>(){

            @Override
            public UploadedPendingFile doInJCR(JCRSessionWrapper jcrSession) throws RepositoryException {
                JCRNodeWrapper fileNode = jcrSession.getNode(UploadedPendingFileStorageJcr.getPathString(UploadedPendingFileStorageJcr.this.jcrFolderName, finalSessionID, finalName));
                final Binary contentBinary = fileNode.getProperty("jcr:data").getBinary();
                final String contentType = fileNode.getPropertyAsString("jcr:mimeType");
                return new UploadedPendingFile(){

                    @Override
                    public String getContentType() {
                        return contentType;
                    }

                    @Override
                    public InputStream getContentStream() {
                        try {
                            return contentBinary.getStream();
                        }
                        catch (RepositoryException e) {
                            throw new JahiaRuntimeException(e);
                        }
                    }

                    @Override
                    public void close() {
                        contentBinary.dispose();
                    }
                };
            }
        });
    }
}

