/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.helper;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.ajax.gwt.client.data.GWTJahiaValueDisplayBean;
import org.jahia.ajax.gwt.client.data.GWTResourceBundle;
import org.jahia.ajax.gwt.client.data.GWTResourceBundleEntry;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.service.GWTJahiaServiceException;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.utils.LanguageCodeConverters;
import org.jahia.utils.Patterns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GWTResourceBundleUtils {
    private static Logger logger = LoggerFactory.getLogger(GWTResourceBundleUtils.class);

    private static String getAsString(String lang, GWTResourceBundle bundle) {
        StringBuilder out = new StringBuilder(512);
        for (GWTResourceBundleEntry entry : bundle.getEntries()) {
            String value = entry.getValue(lang);
            if (StringUtils.isEmpty((String)value)) continue;
            out.append(entry.getKey()).append("=").append(EscapeUtils.convertUnicodeToEncoded(value)).append("\n");
        }
        return out.toString();
    }

    private static String getLanguageCode(String resourceBundleFileName) {
        String name = StringUtils.substringBeforeLast((String)resourceBundleFileName, (String)".properties");
        Object lang = "<default>";
        if (name.contains("_")) {
            String[] parts = Patterns.UNDERSCORE.split(name);
            int l = parts.length;
            if (l == 2) {
                lang = parts[1];
            } else if (l == 3) {
                lang = parts[1] + "_" + parts[2];
            } else if (l >= 4) {
                lang = parts[l - 3] + "_" + parts[l - 2] + "_" + parts[l - 1];
            }
        }
        return lang;
    }

    private static boolean isValidKey(String key) {
        return key != null && key.length() > 0 && key.indexOf(60) == -1 && key.indexOf(61) == -1 && key.indexOf(62) == -1;
    }

    public static GWTResourceBundle load(JCRNodeWrapper node, Locale uiLocale) {
        GWTResourceBundle gwtBundle = null;
        long timer = System.currentTimeMillis();
        try {
            boolean isFile = false;
            isFile = node.isNodeType("jnt:resourceBundleFile");
            if (!isFile && !node.isNodeType("jnt:resourceBundleFolder")) {
                return null;
            }
            gwtBundle = new GWTResourceBundle();
            HashSet<String> languages = new HashSet<String>();
            List<JCRNodeWrapper> rbFileNodes = JCRContentUtils.getChildrenOfType(isFile ? node.getParent() : node, "jnt:resourceBundleFile");
            for (JCRNodeWrapper rbFileNode : rbFileNodes) {
                GWTResourceBundleUtils.populate(gwtBundle, rbFileNode, languages);
            }
            for (GWTResourceBundleEntry entry : gwtBundle.getEntryMap().values()) {
                for (String l : languages) {
                    if (entry.getValues().get(l) != null) continue;
                    entry.setValue(l, null);
                }
            }
            if (gwtBundle.getEntries().isEmpty()) {
                gwtBundle.setName(node.getResolveSite().getTemplatePackage().getId());
                gwtBundle.setValue("<empty>", "<default>", null);
            }
            ArrayList<GWTJahiaValueDisplayBean> availableLocales = new ArrayList<GWTJahiaValueDisplayBean>();
            for (Locale l : LanguageCodeConverters.getSortedLocaleList(uiLocale)) {
                availableLocales.add(new GWTJahiaValueDisplayBean(l.toString(), StringUtils.capitalize((String)l.getDisplayName(uiLocale))));
            }
            gwtBundle.setAvailableLanguages(availableLocales);
            if (logger.isDebugEnabled()) {
                logger.debug("Loaded resource bundle for node {} in {} ms", (Object)node.getPath(), (Object)(System.currentTimeMillis() - timer));
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return gwtBundle;
    }

    public static void lock(JCRNodeWrapper node) {
        try {
            boolean isFile = false;
            isFile = node.isNodeType("jnt:resourceBundleFile");
            if (!isFile && !node.isNodeType("jnt:resourceBundleFolder")) {
                return;
            }
            JCRNodeWrapper parent = isFile ? node.getParent() : node;
            List<JCRNodeWrapper> rbFileNodes = JCRContentUtils.getChildrenOfType(parent, "jnt:resourceBundleFile");
            for (JCRNodeWrapper rbFileNode : rbFileNodes) {
                rbFileNode.lockAndStoreToken("engine");
            }
            parent.lockAndStoreToken("engine");
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void populate(GWTResourceBundle gwtBundle, JCRNodeWrapper node, Set<String> languages) {
        String name = StringUtils.substringBeforeLast((String)node.getName(), (String)".properties");
        String lang = "<default>";
        if (name.contains("_")) {
            lang = GWTResourceBundleUtils.getLanguageCode(name);
            if (gwtBundle.getName() == null) {
                name = StringUtils.substringBeforeLast((String)StringUtils.substringBeforeLast((String)name, (String)lang), (String)"_");
            }
        }
        if (gwtBundle.getName() == null) {
            gwtBundle.setName(name);
        }
        languages.add(lang);
        InputStream is = null;
        try {
            is = node.getFileContent().downloadFile();
            Properties p = new Properties();
            p.load(is);
            for (Object keyObj : p.keySet()) {
                String key = keyObj.toString();
                if (!GWTResourceBundleUtils.isValidKey(key)) continue;
                gwtBundle.setValue(key, lang, p.getProperty(key));
            }
        }
        catch (IOException e) {
            logger.error("Error reading content of the " + node.getPath() + " node as a properties file. Cause: " + e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public static boolean store(GWTJahiaNode gwtNode, GWTResourceBundle bundle, JCRSessionWrapper session) throws GWTJahiaServiceException {
        boolean needPermissionReload = false;
        try {
            JCRNodeWrapper node = session.getNode(gwtNode.isFile() != false ? StringUtils.substringBeforeLast((String)gwtNode.getPath(), (String)"/") : gwtNode.getPath());
            HashMap<String, JCRNodeWrapper> nodesByLanguage = new HashMap<String, JCRNodeWrapper>();
            for (JCRNodeWrapper rbFileNode : JCRContentUtils.getChildrenOfType(node, "jnt:propertiesFile")) {
                nodesByLanguage.put(GWTResourceBundleUtils.getLanguageCode(rbFileNode.getName()), rbFileNode);
            }
            for (String lang : bundle.getLanguages()) {
                ByteArrayInputStream is;
                block10: {
                    JCRNodeWrapper current = (JCRNodeWrapper)nodesByLanguage.remove(lang);
                    is = null;
                    try {
                        is = new ByteArrayInputStream(GWTResourceBundleUtils.getAsString(lang, bundle).getBytes("ISO-8859-1"));
                        if (current == null) {
                            logger.debug("Processing new resource bundle for language '{}'", (Object)lang);
                            String bundleName = StringUtils.equals((String)lang, (String)"<default>") ? bundle.getName() + ".properties" : bundle.getName() + "_" + lang + ".properties";
                            node.uploadFile(bundleName, is, "text/plain");
                            break block10;
                        }
                        logger.debug("Processing resource bundle {} for language '{}'", (Object)current.getPath(), (Object)lang);
                        current.getFileContent().uploadFile(is, "text/plain");
                    }
                    catch (UnsupportedEncodingException e) {
                        try {
                            throw new IllegalArgumentException(e.getMessage(), e);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(is);
                            throw throwable;
                        }
                    }
                }
                IOUtils.closeQuietly((InputStream)is);
            }
            for (JCRNodeWrapper toDelete : nodesByLanguage.values()) {
                logger.debug("Removing resource bundle node {}", (Object)toDelete.getPath());
                toDelete.remove();
            }
            ResourceBundle.clearCache();
            NodeTypeRegistry.getInstance().flushLabels();
            needPermissionReload = !node.getResolveSite().getLanguages().containsAll(bundle.getLanguages());
            node.getResolveSite().setLanguages(bundle.getLanguages());
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException(e.getMessage());
        }
        return needPermissionReload;
    }

    public static void unlock(JCRNodeWrapper node) {
        try {
            boolean isFile = false;
            isFile = node.isNodeType("jnt:resourceBundleFile");
            if (!isFile && !node.isNodeType("jnt:resourceBundleFolder")) {
                return;
            }
            JCRNodeWrapper parent = isFile ? node.getParent() : node;
            List<JCRNodeWrapper> rbFileNodes = JCRContentUtils.getChildrenOfType(parent, "jnt:resourceBundleFile");
            for (JCRNodeWrapper rbFileNode : rbFileNodes) {
                if (!rbFileNode.isLocked()) continue;
                rbFileNode.unlock("engine");
            }
            if (parent.isLocked()) {
                parent.unlock("engine");
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private GWTResourceBundleUtils() {
    }

    private static final class EscapeUtils {
        private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

        private EscapeUtils() {
        }

        static String convertUnicodeToEncoded(String str) {
            int len = str.length();
            StringBuilder outBuffer = new StringBuilder(len * 2);
            for (int x = 0; x < len; ++x) {
                char aChar = str.charAt(x);
                if (aChar < ' ' || aChar > '~') {
                    outBuffer.append('\\');
                    outBuffer.append('u');
                    outBuffer.append(EscapeUtils.toHex(aChar >> 12 & 0xF));
                    outBuffer.append(EscapeUtils.toHex(aChar >> 8 & 0xF));
                    outBuffer.append(EscapeUtils.toHex(aChar >> 4 & 0xF));
                    outBuffer.append(EscapeUtils.toHex(aChar & 0xF));
                    continue;
                }
                outBuffer.append(aChar);
            }
            return outBuffer.toString();
        }

        private static char toHex(int nibble) {
            char hexChar = HEX_DIGITS[nibble & 0xF];
            return Character.toLowerCase(hexChar);
        }
    }
}

