/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.helper;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.jahia.ajax.gwt.client.service.GWTJahiaServiceException;
import org.jahia.ajax.gwt.client.service.content.ExistingFileException;
import org.jahia.ajax.gwt.helper.ContentManagerHelper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.image.Image;
import org.jahia.services.image.JahiaImageService;
import org.jahia.utils.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageHelper {
    private static final transient Logger logger = LoggerFactory.getLogger(ImageHelper.class);
    private ContentManagerHelper contentManager;
    private JahiaImageService imageService;

    public void setContentManager(ContentManagerHelper contentManager) {
        this.contentManager = contentManager;
    }

    public void setImageService(JahiaImageService imageService) {
        this.imageService = imageService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void crop(String path, String target, int top, int left, int width, int height, boolean forceReplace, JCRSessionWrapper session, Locale uiLocale) throws GWTJahiaServiceException {
        try {
            JCRNodeWrapper node = session.getNode(path);
            if (this.contentManager.checkExistence(node.getPath().replace(node.getName(), target), session, uiLocale) && !forceReplace) {
                throw new ExistingFileException("The file " + target + " already exists.");
            }
            Image image = this.imageService.getImage(node);
            Object fileExtension = FilenameUtils.getExtension((String)node.getName());
            fileExtension = fileExtension != null && !"".equals(fileExtension) ? (String)fileExtension + "." + (String)fileExtension : null;
            File f = File.createTempFile("image", (String)fileExtension);
            this.imageService.cropImage(image, f, top, left, width, height);
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(f));
            try {
                node.getParent().uploadFile(target, fis, node.getFileContent().getContentType());
                session.save();
            }
            finally {
                IOUtils.closeQuietly((InputStream)fis);
                f.delete();
            }
        }
        catch (ExistingFileException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.crop.image", uiLocale, e.getLocalizedMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeImage(String path, String target, int width, int height, boolean forceReplace, JCRSessionWrapper session, Locale uiLocale) throws GWTJahiaServiceException {
        try {
            JCRNodeWrapper node = session.getNode(path);
            if (this.contentManager.checkExistence(node.getPath().replace(node.getName(), target), session, uiLocale) && !forceReplace) {
                throw new ExistingFileException(Messages.getInternalWithArguments("file.already.exists", uiLocale, target));
            }
            Image image = this.imageService.getImage(node);
            Object fileExtension = FilenameUtils.getExtension((String)node.getName());
            fileExtension = fileExtension != null && !"".equals(fileExtension) ? (String)fileExtension + "." + (String)fileExtension : null;
            File f = File.createTempFile("image", (String)fileExtension);
            this.imageService.resizeImage(image, f, width, height, JahiaImageService.ResizeType.SCALE_TO_FILL);
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(f));
            try {
                node.getParent().uploadFile(target, fis, node.getFileContent().getContentType());
                session.save();
            }
            finally {
                IOUtils.closeQuietly((InputStream)fis);
                f.delete();
            }
        }
        catch (ExistingFileException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.resize.image", uiLocale, e.getLocalizedMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rotateImage(String path, String target, boolean clockwise, boolean forceReplace, JCRSessionWrapper session, Locale uiLocale) throws GWTJahiaServiceException {
        try {
            JCRNodeWrapper node = session.getNode(path);
            if (this.contentManager.checkExistence(node.getPath().replace(node.getName(), target), session, uiLocale) && !forceReplace) {
                throw new ExistingFileException(Messages.getInternalWithArguments("file.already.exists", uiLocale, target));
            }
            Image image = this.imageService.getImage(node);
            Object fileExtension = FilenameUtils.getExtension((String)node.getName());
            fileExtension = fileExtension != null && !"".equals(fileExtension) ? (String)fileExtension + "." + (String)fileExtension : null;
            File f = File.createTempFile("image", (String)fileExtension);
            this.imageService.rotateImage(image, f, clockwise);
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(f));
            try {
                node.getParent().uploadFile(target, fis, node.getFileContent().getContentType());
                session.save();
            }
            finally {
                IOUtils.closeQuietly((InputStream)fis);
                f.delete();
            }
        }
        catch (ExistingFileException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new GWTJahiaServiceException(Messages.getInternalWithArguments("label.gwt.error.cannot.rotate.image", uiLocale, e.getLocalizedMessage()));
        }
    }
}

