/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.helper;

import com.extjs.gxt.ui.client.data.BaseModelData;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.version.Version;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.jackrabbit.core.security.JahiaPrivilegeRegistry;
import org.jahia.ajax.gwt.client.data.GWTResourceBundle;
import org.jahia.ajax.gwt.client.data.node.GWTBitSet;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNode;
import org.jahia.ajax.gwt.client.data.node.GWTJahiaNodeVersion;
import org.jahia.ajax.gwt.client.data.publication.GWTJahiaPublicationInfo;
import org.jahia.ajax.gwt.client.data.workflow.GWTJahiaWorkflowInfo;
import org.jahia.ajax.gwt.client.service.GWTJahiaServiceException;
import org.jahia.ajax.gwt.helper.GWTResourceBundleUtils;
import org.jahia.ajax.gwt.helper.LanguageHelper;
import org.jahia.ajax.gwt.helper.PublicationHelper;
import org.jahia.ajax.gwt.helper.WorkflowHelper;
import org.jahia.bin.Jahia;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeLockType;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRStoreProvider;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.JCRVersionService;
import org.jahia.services.content.VersionInfo;
import org.jahia.services.content.decorator.JCRGroupNode;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.content.nodetypes.ConstraintsHelper;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.jahia.services.content.nodetypes.ExtendedPropertyDefinition;
import org.jahia.services.content.nodetypes.NodeTypeRegistry;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.RenderService;
import org.jahia.services.render.Resource;
import org.jahia.services.render.Template;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.services.visibility.VisibilityConditionRule;
import org.jahia.services.visibility.VisibilityService;
import org.jahia.utils.LanguageCodeConverters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeHelper {
    private static final Logger logger = LoggerFactory.getLogger(NodeHelper.class);
    private JCRVersionService jcrVersionService;
    private LanguageHelper languages;
    private PublicationHelper publication;
    private JCRSessionFactory sessionFactory;
    private VisibilityService visibilityService;
    private WorkflowHelper workflow;

    NodeHelper() {
    }

    static String getNodeURL(String servlet, JCRNodeWrapper node, Date versionDate, String versionLabel, String workspace, Locale locale, boolean findDisplayable) throws RepositoryException {
        Template template;
        if (servlet == null) {
            servlet = "render";
        }
        String url = Jahia.getContextPath() + "/cms/" + servlet + "/" + workspace + "/" + locale;
        Resource resource = new Resource(node, "html", null, "page");
        RenderContext renderContext = new RenderContext(null, null, node.getSession().getUser());
        renderContext.setMainResource(resource);
        renderContext.setServletPath("/cms/" + servlet);
        JCRNodeWrapper nodeForURL = node;
        if (findDisplayable && (nodeForURL = JCRContentUtils.findDisplayableNode(node, renderContext)) != null && !nodeForURL.getIdentifier().equals(node.getIdentifier())) {
            resource = new Resource(nodeForURL, "html", null, "page");
        }
        String extensionName = (template = RenderService.getInstance().resolveTemplate(resource, renderContext)) != null || nodeForURL.isNodeType("jnt:page") || nodeForURL.isNodeType("jmix:mainResource") ? ".html" : ".content-template.html";
        url = url + nodeForURL.getPath() + extensionName;
        if (versionDate != null) {
            url = url + "?v=" + versionDate.getTime();
            if (versionLabel != null) {
                url = url + "&l=" + versionLabel;
            }
        }
        return url;
    }

    private static Object getPropertyValue(Value value, JCRSessionWrapper session) throws RepositoryException {
        switch (value.getType()) {
            case 5: {
                return value.getDate().getTime();
            }
            case 9: 
            case 10: {
                try {
                    return session.getNodeByUUID(value.getString()).getPath();
                }
                catch (ItemNotFoundException itemNotFoundException) {
                    // empty catch block
                }
            }
        }
        return value.getString();
    }

    private static void setPropertyValue(GWTJahiaNode n, JCRPropertyWrapper property, JCRSessionWrapper session) throws RepositoryException {
        if (property.isMultiple()) {
            JCRValueWrapper[] values = property.getValues();
            ArrayList<Object> l = new ArrayList<Object>();
            for (JCRValueWrapper value : values) {
                l.add(NodeHelper.getPropertyValue(value, session));
            }
            n.set(property.getName(), l);
        } else {
            JCRValueWrapper value = property.getValue();
            n.set(property.getName(), NodeHelper.getPropertyValue(value, session));
        }
    }

    GWTJahiaNode getGWTJahiaNode(JCRNodeWrapper node) {
        return this.getGWTJahiaNode(node, GWTJahiaNode.DEFAULT_FIELDS, null);
    }

    GWTJahiaNode getGWTJahiaNode(JCRNodeWrapper node, List<String> fields, Locale uiLocale) {
        GWTResourceBundle b;
        JCRStoreProvider p;
        if (fields == null) {
            fields = Collections.emptyList();
        }
        GWTJahiaNode n = new GWTJahiaNode();
        try {
            n.setUUID(node.getIdentifier());
        }
        catch (RepositoryException e) {
            logger.debug("Unable to get uuid for node " + node.getName(), (Throwable)e);
        }
        this.populateNames(n, node, uiLocale);
        this.populateDescription(n, node);
        n.setPath(node.getPath());
        n.setUrl(node.getUrl());
        this.populateNodeTypes(n, node);
        JCRStoreProvider provider = node.getProvider();
        if (provider.isDynamicallyMounted()) {
            n.setProviderKey(StringUtils.substringAfterLast((String)provider.getMountPoint(), (String)"/"));
        } else {
            n.setProviderKey(provider.getKey());
        }
        if (fields.contains("permissions")) {
            this.populatePermissions(n, node);
        }
        if (fields.contains("locksInfo") && !provider.isSlowConnection()) {
            this.populateLocksInfo(n, node);
        }
        if (fields.contains("visibilityInfo")) {
            this.populateVisibilityInfo(n, node);
        }
        n.setVersioned(node.isVersioned());
        n.setLanguageCode(node.getLanguage());
        this.populateSiteInfo(n, node);
        if (node.isFile()) {
            n.setSize(Long.valueOf(node.getFileContent().getContentLength()));
        }
        n.setFile(Boolean.valueOf(node.isFile()));
        n.setIsShared(false);
        try {
            if (node.isNodeType("mix:shareable") && node.getSharedSet().getSize() > 1L) {
                n.setIsShared(true);
            }
        }
        catch (RepositoryException e) {
            logger.error("Error when getting shares", (Throwable)e);
        }
        try {
            n.setReference(node.isNodeType("jmix:nodeReference"));
        }
        catch (RepositoryException e1) {
            logger.error("Error checking node type", (Throwable)e1);
        }
        if (fields.contains("childrenInfo")) {
            this.populateChildrenInfo(n, node);
        }
        if (fields.contains("tags")) {
            this.populateTags(n, node);
        }
        if (fields.contains("icon")) {
            this.populateIcon(n, node);
        }
        this.populateThumbnails(n, node, fields.contains("previewLarge"));
        if (fields.contains("count")) {
            this.populateCount(n, node);
        }
        this.populateStatusInfo(n, node);
        if (this.supportsWorkspaceManagement(node).booleanValue()) {
            if (fields.contains("publicationInfo")) {
                this.populatePublicationInfo(n, node);
            }
            if (fields.contains("quickPublicationInfo")) {
                this.populateQuickPublicationInfo(n, node);
            }
            if (fields.contains("publicationInfos")) {
                this.populatePublicationInfos(n, node);
            }
            n.set("supportsPublication", (Object)this.supportsPublication(node));
        }
        if (fields.contains("workflowInfo") || fields.contains("publicationInfo")) {
            this.populateWorkflowInfo(n, node, uiLocale);
        }
        if (fields.contains("workflowInfos")) {
            this.populateWorkflowInfos(n, node, uiLocale);
        }
        if (fields.contains("j:availableWorkflows")) {
            this.populateAvailableWorkflows(n, node);
        }
        if (fields.contains("primaryTypeLabel")) {
            this.populatePrimaryTypeLabel(n, node);
        }
        if ((p = JCRSessionFactory.getInstance().getMountPoints().get(n.getPath())) != null && p.isDynamicallyMounted()) {
            n.set("j:isDynamicMountPoint", (Object)Boolean.TRUE);
        }
        if (n.isFile().booleanValue() && (n.isNodeType("jmix:image") || n.isNodeType("jmix:size"))) {
            try {
                if (node.hasProperty("j:height")) {
                    n.set("j:height", (Object)node.getProperty("j:height").getString());
                }
            }
            catch (RepositoryException e) {
                logger.error("Cannot get property j:height on node {}", (Object)node.getPath());
            }
            try {
                if (node.hasProperty("j:width")) {
                    n.set("j:width", (Object)node.getProperty("j:width").getString());
                }
            }
            catch (RepositoryException e) {
                logger.error("Cannot get property j:width on node {}", (Object)node.getPath());
            }
        }
        if (fields.contains("j:view") && n.isNodeType("jmix:renderable")) {
            try {
                if (node.hasProperty("j:view")) {
                    n.set("j:view", (Object)node.getProperty("j:view").getString());
                }
            }
            catch (RepositoryException e) {
                logger.error("Cannot get property j:view on node {}", (Object)node.getPath());
            }
        }
        if (fields.contains("siteLanguages")) {
            this.populateSiteLanguages(n, node);
        }
        if (node instanceof JCRSiteNode && fields.contains("j:resolvedDependencies")) {
            this.populateDependencies(n, node);
        }
        if (fields.contains("subnodesConstraintsInfo")) {
            this.populateSubnodesConstraintsInfo(n, node);
        }
        if (fields.contains("j:defaultLanguage")) {
            this.populateDefaultLanguage(n, node);
        }
        if (node instanceof JCRSiteNode && fields.contains("homepage-path")) {
            this.populateHomePage(n, node);
        }
        Boolean isModuleNode = null;
        JahiaTemplateManagerService templateManagerService = ServicesRegistry.getInstance().getJahiaTemplateManagerService();
        try {
            if (fields.contains("j:versionInfo") && (isModuleNode = Boolean.valueOf(node.isNodeType("jnt:module"))).booleanValue()) {
                this.populateVersionInfoForModule(n, node);
            }
        }
        catch (RepositoryException e) {
            logger.error("Cannot get property module version");
        }
        for (String field : fields) {
            if (GWTJahiaNode.RESERVED_FIELDS.contains(field)) continue;
            try {
                Iterator versionNode;
                JahiaTemplatesPackage templatePackageByFileName;
                JCRPropertyWrapper property;
                if (field.startsWith("fields-")) {
                    String type = field.substring("fields-".length());
                    PropertyIterator pi = node.getProperties();
                    while (pi.hasNext()) {
                        property = (JCRPropertyWrapper)pi.next();
                        if (!((ExtendedPropertyDefinition)property.getDefinition()).getItemType().equals(type)) continue;
                        NodeHelper.setPropertyValue(n, property, node.getSession());
                    }
                    continue;
                }
                if (node.hasProperty(field)) {
                    JCRPropertyWrapper property2 = node.getProperty(field);
                    NodeHelper.setPropertyValue(n, property2, node.getSession());
                    continue;
                }
                if (!(isModuleNode != null ? isModuleNode != false : (isModuleNode = Boolean.valueOf(node.isNodeType("jnt:module"))) != false) || (templatePackageByFileName = templateManagerService.getTemplatePackageById(node.getName())) == null || !(versionNode = node.getNode(templatePackageByFileName.getVersion().toString())).hasProperty(field)) continue;
                property = versionNode.getProperty(field);
                NodeHelper.setPropertyValue(n, property, node.getSession());
            }
            catch (RepositoryException e) {
                logger.error("Cannot get property {} on node {}", (Object)field, (Object)node.getPath());
            }
        }
        if (fields.contains("versions") && node.isVersioned()) {
            this.populateVersions(n, node);
        }
        if (fields.contains("resourceBundle") && (b = GWTResourceBundleUtils.load(node, uiLocale)) != null) {
            n.set("resourceBundle", (Object)b);
        }
        this.populateReference(n, node, fields, uiLocale);
        this.populateOrdering(n, node);
        this.populateChildConstraints(n, node);
        this.populateWCAG(n, node);
        this.populateInvalidLanguages(n, node);
        List installedModules = (List)n.get("j:installedModules");
        if (installedModules != null) {
            ArrayList<JahiaTemplatesPackage> s = new ArrayList<JahiaTemplatesPackage>();
            LinkedHashMap deps = new LinkedHashMap();
            for (String packId : installedModules) {
                JahiaTemplatesPackage pack = templateManagerService.getTemplatePackageById(packId);
                if (pack == null) continue;
                deps.put(pack, new ArrayList());
            }
            installedModules.clear();
            for (Map.Entry entry : deps.entrySet()) {
                List<JahiaTemplatesPackage> allDeps = ((JahiaTemplatesPackage)entry.getKey()).getDependencies();
                for (JahiaTemplatesPackage dep : allDeps) {
                    if (!deps.keySet().contains(dep)) continue;
                    ((List)entry.getValue()).add(dep);
                }
                if (!((List)entry.getValue()).isEmpty()) continue;
                s.add((JahiaTemplatesPackage)entry.getKey());
            }
            while (!s.isEmpty()) {
                JahiaTemplatesPackage pack = (JahiaTemplatesPackage)s.remove(0);
                installedModules.add(pack.getId());
                for (Map.Entry entry : deps.entrySet()) {
                    if (!((List)entry.getValue()).contains(pack)) continue;
                    ((List)entry.getValue()).remove(pack);
                    if (!((List)entry.getValue()).isEmpty()) continue;
                    s.add((JahiaTemplatesPackage)entry.getKey());
                }
            }
        }
        return n;
    }

    private Boolean supportsPublication(JCRNodeWrapper node) {
        try {
            return JCRPublicationService.supportsPublication(node.getSession(), node);
        }
        catch (RepositoryException e) {
            logger.warn("Unable to get the repository descriptor for node {}. Cause: {}", (Object)node.getPath(), (Object)e.getLocalizedMessage());
            return Boolean.FALSE;
        }
    }

    private Boolean supportsWorkspaceManagement(JCRNodeWrapper node) {
        JCRStoreProvider provider = node.getProvider();
        if (provider.isDefault()) {
            return Boolean.TRUE;
        }
        try {
            Value descriptorValue = node.getSession().getProviderSession(provider).getRepository().getDescriptorValue("option.workspace.management.supported");
            return descriptorValue != null && descriptorValue.getBoolean();
        }
        catch (RepositoryException e) {
            logger.warn("Unable to get the repository descriptor for node {}. Cause: {}", (Object)node.getPath(), (Object)e.getLocalizedMessage());
            return Boolean.FALSE;
        }
    }

    private List<GWTJahiaNodeVersion> getVersions(JCRNodeWrapper node) throws RepositoryException {
        return this.getVersions(node, false);
    }

    List<GWTJahiaNodeVersion> getVersions(JCRNodeWrapper node, boolean publishedOnly) throws RepositoryException {
        ArrayList<GWTJahiaNodeVersion> versions = new ArrayList<GWTJahiaNodeVersion>();
        List<VersionInfo> versionInfos = this.jcrVersionService.getVersionInfos(node.getSession(), node);
        for (VersionInfo versionInfo : versionInfos) {
            if (publishedOnly && !versionInfo.getLabel().startsWith("live_")) continue;
            Version v = versionInfo.getVersion();
            GWTJahiaNode n = this.getGWTJahiaNode(node);
            String workspace = StringUtils.substringBefore((String)versionInfo.getLabel(), (String)"_");
            GWTJahiaNodeVersion jahiaNodeVersion = new GWTJahiaNodeVersion(v.getIdentifier(), v.getName(), v.getCreated().getTime(), versionInfo.getLabel(), workspace, n);
            String url = NodeHelper.getNodeURL(null, node, versionInfo.getVersion().getCreated().getTime(), versionInfo.getLabel(), workspace, node.getSession().getLocale(), false);
            jahiaNodeVersion.setUrl(url);
            versions.add(jahiaNodeVersion);
        }
        return versions;
    }

    private void populateAvailableWorkflows(GWTJahiaNode n, JCRNodeWrapper node) {
        try {
            if (node.hasProperty("j:availableWorkflows")) {
                JCRPropertyWrapper property = node.getProperty("j:availableWorkflows");
                JCRValueWrapper[] values = null;
                values = property.isMultiple() ? property.getValues() : new Value[]{property.getValue()};
                LinkedList<String> vals = new LinkedList<String>();
                if (values != null) {
                    for (JCRValueWrapper value : values) {
                        if (value == null) continue;
                        vals.add(value.getString());
                    }
                }
                n.set("j:availableWorkflows", (Object)StringUtils.join(vals, (String)", "));
            }
        }
        catch (RepositoryException e) {
            logger.error("Cannot get property j:availableWorkflows on node " + node.getPath());
        }
    }

    private void populateChildConstraints(GWTJahiaNode n, JCRNodeWrapper node) {
        try {
            n.setChildConstraints(ConstraintsHelper.getConstraints(node));
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void populateChildrenInfo(GWTJahiaNode n, JCRNodeWrapper node) {
        try {
            boolean slowConnection = node.getProvider().isSlowConnection();
            boolean allowChildNodes = false;
            for (String s : node.getNodeTypes()) {
                if (NodeTypeRegistry.getInstance().getNodeType(s).getChildNodeDefinitions().length <= 0) continue;
                allowChildNodes = true;
                break;
            }
            n.setHasChildren(allowChildNodes && (slowConnection || node.hasNodes()));
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void populateCount(GWTJahiaNode n, JCRNodeWrapper node) {
        try {
            n.set("count", (Object)JCRContentUtils.size((RangeIterator)node.getWeakReferences()));
        }
        catch (RepositoryException e) {
            logger.warn("Unable to count node references for node");
        }
    }

    private void populateDefaultLanguage(GWTJahiaNode n, JCRNodeWrapper node) {
        try {
            if (node.hasProperty("j:defaultLanguage")) {
                Locale locale = LanguageCodeConverters.languageCodeToLocale(node.getProperty("j:defaultLanguage").getString());
                n.set("j:defaultLanguage", (Object)this.languages.getCurrentLang(locale));
            }
        }
        catch (RepositoryException e) {
            logger.error("Cannot get property j:defaultLanguage on node " + node.getPath());
        }
    }

    private void populateDependencies(GWTJahiaNode n, JCRNodeWrapper node) {
        ArrayList<String> dependencies = new ArrayList<String>();
        for (String s : ((JCRSiteNode)node).getInstalledModules()) {
            JahiaTemplatesPackage templatePackageByFileName = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById(s);
            if (templatePackageByFileName == null) continue;
            for (JahiaTemplatesPackage aPackage : templatePackageByFileName.getDependencies()) {
                if (dependencies.contains(aPackage.getId())) continue;
                dependencies.add(aPackage.getId());
            }
        }
        n.set("j:resolvedDependencies", dependencies);
    }

    private void populateDescription(GWTJahiaNode n, JCRNodeWrapper node) {
        try {
            JCRValueWrapper dValue;
            if (node.hasProperty("jcr:description") && (dValue = node.getProperty("jcr:description").getValue()) != null) {
                n.setDescription(dValue.getString());
            }
        }
        catch (RepositoryException e) {
            logger.debug("Unable to get description property for node " + node.getName(), (Throwable)e);
        }
    }

    private void populateHomePage(GWTJahiaNode n, JCRNodeWrapper node) {
        try {
            if (((JCRSiteNode)node).getHome() != null) {
                n.set("homepage-path", (Object)((JCRSiteNode)node).getHome().getPath());
            }
        }
        catch (RepositoryException e) {
            logger.error("Cannot get property homepage-path on node " + node.getPath());
        }
    }

    private void populateIcon(GWTJahiaNode n, JCRNodeWrapper node) {
        try {
            n.setIcon(JCRContentUtils.getIconWithContext(node, true));
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void populateInvalidLanguages(GWTJahiaNode n, JCRNodeWrapper node) {
        try {
            if (node.hasProperty("j:invalidLanguages")) {
                JCRValueWrapper[] values = node.getProperty("j:invalidLanguages").getValues();
                ArrayList<String> invalidLanguages = new ArrayList<String>(values.length);
                for (JCRValueWrapper value : values) {
                    invalidLanguages.add(value.getString());
                }
                n.setInvalidLanguages(invalidLanguages);
            } else {
                n.setInvalidLanguages(new ArrayList());
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void populateLocksInfo(GWTJahiaNode n, JCRNodeWrapper node) {
        n.setLockable(Boolean.valueOf(node.isLockable()));
        try {
            String username = node.getSession().getUser().getName();
            n.setLocked(Boolean.valueOf(JCRContentUtils.isLockedAndCannotBeEdited(node)));
            Map<String, List<String>> infos = node.getLockInfos();
            HashMap results = new HashMap(infos.size());
            if (!infos.isEmpty()) {
                for (Map.Entry<String, List<String>> entry : infos.entrySet()) {
                    for (String s2 : entry.getValue()) {
                        JCRNodeLockType type = JCRContentUtils.getLockType(s2);
                        if (!results.containsKey(entry.getKey())) {
                            results.put(entry.getKey(), new LinkedList());
                        }
                        ((List)results.get(entry.getKey())).add(JCRNodeLockType.USER.equals((Object)type) && StringUtils.isNotBlank((String)s2) ? StringUtils.substringBefore((String)s2, (String)":") : "label.locked.by." + type.toString().toLowerCase());
                    }
                }
                if (infos.get(null) != null && infos.get(null).stream().allMatch(s -> s.endsWith(JCRNodeLockType.ALLOWS_ADD_SUFFIX))) {
                    n.setLockAllowsAdd(Boolean.valueOf(true));
                }
            }
            n.setLockInfos(results);
            if (node.getSession().getLocale() != null) {
                String l = node.getSession().getLocale().toString();
                n.setCanLock(Boolean.valueOf(infos.isEmpty() || !infos.containsKey(l) && infos.size() > 1));
                n.setCanUnlock(Boolean.valueOf(infos.containsKey(null) && infos.get(null).contains(username + ":user") && (infos.size() == 1 || infos.containsKey(l) && infos.get(l).contains(username + ":user"))));
            } else {
                n.setCanLock(Boolean.valueOf(infos.isEmpty()));
                n.setCanUnlock(Boolean.valueOf(infos.containsKey(null) && infos.get(null).contains(username + ":user")));
            }
        }
        catch (RepositoryException e) {
            logger.error("Error when getting lock", (Throwable)e);
        }
    }

    private void populateNames(GWTJahiaNode n, JCRNodeWrapper node, Locale uiLocale) {
        n.setName(JCRContentUtils.unescapeLocalNodeName(node.getName()));
        n.setEscapedName(node.getName());
        try {
            if (node.getPath().equals("/")) {
                n.setDisplayName("root");
                n.setName("root");
                n.setEscapedName("root");
            } else if (node instanceof JCRUserNode) {
                n.setDisplayName(((JCRUserNode)node).getDisplayableName(uiLocale));
            } else if (node instanceof JCRGroupNode) {
                n.setDisplayName(((JCRGroupNode)node).getDisplayableName(uiLocale));
            } else {
                n.setDisplayName(WordUtils.abbreviate((String)JCRContentUtils.unescapeLocalNodeName(node.getDisplayableName()), (int)70, (int)90, (String)"..."));
            }
        }
        catch (Exception e) {
            logger.error("Error when getting name", (Throwable)e);
        }
    }

    private void populateNodeTypes(GWTJahiaNode n, JCRNodeWrapper node) {
        ArrayList<String> inheritedTypes = new ArrayList<String>();
        List<String> nodeTypes = null;
        try {
            nodeTypes = node.getNodeTypes();
            for (String s : nodeTypes) {
                ExtendedNodeType[] inh;
                for (ExtendedNodeType extendedNodeType : inh = NodeTypeRegistry.getInstance().getNodeType(s).getSupertypes()) {
                    if (inheritedTypes.contains(extendedNodeType.getName())) continue;
                    inheritedTypes.add(extendedNodeType.getName());
                }
            }
        }
        catch (RepositoryException e) {
            logger.debug("Error when getting nodetypes", (Throwable)e);
        }
        n.setNodeTypes(nodeTypes);
        n.setInheritedNodeTypes(inheritedTypes);
    }

    private void populateOrdering(GWTJahiaNode n, JCRNodeWrapper node) {
        try {
            if (node.getPrimaryNodeType().hasOrderableChildNodes()) {
                n.set("hasOrderableChildNodes", (Object)Boolean.TRUE);
                n.setSortField("index");
            } else {
                n.setSortField("name");
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void populatePermissions(GWTJahiaNode n, JCRNodeWrapper node) {
        BitSet bs = node.getPermissionsAsBitSet();
        if (bs != null) {
            GWTBitSet gwtBs = new GWTBitSet(bs.size());
            gwtBs.setReferenceHashCode(JahiaPrivilegeRegistry.getRegisteredPrivilegeNames().hashCode());
            int i = bs.nextSetBit(0);
            while (i >= 0) {
                gwtBs.set(i);
                i = bs.nextSetBit(i + 1);
            }
            n.setPermissions(gwtBs);
            try {
                boolean hasAcl = node.hasNode("j:acl") && node.getNode("j:acl").hasNodes();
                n.setHasAcl(Boolean.valueOf(hasAcl));
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void populatePrimaryTypeLabel(GWTJahiaNode n, JCRNodeWrapper node) {
        try {
            n.set("primaryTypeLabel", (Object)node.getPrimaryNodeType().getLabel(node.getSession().getLocale()));
        }
        catch (RepositoryException e) {
            logger.error("Cannot get property primaryTypeLabel on node " + node.getPath());
        }
    }

    private void populatePublicationInfo(GWTJahiaNode n, JCRNodeWrapper node) {
        if (logger.isDebugEnabled()) {
            logger.debug("populate publication info for {}", (Object)node.getPath());
        }
        try {
            if (node.getSession().getLocale() != null) {
                n.setAggregatedPublicationInfos(this.publication.getAggregatedPublicationInfosByLanguage(node, Collections.singleton(node.getSession().getLocale().toString()), node.getSession(), true, true));
            }
        }
        catch (UnsupportedRepositoryOperationException e) {
            logger.debug(e.getMessage());
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (GWTJahiaServiceException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void populateQuickPublicationInfo(GWTJahiaNode n, JCRNodeWrapper node) {
        if (logger.isDebugEnabled()) {
            logger.debug("populate quick publication info for {}", (Object)node.getPath());
        }
        try {
            if (node.getSession().getLocale() != null) {
                n.setQuickPublicationInfo(this.publication.getAggregatedPublicationInfosByLanguage(node, Collections.singleton(node.getSession().getLocale().toString()), node.getSession(), false, false).values().iterator().next());
            }
        }
        catch (UnsupportedRepositoryOperationException e) {
            logger.debug(e.getMessage());
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (GWTJahiaServiceException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void populatePublicationInfos(GWTJahiaNode n, JCRNodeWrapper node) {
        if (logger.isDebugEnabled()) {
            logger.debug("populate publication infos for {}", (Object)node.getPath());
        }
        try {
            JCRSiteNode siteNode = node.getResolveSite();
            if (siteNode != null) {
                JCRSessionWrapper session = node.getSession();
                Map<String, GWTJahiaPublicationInfo> aggregatedPublicationInfosByLanguage = this.publication.getAggregatedPublicationInfosByLanguage(node, siteNode.getLanguages(), session, true, true);
                n.setAggregatedPublicationInfos(aggregatedPublicationInfosByLanguage);
                Map<String, List<GWTJahiaPublicationInfo>> fullPublicationInfosByLanguage = this.publication.getFullPublicationInfosByLanguage(Arrays.asList(node.getIdentifier()), siteNode.getLanguages(), session, false);
                n.setFullPublicationInfos(fullPublicationInfosByLanguage);
                for (Map.Entry<String, List<GWTJahiaPublicationInfo>> entry : fullPublicationInfosByLanguage.entrySet()) {
                    GWTJahiaPublicationInfo pubInfo = aggregatedPublicationInfosByLanguage.get(entry.getKey());
                    if (pubInfo == null || entry.getValue().isEmpty()) continue;
                    GWTJahiaPublicationInfo fullPubInfo = entry.getValue().iterator().next();
                    pubInfo.setWorkflowGroup(fullPubInfo.getWorkflowGroup());
                    pubInfo.setWorkflowDefinition(fullPubInfo.getWorkflowDefinition());
                }
            }
        }
        catch (UnsupportedRepositoryOperationException e) {
            logger.debug(e.getMessage());
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (GWTJahiaServiceException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void populateReference(GWTJahiaNode n, JCRNodeWrapper node, List<String> fields, Locale uiLocale) {
        try {
            if (node.isNodeType("jmix:nodeReference") && node.hasProperty("j:node")) {
                JCRNodeWrapper referencedNode = (JCRNodeWrapper)node.getProperty("j:node").getNode();
                n.setReferencedNode(n.getUUID().equals(referencedNode.getIdentifier()) ? n : this.getGWTJahiaNode(referencedNode, fields, uiLocale));
            }
        }
        catch (ItemNotFoundException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void populateSiteInfo(GWTJahiaNode n, JCRNodeWrapper node) {
        try {
            JCRSiteNode site = node.getResolveSite();
            if (site != null) {
                n.setSiteUUID(site.getUUID());
                n.setSiteKey(site.getSiteKey());
                if (site.getTemplatePackage() != null) {
                    n.set("editModeBlocked", (Object)site.getTemplatePackage().isEditModeBlocked());
                }
            }
        }
        catch (RepositoryException e) {
            logger.error("Error when getting sitekey", (Throwable)e);
        }
    }

    private void populateSiteLanguages(GWTJahiaNode n, JCRNodeWrapper node) {
        try {
            n.set("siteLanguages", this.languages.getLanguages(node.getResolveSite(), node.getSession().getLocale()));
            n.set("siteMandatoryLanguages", new ArrayList<String>(node.getResolveSite().getMandatoryLanguages()));
        }
        catch (RepositoryException e) {
            logger.error("Cannot get sites languages");
        }
    }

    private void populateStatusInfo(GWTJahiaNode n, JCRNodeWrapper node) {
        try {
            n.setCanMarkForDeletion(node.canMarkForDeletion());
        }
        catch (RepositoryException e) {
            logger.error("Unable to check if the node " + node.getPath() + " supports marking for deletion. Cause: " + e.getMessage(), (Throwable)e);
        }
        try {
            n.set("everPublished", (Object)node.hasProperty("j:published"));
        }
        catch (RepositoryException e) {
            logger.warn("Unable to check existence of the j:published property on node " + node.getPath() + ". Cause: " + e.getMessage(), (Throwable)e);
        }
        try {
            if (node.hasProperty("j:workInProgressStatus")) {
                NodeHelper.setPropertyValue(n, node.getProperty("j:workInProgressStatus"), node.getSession());
            }
            if (node.hasProperty("j:workInProgressLanguages")) {
                NodeHelper.setPropertyValue(n, node.getProperty("j:workInProgressLanguages"), node.getSession());
            }
        }
        catch (RepositoryException e) {
            logger.error("Cannot get repository infos", (Throwable)e);
        }
    }

    private void populateSubnodesConstraintsInfo(GWTJahiaNode n, JCRNodeWrapper node) {
        try {
            String cons = ConstraintsHelper.getConstraints(node);
            if (cons != null) {
                n.set("referenceTypes", (Object)ConstraintsHelper.getReferenceTypes(cons, null));
            }
        }
        catch (RepositoryException e) {
            logger.error("Cannot get property subnodesConstraintsInfo on node " + node.getPath());
        }
    }

    private void populateTags(GWTJahiaNode n, JCRNodeWrapper node) {
        try {
            if (node.hasProperty("j:tagList")) {
                JCRValueWrapper[] values;
                StringBuilder b = new StringBuilder();
                for (JCRValueWrapper value : values = node.getProperty("j:tagList").getValues()) {
                    b.append(", ");
                    b.append(value.getString());
                }
                if (b.length() > 0) {
                    n.setTags(b.substring(2));
                }
            }
        }
        catch (RepositoryException e) {
            logger.error("Error when getting tags", (Throwable)e);
        }
    }

    private void populateThumbnails(GWTJahiaNode n, JCRNodeWrapper node, boolean useLargeThumbnails) {
        try {
            if (!n.isNodeType("jmix:thumbnail")) {
                return;
            }
            if (node.hasNode("thumbnail")) {
                n.setPreview(node.getThumbnailUrl("thumbnail"));
                n.setDisplayable(true);
            }
            if (useLargeThumbnails && node.hasNode("thumbnail2")) {
                n.setPreviewLarge(node.getThumbnailUrl("thumbnail2"));
                n.setDisplayable(true);
            }
        }
        catch (RepositoryException e) {
            logger.warn("Error checking thumbnails for node " + n.getPath(), (Throwable)e);
        }
    }

    private void populateVersionInfoForModule(GWTJahiaNode n, JCRNodeWrapper node) {
        try {
            JahiaTemplateManagerService templateManagerService = ServicesRegistry.getInstance().getJahiaTemplateManagerService();
            JahiaTemplatesPackage packageByFileName = templateManagerService.getTemplatePackageById(node.getName());
            if (packageByFileName != null) {
                JCRNodeWrapper versionInfo = node.getNode(packageByFileName.getVersion().toString() + "/j:versionInfo");
                if (packageByFileName != null) {
                    n.set("displayName", (Object)packageByFileName.getName());
                    n.set("j:versionInfo", (Object)packageByFileName.getVersion().toString());
                    n.set("j:versionNumbers", packageByFileName.getVersion().getOrderedVersionNumbers());
                    File sources = templateManagerService.getSources(packageByFileName, node.getSession());
                    if (sources != null) {
                        n.set("j:sourcesFolder", (Object)sources.getPath());
                    }
                    if (versionInfo.hasProperty("j:scmURI")) {
                        n.set("j:scmURI", (Object)versionInfo.getProperty("j:scmURI").getString());
                    }
                    if (StringUtils.isNotEmpty((String)packageByFileName.getForgeUrl())) {
                        n.set("j:forgeUrl", (Object)packageByFileName.getForgeUrl());
                    }
                }
            }
        }
        catch (RepositoryException e) {
            logger.error("Cannot get property module version " + n.getPath());
        }
    }

    private void populateVersions(GWTJahiaNode n, JCRNodeWrapper node) {
        try {
            n.setCurrentVersion(node.getBaseVersion().getName());
            List<GWTJahiaNodeVersion> gwtJahiaNodeVersions = this.getVersions(node);
            if (gwtJahiaNodeVersions != null && gwtJahiaNodeVersions.size() > 0) {
                n.setVersions(gwtJahiaNodeVersions);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void populateVisibilityInfo(GWTJahiaNode n, JCRNodeWrapper node) {
        Map<JCRNodeWrapper, Boolean> conditionMatchesDetails = this.visibilityService.getConditionMatchesDetails(node);
        HashMap<GWTJahiaNode, BaseModelData> visibilityInfo = new HashMap<GWTJahiaNode, BaseModelData>();
        for (Map.Entry<JCRNodeWrapper, Boolean> entry : conditionMatchesDetails.entrySet()) {
            BaseModelData data = new BaseModelData();
            data.set("matches", (Object)entry.getValue());
            VisibilityConditionRule visibilityConditionRule = null;
            try {
                visibilityConditionRule = this.visibilityService.getConditions().get(entry.getKey().getPrimaryNodeTypeName());
                data.set("xtemplate", (Object)visibilityConditionRule.getGWTDisplayTemplate(node.getSession().getLocale()));
            }
            catch (RepositoryException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            if (visibilityConditionRule == null) continue;
            visibilityInfo.put(this.getGWTJahiaNode(entry.getKey(), visibilityConditionRule.getRequiredFieldNamesForTemplate(), null), data);
        }
        n.setVisibilityInfo(visibilityInfo);
        n.setVisible(Boolean.valueOf(this.visibilityService.matchesConditions(node)));
    }

    private void populateWCAG(GWTJahiaNode n, JCRNodeWrapper node) {
        try {
            JCRSiteNode site = node.getResolveSite();
            if (site != null) {
                n.setWCAGComplianceCheckEnabled(site.hasProperty("j:wcagCompliance") && site.getProperty("j:wcagCompliance").getBoolean());
            }
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void populateWorkflowInfo(GWTJahiaNode n, JCRNodeWrapper node, Locale displayLocale) {
        try {
            n.setWorkflowInfo(this.workflow.getWorkflowInfo(n.getPath(), false, node.getSession(), node.getSession().getLocale(), displayLocale));
        }
        catch (UnsupportedRepositoryOperationException e) {
            logger.debug(e.getMessage());
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (GWTJahiaServiceException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void populateWorkflowInfos(GWTJahiaNode n, JCRNodeWrapper node, Locale displayLocale) {
        try {
            JCRSiteNode node1 = node.getResolveSite();
            if (node1 != null) {
                HashMap<String, GWTJahiaWorkflowInfo> infoMap = new HashMap<String, GWTJahiaWorkflowInfo>();
                JCRSessionWrapper session = node.getSession();
                for (String code : node1.getLanguages()) {
                    Locale locale = LanguageCodeConverters.languageCodeToLocale(code);
                    JCRSessionWrapper localeSession = this.sessionFactory.getCurrentUserSession(session.getWorkspace().getName(), locale);
                    GWTJahiaWorkflowInfo info = this.workflow.getWorkflowInfo(n.getPath(), true, localeSession, locale, displayLocale);
                    infoMap.put(code, info);
                }
                n.setWorkflowInfos(infoMap);
            }
        }
        catch (UnsupportedRepositoryOperationException e) {
            logger.debug(e.getMessage());
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (GWTJahiaServiceException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void setJcrVersionService(JCRVersionService jcrVersionService) {
        this.jcrVersionService = jcrVersionService;
    }

    public void setLanguages(LanguageHelper languages) {
        this.languages = languages;
    }

    public void setPublication(PublicationHelper publication) {
        this.publication = publication;
    }

    public void setSessionFactory(JCRSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setVisibilityService(VisibilityService visibilityService) {
        this.visibilityService = visibilityService;
    }

    public void setWorkflow(WorkflowHelper workflow) {
        this.workflow = workflow;
    }
}

