/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.ajax.gwt.utils;

import java.net.MalformedURLException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.jahia.ajax.gwt.utils.GWTResourceConfig;
import org.jahia.bin.Jahia;
import org.jahia.bin.Render;
import org.jahia.bin.filters.ContentManagerAccessCheckFilter;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.content.decorator.JCRUserNode;
import org.jahia.services.preferences.user.UserPreferencesHelper;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.URLGenerator;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.LanguageCodeConverters;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GWTInitializer {
    private static volatile GWTResourceConfig config;
    private static final Logger logger;

    public static String generateInitializerStructureForFrame(RenderContext ctx) {
        StringBuilder buf = new StringBuilder();
        GWTInitializer.addCss(buf, ctx.getRequest(), ctx.getResponse(), true);
        buf.append("<script type=\"text/javascript\">\nvar onGWTFrameLoaded = []; function onGWTFrameLoad(fun) { onGWTFrameLoaded[onGWTFrameLoaded.length] = fun; }; ");
        String customCkeditorConfig = GWTInitializer.getCustomCKEditorConfig(ctx);
        buf.append("if (typeof parent.contextJsParameters != 'undefined') { parent.contextJsParameters.ckeCfg='");
        if (customCkeditorConfig != null) {
            buf.append(customCkeditorConfig);
        }
        buf.append("' };\n</script>\n");
        return buf.toString();
    }

    @Deprecated(since="7.3.0.1")
    public static String generateInitializerStructure(HttpServletRequest request, HttpSession session) {
        return GWTInitializer.generateInitializerStructure(request, session, null, null);
    }

    @Deprecated(since="7.3.0.1")
    public static String generateInitializerStructure(HttpServletRequest request, HttpSession session, Locale locale, Locale uilocale) {
        return GWTInitializer.generateInitializerStructure(request, null, session, locale, uilocale);
    }

    public static String generateInitializerStructure(HttpServletRequest request, HttpServletResponse response, HttpSession session, Locale locale, Locale uilocale) {
        String customCkeditorConfig;
        StringBuilder buf = new StringBuilder();
        JahiaUser user = (JahiaUser)session.getAttribute("org.jahia.usermanager.jahiauser");
        if (uilocale == null) {
            Locale sessionLocale = (Locale)session.getAttribute("org.jahia.services.multilang.uilocale");
            JCRUserNode userNode = null;
            if (user != null) {
                userNode = JahiaUserManagerService.getInstance().lookupUserByPath(user.getLocalPath());
            }
            Locale locale2 = uilocale = sessionLocale != null ? UserPreferencesHelper.getPreferredLocale(userNode, sessionLocale) : UserPreferencesHelper.getPreferredLocale(userNode, LanguageCodeConverters.resolveLocaleForGuest(request));
        }
        if (locale == null) {
            String language = request.getParameter("lang");
            if (!StringUtils.isEmpty((String)language)) {
                locale = LanguageCodeConverters.getLocaleFromCode(language);
            }
            if (locale == null) {
                locale = (Locale)session.getAttribute("org.jahia.services.multilang.currentlocale");
            }
            if (locale == null) {
                locale = Locale.ENGLISH;
            }
        }
        buf.append("<meta name=\"gwt:property\" content=\"locale=").append(StringEscapeUtils.escapeXml((String)uilocale.toString())).append("\"/>");
        RenderContext renderContext = (RenderContext)request.getAttribute("renderContext");
        GWTInitializer.addCss(buf, request, (HttpServletResponse)(response != null ? response : (renderContext != null ? renderContext.getResponse() : null)), false);
        HashMap<String, String> params = new HashMap<String, String>();
        String serviceEntrypoint = GWTInitializer.buildServiceBaseEntrypointUrl(request);
        params.put("serviceEntryPoint", serviceEntrypoint);
        String contextPath = request.getContextPath();
        params.put("contextPath", contextPath);
        params.put("dxVersion", Jahia.VERSION);
        params.put("servletPath", request.getAttribute("servletPath") == null ? request.getServletPath() : (String)request.getAttribute("servletPath"));
        params.put("pathInfo", request.getPathInfo());
        params.put("queryString", request.getQueryString());
        boolean devMode = SettingsBean.getInstance().isDevelopmentMode();
        params.put("developmentMode", devMode ? "true" : "false");
        boolean areaAutoActivated = SettingsBean.getInstance().isAreaAutoActivated();
        params.put("areaAutoActivated", areaAutoActivated ? "true" : "false");
        if (devMode) {
            params.put("modulesSourcesDiskPath", SettingsBean.getInstance().getModulesSourcesDiskPath());
        }
        if (user != null) {
            String name = user.getUsername();
            int index = name.indexOf(":");
            if (index > 0) {
                String displayname = name.substring(0, index);
                params.put("currentUser", displayname);
            } else {
                params.put("currentUser", name);
            }
            params.put("currentUserPath", user.getLocalPath());
        } else {
            params.put("currentUser", "guest");
            params.put("currentUserPath", "/users/guest");
        }
        params.put("lang", locale.toString());
        params.put("langdisplayname", WordUtils.capitalizeFully((String)locale.getDisplayName(locale)));
        params.put("uilang", uilocale.toString());
        params.put("uilangdisplayname", WordUtils.capitalizeFully((String)uilocale.getDisplayName(uilocale)));
        try {
            if (renderContext != null) {
                params.put("workspace", renderContext.getMainResource().getWorkspace());
                if (renderContext.getSite() != null) {
                    params.put("siteUuid", renderContext.getSite().getIdentifier());
                    params.put("siteKey", renderContext.getSite().getSiteKey());
                }
            } else {
                if (request.getParameter("site") != null) {
                    params.put("siteUuid", StringEscapeUtils.escapeXml((String)request.getParameter("site")));
                }
                if (request.getParameter("workspace") != null) {
                    params.put("workspace", request.getParameter("workspace"));
                } else {
                    params.put("workspace", "default");
                }
            }
        }
        catch (RepositoryException e) {
            logger.error("Error when getting site id", (Throwable)e);
        }
        if (request.getAttribute("url") != null) {
            URLGenerator url = (URLGenerator)request.getAttribute("url");
            params.put("baseUrl", url.getContext() + url.getBase());
            params.put("editUrl", url.getContext() + url.getBaseEdit());
            params.put("studioUrl", url.getContext() + url.getStudio());
            params.put("studioVisualUrl", url.getContext() + url.getStudioVisual());
            GWTInitializer.addLanguageSwitcherLinks(renderContext, params, url);
        } else {
            params.put("baseUrl", contextPath + Render.getRenderServletPath() + "/" + (String)params.get("workspace") + "/" + locale.toString());
            params.put("editUrl", contextPath + "/cms/edit/" + (String)params.get("workspace") + "/" + locale.toString());
        }
        if (SettingsBean.getInstance().isUseWebsockets()) {
            params.put("useWebsockets", "true");
        }
        if ((customCkeditorConfig = GWTInitializer.getCustomCKEditorConfig(request, renderContext)) != null) {
            params.put("ckeCfg", customCkeditorConfig);
        }
        params.put("studioMaxDisplayableFileSize", String.valueOf(SettingsBean.getInstance().getStudioMaxDisplayableFileSize()));
        params.put("serverDisplayableTimeZone", GWTInitializer.getServerDisplayableTimezone(Calendar.getInstance().getTimeZone(), uilocale));
        buf.append("<script type=\"text/javascript\">\n");
        buf.append(GWTInitializer.getJahiaGWTConfig(params));
        buf.append("\n</script>\n");
        GWTInitializer.addJavaScript(buf, request, response, renderContext);
        return buf.toString();
    }

    private static String getServerDisplayableTimezone(TimeZone timeZone, Locale locale) {
        long hours = TimeUnit.MILLISECONDS.toHours(timeZone.getRawOffset());
        long minutes = TimeUnit.MILLISECONDS.toMinutes(timeZone.getRawOffset()) - TimeUnit.HOURS.toMinutes(hours);
        minutes = Math.abs(minutes);
        if (hours > 0L) {
            return String.format("%s (GMT+%d:%02d)", timeZone.getDisplayName(locale), hours, minutes);
        }
        return String.format("%s (GMT%d:%02d)", timeZone.getDisplayName(locale), hours, minutes);
    }

    public static String getCustomCKEditorConfig(RenderContext ctx) {
        return ctx == null ? null : GWTInitializer.getCustomCKEditorConfig(ctx.getRequest(), ctx);
    }

    public static String getCustomCKEditorConfig(HttpServletRequest request, RenderContext ctx) {
        Bundle ckeditorBundle;
        JahiaTemplatesPackage ckeditorModule;
        Bundle bundle;
        JahiaTemplatesPackage pkg;
        String cfgPath = null;
        if (GWTInitializer.getConfig().isDetectCustomCKEditorConfig() && (pkg = GWTInitializer.getCurrentSiteTemplatePackage(request, ctx)) != null && (bundle = pkg.getBundle()) != null && bundle.getEntry("/javascript/ckeditor_config.js") != null) {
            cfgPath = (ctx != null ? ctx.getRequest() : request).getContextPath() + pkg.getRootFolderPath() + "/javascript/ckeditor_config.js";
        }
        if (null == cfgPath && (ckeditorModule = ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageById("ckeditor")) != null && (ckeditorBundle = ckeditorModule.getBundle()) != null && ckeditorBundle.getResource("javascript/config.js") != null) {
            cfgPath = request.getContextPath() + ckeditorModule.getRootFolderPath() + "/javascript/config.js";
        }
        return cfgPath;
    }

    private static JahiaTemplatesPackage getCurrentSiteTemplatePackage(HttpServletRequest request, RenderContext ctx) {
        JahiaTemplatesPackage pkg = null;
        if (ctx != null) {
            JCRSiteNode site = ctx.getSite();
            if (site != null) {
                pkg = site.getTemplatePackage();
            }
        } else if (request != null) {
            pkg = ContentManagerAccessCheckFilter.getCurrentSiteTemplatePackage(request);
        }
        return pkg;
    }

    private static void addCss(StringBuilder buf, HttpServletRequest request, HttpServletResponse response, boolean frame) {
        String context = request.getContextPath();
        String theme = (String)request.getSession().getAttribute("jahia.ui.theme");
        List<String> cssStyles = frame ? GWTInitializer.getConfig().getCssStylesForFrame() : GWTInitializer.getConfig().getCssStyles();
        for (String css : cssStyles) {
            if (frame && css.startsWith("/gwt/resources/css") && theme != null) {
                try {
                    String themedCss = css.replaceFirst("/gwt/resources/css", "/gwt/resources/css/" + theme);
                    if (request.getServletContext().getResource(themedCss) != null) {
                        css = themedCss;
                    }
                }
                catch (MalformedURLException e) {
                    logger.error("Invalid path", (Throwable)e);
                }
            }
            buf.append("<link type=\"text/css\" href=\"");
            if (response != null) {
                buf.append(context.isEmpty() ? response.encodeURL(css) : response.encodeURL(context + css));
            } else {
                buf.append(context).append(css);
            }
            buf.append("\" rel=\"stylesheet\"/>\n");
        }
    }

    private static void addJavaScript(StringBuilder buf, HttpServletRequest request, HttpServletResponse response, RenderContext ctx) {
        String context = request.getContextPath();
        for (String js : GWTInitializer.getConfig().getJavaScripts()) {
            buf.append("<script type=\"text/javascript\" src=\"");
            if (response != null) {
                buf.append(context.isEmpty() ? response.encodeURL(js) : response.encodeURL(context + js));
            } else {
                buf.append(context).append(js);
            }
            buf.append("\"></script>\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static GWTResourceConfig getConfig() {
        if (config != null) return config;
        Class<GWTInitializer> clazz = GWTInitializer.class;
        synchronized (GWTInitializer.class) {
            if (config != null) return config;
            config = (GWTResourceConfig)SpringContextSingleton.getBean("GWTResourceConfig");
            // ** MonitorExit[var0] (shouldn't be in output)
            return config;
        }
    }

    public static void addLanguageSwitcherLinks(RenderContext renderContext, Map<String, String> params, URLGenerator urlGenerator) {
        try {
            Set<String> languageSettings;
            JCRSiteNode currentSite = renderContext.getSite();
            if (currentSite != null && (languageSettings = currentSite.getLanguages()) != null && languageSettings.size() > 0) {
                for (String lang : languageSettings) {
                    params.put(lang, urlGenerator.getLanguages().get(lang));
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while creating change site link", (Throwable)e);
        }
    }

    public static String getJahiaGWTConfig(Map<String, String> params) {
        StringBuilder s = new StringBuilder();
        s.append("var jahiaGWTParameters={");
        if (params != null) {
            boolean b = false;
            for (Map.Entry<String, String> param : params.entrySet()) {
                if (param.getValue() == null) continue;
                if (b) {
                    s.append(",");
                } else {
                    b = true;
                }
                s.append("\"").append(StringEscapeUtils.escapeJavaScript((String)param.getKey())).append("\":\"").append(StringEscapeUtils.escapeJavaScript((String)String.valueOf(param.getValue()))).append("\"");
            }
        }
        s.append("}; contextJsParameters=jahiaGWTParameters;");
        return s.toString();
    }

    private static String buildServiceBaseEntrypointUrl(HttpServletRequest request) {
        return request.getContextPath() + "/gwt/";
    }

    static {
        logger = LoggerFactory.getLogger(GWTInitializer.class);
    }
}

