/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.Action;
import org.jahia.bin.ActionResult;
import org.jahia.bin.Render;
import org.jahia.services.content.CompositeConstraintViolationException;
import org.jahia.services.content.JCRCallback;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRTemplate;
import org.jahia.services.logging.MetricsLoggingService;
import org.jahia.services.render.RenderContext;
import org.jahia.services.render.Resource;
import org.jahia.services.render.URLResolver;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.tools.files.FileUpload;
import org.jahia.utils.Patterns;
import org.json.JSONObject;

public class DefaultPostAction
extends Action {
    public static final String ACTION_NAME = "default";
    private MetricsLoggingService loggingService;

    public DefaultPostAction() {
        this.setName(ACTION_NAME);
    }

    public MetricsLoggingService getLoggingService() {
        return this.loggingService;
    }

    public void setLoggingService(MetricsLoggingService loggingService) {
        this.loggingService = loggingService;
    }

    @Override
    public ActionResult doExecute(HttpServletRequest req, RenderContext renderContext, Resource resource, final JCRSessionWrapper session, final Map<String, List<String>> parameters, URLResolver urlResolver) throws Exception {
        JCRNodeWrapper newNode = null;
        String[] subPaths = Patterns.SLASH.split(urlResolver.getPath());
        String lastPath = subPaths[subPaths.length - 1];
        JCRNodeWrapper node = null;
        StringBuilder realPath = new StringBuilder();
        String startPath = "";
        int index = 0;
        for (String subPath : subPaths) {
            if (!StringUtils.isNotBlank((String)subPath) || "*".equals(subPath) || ++index == subPaths.length) continue;
            realPath.append("/").append(subPath);
            try {
                session.getNode(JCRContentUtils.escapeNodePath(realPath.toString()));
                startPath = "";
            }
            catch (PathNotFoundException e) {
                if (!"".equals(startPath)) continue;
                startPath = realPath.substring(0, realPath.lastIndexOf("/"));
            }
        }
        startPath = "".equals(startPath) ? realPath.toString() : startPath;
        realPath = realPath.delete(0, realPath.length());
        index = 0;
        for (String subPath : subPaths) {
            if (!StringUtils.isNotBlank((String)subPath) || "*".equals(subPath) || ++index == subPaths.length) continue;
            realPath.append("/").append(subPath);
            if (!realPath.toString().contains(startPath)) continue;
            try {
                node = session.getNode(JCRContentUtils.escapeNodePath(realPath.toString()));
            }
            catch (PathNotFoundException e) {
                if (node == null) continue;
                if (!node.isCheckedOut()) {
                    session.checkout(node);
                }
                Iterator<Map.Entry<String, DiskFileItem>> parentType = "jnt:contentList";
                if (parameters.containsKey("jcrParentType")) {
                    parentType = parameters.get("jcrParentType").get(0);
                }
                node = node.addNode(subPath, (String)((Object)parentType));
            }
        }
        if (node != null) {
            String nodeType = null;
            if (parameters.containsKey("jcrNodeType")) {
                nodeType = parameters.get("jcrNodeType").get(0);
            }
            if (StringUtils.isBlank(nodeType)) {
                return ActionResult.BAD_REQUEST;
            }
            String nodeName = null;
            if (parameters.containsKey("jcrNodeName")) {
                nodeName = parameters.get("jcrNodeName").get(0);
            }
            boolean forceCreation = false;
            if (!"*".equals(lastPath)) {
                nodeName = lastPath;
            } else {
                forceCreation = true;
            }
            try {
                newNode = this.createNode(req, parameters, node, nodeType, nodeName, forceCreation);
                FileUpload fileUpload = (FileUpload)req.getAttribute("fileUpload");
                if (fileUpload != null && fileUpload.getFileItems() != null && fileUpload.getFileItems().size() > 0) {
                    Map<String, DiskFileItem> stringDiskFileItemMap = fileUpload.getFileItems();
                    for (Map.Entry<String, DiskFileItem> itemEntry : stringDiskFileItemMap.entrySet()) {
                        newNode.uploadFile(itemEntry.getValue().getName(), itemEntry.getValue().getInputStream(), JCRContentUtils.getMimeType(itemEntry.getValue().getName(), itemEntry.getValue().getContentType()));
                    }
                }
                session.save();
            }
            catch (CompositeConstraintViolationException e) {
                ArrayList<JSONObject> jsonErrors = new ArrayList<JSONObject>();
                for (ConstraintViolationException exception : e.getErrors()) {
                    jsonErrors.add(this.getJSONConstraintError(exception));
                }
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("validationError", jsonErrors);
                return new ActionResult(400, null, jsonObject);
            }
            catch (ConstraintViolationException e) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("validationError", Arrays.asList(this.getJSONConstraintError(e)));
                return new ActionResult(400, null, jsonObject);
            }
            final String nodeId = newNode.getIdentifier();
            if (parameters.containsKey("jcrAutoAssignRole") && !JahiaUserManagerService.isGuest(session.getUser())) {
                JCRTemplate.getInstance().doExecuteWithSystemSessionAsUser(session.getUser(), session.getWorkspace().getName(), null, new JCRCallback<Object>(){

                    @Override
                    public Object doInJCR(JCRSessionWrapper rootSession) throws RepositoryException {
                        JCRNodeWrapper createdNode = rootSession.getNodeByUUID(nodeId);
                        List roles = (List)parameters.get("jcrAutoAssignRole");
                        createdNode.grantRoles("u:" + session.getUser().getName(), new HashSet<String>(roles));
                        rootSession.save();
                        return null;
                    }
                });
            }
            if (parameters.containsKey("jcrAutoCheckin") && parameters.get("jcrAutoCheckin").get(0).length() > 0) {
                newNode.checkpoint();
            }
        }
        String sessionID = "";
        HttpSession httpSession = req.getSession(false);
        if (httpSession != null) {
            sessionID = httpSession.getId();
        }
        String nodeIdentifier = null;
        if (newNode != null) {
            nodeIdentifier = newNode.getIdentifier();
        }
        if (this.loggingService.isEnabled()) {
            this.loggingService.logContentEvent(renderContext.getUser().getName(), req.getRemoteAddr(), sessionID, nodeIdentifier, urlResolver.getPath(), parameters.get("jcrNodeType").get(0), "nodeCreated", new JSONObject(parameters).toString());
        }
        if (newNode != null) {
            return new ActionResult(201, newNode.getPath(), Render.serializeNodeToJSON(newNode));
        }
        return null;
    }
}

