/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.JahiaController;
import org.jahia.bin.errors.DefaultErrorHandler;
import org.jahia.exceptions.JahiaBadRequestException;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaForbiddenAccessException;
import org.jahia.exceptions.JahiaUnauthorizedException;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.content.JCRContentUtils;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.decorator.JCRSiteNode;
import org.jahia.services.importexport.ImportExportBaseService;
import org.jahia.services.importexport.ImportExportService;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.usermanager.JahiaUser;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.WebUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.ModelAndView;
import org.xml.sax.SAXException;

public class Export
extends JahiaController
implements ServletContextAware {
    private static final Logger logger = LoggerFactory.getLogger(Export.class);
    public static final String CLEANUP = "cleanup";
    private static final String CONTROLLER_MAPPING = "/export";
    private static final String EXPORT_SITES_REQUIRED_PERMISSION = "adminVirtualSites";
    private static final Pattern URI_PATTERN = Pattern.compile("/export/(live|default)/(.*)\\.(xml|zip)");
    private static final String MEDIATYPE_ZIP = "application/zip";
    private static final String MEDIATYPE_XML = "text/xml";
    private String cleanupXsl;
    private boolean downloadExportedXmlAsFile;
    private ImportExportService importExportService;
    private String templatesCleanupXsl;

    public static String getExportServletPath() {
        return "/cms/export";
    }

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            this.checkUserLoggedIn();
            Matcher m = this.getMatcher(request);
            String workspace = m.group(1);
            String nodePath = JCRContentUtils.escapeNodePath(String.format("/%s", m.group(2)));
            String exportFormat = m.group(3);
            JCRNodeWrapper exportRoot = null;
            JCRSessionWrapper session = JCRSessionFactory.getInstance().getCurrentUserSession(workspace).disableSessionCache();
            Map<String, Object> params = this.getRequestParams(request);
            if (StringUtils.isNotEmpty((String)request.getParameter("exportformat"))) {
                exportFormat = this.validateExportFormatType(request.getParameter("exportformat"));
            }
            switch (exportFormat.trim().toLowerCase()) {
                case "all": {
                    this.checkUserAuthorized(session.getNode("/").getResolveSite());
                    this.handleExportFormatTypeAll(response, params, session);
                    break;
                }
                case "site": {
                    this.checkUserAuthorized(session.getNode("/").getResolveSite());
                    this.handleExportFormatTypeSite(request, response, params, session);
                    break;
                }
                case "xml": {
                    this.checkUserAuthorized(session.getNode(nodePath).getResolveSite());
                    exportRoot = request.getParameter("root") != null ? session.getNode(request.getParameter("root")) : null;
                    this.handleExportFormatTypeXML(request, response, nodePath, params, session, exportRoot);
                    break;
                }
                case "zip": {
                    this.checkUserAuthorized(session.getNode(nodePath).getResolveSite());
                    exportRoot = request.getParameter("root") != null ? session.getNode(request.getParameter("root")) : null;
                    this.handleExportFormatTypeZip(request, response, nodePath, params, session, exportRoot);
                    break;
                }
                default: {
                    logger.error("Export format type entered is {} which is not recognized or handled yet", (Object)exportFormat);
                    throw new JahiaBadRequestException("exportFormat parameter needs to be one of ALL, SITE, XML, or ZIP");
                }
            }
            response.setStatus(200);
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Cannot export due to some IO exception ", (Throwable)e);
            } else {
                logger.warn("Cannot export due to some IO exception {}", (Object)e.getMessage());
            }
            DefaultErrorHandler.getInstance().handle(e, request, response);
        }
        catch (Exception e) {
            logger.error("Cannot export", (Throwable)e);
            DefaultErrorHandler.getInstance().handle(e, request, response);
        }
        return null;
    }

    private String validateExportFormatType(String exportformat) {
        String formatType = exportformat.trim().toLowerCase();
        if (formatType.equals("zip") || formatType.equals("xml") || formatType.equals("site") || formatType.equals("all")) {
            return formatType;
        }
        logger.error("Unable to handle export format type {}.", (Object)exportformat);
        throw new JahiaBadRequestException("Unable to handle export format");
    }

    private Matcher getMatcher(HttpServletRequest request) {
        Matcher m;
        Matcher matcher = m = StringUtils.isNotEmpty((String)request.getPathInfo()) ? URI_PATTERN.matcher(request.getPathInfo()) : null;
        if (m == null || !m.matches()) {
            throw new JahiaBadRequestException("Requested URI '" + request.getRequestURI() + "' is malformed");
        }
        return m;
    }

    private void handleExportFormatTypeZip(HttpServletRequest request, HttpServletResponse response, String nodePath, Map<String, Object> params, JCRSessionWrapper session, JCRNodeWrapper exportRoot) throws RepositoryException, IOException, SAXException, TransformerException, JahiaForbiddenAccessException {
        String filesToZip;
        JCRNodeWrapper sessionNode = session.getNode(nodePath);
        ServletOutputStream outputStream = response.getOutputStream();
        Cookie exportedNodeCookie = new Cookie("exportedNode", sessionNode.getIdentifier());
        exportedNodeCookie.setSecure(request.isSecure());
        response.setContentType(MEDIATYPE_ZIP);
        WebUtils.setNoCacheHeaders(response);
        if ("template".equals(request.getParameter(CLEANUP))) {
            params.put("xsl_path", this.templatesCleanupXsl);
        } else if ("simple".equals(request.getParameter(CLEANUP))) {
            params.put("xsl_path", this.cleanupXsl);
        }
        if (request.getParameter("live") == null || Boolean.valueOf(request.getParameter("live")).booleanValue()) {
            params.put("includeLive", Boolean.TRUE);
        }
        if ((filesToZip = request.getParameter("filesToZip")) != null) {
            String[] stringArray;
            if (StringUtils.isEmpty((String)filesToZip)) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = nodePath;
            } else {
                stringArray = this.extractJCRFilesPathFromJson(new String(Base64.getDecoder().decode(filesToZip), StandardCharsets.UTF_8));
            }
            String[] files = stringArray;
            params.put("filesToZip", files);
        }
        exportedNodeCookie.setMaxAge(60);
        exportedNodeCookie.setPath("/");
        response.addCookie(exportedNodeCookie);
        this.importExportService.exportZip(sessionNode, exportRoot, (OutputStream)outputStream, params);
        outputStream.close();
    }

    private String[] extractJCRFilesPathFromJson(String jsonAsString) {
        try {
            JSONArray json = new JSONArray(jsonAsString);
            String[] array = new String[json.length()];
            for (int i = 0; i < json.length(); ++i) {
                array[i] = json.getString(i);
            }
            return array;
        }
        catch (JSONException e) {
            logger.warn("Unable to read json files {}", (Object)jsonAsString);
            return new String[0];
        }
    }

    private void handleExportFormatTypeXML(HttpServletRequest request, HttpServletResponse response, String nodePath, Map<String, Object> params, JCRSessionWrapper session, JCRNodeWrapper exportRoot) throws RepositoryException, IOException, SAXException, TransformerException {
        JCRNodeWrapper sessionNode = session.getNode(nodePath);
        ServletOutputStream outputStream = response.getOutputStream();
        Cookie exportedNodeCookie = new Cookie("exportedNode", sessionNode.getIdentifier());
        exportedNodeCookie.setSecure(request.isSecure());
        response.setContentType(MEDIATYPE_XML);
        WebUtils.setNoCacheHeaders(response);
        if (this.downloadExportedXmlAsFile) {
            WebUtils.setFileDownloadHeaders(response, String.format("%s.xml", StringUtils.substringBeforeLast((String)sessionNode.getName(), (String)".")));
        }
        if ("template".equals(request.getParameter(CLEANUP))) {
            params.put("xsl_path", this.templatesCleanupXsl);
        } else if ("simple".equals(request.getParameter(CLEANUP))) {
            params.put("xsl_path", this.cleanupXsl);
        }
        exportedNodeCookie.setMaxAge(60);
        exportedNodeCookie.setPath("/");
        response.addCookie(exportedNodeCookie);
        this.importExportService.exportNode(sessionNode, exportRoot, (OutputStream)outputStream, params);
        outputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleExportFormatTypeSite(HttpServletRequest request, HttpServletResponse response, Map<String, Object> params, JCRSessionWrapper session) throws JahiaException, IOException, RepositoryException, SAXException, TransformerException {
        List<JCRSiteNode> sites = this.getJcrSiteNodes(request);
        JahiaUser currentUser = session.getUser();
        boolean isElevated = false;
        try {
            if (!sites.isEmpty()) {
                isElevated = this.elevateSecurityPrivilege(session);
                response.setContentType(MEDIATYPE_ZIP);
                WebUtils.setNoCacheHeaders(response);
                params.put("includeRoles", Boolean.TRUE);
                params.put("includeMounts", Boolean.TRUE);
                params.put("wf", Boolean.TRUE);
                params.put("xsl_path", this.cleanupXsl);
                params.put("allfiles", Boolean.TRUE);
                params.put("templates", Boolean.TRUE);
                params.put("siteinfos", Boolean.TRUE);
                params.put("definitions", Boolean.TRUE);
                if (request.getParameter("live") == null || Boolean.valueOf(request.getParameter("live")).booleanValue()) {
                    params.put("includeLive", Boolean.TRUE);
                }
                this.handleUserParameter(request, params);
                ServletOutputStream outputStream = response.getOutputStream();
                this.importExportService.exportSites((OutputStream)outputStream, params, sites);
                outputStream.close();
            }
        }
        finally {
            if (isElevated) {
                this.restoreSecurityPrivilege(currentUser);
            }
        }
    }

    private void handleUserParameter(HttpServletRequest request, Map<String, Object> params) {
        String userParameter = "users";
        if (request.getParameter("users") == null && SettingsBean.getInstance().getPropertiesFile().getProperty("siteExportUsersDefaultValue") != null) {
            boolean siteExportUsersDefaultValue = Boolean.parseBoolean(SettingsBean.getInstance().getPropertiesFile().getProperty("siteExportUsersDefaultValue"));
            if (siteExportUsersDefaultValue) {
                params.put("includeUsers", Boolean.TRUE);
            } else {
                params.remove("includeUsers");
            }
        } else if (request.getParameter("users") != null) {
            if (Boolean.parseBoolean(request.getParameter("users"))) {
                params.put("includeUsers", Boolean.TRUE);
            } else {
                params.remove("includeUsers");
            }
        } else {
            params.put("includeUsers", Boolean.TRUE);
        }
    }

    private List<JCRSiteNode> getJcrSiteNodes(HttpServletRequest request) throws JahiaException {
        ArrayList<JCRSiteNode> sites = new ArrayList<JCRSiteNode>();
        String[] sitekeys = request.getParameterValues("sitebox");
        if (sitekeys != null) {
            for (String sitekey : sitekeys) {
                JahiaSite site = ServicesRegistry.getInstance().getJahiaSitesService().getSiteByKey(sitekey);
                sites.add((JCRSiteNode)site);
            }
        }
        return sites;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleExportFormatTypeAll(HttpServletResponse response, Map<String, Object> params, JCRSessionWrapper session) throws IOException, JahiaException, RepositoryException, SAXException, TransformerException {
        JahiaUser currentUser = session.getUser();
        boolean isElevated = false;
        try {
            isElevated = this.elevateSecurityPrivilege(session);
            response.setContentType(MEDIATYPE_ZIP);
            WebUtils.setNoCacheHeaders(response);
            params.put("allfiles", Boolean.TRUE);
            params.put("templates", Boolean.TRUE);
            params.put("siteinfos", Boolean.TRUE);
            params.put("definitions", Boolean.TRUE);
            params.put("wf", Boolean.TRUE);
            params.put("xsl_path", this.cleanupXsl);
            ServletOutputStream outputStream = response.getOutputStream();
            this.importExportService.exportAll((OutputStream)outputStream, params);
            outputStream.close();
        }
        finally {
            if (isElevated) {
                this.restoreSecurityPrivilege(currentUser);
            }
        }
    }

    private boolean elevateSecurityPrivilege(JCRSessionWrapper session) throws JahiaForbiddenAccessException, RepositoryException {
        if (!session.getUser().isRoot()) {
            this.checkAuthorization(session);
            logger.debug("Elevating security");
            JCRSessionFactory.getInstance().setCurrentUser(JahiaUserManagerService.getInstance().lookupRootUser().getJahiaUser());
        }
        return !JCRSessionFactory.getInstance().getCurrentUser().equals(session.getUser());
    }

    private void restoreSecurityPrivilege(JahiaUser user) {
        logger.debug("Restoring security permission back");
        JCRSessionFactory.getInstance().setCurrentUser(user);
    }

    private void checkAuthorization(JCRSessionWrapper session) throws RepositoryException, JahiaForbiddenAccessException {
        if (JahiaUserManagerService.isGuest(session.getUser())) {
            throw new JahiaUnauthorizedException("User guest is not allowed to export site content");
        }
        if (!session.getRootNode().hasPermission(EXPORT_SITES_REQUIRED_PERMISSION)) {
            throw new JahiaForbiddenAccessException("User does not have sufficient permission to perform export of site content");
        }
    }

    private Map<String, Object> getRequestParams(HttpServletRequest request) throws IOException {
        String exportPath;
        HashMap<String, Object> params = new HashMap<String, Object>(6);
        params.put("content", Boolean.valueOf(request.getParameter("viewContent")));
        params.put("version", Boolean.valueOf(request.getParameter("viewVersion")));
        params.put("acl", Boolean.valueOf(request.getParameter("viewAcl")));
        params.put("metadata", Boolean.valueOf(request.getParameter("viewMetadata")));
        params.put("links", Boolean.valueOf(request.getParameter("viewLinks")));
        params.put("wf", Boolean.valueOf(request.getParameter("viewWorkflow")));
        String[] paths = request.getParameterValues("path");
        if (paths != null) {
            params.put("includePaths", paths);
        }
        if (StringUtils.isNotBlank((String)(exportPath = request.getParameter("exportPath")))) {
            String serverDirectory = ImportExportBaseService.updatedServerDirectoryPath(exportPath);
            if (serverDirectory != null && ImportExportBaseService.isValidServerDirectory(serverDirectory)) {
                params.put("serverDirectory", serverDirectory);
            } else {
                logger.error("Failed validation to the path {}. Check logs for more details", (Object)serverDirectory);
                throw new JahiaBadRequestException("exportPath parameter is invalid.");
            }
        }
        return params;
    }

    public void setServletContext(ServletContext servletContext) {
        this.cleanupXsl = servletContext.getRealPath("/WEB-INF/etc/repository/export/cleanup.xsl");
        this.templatesCleanupXsl = servletContext.getRealPath("/WEB-INF/etc/repository/export/templatesCleanup.xsl");
    }

    public void setImportExportService(ImportExportService importExportService) {
        this.importExportService = importExportService;
    }

    public void setDownloadExportedXmlAsFile(boolean downloadExportedXmlAsFile) {
        this.downloadExportedXmlAsFile = downloadExportedXmlAsFile;
    }
}

