/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin;

import com.ibm.icu.text.DateFormat;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.api.Constants;
import org.jahia.bin.listeners.JahiaContextLoaderListener;
import org.jahia.commons.Version;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.settings.SettingsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Jahia {
    public static final String YEAR = "2025";
    public static final String CODE_NAME = "Kimchi";
    public static final String PRODUCT_NAME = "Jahia";
    public static final String VENDOR_NAME = "Jahia Solutions Group SA";
    public static final String COPYRIGHT = "&copy; Copyright 2002-2025  <a href=\"https://www.jahia.com\" target=\"newJahia\">Jahia Solutions Group SA</a> -";
    public static final String COPYRIGHT_TXT = "2025 Jahia Solutions Group SA";
    private static final Logger logger = LoggerFactory.getLogger(Jahia.class);
    private static final Version JAHIA_VERSION;
    public static final String LOGGER_INVALID_SUPPORTED_JDK_VERSIONS = "Invalid supported_jdk_versions initialization parameter in web.xml, it MUST be in the ";
    private static final DateTimeFormatter BUILD_DATE_PATTERN;
    private static final DateTimeFormatter UTC_FORMATTER;
    private static final String GIT_PROPERTIES = "git.properties";
    private static final String GIT_COMMIT_ID_ABBREV = "git.commit.id.abbrev";
    public static final String VERSION;
    private static final String INIT_PARAM_SUPPORTED_JDK_VERSIONS = "supported_jdk_versions";
    private static String jahiaServletPath;
    private static String jahiaContextPath;
    private static boolean maintenance;
    private static volatile int eeBuildNumber;
    private static volatile String edition;
    private static volatile String buildDate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBuildNumber() {
        Properties properties = new Properties();
        Class<Jahia> clazz = Jahia.class;
        synchronized (Jahia.class) {
            try {
                properties.load(Jahia.class.getClassLoader().getResourceAsStream(GIT_PROPERTIES));
            }
            catch (IOException e) {
                logger.error("Properties file wasn't read properly", (Throwable)e);
            }
            return properties.getProperty(GIT_COMMIT_ID_ABBREV);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getBuildDate() {
        if (buildDate != null) return buildDate;
        Class<Jahia> clazz = Jahia.class;
        synchronized (Jahia.class) {
            if (buildDate != null) return buildDate;
            try {
                URL urlToVersionMarker = Jahia.class.getResource("/META-INF/jahia-impl-marker.txt");
                if (urlToVersionMarker != null) {
                    URLConnection conn = urlToVersionMarker.openConnection();
                    long lastModified = conn instanceof JarURLConnection ? ((JarURLConnection)conn).getJarEntry().getTime() : conn.getLastModified();
                    buildDate = DateFormat.getDateTimeInstance((int)1, (int)1, (Locale)Locale.ENGLISH).format(new Date(lastModified));
                } else {
                    buildDate = "";
                }
            }
            catch (IOException ioe) {
                logger.error(ioe.getMessage(), (Throwable)ioe);
                buildDate = "";
            }
            return buildDate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getEEBuildNumber() {
        if (eeBuildNumber != -1) return eeBuildNumber;
        Class<Jahia> clazz = Jahia.class;
        synchronized (Jahia.class) {
            if (eeBuildNumber != -1) return eeBuildNumber;
            eeBuildNumber = Jahia.getBuildNumber("/META-INF/jahia-ee-impl-marker.txt");
            // ** MonitorExit[var0] (shouldn't be in output)
            return eeBuildNumber;
        }
    }

    public static int getBuildNumber(String markerFilePathName) {
        int buildNumber = 0;
        try (InputStream in = Jahia.class.getResourceAsStream(markerFilePathName);){
            String number = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            buildNumber = Integer.parseInt(number);
        }
        catch (IOException | NumberFormatException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return buildNumber;
    }

    public static String getReleaseNumber() {
        return JAHIA_VERSION.getMajorVersion() + "." + JAHIA_VERSION.getMinorVersion();
    }

    public static String getLicenseText() {
        String txt;
        try (InputStream in = JahiaContextLoaderListener.getServletContext().getResourceAsStream("/LICENSE");){
            txt = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            txt = "Unable to parse licence file";
        }
        return txt;
    }

    public static int getPatchNumber() {
        return JAHIA_VERSION.getPatchVersion();
    }

    public static int getServicePackNumber() {
        return JAHIA_VERSION.getServicePackVersion();
    }

    public static void verifyJavaVersion(String supportedJDKVersions) throws JahiaInitializationException {
        if (supportedJDKVersions != null) {
            try {
                Version currentJDKVersion = new Version(System.getProperty("java.version"));
                if (Arrays.stream(StringUtils.split((String)supportedJDKVersions, (char)',')).noneMatch(v -> Jahia.isSupportedJDKVersion(currentJDKVersion, v.trim()))) {
                    String jemsg = "WARNING\n\nYou are using an unsupported JDK version\nor have an invalid supported_jdk_versions parameter string in \nthe deployment descriptor file web.xml.\n\n\nHere is the range specified in the web.xml file : " + supportedJDKVersions + ".\n\nIf you want to disable this warning, remove the supported_jdk_versions\n\ninitialization parameter in the WEB-INF/web.xml\n\n\n\nPlease note that if you deactivate this check or use unsupported versions\n\n\nYou might run into serious problems and we cannot offer support for these.\n\n\nYou may download a supported JDK from Oracle site: http://www.oracle.com/technetwork/java/javase/downloads/index.html\n\n&nbsp;\n";
                    JahiaInitializationException e = new JahiaInitializationException(jemsg);
                    logger.error("Invalid JDK version", (Throwable)e);
                    throw e;
                }
            }
            catch (NumberFormatException nfe) {
                logger.warn("Couldn't convert JDK version to internal version testing system, ignoring JDK version test...", (Throwable)nfe);
            }
        }
    }

    public static String getServletPath() {
        return jahiaServletPath;
    }

    public static String getContextPath() {
        return jahiaContextPath;
    }

    public static void setContextPath(String contextPath) {
        jahiaContextPath = contextPath;
    }

    @Deprecated(since="7.1.0.0")
    public static SettingsBean getSettings() {
        return SettingsBean.getInstance();
    }

    public static boolean isMaintenance() {
        return maintenance || SettingsBean.getInstance().isMaintenanceMode();
    }

    public static void setMaintenance(boolean maintenance) {
        if (SettingsBean.getInstance().isMaintenanceMode()) {
            logger.info("Maintenance mode has been enforced in Jahia properties, impossible to change at runtime level.");
        }
        Jahia.maintenance = maintenance;
    }

    private static boolean isSupportedJDKVersion(Version currentJDKVersion, String supportedJDKString) {
        Version upperVersion;
        String rightVersionStr;
        Version lowerVersion;
        String leftVersionStr;
        if (supportedJDKString == null) {
            return true;
        }
        String workString = supportedJDKString.toLowerCase();
        int xPos = workString.indexOf(120);
        if (xPos == -1) {
            logger.debug("{} following format : 1.2 < x <= 1.3 (the 'x' character is mandatory and was missing in this case : [{}] )", (Object)LOGGER_INVALID_SUPPORTED_JDK_VERSIONS, (Object)supportedJDKString);
            return false;
        }
        String leftArg = workString.substring(0, xPos).trim();
        String rightArg = workString.substring(xPos + 1).trim();
        if (leftArg.endsWith("<=")) {
            leftVersionStr = leftArg.substring(0, leftArg.length() - 2).trim();
            try {
                lowerVersion = new Version(leftVersionStr);
            }
            catch (NumberFormatException nfe) {
                logger.error("Error in lower version number conversion", (Throwable)nfe);
                return false;
            }
            if (lowerVersion.compareTo(currentJDKVersion) > 0) {
                return false;
            }
        } else if (leftArg.endsWith("<")) {
            leftVersionStr = leftArg.substring(0, leftArg.length() - 1).trim();
            try {
                lowerVersion = new Version(leftVersionStr);
            }
            catch (NumberFormatException nfe) {
                logger.error("Error in lower number conversion", (Throwable)nfe);
                return false;
            }
            if (lowerVersion.compareTo(currentJDKVersion) >= 0) {
                return false;
            }
        } else {
            logger.error("{} following format : 1.2 < x <= 1.3. Current string : [{}] )", (Object)LOGGER_INVALID_SUPPORTED_JDK_VERSIONS, (Object)supportedJDKString);
            return false;
        }
        if (rightArg.startsWith("<=")) {
            rightVersionStr = rightArg.substring(2).trim();
            try {
                upperVersion = new Version(rightVersionStr);
            }
            catch (NumberFormatException nfe) {
                logger.error("Error in upper number conversion", (Throwable)nfe);
                return false;
            }
            if (upperVersion.compareTo(currentJDKVersion) < 0) {
                return false;
            }
        } else if (rightArg.startsWith("<")) {
            rightVersionStr = rightArg.substring(1).trim();
            try {
                upperVersion = new Version(rightVersionStr);
            }
            catch (NumberFormatException nfe) {
                logger.error("Error in upper number conversion", (Throwable)nfe);
                return false;
            }
            if (upperVersion.compareTo(currentJDKVersion) <= 0) {
                return false;
            }
        } else {
            logger.error("{} following format : 1.2 < x <= 1.3. Current string : [{}] )", (Object)LOGGER_INVALID_SUPPORTED_JDK_VERSIONS, (Object)supportedJDKString);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getEdition() {
        if (edition != null) return edition;
        Class<Jahia> clazz = Jahia.class;
        synchronized (Jahia.class) {
            if (edition != null) return edition;
            edition = Jahia.class.getResource("/META-INF/jahia-ee-impl-marker.txt") != null ? "EE" : "CE";
            // ** MonitorExit[var0] (shouldn't be in output)
            return edition;
        }
    }

    public static boolean isEnterpriseEdition() {
        return "EE".equals(Jahia.getEdition());
    }

    public static String getFullProductVersion() {
        StringBuilder version = new StringBuilder();
        if (JAHIA_VERSION.toString().endsWith("SNAPSHOT")) {
            try {
                Properties properties = new Properties();
                properties.load(Jahia.class.getClassLoader().getResourceAsStream(GIT_PROPERTIES));
                version.append(PRODUCT_NAME).append(" ").append(VERSION).append(" [Kimchi] - Build: ").append(properties.getProperty(GIT_COMMIT_ID_ABBREV)).append(" - Built on: ").append(ZonedDateTime.parse(properties.getProperty("git.build.time"), BUILD_DATE_PATTERN).format(UTC_FORMATTER));
            }
            catch (IOException e) {
                logger.error("Properties file wasn't read properly", (Throwable)e);
            }
        } else {
            version.append(PRODUCT_NAME).append(" ").append(VERSION);
        }
        return version.toString();
    }

    static {
        BUILD_DATE_PATTERN = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZ");
        UTC_FORMATTER = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG).withZone(ZoneId.of("UTC"));
        Version v = null;
        try {
            v = new Version(Constants.JAHIA_PROJECT_VERSION);
        }
        catch (NumberFormatException e) {
            logger.error("Version number is not correct", (Throwable)e);
        }
        JAHIA_VERSION = v != null ? v : new Version("8.0.0.0");
        VERSION = JAHIA_VERSION.getMajorVersion() + "." + JAHIA_VERSION.getMinorVersion() + "." + JAHIA_VERSION.getServicePackVersion() + "." + JAHIA_VERSION.getPatchVersion();
        maintenance = false;
        eeBuildNumber = -1;
    }
}

