/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin.errors;

import java.io.IOException;
import java.net.MalformedURLException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jahia.bin.errors.ErrorLoggingFilter;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.params.valves.LoginConfig;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.render.URLResolver;
import org.jahia.services.render.URLResolverFactory;
import org.jahia.services.seo.urlrewrite.SessionidRemovalResponseWrapper;
import org.jahia.services.sites.JahiaSite;
import org.jahia.services.sites.JahiaSitesService;
import org.jahia.services.templates.JahiaTemplateManagerService;
import org.jahia.settings.SettingsBean;
import org.jahia.utils.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorServlet
extends HttpServlet {
    public static final String LICENSE_TERMS_VIOLATION_MODE = "Jahia License Violation";
    private static final Logger logger = LoggerFactory.getLogger(ErrorServlet.class);
    public static final String MAINTENANCE_MODE = "Jahia in under maintenance";
    private static final long serialVersionUID = -6990851339777685000L;
    private transient boolean siteLevelErrorPagesEnabled;
    private transient JahiaSitesService sitesService;
    private transient JahiaTemplateManagerService templateService;
    private transient URLResolverFactory urlResolverFactory;

    protected void forwardToErrorPage(String errorPagePath, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (null == errorPagePath) {
            logger.info("No appropriate error page found for error code '" + this.getErrorCode(request) + "'. Using server's default page.");
            throw new JahiaRuntimeException("No appropriate error page found. Server's default page will be used.");
        }
        logger.debug("Forwarding request to the following error page: {}", (Object)errorPagePath);
        request.setAttribute("org.jahia.exception.forwarded", (Object)Boolean.TRUE);
        try {
            this.getServletContext().getRequestDispatcher(errorPagePath).forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Throwable e) {
            logger.error("Unable to process error page {}", (Object)errorPagePath, (Object)e);
            request.setAttribute("org.jahia.exception", (Object)e);
            this.getServletContext().getRequestDispatcher(this.getErrorPagePath("error.jsp", null)).forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected int getErrorCode(HttpServletRequest request) {
        int errorCode = (Integer)request.getAttribute("javax.servlet.error.status_code");
        return errorCode != 0 ? errorCode : 500;
    }

    protected String getErrorPagePath(HttpServletRequest request) throws IOException {
        String siteKey;
        boolean isEdit;
        String path = null;
        int errorCode = this.getErrorCode(request);
        String page = this.getDedicateErrorPage(errorCode);
        URLResolver urlResolver = (URLResolver)request.getAttribute("urlResolver");
        boolean bl = isEdit = urlResolver != null && !urlResolver.getServletPart().equals("render");
        if (this.siteLevelErrorPagesEnabled && !isEdit && (siteKey = this.resolveSiteKey(request)) != null && null == (path = this.getSiteSpecificErrorPagePath(page, siteKey))) {
            path = this.getModuleErrorPagePath(page, siteKey);
        }
        if (isEdit && !urlResolver.getServletPart().equals("studio")) {
            path = this.getErrorPagePath(page, "react");
        }
        if (null == path && null == (path = this.getErrorPagePath(page, null))) {
            path = this.getErrorPagePath("error.jsp", null);
        }
        return path;
    }

    private String getModuleErrorPagePath(String page, String siteKey) {
        try {
            JahiaTemplatesPackage pkg;
            JahiaSite site = this.sitesService.getSiteByKey(siteKey);
            if (site != null && (pkg = this.templateService.getTemplatePackage(site.getTemplatePackageName())) != null) {
                if (pkg.getResource("/errors/" + page) != null) {
                    return "/modules/" + pkg.getId() + "/errors/" + page;
                }
                if (pkg.getResource("/errors/error.jsp") != null) {
                    return "/modules/" + pkg.getId() + "/errors/error.jsp";
                }
            }
        }
        catch (JahiaException e) {
            logger.debug("Cannot find site", (Throwable)e);
        }
        return null;
    }

    private String getSiteSpecificErrorPagePath(String page, String siteKey) throws MalformedURLException {
        String path;
        String pathToCheck = "/errors/sites/" + siteKey + "/" + page;
        if (this.getServletContext().getResource(pathToCheck) != null) {
            path = pathToCheck;
        } else {
            pathToCheck = "/errors/sites/" + siteKey + "/error.jsp";
            path = this.getServletContext().getResource(pathToCheck) != null ? pathToCheck : null;
        }
        return path;
    }

    private String getDedicateErrorPage(int errorCode) {
        switch (errorCode) {
            case 400: 
            case 401: 
            case 403: 
            case 404: 
            case 503: {
                return "error_" + errorCode + ".jsp";
            }
        }
        return "error.jsp";
    }

    private String getErrorPagePath(String page, String theme) throws MalformedURLException {
        boolean defaultTheme = theme == null || "default".equals(theme);
        String path = defaultTheme ? "/errors/" + page : "/errors/" + theme + "/" + page;
        if (this.getServletContext().getResource(path) != null) {
            return path;
        }
        if (defaultTheme) {
            return null;
        }
        return this.getErrorPagePath(page, null);
    }

    protected String resolveSiteKey(HttpServletRequest request) {
        String siteKey = (String)request.getAttribute("siteKey");
        if (siteKey != null) {
            return siteKey;
        }
        try {
            URLResolver urlResolver = (URLResolver)request.getAttribute("urlResolver");
            if (urlResolver == null) {
                urlResolver = this.urlResolverFactory.createURLResolver(request.getPathInfo(), request.getServerName(), request);
            }
            siteKey = urlResolver.getSiteKey();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return siteKey;
    }

    protected Throwable getException(HttpServletRequest request) {
        Throwable ex = (Throwable)request.getAttribute("javax.servlet.error.exception");
        ex = ex != null ? ex : (Throwable)request.getAttribute("org.jahia.exception");
        return ex;
    }

    public void init() throws ServletException {
        super.init();
        this.siteLevelErrorPagesEnabled = SettingsBean.getInstance().getSiteErrorEnabled();
        if (this.siteLevelErrorPagesEnabled) {
            this.sitesService = ServicesRegistry.getInstance().getJahiaSitesService();
            this.templateService = ServicesRegistry.getInstance().getJahiaTemplateManagerService();
            this.urlResolverFactory = (URLResolverFactory)SpringContextSingleton.getBean("urlResolverFactory");
        }
    }

    protected void process(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String redirectUrl;
        if (response.isCommitted()) {
            logger.warn("Response is already committed. Skipping error processing.");
            ErrorLoggingFilter.handle(request, response);
            return;
        }
        int errorCode = this.getErrorCode(request);
        if (errorCode == 401 && (redirectUrl = LoginConfig.getInstance().getCustomLoginUrl(request)) != null) {
            redirectUrl = response.encodeRedirectURL(redirectUrl);
            if (SettingsBean.getInstance().isDisableJsessionIdParameter()) {
                redirectUrl = SessionidRemovalResponseWrapper.removeJsessionId(redirectUrl);
            }
            response.sendRedirect(redirectUrl);
            return;
        }
        response.setStatus(errorCode);
        response.setContentType("text/html; charset=" + SettingsBean.getInstance().getCharacterEncoding());
        response.resetBuffer();
        String errorPagePath = this.getErrorPagePath(request);
        this.forwardToErrorPage(errorPagePath, request, response);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebUtils.setNoCacheHeaders(response);
        Integer errorCode = (Integer)request.getAttribute("javax.servlet.error.status_code");
        if (errorCode == 503 && StringUtils.equals((String)MAINTENANCE_MODE, (String)((String)request.getAttribute("javax.servlet.error.message")))) {
            this.forwardToErrorPage("/errors/maintenance.jsp", request, response);
        } else if (errorCode == 503 && StringUtils.equals((String)LICENSE_TERMS_VIOLATION_MODE, (String)((String)request.getAttribute("javax.servlet.error.message")))) {
            this.forwardToErrorPage("/errors/license.jsp", request, response);
        } else {
            String method = request.getMethod();
            if (method.equals("GET") || method.equals("POST")) {
                this.process(request, response);
            } else {
                response.sendError(errorCode != null ? errorCode : 500);
            }
        }
    }
}

