/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin.errors;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.ThrowablePatternConverter;
import org.jahia.bin.errors.StackTraceFilter;

@Plugin(name="SafeExtendedThrowablePatternConverter", category="Converter")
@ConverterKeys(value={"sxEx", "sxThrowable", "sxException"})
public final class SafeExtendedThrowablePatternConverter
extends ThrowablePatternConverter {
    private SafeExtendedThrowablePatternConverter(Configuration config, String[] options) {
        super("SafeExtendedThrowable", "throwable", options, config);
    }

    public static SafeExtendedThrowablePatternConverter newInstance(Configuration config, String[] options) {
        return new SafeExtendedThrowablePatternConverter(config, options);
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        ThrowableProxy proxy = event.getThrownProxy();
        Throwable throwable = event.getThrown();
        if ((throwable != null || proxy != null) && this.options.anyLines()) {
            if (proxy == null) {
                super.format(event, toAppendTo);
                return;
            }
            String suffix = this.getSuffix(event);
            String extStackTrace = proxy.getExtendedStackTraceAsString(this.options.getIgnorePackages(), this.options.getTextRenderer(), suffix);
            int len = toAppendTo.length();
            if (len > 0 && !Character.isWhitespace(toAppendTo.charAt(len - 1))) {
                toAppendTo.append(' ');
            }
            StackTraceFilter.appendExtendedStackTrace(toAppendTo, extStackTrace, this.options.allLines(), this.options.getSeparator(), this.options.getLines());
        }
    }
}

