/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin.errors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.FileAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.RollingRandomAccessFileAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.filter.LevelRangeFilter;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.PlainTextRenderer;
import org.apache.logging.log4j.core.pattern.TextRenderer;
import org.apache.logging.log4j.util.Strings;
import org.jahia.utils.Log4jEventCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackTraceFilter {
    private static final Logger logger = LoggerFactory.getLogger(StackTraceFilter.class);
    private static final String STACKTRACE_LINE_START = "\n\tat";
    private static final String NESTED_STACKTRACE_LINE_START = "\n\t\tat";
    public static final String DEFAULT_FILTERED_PACKAGES = "jdk.internal.,org.apache.felix.,org.eclipse.gemini.,org.springframework.,com.oracle.,org.apache.tomcat.,org.apache.catalina.,org.tuckey.web.filters.,org.graalvm.,org.apache.logging.,org.apache.jsp.,org.apache.jasper.,org.ops4j.,javax.servlet.,org.apache.shiro.,org.glassfish.jersey";
    public static final int DEFAULT_MAX_NUMBER_OF_LINES = 100;
    public static final String DEFAULT_APPENDERS_TO_MODIFY = "Console,RollingJahiaLog";
    public static final int SXTHROWABLE_LENGTH = "%sxThrowable".length();
    private static List<String> filteredPackages;
    private static int maxNumberOfLines;
    private static List<String> log4jAppendersToModify;

    public static void init(String filteredPackages, int maxNumberOfLines, String log4jAppendersToModify) {
        logger.info("Configuring StackTraceFilter with filteredPackages: {}, maxNumberOfLines: {}, log4jAppendersToModify: {}", new Object[]{filteredPackages, maxNumberOfLines, log4jAppendersToModify});
        StackTraceFilter.maxNumberOfLines = Math.max(maxNumberOfLines, 0);
        StackTraceFilter.filteredPackages = StackTraceFilter.splitAndStrip(filteredPackages);
        StackTraceFilter.log4jAppendersToModify = StackTraceFilter.splitAndStrip(log4jAppendersToModify);
        if (!StackTraceFilter.log4jAppendersToModify.isEmpty()) {
            StackTraceFilter.updateLog4JConfiguration();
        }
    }

    public static String printStackTrace(Throwable throwable) {
        StringBuilder toAppendTo = new StringBuilder();
        String suffix = "";
        String extStackTrace = new ThrowableProxy(throwable).getExtendedStackTraceAsString(filteredPackages, (TextRenderer)PlainTextRenderer.getInstance(), "");
        int len = toAppendTo.length();
        if (len > 0 && !Character.isWhitespace(toAppendTo.charAt(len - 1))) {
            toAppendTo.append(' ');
        }
        StackTraceFilter.appendExtendedStackTrace(toAppendTo, extStackTrace, maxNumberOfLines == Integer.MAX_VALUE, Strings.LINE_SEPARATOR, maxNumberOfLines);
        return toAppendTo.toString();
    }

    public static void appendExtendedStackTrace(StringBuilder toAppendTo, String extStackTrace, boolean allLines, String separator, int maxLines) {
        if (!allLines || !Strings.LINE_SEPARATOR.equals(separator)) {
            toAppendTo.append(StackTraceFilter.replaceLineSeparator(extStackTrace, separator, maxLines));
        } else {
            int firstMessageWithCRLFIndex = StackTraceFilter.indexOfMessageWithCRLF(extStackTrace);
            if (firstMessageWithCRLFIndex != -1) {
                toAppendTo.append(StackTraceFilter.replaceLineSeparatorInMessages(extStackTrace, firstMessageWithCRLFIndex));
            } else {
                toAppendTo.append(extStackTrace);
            }
        }
    }

    private static String replaceLineSeparator(String extStackTrace, String separator, int maxLines) {
        Object[] array = extStackTrace.split(Strings.LINE_SEPARATOR);
        return StringUtils.join((Object[])array, (String)separator, (int)0, (int)Math.min(maxLines, array.length)) + separator;
    }

    private static int indexOfMessageWithCRLF(String extStackTrace) {
        int stackTraceStartIndex;
        int messageStartIndex = 0;
        do {
            if ((stackTraceStartIndex = StackTraceFilter.getNextIndex(extStackTrace.indexOf(STACKTRACE_LINE_START, messageStartIndex), extStackTrace.indexOf(NESTED_STACKTRACE_LINE_START, messageStartIndex))) == -1) continue;
            if (StringUtils.lastIndexOf((CharSequence)extStackTrace, (int)13, (int)(--stackTraceStartIndex)) >= messageStartIndex || StringUtils.lastIndexOf((CharSequence)extStackTrace, (int)10, (int)stackTraceStartIndex) >= messageStartIndex) {
                return messageStartIndex;
            }
            if (stackTraceStartIndex == -1) continue;
            messageStartIndex = StackTraceFilter.getNextNestedMessageIndex(extStackTrace, stackTraceStartIndex);
        } while (messageStartIndex != -1 && stackTraceStartIndex != -1);
        return -1;
    }

    private static int getNextNestedMessageIndex(String extStackTrace, int stackTraceStartIndex) {
        return StackTraceFilter.getNextIndex(extStackTrace.indexOf("Caused by:", stackTraceStartIndex), extStackTrace.indexOf("Suppressed:", stackTraceStartIndex));
    }

    private static int getNextNestedMessageIndex(StringBuilder extStackTrace, int stackTraceStartIndex) {
        return StackTraceFilter.getNextIndex(extStackTrace.indexOf("Caused by:", stackTraceStartIndex), extStackTrace.indexOf("Suppressed:", stackTraceStartIndex));
    }

    private static int getNextIndex(int firstIndex, int secondIndex) {
        if (secondIndex == -1) {
            return firstIndex;
        }
        if (firstIndex == -1) {
            return secondIndex;
        }
        return Math.min(firstIndex, secondIndex);
    }

    private static String replaceLineSeparatorInMessages(String extStackTrace, int messageWithCRLFIndex) {
        int beginningOfStackTrace;
        StringBuilder sb = new StringBuilder(extStackTrace);
        do {
            beginningOfStackTrace = StackTraceFilter.getNextIndex(sb.indexOf(STACKTRACE_LINE_START, messageWithCRLFIndex), sb.indexOf(NESTED_STACKTRACE_LINE_START, messageWithCRLFIndex));
            StackTraceFilter.replaceCRLF(sb, messageWithCRLFIndex, beginningOfStackTrace);
        } while ((messageWithCRLFIndex = StackTraceFilter.indexOfNestedExceptionMessageWithCRLF(sb, beginningOfStackTrace)) != -1);
        return sb.toString();
    }

    private static int indexOfNestedExceptionMessageWithCRLF(StringBuilder extStackTrace, int startIndex) {
        int stackTraceStartIndex;
        do {
            if ((startIndex = StackTraceFilter.getNextNestedMessageIndex(extStackTrace, startIndex)) == -1) {
                return startIndex;
            }
            stackTraceStartIndex = StackTraceFilter.getNextIndex(extStackTrace.indexOf(STACKTRACE_LINE_START, startIndex), extStackTrace.indexOf(NESTED_STACKTRACE_LINE_START, startIndex));
            if (stackTraceStartIndex == -1 || StringUtils.lastIndexOf((CharSequence)extStackTrace, (int)13, (int)(--stackTraceStartIndex)) < startIndex && StringUtils.lastIndexOf((CharSequence)extStackTrace, (int)10, (int)stackTraceStartIndex) < startIndex) continue;
            return startIndex;
        } while ((startIndex = stackTraceStartIndex) != -1 && stackTraceStartIndex != -1);
        return -1;
    }

    private static StringBuilder replaceCRLF(StringBuilder toAppendTo, int start, int end) {
        block4: for (int i = end - 1; i >= start; --i) {
            char c = toAppendTo.charAt(i);
            switch (c) {
                case '\r': {
                    toAppendTo.setCharAt(i, '\\');
                    toAppendTo.insert(i + 1, 'r');
                    continue block4;
                }
                case '\n': {
                    toAppendTo.setCharAt(i, '\\');
                    toAppendTo.insert(i + 1, 'n');
                    continue block4;
                }
            }
        }
        return toAppendTo;
    }

    private static void updateLog4JConfiguration() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig("");
        for (String appenderName : log4jAppendersToModify) {
            PatternLayout newLayout;
            Appender newAppender;
            Layout layout;
            Appender oldAppender = (Appender)loggerConfig.getAppenders().get(appenderName);
            if (oldAppender == null || !((layout = oldAppender.getLayout()) instanceof PatternLayout) || (newAppender = StackTraceFilter.createNewAppender(oldAppender, newLayout = StackTraceFilter.updatePatternLayout((PatternLayout)layout, config), config)) == null) continue;
            newAppender.start();
            loggerConfig.removeAppender(appenderName);
            loggerConfig.addAppender(newAppender, null, null);
        }
        ctx.updateLoggers();
    }

    private static PatternLayout updatePatternLayout(PatternLayout oldLayout, Configuration config) {
        String oldPattern = oldLayout.getConversionPattern();
        Object newPattern = oldPattern;
        if (oldPattern.contains("sxThrowable")) {
            int sxThrowablePos = oldPattern.indexOf("%sxThrowable{");
            if (sxThrowablePos > 0) {
                oldPattern = oldPattern.substring(0, sxThrowablePos + SXTHROWABLE_LENGTH);
            }
            newPattern = oldPattern + "{" + maxNumberOfLines + "}{filters(" + StringUtils.join(filteredPackages, (String)",") + ")}";
        }
        return PatternLayout.newBuilder().withPattern((String)newPattern).withConfiguration(config).build();
    }

    private static Appender createNewAppender(Appender oldAppender, Layout<?> newLayout, Configuration config) {
        if (oldAppender instanceof ConsoleAppender) {
            ConsoleAppender oldConsoleAppender = (ConsoleAppender)oldAppender;
            return ((ConsoleAppender.Builder)((ConsoleAppender.Builder)((ConsoleAppender.Builder)((ConsoleAppender.Builder)((ConsoleAppender.Builder)ConsoleAppender.newBuilder().setName(oldConsoleAppender.getName())).setLayout(newLayout)).setConfiguration(config)).setFilter(oldConsoleAppender.getFilter())).setIgnoreExceptions(oldConsoleAppender.ignoreExceptions())).setTarget(oldConsoleAppender.getTarget()).build();
        }
        if (oldAppender instanceof FileAppender) {
            FileAppender oldFileAppender = (FileAppender)oldAppender;
            return ((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)((FileAppender.Builder)FileAppender.newBuilder().setName(oldFileAppender.getName())).setLayout(newLayout)).withFileName(oldFileAppender.getFileName()).setConfiguration(config)).setFilter(oldFileAppender.getFilter())).setIgnoreExceptions(oldFileAppender.ignoreExceptions())).build();
        }
        if (oldAppender instanceof RollingFileAppender) {
            RollingFileAppender oldRollingFileAppender = (RollingFileAppender)oldAppender;
            return ((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().setName(oldRollingFileAppender.getName())).setLayout(newLayout)).withFileName(oldRollingFileAppender.getFileName()).withFilePattern(oldRollingFileAppender.getFilePattern()).setConfiguration(config)).setFilter(oldRollingFileAppender.getFilter())).setIgnoreExceptions(oldRollingFileAppender.ignoreExceptions())).withPolicy(oldRollingFileAppender.getTriggeringPolicy()).build();
        }
        if (oldAppender instanceof RollingRandomAccessFileAppender) {
            RollingRandomAccessFileAppender oldRollingRandomAccessFileAppender = (RollingRandomAccessFileAppender)oldAppender;
            return ((RollingRandomAccessFileAppender.Builder)((RollingRandomAccessFileAppender.Builder)((RollingRandomAccessFileAppender.Builder)((RollingRandomAccessFileAppender.Builder)((RollingRandomAccessFileAppender.Builder)RollingRandomAccessFileAppender.newBuilder().setName(oldRollingRandomAccessFileAppender.getName())).setLayout(newLayout)).withFileName(oldRollingRandomAccessFileAppender.getFileName()).withFilePattern(oldRollingRandomAccessFileAppender.getFilePattern()).setConfiguration(config)).setFilter(oldRollingRandomAccessFileAppender.getFilter())).setIgnoreExceptions(oldRollingRandomAccessFileAppender.ignoreExceptions())).build();
        }
        if (oldAppender instanceof Log4jEventCollector) {
            Log4jEventCollector oldLog4jEventCollector = (Log4jEventCollector)oldAppender;
            return Log4jEventCollector.createAppender(oldLog4jEventCollector.getName(), (LevelRangeFilter)oldLog4jEventCollector.getFilter(), newLayout);
        }
        return null;
    }

    private static List<String> splitAndStrip(String input) {
        if (input == null || input.isEmpty()) {
            return new ArrayList<String>();
        }
        String[] parts = input.split(",");
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = StringUtils.strip((String)parts[i]);
        }
        return Arrays.asList(parts);
    }
}

