/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.bin.listeners;

import java.io.File;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import javax.servlet.jsp.jstl.core.Config;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VFS;
import org.jahia.api.Constants;
import org.jahia.bin.Jahia;
import org.jahia.bin.listeners.HttpListener;
import org.jahia.bin.listeners.HttpListenersRegistry;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.osgi.FrameworkService;
import org.jahia.registries.ServicesRegistry;
import org.jahia.services.JahiaAfterInitializationService;
import org.jahia.services.SpringContextSingleton;
import org.jahia.services.content.JCRSessionFactory;
import org.jahia.services.modulemanager.util.ModuleUtils;
import org.jahia.services.observation.JahiaEventService;
import org.jahia.services.usermanager.JahiaUserManagerService;
import org.jahia.settings.SettingsBean;
import org.jahia.tools.patches.Patcher;
import org.jahia.utils.Patterns;
import org.jahia.utils.WebAppPathResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class JahiaContextLoaderListener
extends ContextLoaderListener
implements ServletRequestListener,
ServletRequestAttributeListener,
HttpSessionListener,
HttpSessionActivationListener,
HttpSessionAttributeListener,
HttpSessionBindingListener,
ServletContextAttributeListener {
    private static final Pattern HTTP_METHOD = Pattern.compile("POST|PUT|GET|DELETE");
    private static final Logger logger = LoggerFactory.getLogger(JahiaContextLoaderListener.class);
    private static Set<String> addedSystemProperties = new ConcurrentSkipListSet<String>();
    private static ServletContext servletContext;
    private static long startupTime;
    private static String pid;
    private static String webAppRoot;
    private static Map<String, Object> jahiaContextListenersConfiguration;
    private static volatile long sessionCount;
    private static volatile boolean contextInitialized;
    private static volatile boolean running;
    private static Map<ServletRequest, Long> requestTimes;

    public static void endContextInitialized() {
        try {
            FrameworkService frameworkService = FrameworkService.getInstance();
            frameworkService.waitForInitialStartLevelReached();
            frameworkService.waitForFileInstallStarted();
            frameworkService.waitForSpringBridgeStarted();
            if (SettingsBean.getInstance().isProcessingServer()) {
                Patcher.getInstance().executeScripts("contextInitialized-processingServer");
            } else {
                Patcher.getInstance().executeScripts("contextInitialized-nonProcessingServer");
            }
            Patcher.getInstance().executeScripts("contextInitialized");
            frameworkService.raiseStartLevel();
            frameworkService.waitForFinalStartLevelReached();
            frameworkService.waitForClusterStarted();
            logger.info("Finishing context initialization phase");
            if (SettingsBean.getInstance().isProcessingServer()) {
                ModuleUtils.getModuleManager().storeAllLocalPersistentStates();
            }
            JahiaContextLoaderListener.initJahiaAfterInitializationServices();
            Config.set((ServletContext)servletContext, (String)"javax.servlet.jsp.jstl.fmt.fallbackLocale", (Object)(SettingsBean.getInstance().getDefaultLanguageCode() != null ? SettingsBean.getInstance().getDefaultLanguageCode() : Locale.ENGLISH.getLanguage()));
            jahiaContextListenersConfiguration = (Map)ContextLoader.getCurrentWebApplicationContext().getBean("jahiaContextListenersConfiguration");
            if (JahiaContextLoaderListener.isEventInterceptorActivated("interceptServletContextListenerEvents")) {
                SpringContextSingleton.getInstance().publishEvent(new ServletContextInitializedEvent(JahiaContextLoaderListener.getServletContext()));
            }
            contextInitialized = true;
            ServicesRegistry.getInstance().getSchedulerService().startSchedulers();
            logger.info("Context initialization phase finished");
        }
        catch (JahiaException e) {
            running = false;
            logger.error(e.getMessage(), (Throwable)e);
            throw new JahiaRuntimeException(e);
        }
        catch (RuntimeException e) {
            running = false;
            throw e;
        }
        finally {
            JCRSessionFactory.getInstance().closeAllSessions();
        }
    }

    public static boolean isEventInterceptorActivated(String interceptorName) {
        if (jahiaContextListenersConfiguration == null) {
            return false;
        }
        Object interceptorActivatedObject = jahiaContextListenersConfiguration.get(interceptorName);
        if (interceptorActivatedObject instanceof Boolean) {
            return (Boolean)interceptorActivatedObject;
        }
        return interceptorActivatedObject instanceof String && Boolean.parseBoolean((String)interceptorActivatedObject);
    }

    public void contextInitialized(ServletContextEvent event) {
        startupTime = System.currentTimeMillis();
        this.startupWithTrust(Jahia.getBuildNumber());
        logger.info("Starting up Jahia, please wait...");
        servletContext = event.getServletContext();
        Jahia.setContextPath(servletContext.getContextPath());
        JahiaContextLoaderListener.initWebAppRoot();
        if (System.getProperty("jahia.config") == null) {
            JahiaContextLoaderListener.setSystemProperty("jahia.config", "");
        }
        if (System.getProperty("jahia.license") == null) {
            JahiaContextLoaderListener.setSystemProperty("jahia.license", "");
        }
        try {
            Jahia.verifyJavaVersion(servletContext.getInitParameter("supported_jdk_versions"));
        }
        catch (JahiaInitializationException e) {
            throw new JahiaRuntimeException(e);
        }
        JahiaContextLoaderListener.detectPID(servletContext);
        this.initializeTemporarySettingsBean();
        Patcher.getInstance().setServletContext(servletContext);
        Patcher.getInstance().executeScripts("beforeContextInitializing");
        try {
            VFS.getManager();
        }
        catch (FileSystemException e) {
            throw new JahiaRuntimeException(e);
        }
        try {
            long timer = System.currentTimeMillis();
            logger.info("Start initializing Spring root application context");
            running = true;
            super.contextInitialized(event);
            logger.info("Spring Root application context initialized in {} ms", (Object)(System.currentTimeMillis() - timer));
            ServicesRegistry.getInstance().init();
            WebApplicationContext rootCtx = ContextLoader.getCurrentWebApplicationContext();
            rootCtx.publishEvent((ApplicationEvent)new RootContextInitializedEvent(rootCtx));
            boolean isProcessingServer = SettingsBean.getInstance().isProcessingServer();
            if (isProcessingServer) {
                Patcher.getInstance().executeScripts("rootContextInitialized");
            }
            FrameworkService.getInstance().start();
        }
        catch (JahiaException e) {
            running = false;
            logger.error(e.getMessage(), (Throwable)e);
            throw new JahiaRuntimeException(e);
        }
        catch (RuntimeException e) {
            running = false;
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            JCRSessionFactory.getInstance().closeAllSessions();
        }
    }

    private void initializeTemporarySettingsBean() {
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext("classpath*:org/jahia/defaults/config/**/applicationcontext-jahiaproperties.xml");
        WebAppPathResolver pathResolver = (WebAppPathResolver)ctx.getBean("pathResolver");
        pathResolver.setServletContext(servletContext);
        SettingsBean settingsBean = new SettingsBean(pathResolver, (Properties)ctx.getBean("jahiaProperties"), (List)ctx.getBean("licensesList"));
        settingsBean.setStartupOptionsMapping((Map)ctx.getBean("startupOptionsMapping"));
        settingsBean.setApplicationContext((ApplicationContext)ctx);
        settingsBean.initPaths();
    }

    private static void initWebAppRoot() {
        webAppRoot = servletContext.getRealPath("/");
        if (webAppRoot != null && webAppRoot.length() > 1 && webAppRoot.charAt(webAppRoot.length() - 1) == File.separatorChar) {
            webAppRoot = webAppRoot.substring(0, webAppRoot.length() - 1);
        }
        if (webAppRoot != null) {
            try {
                JahiaContextLoaderListener.setSystemProperty("jahiaWebAppRoot", webAppRoot);
            }
            catch (SecurityException se) {
                logger.error("System property jahiaWebAppRoot was NOT set to " + webAppRoot + " successfully ! Please check app server security manager policies to allow this.", (Throwable)se);
            }
        }
        if (System.getProperty("jahiaWebAppRoot") != null && System.getProperty("jahiaWebAppRoot").equals(webAppRoot)) {
            logger.info("System property jahiaWebAppRoot set to " + webAppRoot + " successfully.");
        } else {
            logger.error("System property jahiaWebAppRoot was NOT set to " + webAppRoot + " successfully ! Please check app server security manager policies to allow this.");
        }
    }

    private static void initJahiaAfterInitializationServices() throws JahiaInitializationException {
        try {
            JCRSessionFactory.getInstance().setCurrentUser(JahiaUserManagerService.getInstance().lookupRootUser().getJahiaUser());
            for (JahiaAfterInitializationService service : SpringContextSingleton.getInstance().getContext().getBeansOfType(JahiaAfterInitializationService.class).values()) {
                service.initAfterAllServicesAreStarted();
            }
            ServicesRegistry.getInstance().getJahiaTemplateManagerService().getTemplatePackageRegistry().afterInitializationForModules();
        }
        finally {
            JCRSessionFactory.getInstance().setCurrentUser(null);
        }
    }

    private static void detectPID(ServletContext servletContext) {
        try {
            pid = Patterns.AT.split(ManagementFactory.getRuntimeMXBean().getName())[0];
        }
        catch (Exception e) {
            logger.warn("Unable to determine process id", (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        if (!running) {
            return;
        }
        contextInitialized = false;
        running = false;
        logger.info("Shutting down scheduler, wait for running jobs");
        ServicesRegistry.getInstance().getSchedulerService().stop();
        if (JahiaContextLoaderListener.isEventInterceptorActivated("interceptServletContextListenerEvents")) {
            SpringContextSingleton.getInstance().publishEvent(new ServletContextDestroyedEvent(event.getServletContext()));
        }
        for (HttpListener listener : this.getListeners()) {
            listener.contextDestroyed(event);
        }
        long timer = System.currentTimeMillis();
        logger.info("Stopping OSGi platform service");
        try {
            FrameworkService.getInstance().stop();
        }
        catch (Exception e) {
            logger.error("Error stopping OSGi platform service. Cause: " + e.getMessage(), (Throwable)e);
        }
        logger.info("OSGi platform service stopped in {} ms", (Object)(System.currentTimeMillis() - timer));
        timer = System.currentTimeMillis();
        logger.info("Shutting down Spring root application context");
        super.contextDestroyed(event);
        JahiaContextLoaderListener.removeAddedSystemProperties();
        logger.info("Spring Root application context shut down in {} ms", (Object)(System.currentTimeMillis() - timer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startupWithTrust(String buildString) {
        String msg;
        StringBuilder buildBuffer = new StringBuilder();
        for (int i = 0; i < buildString.length(); ++i) {
            buildBuffer.append(" ");
            buildBuffer.append(buildString.substring(i, i + 1));
        }
        StringBuilder versionBuffer = new StringBuilder();
        for (int i = 0; i < Constants.JAHIA_PROJECT_VERSION.length(); ++i) {
            versionBuffer.append(" ");
            versionBuffer.append(Constants.JAHIA_PROJECT_VERSION.substring(i, i + 1));
        }
        StringBuilder codeNameBuffer = new StringBuilder();
        for (int i = 0; i < "Kimchi".length(); ++i) {
            codeNameBuffer.append(" ");
            codeNameBuffer.append("Kimchi".substring(i, i + 1));
        }
        InputStream is = null;
        try {
            is = ((Object)((Object)this)).getClass().getResourceAsStream(Jahia.isEnterpriseEdition() ? "/META-INF/jahia-ee-startup-intro.txt" : "/META-INF/jahia-startup-intro.txt");
            msg = IOUtils.toString((InputStream)is);
        }
        catch (Exception e) {
            try {
                logger.warn(e.getMessage(), (Throwable)e);
                msg = "";
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        IOUtils.closeQuietly((InputStream)is);
        msg = StringUtils.replace((String)msg, (String)"@BUILD_NUMBER@", (String)buildBuffer.toString());
        msg = StringUtils.replace((String)msg, (String)"@BUILD_DATE@", (String)Jahia.getBuildDate());
        msg = StringUtils.replace((String)msg, (String)"@VERSION@", (String)versionBuffer.toString());
        msg = StringUtils.replace((String)msg, (String)"@CODENAME@", (String)codeNameBuffer.toString());
        msg = StringUtils.replace((String)msg, (String)"@YEAR@", (String)"2025");
        System.out.println(msg);
        System.out.flush();
    }

    public static ServletContext getServletContext() {
        return servletContext;
    }

    public static long getStartupTime() {
        return startupTime;
    }

    public void sessionCreated(HttpSessionEvent se) {
        logger.debug("HTTP session created: {}", (Object)se.getSession().getId());
        ++sessionCount;
        if (JahiaContextLoaderListener.isEventInterceptorActivated("interceptHttpSessionListenerEvents")) {
            HttpSessionCreatedEvent event = new HttpSessionCreatedEvent(se.getSession());
            SpringContextSingleton.getInstance().publishEvent(event);
            ((JahiaEventService)SpringContextSingleton.getBean("jahiaEventService")).publishEvent((EventObject)((Object)event));
        }
        for (HttpListener listener : this.getListeners()) {
            listener.sessionCreated(se);
        }
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        logger.debug("HTTP session destroyed: {}", (Object)se.getSession().getId());
        --sessionCount;
        if (JahiaContextLoaderListener.isEventInterceptorActivated("interceptHttpSessionListenerEvents")) {
            HttpSessionDestroyedEvent event = new HttpSessionDestroyedEvent(se.getSession());
            SpringContextSingleton.getInstance().publishEvent(event);
            ((JahiaEventService)SpringContextSingleton.getBean("jahiaEventService")).publishEvent((EventObject)((Object)event));
        }
        for (HttpListener listener : this.getListeners()) {
            listener.sessionDestroyed(se);
        }
    }

    public void requestDestroyed(ServletRequestEvent sre) {
        requestTimes.remove(sre.getServletRequest());
        if (JahiaContextLoaderListener.isEventInterceptorActivated("interceptServletRequestListenerEvents")) {
            SpringContextSingleton.getInstance().publishEvent(new ServletRequestDestroyedEvent(sre.getServletRequest()));
        }
        for (HttpListener listener : this.getListeners()) {
            listener.requestDestroyed(sre);
        }
    }

    public void requestInitialized(ServletRequestEvent sre) {
        HttpServletRequest req;
        ServletRequest servletRequest = sre.getServletRequest();
        if (servletRequest instanceof HttpServletRequest && HTTP_METHOD.matcher((req = (HttpServletRequest)servletRequest).getMethod().toUpperCase()).matches() && !StringUtils.contains((String)req.getQueryString(), (String)"X-Atmosphere-Transport=") && !StringUtils.equals((String)req.getHeader("Accept"), (String)"text/event-stream")) {
            requestTimes.put(servletRequest, System.currentTimeMillis());
        }
        if (JahiaContextLoaderListener.isEventInterceptorActivated("interceptServletRequestListenerEvents")) {
            SpringContextSingleton.getInstance().publishEvent(new ServletRequestInitializedEvent(servletRequest));
        }
        for (HttpListener listener : this.getListeners()) {
            listener.requestInitialized(sre);
        }
    }

    public static long getSessionCount() {
        return sessionCount;
    }

    public static long getRequestCount() {
        return requestTimes.size();
    }

    public static String getPid() {
        return pid;
    }

    public static void setSystemProperty(String key, String value) {
        if (System.setProperty(key, value) == null) {
            addedSystemProperties.add(key);
        }
    }

    private static void removeAddedSystemProperties() {
        try {
            for (String key : addedSystemProperties) {
                System.clearProperty(key);
            }
        }
        finally {
            addedSystemProperties.clear();
        }
    }

    private List<HttpListener> getListeners() {
        if (contextInitialized) {
            HttpListenersRegistry registry = (HttpListenersRegistry)SpringContextSingleton.getInstance().getContext().getBean("HttpListenersRegistry");
            return registry.getEventListeners();
        }
        return Collections.emptyList();
    }

    public void sessionWillPassivate(HttpSessionEvent se) {
        if (JahiaContextLoaderListener.isEventInterceptorActivated("interceptHttpSessionActivationEvents")) {
            SpringContextSingleton.getInstance().publishEvent(new HttpSessionWillPassivateEvent(se.getSession()));
        }
        for (HttpListener listener : this.getListeners()) {
            listener.sessionWillPassivate(se);
        }
    }

    public void sessionDidActivate(HttpSessionEvent se) {
        if (JahiaContextLoaderListener.isEventInterceptorActivated("interceptHttpSessionActivationEvents")) {
            SpringContextSingleton.getInstance().publishEvent(new HttpSessionDidActivateEvent(se.getSession()));
        }
        for (HttpListener listener : this.getListeners()) {
            listener.sessionDidActivate(se);
        }
    }

    public void attributeAdded(HttpSessionBindingEvent se) {
        if (JahiaContextLoaderListener.isEventInterceptorActivated("interceptHttpSessionAttributeListenerEvents")) {
            SpringContextSingleton.getInstance().publishEvent(new HttpSessionAttributeAddedEvent(se));
        }
        for (HttpListener listener : this.getListeners()) {
            listener.attributeAdded(se);
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent se) {
        if (JahiaContextLoaderListener.isEventInterceptorActivated("interceptHttpSessionAttributeListenerEvents")) {
            SpringContextSingleton.getInstance().publishEvent(new HttpSessionAttributeRemovedEvent(se));
        }
        for (HttpListener listener : this.getListeners()) {
            listener.attributeRemoved(se);
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent se) {
        if (JahiaContextLoaderListener.isEventInterceptorActivated("interceptHttpSessionAttributeListenerEvents")) {
            SpringContextSingleton.getInstance().publishEvent(new HttpSessionAttributeReplacedEvent(se));
        }
        for (HttpListener listener : this.getListeners()) {
            listener.attributeReplaced(se);
        }
    }

    public void valueBound(HttpSessionBindingEvent event) {
        if (JahiaContextLoaderListener.isEventInterceptorActivated("interceptHttpSessionBindingListenerEvents")) {
            SpringContextSingleton.getInstance().publishEvent(new HttpSessionValueBoundEvent(event));
        }
        for (HttpListener listener : this.getListeners()) {
            listener.valueBound(event);
        }
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        if (JahiaContextLoaderListener.isEventInterceptorActivated("interceptHttpSessionBindingListenerEvents")) {
            SpringContextSingleton.getInstance().publishEvent(new HttpSessionValueUnboundEvent(event));
        }
        for (HttpListener listener : this.getListeners()) {
            listener.valueUnbound(event);
        }
    }

    public void attributeAdded(ServletContextAttributeEvent scab) {
        if (contextInitialized) {
            if (JahiaContextLoaderListener.isEventInterceptorActivated("interceptServletContextAttributeListenerEvents")) {
                SpringContextSingleton.getInstance().publishEvent(new ServletContextAttributeAddedEvent(scab));
            }
            for (HttpListener listener : this.getListeners()) {
                listener.attributeAdded(scab);
            }
        }
    }

    public void attributeRemoved(ServletContextAttributeEvent scab) {
        if (contextInitialized) {
            if (JahiaContextLoaderListener.isEventInterceptorActivated("interceptServletContextAttributeListenerEvents")) {
                SpringContextSingleton.getInstance().publishEvent(new ServletContextAttributeRemovedEvent(scab));
            }
            for (HttpListener listener : this.getListeners()) {
                listener.attributeRemoved(scab);
            }
        }
    }

    public void attributeReplaced(ServletContextAttributeEvent scab) {
        if (contextInitialized) {
            if (JahiaContextLoaderListener.isEventInterceptorActivated("interceptServletContextAttributeListenerEvents")) {
                SpringContextSingleton.getInstance().publishEvent(new ServletContextAttributeReplacedEvent(scab));
            }
            for (HttpListener listener : this.getListeners()) {
                listener.attributeReplaced(scab);
            }
        }
    }

    public void attributeAdded(ServletRequestAttributeEvent srae) {
        if (JahiaContextLoaderListener.isEventInterceptorActivated("interceptServletRequestAttributeListenerEvents")) {
            SpringContextSingleton.getInstance().publishEvent(new ServletRequestAttributeAddedEvent(srae));
        }
        for (HttpListener listener : this.getListeners()) {
            listener.attributeAdded(srae);
        }
    }

    public void attributeRemoved(ServletRequestAttributeEvent srae) {
        if (JahiaContextLoaderListener.isEventInterceptorActivated("interceptServletRequestAttributeListenerEvents")) {
            SpringContextSingleton.getInstance().publishEvent(new ServletRequestAttributeRemovedEvent(srae));
        }
        for (HttpListener listener : this.getListeners()) {
            listener.attributeRemoved(srae);
        }
    }

    public void attributeReplaced(ServletRequestAttributeEvent srae) {
        if (JahiaContextLoaderListener.isEventInterceptorActivated("interceptServletRequestAttributeListenerEvents")) {
            SpringContextSingleton.getInstance().publishEvent(new ServletRequestAttributeReplacedEvent(srae));
        }
        for (HttpListener listener : this.getListeners()) {
            listener.attributeReplaced(srae);
        }
    }

    public static boolean isContextInitialized() {
        return contextInitialized;
    }

    public static boolean isRunning() {
        return running;
    }

    public static String getWebAppRoot() {
        return webAppRoot;
    }

    static {
        pid = "";
        sessionCount = 0L;
        contextInitialized = false;
        running = false;
        requestTimes = Collections.synchronizedMap(new LRUMap(1000));
    }

    private class ServletContextDestroyedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = -2099082546094025673L;

        public ServletContextDestroyedEvent(ServletContext servletContext) {
            super((Object)servletContext);
        }
    }

    public static class ServletContextInitializedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 7380625349896182566L;

        public ServletContextInitializedEvent(ServletContext servletContext) {
            super((Object)servletContext);
        }

        public ServletContext getServletContext() {
            return (ServletContext)super.getSource();
        }
    }

    private class ServletRequestAttributeReplacedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 1785714293103597626L;

        public ServletRequestAttributeReplacedEvent(ServletRequestAttributeEvent servletRequestAttributeEvent) {
            super((Object)servletRequestAttributeEvent);
        }
    }

    private class ServletRequestAttributeRemovedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 4181992489489417634L;

        public ServletRequestAttributeRemovedEvent(ServletRequestAttributeEvent servletRequestAttributeEvent) {
            super((Object)servletRequestAttributeEvent);
        }
    }

    public class ServletRequestAttributeAddedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 3317475270634384739L;

        public ServletRequestAttributeAddedEvent(ServletRequestAttributeEvent servletRequestAttributeEvent) {
            super((Object)servletRequestAttributeEvent);
        }

        public ServletRequestAttributeEvent getServletRequestAttributeEvent() {
            return (ServletRequestAttributeEvent)super.getSource();
        }
    }

    public class ServletContextAttributeReplacedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 5729697513603811739L;

        public ServletContextAttributeReplacedEvent(ServletContextAttributeEvent servletContextAttributeEvent) {
            super((Object)servletContextAttributeEvent);
        }

        public ServletContextAttributeEvent getServletContextAttributeEvent() {
            return (ServletContextAttributeEvent)super.getSource();
        }
    }

    public class ServletContextAttributeRemovedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = -3543715780914938235L;

        public ServletContextAttributeRemovedEvent(ServletContextAttributeEvent servletContextAttributeEvent) {
            super((Object)servletContextAttributeEvent);
        }

        public ServletContextAttributeEvent getServletContextAttributeEvent() {
            return (ServletContextAttributeEvent)super.getSource();
        }
    }

    public class ServletContextAttributeAddedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 3430737803878399224L;

        public ServletContextAttributeAddedEvent(ServletContextAttributeEvent servletContextAttributeEvent) {
            super((Object)servletContextAttributeEvent);
        }

        public ServletContextAttributeEvent getServletContextAttributeEvent() {
            return (ServletContextAttributeEvent)super.getSource();
        }
    }

    public class HttpSessionValueUnboundEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 8453994121930169941L;

        public HttpSessionValueUnboundEvent(HttpSessionBindingEvent httpSessionBindingEvent) {
            super((Object)httpSessionBindingEvent);
        }

        public HttpSessionBindingEvent getHttpSessionBindingEvent() {
            return (HttpSessionBindingEvent)super.getSource();
        }
    }

    public class HttpSessionValueBoundEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = -3415824235349946403L;

        public HttpSessionValueBoundEvent(HttpSessionBindingEvent httpSessionBindingEvent) {
            super((Object)httpSessionBindingEvent);
        }

        public HttpSessionBindingEvent getHttpSessionBindingEvent() {
            return (HttpSessionBindingEvent)super.getSource();
        }
    }

    public class HttpSessionAttributeReplacedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 8128290080471455221L;

        public HttpSessionAttributeReplacedEvent(HttpSessionBindingEvent httpSessionBindingEvent) {
            super((Object)httpSessionBindingEvent);
        }

        public HttpSessionBindingEvent getHttpSessionBindingEvent() {
            return (HttpSessionBindingEvent)super.getSource();
        }
    }

    public class HttpSessionAttributeRemovedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 876708448117102271L;

        public HttpSessionAttributeRemovedEvent(HttpSessionBindingEvent httpSessionBindingEvent) {
            super((Object)httpSessionBindingEvent);
        }

        public HttpSessionBindingEvent getHttpSessionBindingEvent() {
            return (HttpSessionBindingEvent)super.getSource();
        }
    }

    public class HttpSessionAttributeAddedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 7316259699549761735L;

        public HttpSessionAttributeAddedEvent(HttpSessionBindingEvent httpSessionBindingEvent) {
            super((Object)httpSessionBindingEvent);
        }

        public HttpSessionBindingEvent getHttpSessionBindingEvent() {
            return (HttpSessionBindingEvent)super.getSource();
        }
    }

    public class HttpSessionDidActivateEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 5814761122135408014L;

        public HttpSessionDidActivateEvent(HttpSession session) {
            super((Object)session);
        }

        public HttpSession getSession() {
            return (HttpSession)super.getSource();
        }
    }

    public class HttpSessionWillPassivateEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 6886011344567163295L;

        public HttpSessionWillPassivateEvent(HttpSession session) {
            super((Object)session);
        }

        public HttpSession getSession() {
            return (HttpSession)super.getSource();
        }
    }

    public class ServletRequestInitializedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 5822992792782543993L;

        public ServletRequestInitializedEvent(ServletRequest servletRequest) {
            super((Object)servletRequest);
        }

        public ServletRequest getServletRequest() {
            return (ServletRequest)super.getSource();
        }
    }

    public class ServletRequestDestroyedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 7596456549896361175L;

        public ServletRequestDestroyedEvent(ServletRequest servletRequest) {
            super((Object)servletRequest);
        }

        public ServletRequest getServletRequest() {
            return (ServletRequest)super.getSource();
        }
    }

    public class HttpSessionDestroyedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = -1387944667725619591L;

        public HttpSessionDestroyedEvent(HttpSession session) {
            super((Object)session);
        }

        public HttpSession getSession() {
            return (HttpSession)super.getSource();
        }
    }

    public class HttpSessionCreatedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = -7421486835176013728L;

        public HttpSessionCreatedEvent(HttpSession session) {
            super((Object)session);
        }

        public HttpSession getSession() {
            return (HttpSession)super.getSource();
        }
    }

    public static class RootContextInitializedEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 8215602249732419470L;

        public RootContextInitializedEvent(Object source) {
            super(source);
        }

        public XmlWebApplicationContext getContext() {
            return (XmlWebApplicationContext)this.getSource();
        }
    }
}

