/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.content;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jahia.content.CategoryKey;
import org.jahia.content.ObjectKeyInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ObjectKey
implements ObjectKeyInterface,
Serializable,
Comparable<ObjectKey> {
    private static final Logger logger = LoggerFactory.getLogger(ObjectKey.class);
    private static final long serialVersionUID = 7375719911472500146L;
    private static Map<String, ObjectKeyInterface> keyTypeInstances = new ConcurrentHashMap<String, ObjectKeyInterface>();
    public static final String OBJECT_TYPE = "object";
    protected final String key;
    private String type = "object";
    private String IDInType;

    protected ObjectKey() {
        this.key = null;
    }

    protected ObjectKey(String type, String IDInType) {
        this.type = type;
        this.IDInType = IDInType;
        StringBuilder buf = new StringBuilder(50);
        buf.append(type);
        buf.append("_");
        buf.append(IDInType);
        this.key = buf.toString();
    }

    protected ObjectKey(String type, String IDInType, String key) {
        this.type = type;
        this.IDInType = IDInType;
        this.key = key;
    }

    private static void registerType(String type, Class<? extends ObjectKey> klass) {
        logger.debug("Registering type [" + type + "] with class [" + klass + "]");
        try {
            keyTypeInstances.put(type.toLowerCase(), klass.newInstance());
        }
        catch (IllegalAccessException e) {
            logger.error("Error while registering type " + type, (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error("Error while registering type " + type, (Throwable)e);
        }
    }

    public static void unregisterType(String type) {
        keyTypeInstances.remove(type.toLowerCase());
    }

    public static ObjectKey getInstance(String key) throws ClassNotFoundException {
        ObjectKey resultKey = null;
        int separatorPos = key.indexOf("_");
        if (separatorPos > 0) {
            String type = key.substring(0, separatorPos).toLowerCase();
            String idStr = key.substring(separatorPos + "_".length());
            if (!keyTypeInstances.containsKey(type)) {
                throw new ClassNotFoundException("No class defined for type [" + type + "]");
            }
            try {
                ObjectKeyInterface objectKeyInterface = keyTypeInstances.get(type);
                resultKey = objectKeyInterface.getChildInstance(idStr, key);
            }
            catch (SecurityException se) {
                logger.error("Error while creating instance of object key " + key, (Throwable)se);
            }
            catch (IllegalArgumentException iae2) {
                logger.error("Error while creating instance of object key " + key, (Throwable)iae2);
            }
        }
        return resultKey;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getIDInType() {
        return this.IDInType;
    }

    public int getIdInType() {
        return -1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            ObjectKey destObj = (ObjectKey)obj;
            return this.getKey().equals(destObj.getKey());
        }
        return false;
    }

    @Override
    public int compareTo(ObjectKey destObjectKey) throws ClassCastException {
        return this.key.compareTo(destObjectKey.getKey());
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return this.key;
    }

    public static String toObjectKeyString(String type, String IDInType) {
        return new StringBuilder(50).append(type).append("_").append(IDInType).toString();
    }

    static {
        ObjectKey.registerType("Category", CategoryKey.class);
    }
}

