/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.osgi;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleDelegatingClassLoader
extends ClassLoader
implements BundleReference {
    private static final Logger log = LoggerFactory.getLogger(BundleDelegatingClassLoader.class);
    private final ClassLoader bridge;
    private final Bundle backingBundle;

    public static BundleDelegatingClassLoader createBundleClassLoaderFor(Bundle aBundle) {
        return BundleDelegatingClassLoader.createBundleClassLoaderFor(aBundle, null);
    }

    public static BundleDelegatingClassLoader createBundleClassLoaderFor(final Bundle bundle, final ClassLoader bridge) {
        return AccessController.doPrivileged(new PrivilegedAction<BundleDelegatingClassLoader>(){

            @Override
            public BundleDelegatingClassLoader run() {
                return new BundleDelegatingClassLoader(bundle, bridge);
            }
        });
    }

    protected BundleDelegatingClassLoader(Bundle bundle, ClassLoader bridgeLoader) {
        super(null);
        this.backingBundle = bundle;
        this.bridge = bridgeLoader;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return this.backingBundle.loadClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ClassNotFoundException(name + " not found from bundle [" + this.backingBundle.getSymbolicName() + "]", cnfe);
        }
        catch (NoClassDefFoundError ncdfe) {
            String cname = ncdfe.getMessage().replace('/', '.');
            NoClassDefFoundError e = new NoClassDefFoundError(cname + " not found from bundle [" + this.backingBundle + "]");
            e.initCause(ncdfe);
            throw e;
        }
        catch (IllegalStateException ise) {
            throw new IllegalStateException(String.format("Impossible to load the class %s from the bundle %s", name, this.backingBundle), ise);
        }
    }

    @Override
    protected URL findResource(String name) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("Looking for resource " + name);
        }
        URL url = this.backingBundle.getResource(name);
        if (trace && url != null) {
            log.trace("Found resource " + name + " at " + url);
        }
        return url;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace("Looking for resources " + name);
        }
        Enumeration enm = this.backingBundle.getResources(name);
        if (trace && enm != null && enm.hasMoreElements()) {
            log.trace("Found resource " + name + " at " + this.backingBundle.getLocation());
        }
        return enm;
    }

    @Override
    public URL getResource(String name) {
        URL resource = this.findResource(name);
        if (this.bridge != null && resource == null) {
            resource = this.bridge.getResource(name);
        }
        return resource;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> bridgeEnm;
        final Enumeration<URL> enm = this.findResources(name);
        Enumeration<URL> enumeration = bridgeEnm = this.bridge != null ? this.bridge.getResources(name) : null;
        if (enm == null && bridgeEnm == null) {
            return null;
        }
        return new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return enm != null && enm.hasMoreElements() || bridgeEnm != null && bridgeEnm.hasMoreElements();
            }

            @Override
            public URL nextElement() {
                if (enm != null && enm.hasMoreElements()) {
                    return (URL)enm.nextElement();
                }
                if (bridgeEnm != null && bridgeEnm.hasMoreElements()) {
                    return (URL)bridgeEnm.nextElement();
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = this.findClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            if (this.bridge != null) {
                clazz = this.bridge.loadClass(name);
            }
            throw cnfe;
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    public String toString() {
        return "BundleDelegatingClassLoader for [" + this.backingBundle + "]";
    }

    public Bundle getBundle() {
        return this.backingBundle;
    }
}

