/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.osgi;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.osgi.framework.Bundle;
import org.springframework.core.io.UrlResource;

public class BundleResource
extends UrlResource {
    private Bundle bundle;

    public BundleResource(URL url, Bundle bundle) {
        super(url);
        this.bundle = bundle;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public long lastModified() throws IOException {
        String lastModifed = (String)this.bundle.getHeaders().get("Bnd-LastModified");
        if (lastModifed != null) {
            try {
                return Long.parseLong(lastModifed);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.bundle.getLastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists() {
        boolean bl;
        URL url = this.getURL();
        URLConnection con = url.openConnection();
        try {
            bl = con.getContentLength() >= 0;
        }
        catch (Throwable throwable) {
            try {
                con.getInputStream().close();
                throw throwable;
            }
            catch (IOException e) {
                return false;
            }
        }
        con.getInputStream().close();
        return bl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BundleResource that = (BundleResource)((Object)o);
        try {
            return new EqualsBuilder().append((Object)this.getBundle().getSymbolicName(), (Object)that.getBundle().getSymbolicName()).append((Object)this.getURL().getPath(), (Object)that.getURL().getPath()).isEquals();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append((Object)this.getBundle()).toHashCode();
    }
}

