/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.osgi;

import java.util.HashMap;

public enum BundleState {
    UNINSTALLED(1),
    INSTALLED(2),
    RESOLVED(4),
    STARTING(8),
    STOPPING(16),
    ACTIVE(32);

    int value;
    private static final HashMap<Integer, BundleState> STATE_BY_VALUE;

    private BundleState(int value) {
        this.value = value;
    }

    public int toInt() {
        return this.value;
    }

    public static BundleState fromInt(int value) {
        BundleState state = STATE_BY_VALUE.get(value);
        if (state == null) {
            throw new IllegalArgumentException(String.format("Unknown bundle state value: %s", value));
        }
        return state;
    }

    static {
        STATE_BY_VALUE = new HashMap();
        for (BundleState state : BundleState.values()) {
            STATE_BY_VALUE.put(state.toInt(), state);
        }
    }
}

