/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.osgi;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.lang.StringUtils;
import org.jahia.data.templates.JahiaTemplatesPackage;
import org.jahia.exceptions.JahiaRuntimeException;
import org.jahia.osgi.BundleDelegatingClassLoader;
import org.jahia.osgi.FrameworkService;
import org.jahia.osgi.JahiaBundleTemplatesPackageHandler;
import org.jahia.services.SpringContextSingleton;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.ConstantException;
import org.springframework.core.Constants;

public final class BundleUtils {
    private static final Constants BUNDLE_EVENTS = new Constants(BundleEvent.class);
    private static final Logger logger = LoggerFactory.getLogger(BundleUtils.class);
    private static Map<String, String[]> moduleForClass = new ConcurrentHashMap<String, String[]>();
    private static Map<Bundle, AbstractApplicationContext> contextToStart = new HashMap<Bundle, AbstractApplicationContext>();
    private static Map<String, Throwable> contextException = new HashMap<String, Throwable>();
    private static Map<String, Map<String, JahiaTemplatesPackage>> modules = new ConcurrentHashMap<String, Map<String, JahiaTemplatesPackage>>(64);

    private BundleUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static String bundleEventToString(int eventType) {
        try {
            return BUNDLE_EVENTS.toCode((Object)eventType, "");
        }
        catch (ConstantException cex) {
            return "Unknown";
        }
    }

    public static ClassLoader createBundleClassLoader(Bundle bundle) {
        return BundleDelegatingClassLoader.createBundleClassLoaderFor(bundle, SpringContextSingleton.getInstance().getContext().getClassLoader());
    }

    public static Bundle getBundleBySymbolicName(String symbolicName, String version) {
        for (Bundle bundle : FrameworkService.getBundleContext().getBundles()) {
            String n = bundle.getSymbolicName();
            if (!StringUtils.equals((String)n, (String)symbolicName) || version != null && !StringUtils.equals((String)bundle.getVersion().toString(), (String)version)) continue;
            return bundle;
        }
        return null;
    }

    public static Bundle getBundle(long id) {
        return FrameworkService.getBundleContext().getBundle(id);
    }

    public static Bundle getBundle(String location) {
        return FrameworkService.getBundleContext().getBundle(location);
    }

    public static Bundle getBundle(String moduleId, String version) {
        for (Bundle bundle : FrameworkService.getBundleContext().getBundles()) {
            String v;
            String n = BundleUtils.getModuleId(bundle);
            if (!StringUtils.equals((String)n, (String)moduleId) || !StringUtils.equals((String)(v = BundleUtils.getModuleVersion(bundle)), (String)version) && !StringUtils.equals((String)bundle.getVersion().toString(), (String)version)) continue;
            return bundle;
        }
        return null;
    }

    public static String getDisplayName(Bundle bundle) {
        return BundleUtils.getModuleId(bundle) + " v" + BundleUtils.getModuleVersion(bundle) + " [" + bundle.getBundleId() + "]";
    }

    public static JahiaTemplatesPackage getModule(Bundle bundle) {
        if (bundle.getState() == 1 && logger.isWarnEnabled()) {
            logger.warn("Uninstalled bundle passed; name: {}, version: {}, stack trace: {}", new Object[]{bundle.getSymbolicName(), bundle.getVersion(), Arrays.toString(Thread.currentThread().getStackTrace())});
        }
        JahiaTemplatesPackage pkg = null;
        String moduleId = BundleUtils.getModuleId(bundle);
        String version = BundleUtils.getModuleVersion(bundle);
        String groupId = BundleUtils.getModuleGroupId(bundle);
        Map<String, JahiaTemplatesPackage> moduleVersions = modules.get(moduleId);
        if (moduleVersions == null) {
            moduleVersions = new ConcurrentHashMap<String, JahiaTemplatesPackage>(1);
            modules.put(moduleId, moduleVersions);
        } else {
            JahiaTemplatesPackage firstVersionTemplatePackage;
            if (!moduleVersions.isEmpty() && ((firstVersionTemplatePackage = moduleVersions.values().iterator().next()).getGroupId() != null && !firstVersionTemplatePackage.getGroupId().equals(groupId) || firstVersionTemplatePackage.getGroupId() == null && groupId != null)) {
                logger.error("A different Jahia Module with the Id {} already exists", (Object)bundle.getSymbolicName());
                return null;
            }
            pkg = moduleVersions.get(version);
        }
        if (pkg == null) {
            logger.info("Building module instance for bundle {} v{}", (Object)moduleId, (Object)version);
            pkg = JahiaBundleTemplatesPackageHandler.build(bundle);
            if (pkg == null) {
                logger.warn("Bundle {} seems to be not a valid Jahia module. Cannot build JahiaTemplatesPackage instance for it", (Object)bundle.getSymbolicName());
                logger.info("The following manifest headers were found in the bundle: {}", (Object)bundle.getHeaders());
                throw new IllegalArgumentException("Bundle " + bundle.getSymbolicName() + " is not a valid Jahia module");
            }
            moduleVersions.put(version, pkg);
        }
        return pkg;
    }

    public static String getModuleId(Bundle bundle) {
        String symbolicName = bundle.getSymbolicName();
        if (symbolicName != null) {
            return symbolicName;
        }
        throw new NullPointerException("Check your bundle's MANIFEST: missing required Bundle-SymbolicName for bundle " + bundle);
    }

    public static String getModuleVersion(Bundle bundle) {
        String version = bundle.getVersion().toString();
        if (version == null) {
            throw new NullPointerException("Check your bundle's MANIFEST: missing required Bundle-Version for bundle " + bundle);
        }
        return StringUtils.defaultIfEmpty((String)((String)bundle.getHeaders().get("Implementation-Version")), (String)version);
    }

    public static String getModuleGroupId(Bundle bundle) {
        return (String)bundle.getHeaders().get("Jahia-GroupId");
    }

    @Deprecated(since="8.2.1.0", forRemoval=true)
    public static boolean isJahiaBundle(Bundle bundle) {
        return BundleUtils.isJahiaModuleBundle(bundle) || StringUtils.defaultString((String)((String)bundle.getHeaders().get("Bundle-Category"))).toLowerCase().contains("jahia");
    }

    public static boolean isJahiaModuleBundle(Bundle bundle) {
        return bundle.getHeaders().get("Jahia-Module-Type") != null;
    }

    public static Class<?> loadModuleClass(String className) throws ClassNotFoundException {
        return BundleUtils.loadModuleClass(className, 4);
    }

    public static Class<?> loadModuleClass(String className, int requiredModuleStatus) throws ClassNotFoundException {
        return BundleUtils.loadModuleClass(className, requiredModuleStatus, true);
    }

    public static Class<?> loadModuleClass(String className, int requiredModuleStatus, boolean fallbackCoreClassloader) throws ClassNotFoundException {
        JahiaTemplatesPackage pkg;
        Map<String, JahiaTemplatesPackage> versions;
        Class clazz = null;
        String[] moduleKey = moduleForClass.get(className);
        if (moduleKey != null && (versions = modules.get(moduleKey[0])) != null && (pkg = versions.get(moduleKey[1])) != null && pkg.getBundle() != null && pkg.getBundle().getState() >= requiredModuleStatus) {
            try {
                return pkg.getBundle().loadClass(className);
            }
            catch (ClassNotFoundException | IllegalStateException e) {
                moduleForClass.remove(className);
            }
        }
        for (Map<String, JahiaTemplatesPackage> moduleVersions : modules.values()) {
            for (JahiaTemplatesPackage pkg2 : moduleVersions.values()) {
                if (pkg2.getBundle() == null || pkg2.getBundle().getState() < requiredModuleStatus) continue;
                try {
                    clazz = pkg2.getBundle().loadClass(className);
                }
                catch (IllegalStateException e) {
                    logger.warn("Error loading class via module's class loader; group: {}, ID/version: {}", new Object[]{pkg2.getGroupId(), pkg2.getIdWithVersion(), e});
                    continue;
                }
                catch (ClassNotFoundException e) {
                    continue;
                }
                Bundle bundle = BundleUtils.getSourceBundleForClass(clazz);
                if (bundle == null || bundle.getState() < requiredModuleStatus) continue;
                moduleForClass.put(className, new String[]{pkg2.getId(), pkg2.getVersion().toString()});
                return clazz;
            }
        }
        if (fallbackCoreClassloader) {
            try {
                return BundleUtils.class.getClassLoader().loadClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException("Unable to find class '" + className + "' in the class loaders of modules" + (fallbackCoreClassloader ? " and Jahia webapp" : ""));
    }

    private static Bundle getSourceBundleForClass(Class<?> clazz) {
        Bundle bundle = null;
        try {
            bundle = (Bundle)MethodUtils.invokeExactMethod((Object)clazz.getClassLoader(), (String)"getBundle", null, null);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return bundle;
    }

    public static void unregisterModule(Bundle bundle) {
        String moduleId = BundleUtils.getModuleId(bundle);
        String version = BundleUtils.getModuleVersion(bundle);
        String groupId = BundleUtils.getModuleGroupId(bundle);
        Map<String, JahiaTemplatesPackage> moduleVersions = modules.get(moduleId);
        if (moduleVersions != null) {
            JahiaTemplatesPackage firstVersionTemplatePackage;
            if (!moduleVersions.isEmpty() && ((firstVersionTemplatePackage = moduleVersions.values().iterator().next()).getGroupId() != null && !firstVersionTemplatePackage.getGroupId().equals(groupId) || firstVersionTemplatePackage.getGroupId() == null && groupId != null)) {
                logger.warn("A different Jahia Module with the Id {} already exists", (Object)bundle.getSymbolicName());
                return;
            }
            JahiaTemplatesPackage pkg = moduleVersions.remove(version);
            if (moduleVersions.isEmpty()) {
                modules.remove(moduleId);
            }
            if (pkg != null) {
                pkg.setClassLoader(null);
            } else {
                logger.warn("Version {} of module {} does not exist", (Object)version, (Object)moduleId);
            }
        }
    }

    public static AbstractApplicationContext getContextToStartForModule(Bundle bundle) {
        return contextToStart.get(bundle);
    }

    public static void setContextToStartForModule(Bundle bundle, AbstractApplicationContext context) {
        contextToStart.put(bundle, context);
    }

    public static Throwable getContextStartException(String key) {
        return contextException.get(key);
    }

    public static void setContextStartException(String key, Throwable exception) {
        contextException.put(key, exception);
    }

    public static <S> S getOsgiService(String serviceClass) {
        return (S)BundleUtils.getOsgiService(serviceClass, null);
    }

    public static <S> S getOsgiService(Class<S> serviceClass, String filter) {
        return (S)BundleUtils.getOsgiService(serviceClass.getName(), filter);
    }

    public static Object getOsgiService(String serviceClassName, String filter) {
        List<ServiceReference> serviceReferences;
        Object serviceInstance = null;
        BundleContext bundleContext = FrameworkService.getBundleContext();
        if (bundleContext == null) {
            return serviceInstance;
        }
        try {
            ServiceReference[] refs = bundleContext.getAllServiceReferences(serviceClassName, filter);
            serviceReferences = refs != null && refs.length > 0 ? Arrays.asList(refs) : null;
        }
        catch (InvalidSyntaxException e) {
            throw new JahiaRuntimeException(e);
        }
        if (serviceReferences != null && !serviceReferences.isEmpty()) {
            ServiceReference bestServiceReferefnce;
            if (serviceReferences.size() > 1) {
                ArrayList<ServiceReference> matchingServices = new ArrayList<ServiceReference>(serviceReferences);
                Collections.sort(matchingServices);
                bestServiceReferefnce = (ServiceReference)matchingServices.get(matchingServices.size() - 1);
            } else {
                bestServiceReferefnce = (ServiceReference)serviceReferences.iterator().next();
            }
            serviceInstance = bundleContext.getService(bestServiceReferefnce);
        }
        return serviceInstance;
    }

    public static boolean isFragment(Bundle bundle) {
        return StringUtils.isNotBlank((String)((String)bundle.getHeaders().get("Fragment-Host")));
    }

    public static int getPersistentState(Bundle bundle) {
        int persistentState = bundle.getState() != 1 ? (((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).isPersistentlyStarted() ? 32 : 2) : 1;
        return persistentState;
    }
}

