/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.cache;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class CacheEntry<V>
implements Serializable {
    private static final long serialVersionUID = -319255477144589731L;
    private V object;
    private Map<String, Serializable> properties;

    public CacheEntry() {
    }

    public CacheEntry(V entryObj) {
        this();
        this.object = entryObj;
    }

    public V getObject() {
        return this.object;
    }

    public void setObject(V object) {
        this.object = object;
    }

    public void setProperty(String key, Serializable value) {
        if (key == null) {
            return;
        }
        if (this.properties == null) {
            this.properties = new HashMap<String, Serializable>(1);
        }
        this.properties.put(key, value);
    }

    public Object getProperty(String key) {
        return this.properties != null ? this.properties.get(key) : null;
    }

    public boolean containsKey(String key) {
        if (key == null || this.properties == null) {
            return false;
        }
        return this.properties.containsKey(key);
    }

    public Map<String, Serializable> getExtendedProperties() {
        return this.properties != null ? this.properties : Collections.emptyMap();
    }

    public void setExtendedProperties(Map<String, Serializable> newProperties) {
        if (newProperties == null) {
            return;
        }
        this.properties = newProperties;
    }

    @Deprecated(since="7.1.0.0", forRemoval=true)
    public final int getHits() {
        return 0;
    }

    @Deprecated(since="7.1.0.0", forRemoval=true)
    public final void resetHits() {
    }

    @Deprecated(since="7.1.0.0", forRemoval=true)
    public final void incrementHits() {
    }

    @Deprecated(since="7.1.0.0", forRemoval=true)
    public final Date getExpirationDate() {
        return null;
    }

    @Deprecated(since="7.1.0.0", forRemoval=true)
    public final void setExpirationDate(Date expirationDate) {
    }

    @Deprecated(since="7.1.0.0", forRemoval=true)
    public final void setLastAccessedTimeNow() {
    }

    @Deprecated(since="7.1.0.0", forRemoval=true)
    public long getLastAccessedTimeMillis() {
        return 0L;
    }
}

