/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.cache.ehcache;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.statistics.StatisticsGateway;
import org.jahia.services.cache.CacheImplementation;
import org.jahia.services.cache.CacheStatistics;
import org.jahia.services.cache.GroupCacheKey;
import org.jahia.services.cache.ehcache.EhCacheProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhCacheImpl
implements CacheImplementation,
CacheStatistics {
    private static final Logger logger = LoggerFactory.getLogger(EhCacheImpl.class);
    private String name;
    private Cache ehCache;
    private Cache ehCacheGroups;
    private int groupsSizeLimit;

    protected EhCacheImpl(String name, CacheManager ehCacheManager, EhCacheProvider provider) {
        this.name = name;
        this.groupsSizeLimit = provider.getGroupsSizeLimit();
        if (ehCacheManager.getCache(name) == null) {
            ehCacheManager.addCache(name);
        }
        this.ehCache = ehCacheManager.getCache(name);
        if (this.groupsSizeLimit > 0) {
            if (ehCacheManager.getCache(name + "Groups") == null) {
                ehCacheManager.addCache(name + "Groups");
            }
            this.ehCacheGroups = ehCacheManager.getCache(name + "Groups");
        }
    }

    @Deprecated(since="7.2.0.0")
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    public Object get(Object key) {
        Element element = this.ehCache.get(key);
        if (element != null) {
            return element.getObjectValue();
        }
        return null;
    }

    public void put(Object key, String[] groups, Object value) {
        Element element = new Element(key, value);
        this.ehCache.put(element);
        if (key instanceof GroupCacheKey) {
            this.addToGroups(key);
        }
    }

    @Override
    public int size() {
        return this.ehCache.getSize();
    }

    @Override
    public long getGroupsSize() {
        return this.ehCacheGroups != null ? (long)this.ehCacheGroups.getSize() : 0L;
    }

    @Override
    public long getGroupsKeysTotal() {
        if (this.ehCacheGroups == null) {
            return 0L;
        }
        long totalSize = 0L;
        for (Object key : this.ehCacheGroups.getKeysWithExpiryCheck()) {
            Element keySetElement = this.ehCacheGroups.get(key);
            if (keySetElement == null) continue;
            Set keySet = (Set)((Object)keySetElement.getValue());
            totalSize += (long)keySet.size();
        }
        return totalSize;
    }

    @Override
    public void flushAll(boolean propagate) {
        this.ehCache.removeAll();
        if (this.ehCacheGroups != null) {
            this.ehCacheGroups.removeAll();
        }
    }

    public void remove(Object key) {
        this.doRemove(key);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void flushGroup(String groupName) {
        if (this.ehCacheGroups == null) {
            return;
        }
        HashSet keysToFlush = null;
        Element element = this.ehCacheGroups.get((Serializable)((Object)groupName));
        if (element == null) {
            return;
        }
        keysToFlush = (HashSet)element.getValue();
        if (keysToFlush == null) {
            return;
        }
        this.ehCacheGroups.remove((Serializable)((Object)groupName));
        keysToFlush = new HashSet(keysToFlush);
        this.flushKeys(keysToFlush);
    }

    public Set getGroupKeys(String groupName) {
        if (this.ehCacheGroups == null) {
            return Collections.emptySet();
        }
        HashSet keysToFlush = null;
        Element element = this.ehCacheGroups.get((Serializable)((Object)groupName));
        if (element == null) {
            return null;
        }
        keysToFlush = (HashSet)element.getValue();
        if (keysToFlush == null) {
            return null;
        }
        keysToFlush = new HashSet(keysToFlush);
        return keysToFlush;
    }

    protected void flushKeys(Set keysToFlush) {
        if (keysToFlush.contains("ALL")) {
            this.flushAll(true);
            logger.warn("Due to presence of big groups we are flushing the whole cache " + this.ehCache.getName());
        } else {
            for (Object curKeyToFlush : keysToFlush) {
                this.doRemove(curKeyToFlush);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToGroups(Object key) {
        GroupCacheKey groupCacheKey;
        if (this.ehCacheGroups == null || !(key instanceof GroupCacheKey)) {
            return;
        }
        GroupCacheKey groupCacheKey2 = groupCacheKey = (GroupCacheKey)key;
        synchronized (groupCacheKey2) {
            for (String curGroup : groupCacheKey.getGroups()) {
                this.addToGroup(curGroup, key);
            }
        }
    }

    private void addToGroup(String groupName, Object key) {
        if (this.ehCacheGroups == null) {
            return;
        }
        Element element = this.ehCacheGroups.get((Serializable)((Object)groupName));
        Set currentKeys = null;
        currentKeys = element == null ? new HashSet() : (Set)element.getObjectValue();
        if (currentKeys == null) {
            currentKeys = new HashSet();
        }
        if (!currentKeys.contains("ALL") && currentKeys.size() <= this.groupsSizeLimit) {
            currentKeys.add(key);
        }
        if (currentKeys.size() > this.groupsSizeLimit) {
            currentKeys = new HashSet();
            currentKeys.add("ALL");
            logger.warn("Number of keys for group " + groupName + "inside cache " + this.ehCache.getName() + " is exceeding " + this.groupsSizeLimit + " entries so we are putting only one entries to tell jahia to flush all this cache when needed");
        }
        element = new Element((Object)groupName, currentKeys);
        this.ehCacheGroups.put(element);
    }

    private void removeFromGroup(String groupName, Object key) {
        Element element = this.ehCacheGroups.get((Serializable)((Object)groupName));
        Set currentKeys = null;
        if (element != null) {
            currentKeys = (Set)element.getObjectValue();
        }
        if (currentKeys == null) {
            return;
        }
        currentKeys.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromAllGroups(Object key) {
        if (key.getClass() == GroupCacheKey.class) {
            GroupCacheKey curGroupCacheKey;
            GroupCacheKey groupCacheKey = curGroupCacheKey = (GroupCacheKey)key;
            synchronized (groupCacheKey) {
                for (String curGroup : curGroupCacheKey.getGroups()) {
                    this.removeFromGroup(curGroup, key);
                }
            }
        }
    }

    private boolean doRemove(Object key) {
        try {
            boolean removedObject = false;
            removedObject = this.ehCache.remove(key);
            if (removedObject) {
                this.removeFromAllGroups(key);
                return true;
            }
        }
        catch (Exception e) {
            logger.warn("Cannot remove cache entry " + key + " from cache " + this.toString(), (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.ehCache.getSize() == 0;
    }

    public Collection<Object> getKeys() {
        return this.ehCache.getKeys();
    }

    @Override
    public double getCacheEfficiency() {
        StatisticsGateway stats = this.ehCache.getStatistics();
        long hitCount = stats.cacheHitCount();
        long total = hitCount + stats.cacheMissCount();
        return total != 0L ? (double)hitCount * 100.0 / (double)total : 0.0;
    }

    @Override
    public long getSuccessHits() {
        return this.ehCache.getStatistics().cacheHitCount();
    }

    @Override
    public long getTotalHits() {
        StatisticsGateway stats = this.ehCache.getStatistics();
        return stats.cacheHitCount() + stats.cacheMissCount();
    }
}

