/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.categories;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jcr.Node;
import org.jahia.content.CategoryKey;
import org.jahia.content.ObjectKey;
import org.jahia.content.ObjectLink;
import org.jahia.exceptions.JahiaException;
import org.jahia.exceptions.JahiaInitializationException;
import org.jahia.services.categories.Category;
import org.jahia.services.categories.CategoryService;
import org.jahia.services.categories.jcr.JCRCategoryProvider;
import org.jahia.services.usermanager.JahiaUser;

public class CategoryServiceImpl
extends CategoryService {
    private static final String CATEGORY_LINKTYPE = "category";
    private static final String CATEGORY_CHILD_PREFIX = "Category_%";
    private static volatile CategoryServiceImpl singletonInstance;
    private JCRCategoryProvider categoryProvider;

    protected CategoryServiceImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CategoryServiceImpl getInstance() {
        if (singletonInstance != null) return singletonInstance;
        Class<CategoryServiceImpl> clazz = CategoryServiceImpl.class;
        synchronized (CategoryServiceImpl.class) {
            if (singletonInstance != null) return singletonInstance;
            singletonInstance = new CategoryServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singletonInstance;
        }
    }

    public void setCategoryProvider(JCRCategoryProvider categoryProvider) {
        this.categoryProvider = categoryProvider;
    }

    @Override
    public void start() throws JahiaInitializationException {
        Category.categoryService = this;
    }

    @Override
    public void stop() {
    }

    @Override
    public Node getCategoriesRoot() throws JahiaException {
        return this.categoryProvider.getCategoriesRoot();
    }

    @Override
    public List<Category> getRootCategories(JahiaUser user) throws JahiaException {
        return this.categoryProvider.getRootCategories(user);
    }

    @Override
    public List<Category> getCategory(String key) throws JahiaException {
        return this.categoryProvider.findCategoryByKey(key);
    }

    public Category getCategory(String key, Category parentCategory) throws JahiaException {
        return this.categoryProvider.getCategoryByKey(key, parentCategory);
    }

    @Override
    public Category getCategoryByUUID(String categoryUUID) throws JahiaException {
        return this.categoryProvider.getCategoryByUUID(categoryUUID);
    }

    @Override
    public Category getCategoryByPath(String categoryPath) throws JahiaException {
        return this.categoryProvider.getCategoryByPath(categoryPath);
    }

    private List<ObjectLink> getCategoryChildLinks(Category parentCategory) throws JahiaException {
        return ObjectLink.findByTypeAndLeftObjectKey(CATEGORY_LINKTYPE, parentCategory.getObjectKey());
    }

    private List<ObjectLink> getCategoryParentLinks(Category childCategory) throws JahiaException {
        return ObjectLink.findByTypeAndRightObjectKey(CATEGORY_LINKTYPE, childCategory.getObjectKey());
    }

    @Override
    public List<Category> getCategoryChildCategories(Category parentCategory, JahiaUser user) throws JahiaException {
        return this.categoryProvider.getCategoryChildCategories(parentCategory, user);
    }

    @Override
    public List<ObjectKey> getCategoryChildKeys(Category parentCategory) throws JahiaException {
        ArrayList<ObjectKey> returnList = new ArrayList<ObjectKey>();
        return returnList;
    }

    @Override
    public List<ObjectKey> getCategoryParentKeys(Category parentCategory) throws JahiaException {
        List<ObjectLink> links = this.getCategoryParentLinks(parentCategory);
        ArrayList<ObjectKey> leftObjectKeys = new ArrayList<ObjectKey>();
        for (ObjectLink curLink : links) {
            leftObjectKeys.add(curLink.getLeftObjectKey());
        }
        return leftObjectKeys;
    }

    @Override
    public Category addCategory(String key, Category parentCategory) throws JahiaException {
        Category newCategory = this.categoryProvider.createCategory(key, parentCategory);
        return newCategory;
    }

    @Override
    public void removeCategory(Category category) throws JahiaException {
        List<ObjectLink> catChilds = this.getCategoryChildLinks(category);
        for (ObjectLink curLink : catChilds) {
            curLink.remove();
        }
        List<ObjectLink> catParents = this.getCategoryParentLinks(category);
        for (ObjectLink curLink : catParents) {
            curLink.remove();
        }
        this.categoryProvider.removeCategory(category.getJahiaCategory());
    }

    @Override
    public void addObjectKeyToCategory(Category parentCategory, ObjectKey childKey) throws JahiaException {
        if (childKey instanceof CategoryKey) {
            List<ObjectLink> resultList = ObjectLink.findByTypeAndLeftAndRightObjectKeys(CATEGORY_LINKTYPE, parentCategory.getObjectKey(), childKey);
            if (!resultList.isEmpty()) {
                return;
            }
            ObjectLink.createLink(parentCategory.getObjectKey(), childKey, CATEGORY_LINKTYPE, new HashMap<String, String>());
        }
    }

    @Override
    public void removeObjectKeyFromCategory(Category parentCategory, ObjectKey childKey) throws JahiaException {
        if (childKey instanceof CategoryKey) {
            List<ObjectLink> resultList = ObjectLink.findByTypeAndLeftAndRightObjectKeys(CATEGORY_LINKTYPE, parentCategory.getObjectKey(), childKey);
            if (resultList.isEmpty()) {
                return;
            }
            for (ObjectLink curLink : resultList) {
                curLink.remove();
            }
        }
    }

    @Override
    public Set<Category> getObjectCategories(ObjectKey objectKey) throws JahiaException {
        HashSet<Category> categorySet = new HashSet<Category>();
        if (objectKey instanceof CategoryKey) {
            List<ObjectLink> links = ObjectLink.findByTypeAndRightAndLikeLeftObjectKey(CATEGORY_LINKTYPE, objectKey, CATEGORY_CHILD_PREFIX);
            for (ObjectLink curLink : links) {
                CategoryKey curCatKey = (CategoryKey)curLink.getLeftObjectKey();
                Category curCategory = this.getCategoryByUUID(curCatKey.getIDInType());
                if (curCategory == null) continue;
                categorySet.add(curCategory);
            }
        }
        return categorySet;
    }

    @Override
    public Map<String, String> getTitlesForCategory(Category category) throws JahiaException {
        return this.categoryProvider.getTitlesForCategory(category);
    }

    @Override
    public String getTitleForCategory(Category category, Locale locale) throws JahiaException {
        return this.categoryProvider.getTitleForCategory(category, locale);
    }

    @Override
    public void setTitleForCategory(Category category, Locale locale, String title) throws JahiaException {
        this.categoryProvider.setTitleForCategory(category, locale, title);
    }

    @Override
    public void removeTitleForCategory(Category category, Locale locale) throws JahiaException {
        this.categoryProvider.removeTitleForCategory(category, locale);
    }

    @Override
    public List<Category> getCategoryStartingByKeyPrefix(String keyPrefix) throws JahiaException {
        return this.categoryProvider.findCategoriesStartingByKey(keyPrefix);
    }

    @Override
    public List<Category> getCategoryStartingByTitlePrefix(String titlePrefix, String languageCode) throws JahiaException {
        return this.categoryProvider.findCategoriesStartingByTitle(titlePrefix, languageCode);
    }

    @Override
    public List<Category> getCategoriesContainingStringInTitle(String string, String languageCode) throws JahiaException {
        return this.categoryProvider.findCategoriesContainingTitleString(string, languageCode);
    }

    @Override
    public List<Category> findCategoriesByPropNameAndValue(String propName, String propValue, JahiaUser user) {
        return this.categoryProvider.findCategoriesByPropNameAndValue(propName, propValue, user);
    }

    @Override
    public void removeProperties(String categoryId) {
        this.categoryProvider.removeProperties(categoryId);
    }

    @Override
    public Properties getProperties(String categoryId) {
        return this.categoryProvider.getProperties(categoryId);
    }

    @Override
    public void setProperties(String categoryId, Properties properties) {
        this.categoryProvider.setProperties(categoryId, properties);
    }
}

