/*
 * Decompiled with CFR 0.152.
 */
package org.jahia.services.content;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.commons.lang.StringUtils;
import org.jahia.services.content.JCRNodeIteratorWrapper;
import org.jahia.services.content.JCRNodeWrapper;
import org.jahia.services.content.JCRPropertyWrapper;
import org.jahia.services.content.JCRPublicationService;
import org.jahia.services.content.JCRSessionWrapper;
import org.jahia.services.content.JCRValueWrapper;
import org.jahia.services.content.JCRVersionService;
import org.jahia.services.content.nodetypes.ExtendedNodeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConflictResolver {
    private static final List<String> IGNORED_PROPRTIES = Arrays.asList("jcr:uuid", "jcr:primaryType", "jcr:created", "jcr:createdBy", "jcr:baseVersion", "jcr:isCheckedOut", "jcr:versionHistory", "jcr:predecessors", "jcr:activity", "j:checkinDate", "j:locktoken", "j:lockTypes", "jcr:lockOwner", "jcr:lockIsDeep", "j:deletedChildren", "j:processId", "lastReplay");
    private static final Logger logger = LoggerFactory.getLogger(ConflictResolver.class);
    private JCRNodeWrapper sourceNode;
    private JCRNodeWrapper targetNode;
    private Set<JCRNodeWrapper> toCheckpoint;
    private List<Diff> differences;
    private List<Diff> unresolvedDifferences;

    public ConflictResolver(JCRNodeWrapper sourceNode, JCRNodeWrapper targetNode) throws RepositoryException {
        this.sourceNode = sourceNode;
        this.targetNode = targetNode;
    }

    public void setToCheckpoint(Set<JCRNodeWrapper> toCheckpoint) {
        this.toCheckpoint = toCheckpoint;
    }

    public List<Diff> getUnresolvedDifferences() {
        return this.unresolvedDifferences;
    }

    public void applyDifferences() throws RepositoryException {
        this.computeDifferences();
        this.unresolvedDifferences = new ArrayList<Diff>();
        for (Diff diff : this.differences) {
            if (diff.apply()) continue;
            this.unresolvedDifferences.add(diff);
        }
        this.targetNode.getSession().save();
    }

    private void computeDifferences() throws RepositoryException {
        this.differences = this.compare(this.sourceNode, this.targetNode, "");
    }

    private List<Diff> compare(JCRNodeWrapper sourceNode, JCRNodeWrapper targetNode, String basePath) throws RepositoryException {
        ArrayList<Diff> diffs = new ArrayList<Diff>();
        boolean remotelyPublished = targetNode.isNodeType("jmix:remotelyPublished");
        if (!remotelyPublished) {
            ListOrderedMap targetUuids = this.getChildEntries(targetNode, targetNode.getSession());
            ListOrderedMap sourceUuids = this.getChildEntries(sourceNode, sourceNode.getSession());
            if (!targetUuids.values().equals(sourceUuids.values())) {
                for (String key : sourceUuids.keySet()) {
                    if (!targetUuids.containsKey((Object)key) || targetUuids.get((Object)key).equals(sourceUuids.get((Object)key))) continue;
                    diffs.add(new ChildRenamedDiff(key, this.addPath(basePath, (String)targetUuids.get((Object)key)), this.addPath(basePath, (String)sourceUuids.get((Object)key))));
                }
            }
            if (!targetUuids.keyList().equals(sourceUuids.keyList())) {
                ArrayList addedUuids = new ArrayList(sourceUuids.keySet());
                addedUuids.removeAll(targetUuids.keySet());
                ArrayList removedUuids = new ArrayList(targetUuids.keySet());
                removedUuids.removeAll(sourceUuids.keySet());
                if (targetNode.getPrimaryNodeType().hasOrderableChildNodes()) {
                    Iterator newOrdering = this.getOrdering(sourceUuids, Collections.emptyList());
                    ArrayList<String> oldUuidsList = new ArrayList<String>(targetUuids.keySet());
                    oldUuidsList.removeAll(removedUuids);
                    ArrayList newUuidsList = new ArrayList(sourceUuids.keySet());
                    newUuidsList.removeAll(addedUuids);
                    if (!oldUuidsList.equals(newUuidsList)) {
                        for (int i = 1; i < oldUuidsList.size(); ++i) {
                            int n;
                            String x = (String)oldUuidsList.get(i);
                            for (n = i; n > 0 && sourceUuids.indexOf(oldUuidsList.get(n - 1)) > sourceUuids.indexOf((Object)x); --n) {
                                oldUuidsList.set(n, (String)oldUuidsList.get(n - 1));
                            }
                            if (n == i) continue;
                            String orderBeforeUuid = n + 1 == oldUuidsList.size() ? null : (String)oldUuidsList.get(n + 1);
                            diffs.add(new ChildNodeReorderedDiff(x, orderBeforeUuid, this.addPath(basePath, (String)sourceUuids.get((Object)x)), (String)sourceUuids.get((Object)orderBeforeUuid), (Map<String, String>)((Object)newOrdering)));
                            logger.debug("reorder " + sourceUuids.get((Object)x) + " before " + sourceUuids.get((Object)orderBeforeUuid));
                            oldUuidsList.set(n, x);
                        }
                    }
                }
                for (String removedUuid : removedUuids) {
                    try {
                        this.sourceNode.getSession().getNodeByUUID(removedUuid);
                    }
                    catch (ItemNotFoundException e) {
                        diffs.add(new ChildRemovedDiff(removedUuid, this.addPath(basePath, (String)targetUuids.get((Object)removedUuid)), removedUuid));
                    }
                }
                for (String addedUuid : addedUuids) {
                    diffs.add(new ChildAddedDiff(addedUuid, this.addPath(basePath, (String)sourceUuids.get((Object)addedUuid)), addedUuid.equals(sourceUuids.lastKey()) ? null : (String)sourceUuids.get(sourceUuids.get(sourceUuids.indexOf((Object)addedUuid) + 1))));
                }
            }
        }
        PropertyIterator targetProperties = targetNode.getProperties();
        while (targetProperties.hasNext()) {
            JCRPropertyWrapper targetProperty = (JCRPropertyWrapper)targetProperties.next();
            String propertyName = targetProperty.getName();
            if (IGNORED_PROPRTIES.contains(propertyName)) continue;
            if (!sourceNode.hasProperty(propertyName)) {
                diffs.add(new PropertyChangedDiff(this.addPath(basePath, propertyName)));
                continue;
            }
            JCRPropertyWrapper sourceProperty = sourceNode.getProperty(propertyName);
            if (targetProperty.isMultiple() != sourceProperty.isMultiple()) {
                throw new RepositoryException();
            }
            if (targetProperty.isMultiple()) {
                boolean modified;
                List<JCRValueWrapper> targetValues = Arrays.asList(targetProperty.getRealValues());
                List<JCRValueWrapper> sourceValues = Arrays.asList(sourceProperty.getRealValues());
                boolean bl = modified = targetValues.size() != sourceValues.size();
                if (!modified) {
                    Iterator<JCRValueWrapper> it = targetValues.iterator();
                    for (Value value : sourceValues) {
                        if (this.equalsValue(value, it.next())) continue;
                        modified = true;
                    }
                }
                if (!modified) continue;
                diffs.add(new PropertyChangedDiff(this.addPath(basePath, propertyName), sourceProperty.getRealValues()));
                continue;
            }
            if (this.equalsValue(targetProperty.getRealValue(), sourceProperty.getRealValue())) continue;
            diffs.add(new PropertyChangedDiff(this.addPath(basePath, propertyName), sourceProperty.getRealValue()));
        }
        PropertyIterator sourceProperties = sourceNode.getProperties();
        while (sourceProperties.hasNext()) {
            JCRPropertyWrapper sourceProperty = (JCRPropertyWrapper)sourceProperties.next();
            String propertyName = sourceProperty.getName();
            if (IGNORED_PROPRTIES.contains(propertyName) || targetNode.hasProperty(propertyName)) continue;
            if (sourceProperty.isMultiple()) {
                diffs.add(new PropertyChangedDiff(this.addPath(basePath, sourceProperty.getName()), sourceProperty.getRealValues()));
                continue;
            }
            diffs.add(new PropertyChangedDiff(this.addPath(basePath, sourceProperty.getName()), sourceProperty.getRealValue()));
        }
        for (Diff diff : new ArrayList(diffs)) {
            if (!(diff instanceof PropertyChangedDiff) || !((PropertyChangedDiff)diff).propertyPath.endsWith("jcr:mixinTypes")) continue;
            diffs.remove(diff);
            diffs.add(0, diff);
        }
        if (!remotelyPublished) {
            JCRNodeIteratorWrapper targetSubNodes = targetNode.getNodes();
            while (targetSubNodes.hasNext()) {
                JCRNodeWrapper targetSubNode = (JCRNodeWrapper)targetSubNodes.next();
                if (!sourceNode.hasNode(targetSubNode.getName())) continue;
                JCRNodeWrapper sourceSubNode = sourceNode.getNode(targetSubNode.getName());
                if (!this.shouldPublish(targetSubNode) || !this.shouldPublish(sourceSubNode) || !JCRPublicationService.supportsPublication(targetSubNode.getSession(), targetSubNode)) continue;
                diffs.addAll(this.compare(sourceSubNode, targetSubNode, this.addPath(basePath, targetSubNode.getName())));
            }
        }
        return diffs;
    }

    private Map<String, String> getOrdering(ListOrderedMap uuids1, List<String> removed) {
        LinkedHashMap<String, String> previousMap = new LinkedHashMap<String, String>();
        ListIterator it = uuids1.keyList().listIterator(uuids1.size());
        String previous = "";
        while (it.hasPrevious()) {
            String uuid = (String)it.previous();
            if (removed.contains(uuid)) continue;
            previousMap.put(uuid, previous);
            previous = uuid;
        }
        return previousMap;
    }

    private ListOrderedMap getChildEntries(JCRNodeWrapper node, JCRSessionWrapper session) throws RepositoryException {
        ListOrderedMap childEntries = new ListOrderedMap();
        for (JCRNodeWrapper child : node.getNodes()) {
            try {
                if (child.isNodeType("jmix:nolive") || !JCRPublicationService.supportsPublication(session, child) || session.getWorkspace().getName().equals("live") && child.hasProperty("j:originWS") && child.getProperty("j:originWS").getString().equals("live")) continue;
                session.getNodeByUUID(child.getIdentifier());
                childEntries.put((Object)child.getIdentifier(), (Object)child.getName());
            }
            catch (ItemNotFoundException itemNotFoundException) {}
        }
        return childEntries;
    }

    public boolean equalsValue(Value o1, Value o2) {
        try {
            if (o1.getType() != o2.getType()) {
                return false;
            }
            if (o1.getType() == 2) {
                return o1.equals(o2);
            }
            return o1.getString().equals(o2.getString());
        }
        catch (RepositoryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String addPath(String basePath, String name) {
        return basePath.equals("") ? name : basePath + "/" + name;
    }

    private JCRNodeWrapper getParentTarget(JCRNodeWrapper target, String path) throws RepositoryException {
        if (path.contains("/")) {
            return target.getNode(StringUtils.substringBeforeLast((String)path, (String)"/"));
        }
        return target;
    }

    private String getTargetName(String path) {
        if (path.contains("/")) {
            return StringUtils.substringAfterLast((String)path, (String)"/");
        }
        return path;
    }

    private boolean shouldPublish(JCRNodeWrapper node) throws RepositoryException {
        return !node.isVersioned() && !node.isNodeType("jmix:publication");
    }

    class PropertyChangedDiff
    implements Diff {
        private String propertyPath;
        private Value newValue;
        private Value[] newValues;

        PropertyChangedDiff(String propertyPath) {
            this.propertyPath = propertyPath;
        }

        PropertyChangedDiff(String propertyPath, Value newValue) {
            this.propertyPath = propertyPath;
            this.newValue = newValue;
        }

        PropertyChangedDiff(String propertyPath, Value[] newValues) {
            this.propertyPath = propertyPath;
            this.newValues = newValues;
        }

        @Override
        public boolean apply() throws RepositoryException {
            JCRNodeWrapper parentTargetNode = ConflictResolver.this.getParentTarget(ConflictResolver.this.targetNode, this.propertyPath);
            String propertyName = ConflictResolver.this.getTargetName(this.propertyPath);
            boolean isMixin = propertyName.equals("jcr:mixinTypes");
            if (isMixin) {
                List typesToRemove = Arrays.stream(parentTargetNode.getMixinNodeTypes()).map(ExtendedNodeType::getName).collect(Collectors.toList());
                typesToRemove.remove("jmix:liveProperties");
                if (parentTargetNode.hasProperty("j:liveProperties")) {
                    for (JCRValueWrapper value : parentTargetNode.getProperty("j:liveProperties").getValues()) {
                        if (!value.getString().startsWith("jcr:mixinTypes=")) continue;
                        typesToRemove.remove(value.getString().substring("jcr:mixinTypes=".length()));
                    }
                }
                if (!parentTargetNode.isCheckedOut()) {
                    parentTargetNode.checkout();
                }
                ArrayList<String> typesToAdd = new ArrayList<String>();
                if (this.newValues != null) {
                    for (Value value : this.newValues) {
                        if (!typesToRemove.contains(value.getString())) {
                            typesToAdd.add(value.getString());
                            continue;
                        }
                        typesToRemove.remove(value.getString());
                    }
                }
                for (String type : typesToRemove) {
                    parentTargetNode.removeMixin(type);
                }
                for (String type : typesToAdd) {
                    parentTargetNode.addMixin(type);
                }
            } else {
                if (parentTargetNode.hasProperty("j:liveProperties")) {
                    if (propertyName.equals("j:liveProperties")) {
                        return true;
                    }
                    for (JCRValueWrapper value : parentTargetNode.getProperty("j:liveProperties").getValues()) {
                        if (!propertyName.equals(value.getString())) continue;
                        return true;
                    }
                }
                if (!parentTargetNode.isCheckedOut()) {
                    parentTargetNode.checkout();
                }
                if (this.newValue != null) {
                    parentTargetNode.getRealNode().setProperty(propertyName, this.newValue);
                } else if (this.newValues != null) {
                    parentTargetNode.getRealNode().setProperty(propertyName, this.newValues);
                } else if (parentTargetNode.hasProperty(propertyName)) {
                    parentTargetNode.getProperty(propertyName).remove();
                }
            }
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PropertyChangedDiff that = (PropertyChangedDiff)o;
            if (this.newValue != null ? !this.newValue.equals(that.newValue) : that.newValue != null) {
                return false;
            }
            if (this.newValues != null ? !Arrays.equals(this.newValues, that.newValues) : that.newValues != null) {
                return false;
            }
            return !(this.propertyPath == null ? that.propertyPath != null : !this.propertyPath.equals(that.propertyPath));
        }

        public int hashCode() {
            int result = this.propertyPath != null ? this.propertyPath.hashCode() : 0;
            result = 31 * result + (this.newValue != null ? this.newValue.hashCode() : 0) + (this.newValues != null ? Arrays.hashCode(this.newValues) : 0);
            return result;
        }

        public String toString() {
            return "PropertyChangedDiff{propertyPath='" + this.propertyPath + "'" + (this.newValues != null ? ", newValues=" + Arrays.toString(this.newValues) : ", newValue=" + this.newValue) + "}";
        }
    }

    class ChildNodeReorderedDiff
    implements Diff {
        private String name;
        private String orderBeforeName;
        private String uuid;
        private String orderBeforeUuid;
        private Map<String, String> ordering;

        ChildNodeReorderedDiff(String uuid, String orderBeforeUuid, String name, String orderBeforeName, Map<String, String> ordering) {
            this.name = name;
            this.orderBeforeName = orderBeforeName;
            this.uuid = uuid;
            this.orderBeforeUuid = orderBeforeUuid;
            this.ordering = ordering;
        }

        @Override
        public boolean apply() throws RepositoryException {
            if (ConflictResolver.this.targetNode.hasNode(this.name)) {
                JCRNodeWrapper realTargetNode = ConflictResolver.this.targetNode;
                String realName = this.name;
                if (this.name.contains("/")) {
                    realTargetNode = ConflictResolver.this.targetNode.getNode(StringUtils.substringBeforeLast((String)this.name, (String)"/"));
                    realName = StringUtils.substringAfterLast((String)this.name, (String)"/");
                }
                if (realTargetNode.getPrimaryNodeType().hasOrderableChildNodes()) {
                    while (this.orderBeforeName != null && !realTargetNode.hasNode(this.orderBeforeName)) {
                        this.orderBeforeUuid = this.ordering.get(this.orderBeforeUuid);
                        try {
                            if (this.orderBeforeUuid.equals("")) {
                                this.orderBeforeName = null;
                                continue;
                            }
                            this.orderBeforeName = realTargetNode.getSession().getNodeByUUID(this.orderBeforeUuid).getName();
                        }
                        catch (ItemNotFoundException itemNotFoundException) {}
                    }
                    realTargetNode.orderBefore(realName, this.orderBeforeName);
                }
            }
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChildNodeReorderedDiff that = (ChildNodeReorderedDiff)o;
            if (this.orderBeforeUuid != null ? !this.orderBeforeUuid.equals(that.orderBeforeUuid) : that.orderBeforeUuid != null) {
                return false;
            }
            return !(this.uuid == null ? that.uuid != null : !this.uuid.equals(that.uuid));
        }

        public int hashCode() {
            int result = this.uuid != null ? this.uuid.hashCode() : 0;
            result = 31 * result + (this.orderBeforeUuid != null ? this.orderBeforeUuid.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ChildNodeReorderedDiff{name='" + this.name + "', orderBeforeName='" + this.orderBeforeName + "', uuid='" + this.uuid + "', orderBeforeUuid='" + this.orderBeforeUuid + "', ordering=" + this.ordering + "}";
        }
    }

    class ChildRemovedDiff
    implements Diff {
        private String uuid;
        private String oldName;
        private String identifier;

        ChildRemovedDiff(String uuid, String oldName, String identifier) {
            this.uuid = uuid;
            this.oldName = oldName;
            this.identifier = identifier;
        }

        @Override
        public boolean apply() throws RepositoryException {
            JCRNodeWrapper node;
            if (ConflictResolver.this.targetNode.hasNode(this.oldName) && (node = ConflictResolver.this.targetNode.getNode(this.oldName)).getIdentifier().equals(this.identifier)) {
                JCRPublicationService.getInstance().addRemovedLabel(node, node.getSession().getWorkspace().getName() + "_removed_at_" + JCRVersionService.DATE_FORMAT.print(System.currentTimeMillis()));
                node.remove();
            }
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChildRemovedDiff that = (ChildRemovedDiff)o;
            if (!this.oldName.equals(that.oldName)) {
                return false;
            }
            return this.uuid.equals(that.uuid);
        }

        public int hashCode() {
            int result = this.uuid.hashCode();
            result = 31 * result + this.oldName.hashCode();
            return result;
        }

        public String toString() {
            return "ChildRemovedDiff{uuid='" + this.uuid + "', oldName='" + this.oldName + "'}";
        }
    }

    class ChildAddedDiff
    implements Diff {
        private String uuid;
        private String newName;
        private String nextSibling;

        ChildAddedDiff(String uuid, String newName, String nextSibling) {
            this.uuid = uuid;
            this.newName = newName;
            this.nextSibling = nextSibling;
        }

        @Override
        public boolean apply() throws RepositoryException {
            boolean shouldPublish = false;
            try {
                shouldPublish = ConflictResolver.this.shouldPublish(ConflictResolver.this.sourceNode.getNode(this.newName));
            }
            catch (InvalidItemStateException | PathNotFoundException e) {
                logger.warn("Ignoring exception while handling child added conflict during publication for node: " + ConflictResolver.this.sourceNode.getPath() + "/" + this.newName, e);
            }
            if (!shouldPublish || ConflictResolver.this.targetNode.hasNode(this.newName)) {
                if (ConflictResolver.this.targetNode.hasNode(this.newName) && (this.nextSibling == null || ConflictResolver.this.targetNode.hasNode(this.nextSibling)) && ConflictResolver.this.targetNode.getPrimaryNodeType().hasOrderableChildNodes()) {
                    if (!(this.newName.contains("/") || this.nextSibling != null && this.nextSibling.contains("/"))) {
                        ConflictResolver.this.targetNode.orderBefore(this.newName, this.nextSibling);
                    }
                    ConflictResolver.this.targetNode.getSession().save();
                }
                return true;
            }
            JCRNodeWrapper parentTargetNode = ConflictResolver.this.getParentTarget(ConflictResolver.this.targetNode, this.newName);
            JCRNodeWrapper parentSourceNode = ConflictResolver.this.getParentTarget(ConflictResolver.this.sourceNode, this.newName);
            String newNameParsed = ConflictResolver.this.getTargetName(this.newName);
            parentTargetNode.getSession().save();
            JCRPublicationService.getInstance().doClone(parentSourceNode.getNode(newNameParsed), parentSourceNode.getSession(), parentTargetNode.getSession(), ConflictResolver.this.toCheckpoint);
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChildAddedDiff that = (ChildAddedDiff)o;
            if (this.newName != null ? !this.newName.equals(that.newName) : that.newName != null) {
                return false;
            }
            if (this.nextSibling != null ? !this.nextSibling.equals(that.nextSibling) : that.nextSibling != null) {
                return false;
            }
            return !(this.uuid == null ? that.uuid != null : !this.uuid.equals(that.uuid));
        }

        public int hashCode() {
            int result = this.uuid != null ? this.uuid.hashCode() : 0;
            result = 31 * result + (this.newName != null ? this.newName.hashCode() : 0);
            result = 31 * result + (this.nextSibling != null ? this.nextSibling.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "ChildAddedDiff{uuid='" + this.uuid + "', newName='" + this.newName + "', nextSibling='" + this.nextSibling + "'}";
        }
    }

    class ChildRenamedDiff
    implements Diff {
        private String uuid;
        private String oldName;
        private String newName;

        ChildRenamedDiff(String uuid, String oldName, String newName) {
            this.uuid = uuid;
            this.oldName = oldName;
            this.newName = newName;
        }

        @Override
        public boolean apply() throws RepositoryException {
            return !ConflictResolver.this.targetNode.hasNode(this.oldName) || !ConflictResolver.this.shouldPublish(ConflictResolver.this.targetNode.getNode(this.oldName)) || ConflictResolver.this.targetNode.getNode(this.oldName).rename(this.newName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChildRenamedDiff that = (ChildRenamedDiff)o;
            if (!this.newName.equals(that.newName)) {
                return false;
            }
            if (!this.oldName.equals(that.oldName)) {
                return false;
            }
            return this.uuid.equals(that.uuid);
        }

        public int hashCode() {
            int result = this.uuid.hashCode();
            result = 31 * result + this.oldName.hashCode();
            result = 31 * result + this.newName.hashCode();
            return result;
        }

        public String toString() {
            return "ChildRenamedDiff{uuid='" + this.uuid + "', oldName='" + this.oldName + "', newName='" + this.newName + "'}";
        }
    }

    static interface Diff {
        public boolean apply() throws RepositoryException;
    }
}

